/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.nio.charset.CharsetEncoderUtil;
import com.liferay.portal.kernel.servlet.BrowserSnifferUtil;
import com.liferay.portal.kernel.servlet.BufferCacheServletResponse;
import com.liferay.portal.kernel.servlet.Range;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.RandomAccessInputStream;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletResponseUtil {
    private static final String _CLIENT_ABORT_EXCEPTION = "org.apache.catalina.connector.ClientAbortException";
    private static final int _MAX_RANGE_FIELDS = GetterUtil.getInteger(PropsUtil.get("web.server.servlet.max.range.fields"));
    private static final String _RANGE_REGEX = "^bytes=\\d*-\\d*(,\\s?\\d*-\\d*)*$";
    private static final Log _log = LogFactoryUtil.getLog(ServletResponseUtil.class);

    public static List<Range> getRanges(HttpServletRequest request, HttpServletResponse response, long length) throws IOException {
        String rangeString = request.getHeader("Range");
        if (Validator.isNull(rangeString)) {
            return Collections.emptyList();
        }
        if (!rangeString.matches(_RANGE_REGEX)) {
            throw new IOException("Range header does not match regular expression " + rangeString);
        }
        ArrayList<Range> ranges = new ArrayList<Range>();
        String[] rangeFields = StringUtil.split(rangeString.substring(6));
        if (rangeFields.length > _MAX_RANGE_FIELDS) {
            StringBundler sb = new StringBundler(8);
            sb.append("Request range ");
            sb.append(rangeString);
            sb.append(" with ");
            sb.append(rangeFields.length);
            sb.append(" range fields has exceeded maximum allowance as ");
            sb.append("specified by the property \"");
            sb.append("web.server.servlet.max.range.fields");
            sb.append("\"");
            throw new IOException(sb.toString());
        }
        for (String rangeField : rangeFields) {
            int index = rangeField.indexOf("-");
            long start = GetterUtil.getLong(rangeField.substring(0, index), -1L);
            long end = GetterUtil.getLong(rangeField.substring(index + 1, rangeField.length()), -1L);
            if (start == -1L) {
                start = length - end;
                end = length - 1L;
            } else if (end == -1L || end > length - 1L) {
                end = length - 1L;
            }
            if (start > end) {
                throw new IOException("Range start " + start + " is greater than end " + end);
            }
            Range range = new Range(start, end, length);
            ranges.add(range);
        }
        return ranges;
    }

    public static boolean isClientAbortException(IOException ioe) {
        Class<?> clazz = ioe.getClass();
        String className = clazz.getName();
        return className.equals(_CLIENT_ABORT_EXCEPTION);
    }

    public static void sendFile(HttpServletRequest request, HttpServletResponse response, String fileName, byte[] bytes) throws IOException {
        ServletResponseUtil.sendFile(request, response, fileName, bytes, null);
    }

    public static void sendFile(HttpServletRequest request, HttpServletResponse response, String fileName, byte[] bytes, String contentType) throws IOException {
        ServletResponseUtil.sendFile(request, response, fileName, bytes, contentType, null);
    }

    public static void sendFile(HttpServletRequest request, HttpServletResponse response, String fileName, byte[] bytes, String contentType, String contentDispositionType) throws IOException {
        ServletResponseUtil.setHeaders(request, response, fileName, contentType, contentDispositionType);
        ServletResponseUtil.write(response, bytes);
    }

    public static void sendFile(HttpServletRequest request, HttpServletResponse response, String fileName, InputStream inputStream) throws IOException {
        ServletResponseUtil.sendFile(request, response, fileName, inputStream, null);
    }

    public static void sendFile(HttpServletRequest request, HttpServletResponse response, String fileName, InputStream inputStream, long contentLength, String contentType) throws IOException {
        ServletResponseUtil.sendFile(request, response, fileName, inputStream, contentLength, contentType, null);
    }

    public static void sendFile(HttpServletRequest request, HttpServletResponse response, String fileName, InputStream inputStream, long contentLength, String contentType, String contentDispositionType) throws IOException {
        ServletResponseUtil.setHeaders(request, response, fileName, contentType, contentDispositionType);
        ServletResponseUtil.write(response, inputStream, contentLength);
    }

    public static void sendFile(HttpServletRequest request, HttpServletResponse response, String fileName, InputStream inputStream, String contentType) throws IOException {
        ServletResponseUtil.sendFile(request, response, fileName, inputStream, 0L, contentType);
    }

    public static void sendFileWithRangeHeader(HttpServletRequest request, HttpServletResponse response, String fileName, InputStream inputStream, long contentLength, String contentType) throws IOException {
        if (_log.isDebugEnabled()) {
            _log.debug("Accepting ranges for the file " + fileName);
        }
        response.setHeader("Accept-Ranges", "bytes");
        List<Range> ranges = null;
        try {
            ranges = ServletResponseUtil.getRanges(request, response, contentLength);
        }
        catch (IOException ioe) {
            _log.error(ioe);
            response.setHeader("Content-Range", "bytes */" + contentLength);
            response.sendError(416);
            return;
        }
        if (ranges == null || ranges.isEmpty()) {
            ServletResponseUtil.sendFile(request, response, fileName, inputStream, contentLength, contentType);
        } else {
            if (_log.isDebugEnabled()) {
                _log.debug("Request has range header " + request.getHeader("Range"));
            }
            ServletResponseUtil.write(request, response, fileName, ranges, inputStream, contentLength, contentType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(HttpServletRequest request, HttpServletResponse response, String fileName, List<Range> ranges, InputStream inputStream, long fullLength, String contentType) throws IOException {
        ServletOutputStream outputStream = null;
        try {
            outputStream = response.getOutputStream();
            Range fullRange = new Range(0L, fullLength - 1L, fullLength);
            Range firstRange = null;
            if (!ranges.isEmpty()) {
                firstRange = ranges.get(0);
            }
            if (firstRange == null || firstRange.equals(fullRange)) {
                if (_log.isDebugEnabled()) {
                    _log.debug("Writing full range");
                }
                response.setContentType(contentType);
                ServletResponseUtil.setHeaders(request, response, fileName, contentType, null, fullRange);
                ServletResponseUtil.copyRange(inputStream, (OutputStream)outputStream, fullRange.getStart(), fullRange.getLength());
            } else if (ranges.size() == 1) {
                if (_log.isDebugEnabled()) {
                    _log.debug("Attempting to write a single range");
                }
                Range range = ranges.get(0);
                response.setContentType(contentType);
                ServletResponseUtil.setHeaders(request, response, fileName, contentType, null, range);
                response.setStatus(206);
                ServletResponseUtil.copyRange(inputStream, (OutputStream)outputStream, range.getStart(), range.getLength());
            } else if (ranges.size() > 1) {
                if (_log.isDebugEnabled()) {
                    _log.debug("Attempting to write multiple ranges");
                }
                ServletOutputStream servletOutputStream = outputStream;
                String boundary = "liferay-multipart-boundary-" + System.currentTimeMillis();
                String multipartContentType = "multipart/byteranges; boundary=" + boundary;
                response.setContentType(multipartContentType);
                ServletResponseUtil.setHeaders(request, response, fileName, multipartContentType, null);
                response.setStatus(206);
                for (int i = 0; i < ranges.size(); ++i) {
                    Range range = ranges.get(i);
                    servletOutputStream.println();
                    servletOutputStream.println("--" + boundary);
                    servletOutputStream.println("Content-Type: " + contentType);
                    servletOutputStream.println("Content-Range: " + range.getContentRange());
                    servletOutputStream.println();
                    inputStream = ServletResponseUtil.copyRange(inputStream, (OutputStream)outputStream, range.getStart(), range.getLength());
                }
                servletOutputStream.println();
                servletOutputStream.println("--" + boundary + "--");
            }
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void write(HttpServletResponse response, BufferCacheServletResponse bufferCacheServletResponse) throws IOException {
        if (bufferCacheServletResponse.isByteMode()) {
            ServletResponseUtil.write(response, bufferCacheServletResponse.getByteBuffer());
        } else if (bufferCacheServletResponse.isCharMode()) {
            ServletResponseUtil.write(response, bufferCacheServletResponse.getCharBuffer());
        }
    }

    public static void write(HttpServletResponse response, byte[] bytes) throws IOException {
        ServletResponseUtil.write(response, bytes, 0, 0);
    }

    public static void write(HttpServletResponse response, byte[] bytes, int offset, int contentLength) throws IOException {
        try {
            if (!response.isCommitted()) {
                if (contentLength == 0) {
                    contentLength = bytes.length;
                }
                response.setContentLength(contentLength);
                response.flushBuffer();
                if (response instanceof BufferCacheServletResponse) {
                    BufferCacheServletResponse bufferCacheServletResponse = (BufferCacheServletResponse)response;
                    bufferCacheServletResponse.setByteBuffer(ByteBuffer.wrap(bytes, offset, contentLength));
                } else {
                    ServletOutputStream servletOutputStream = response.getOutputStream();
                    if (contentLength != 0 || !ServerDetector.isJetty()) {
                        servletOutputStream.write(bytes, offset, contentLength);
                    }
                }
            }
        }
        catch (IOException ioe) {
            if (ioe instanceof SocketException || ServletResponseUtil.isClientAbortException(ioe)) {
                if (_log.isWarnEnabled()) {
                    _log.warn(ioe);
                }
            }
            throw ioe;
        }
    }

    public static void write(HttpServletResponse response, byte[][] bytesArray) throws IOException {
        try {
            if (!response.isCommitted()) {
                long contentLength = 0L;
                for (byte[] bytes : bytesArray) {
                    contentLength += (long)bytes.length;
                }
                ServletResponseUtil.setContentLength(response, contentLength);
                response.flushBuffer();
                ServletOutputStream servletOutputStream = response.getOutputStream();
                for (byte[] bytes : bytesArray) {
                    servletOutputStream.write(bytes);
                }
            }
        }
        catch (IOException ioe) {
            if (ioe instanceof SocketException || ServletResponseUtil.isClientAbortException(ioe)) {
                if (_log.isWarnEnabled()) {
                    _log.warn(ioe);
                }
            }
            throw ioe;
        }
    }

    public static void write(HttpServletResponse response, ByteBuffer byteBuffer) throws IOException {
        if (response instanceof BufferCacheServletResponse) {
            BufferCacheServletResponse bufferCacheServletResponse = (BufferCacheServletResponse)response;
            bufferCacheServletResponse.setByteBuffer(byteBuffer);
        } else {
            ServletResponseUtil.write(response, byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.arrayOffset() + byteBuffer.limit());
        }
    }

    public static void write(HttpServletResponse response, CharBuffer charBuffer) throws IOException {
        if (response instanceof BufferCacheServletResponse) {
            BufferCacheServletResponse bufferCacheServletResponse = (BufferCacheServletResponse)response;
            bufferCacheServletResponse.setCharBuffer(charBuffer);
        } else {
            ByteBuffer byteBuffer = CharsetEncoderUtil.encode("UTF-8", charBuffer);
            ServletResponseUtil.write(response, byteBuffer);
        }
    }

    public static void write(HttpServletResponse response, File file) throws IOException {
        if (response instanceof BufferCacheServletResponse) {
            BufferCacheServletResponse bufferCacheServletResponse = (BufferCacheServletResponse)response;
            ByteBuffer byteBuffer = ByteBuffer.wrap(FileUtil.getBytes(file));
            bufferCacheServletResponse.setByteBuffer(byteBuffer);
        } else {
            FileInputStream fileInputStream = new FileInputStream(file);
            try (FileChannel fileChannel = fileInputStream.getChannel();){
                long contentLength = fileChannel.size();
                ServletResponseUtil.setContentLength(response, contentLength);
                response.flushBuffer();
                fileChannel.transferTo(0L, contentLength, Channels.newChannel((OutputStream)response.getOutputStream()));
            }
        }
    }

    public static void write(HttpServletResponse response, InputStream inputStream) throws IOException {
        ServletResponseUtil.write(response, inputStream, 0L);
    }

    public static void write(HttpServletResponse response, InputStream inputStream, long contentLength) throws IOException {
        if (response.isCommitted()) {
            StreamUtil.cleanUp(inputStream);
            return;
        }
        if (contentLength > 0L) {
            response.setHeader("Content-Length", String.valueOf(contentLength));
        }
        response.flushBuffer();
        StreamUtil.transfer(inputStream, (OutputStream)response.getOutputStream());
    }

    public static void write(HttpServletResponse response, String s) throws IOException {
        if (response instanceof BufferCacheServletResponse) {
            BufferCacheServletResponse bufferCacheServletResponse = (BufferCacheServletResponse)response;
            bufferCacheServletResponse.setString(s);
        } else {
            ByteBuffer byteBuffer = CharsetEncoderUtil.encode("UTF-8", s);
            ServletResponseUtil.write(response, byteBuffer);
        }
    }

    protected static InputStream copyRange(InputStream inputStream, OutputStream outputStream, long start, long length) throws IOException {
        if (inputStream instanceof FileInputStream) {
            FileInputStream fileInputStream = (FileInputStream)inputStream;
            FileChannel fileChannel = fileInputStream.getChannel();
            fileChannel.transferTo(start, length, Channels.newChannel(outputStream));
            return fileInputStream;
        }
        if (inputStream instanceof ByteArrayInputStream) {
            ByteArrayInputStream byteArrayInputStream = (ByteArrayInputStream)inputStream;
            byteArrayInputStream.reset();
            byteArrayInputStream.skip(start);
            StreamUtil.transfer((InputStream)byteArrayInputStream, outputStream, length);
            return byteArrayInputStream;
        }
        if (inputStream instanceof RandomAccessInputStream) {
            RandomAccessInputStream randomAccessInputStream = (RandomAccessInputStream)inputStream;
            randomAccessInputStream.seek(start);
            StreamUtil.transfer(randomAccessInputStream, outputStream, StreamUtil.BUFFER_SIZE, false, length);
            return randomAccessInputStream;
        }
        return ServletResponseUtil.copyRange(new RandomAccessInputStream(inputStream), outputStream, start, length);
    }

    protected static void setContentLength(HttpServletResponse response, long contentLength) {
        response.setHeader("Content-Length", String.valueOf(contentLength));
    }

    protected static void setHeaders(HttpServletRequest request, HttpServletResponse response, String fileName, String contentType, String contentDispositionType) {
        if (_log.isDebugEnabled()) {
            _log.debug("Sending file of type " + contentType);
        }
        if (Validator.isNotNull(contentType)) {
            if (contentType.equals("image/x-ms-bmp") && BrowserSnifferUtil.isIe(request)) {
                contentType = "image/bmp";
            }
            response.setContentType(contentType);
        }
        if (!response.containsHeader("Cache-Control")) {
            response.setHeader("Cache-Control", "private");
        }
        if (Validator.isNull(fileName)) {
            return;
        }
        String contentDispositionFileName = "filename=\"" + fileName + "\"";
        boolean ascii = true;
        for (int i = 0; i < fileName.length(); ++i) {
            if (Validator.isAscii(fileName.charAt(i))) continue;
            ascii = false;
            break;
        }
        if (!ascii) {
            String encodedFileName = HttpUtil.encodeURL(fileName, true);
            contentDispositionFileName = BrowserSnifferUtil.isIe(request) ? "filename=\"" + encodedFileName + "\"" : "filename*=UTF-8''" + encodedFileName;
        }
        if (Validator.isNull(contentDispositionType)) {
            String extension = GetterUtil.getString(FileUtil.getExtension(fileName));
            extension = StringUtil.toLowerCase(extension);
            Object[] mimeTypesContentDispositionInline = null;
            try {
                mimeTypesContentDispositionInline = PropsUtil.getArray("mime.types.content.disposition.inline");
            }
            catch (Exception e) {
                mimeTypesContentDispositionInline = new String[]{};
            }
            if (ArrayUtil.contains(mimeTypesContentDispositionInline, extension)) {
                contentDispositionType = "inline";
                contentType = MimeTypesUtil.getContentType(fileName);
                response.setContentType(contentType);
            } else {
                contentDispositionType = "attachment";
            }
        }
        StringBundler sb = new StringBundler(4);
        sb.append(contentDispositionType);
        sb.append(";");
        sb.append(" ");
        sb.append(contentDispositionFileName);
        if (_log.isDebugEnabled()) {
            _log.debug("Setting content disposition header " + sb.toString());
        }
        response.setHeader("Content-Disposition", sb.toString());
    }

    protected static void setHeaders(HttpServletRequest request, HttpServletResponse response, String fileName, String contentType, String contentDispositionType, Range range) {
        ServletResponseUtil.setHeaders(request, response, fileName, contentType, contentDispositionType);
        if (range != null) {
            response.setHeader("Content-Range", range.getContentRange());
            response.setHeader("Content-Length", String.valueOf(range.getLength()));
        }
    }
}

