/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.util.ProxyFactory;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import com.liferay.registry.ServiceTrackerFieldUpdaterCustomizer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ServiceProxyFactory {
    public static <T> T newServiceTrackedInstance(Class<T> serviceClass, Class<?> declaringClass, String fieldName, boolean blocking) {
        return ServiceProxyFactory.newServiceTrackedInstance(serviceClass, declaringClass, fieldName, null, blocking, false);
    }

    public static <T> T newServiceTrackedInstance(Class<T> serviceClass, Class<?> declaringClass, String fieldName, boolean blocking, boolean useNullAsDummyService) {
        return ServiceProxyFactory.newServiceTrackedInstance(serviceClass, declaringClass, fieldName, null, blocking, useNullAsDummyService);
    }

    public static <T> T newServiceTrackedInstance(Class<T> serviceClass, Class<?> declaringClass, String fieldName, String filterString, boolean blocking) {
        return ServiceProxyFactory.newServiceTrackedInstance(serviceClass, declaringClass, fieldName, filterString, blocking, false);
    }

    public static <T> T newServiceTrackedInstance(Class<T> serviceClass, Class<?> declaringClass, String fieldName, String filterString, boolean blocking, boolean useNullAsDummyService) {
        try {
            Field field = declaringClass.getDeclaredField(fieldName);
            if (!Modifier.isStatic(field.getModifiers())) {
                throw new IllegalArgumentException(field + " is not static");
            }
            field.setAccessible(true);
            AwaitServiceTrackerFieldUpdaterCustomizer serviceTrackerCustomizer = null;
            if (blocking) {
                ReentrantLock lock = new ReentrantLock();
                Condition realServiceSet = lock.newCondition();
                Object awaitService = ProxyUtil.newProxyInstance(serviceClass.getClassLoader(), new Class[]{serviceClass}, new AwaitServiceInvocationHandler(field, realServiceSet, lock));
                field.set(null, awaitService);
                serviceTrackerCustomizer = new AwaitServiceTrackerFieldUpdaterCustomizer(field, null, awaitService, realServiceSet, lock);
            } else {
                Object dummyService = null;
                if (!useNullAsDummyService) {
                    dummyService = ProxyFactory.newDummyInstance(serviceClass);
                    field.set(null, dummyService);
                }
                serviceTrackerCustomizer = new AwaitServiceTrackerFieldUpdaterCustomizer(field, null, dummyService);
            }
            ServiceProxyFactory._openServiceTracker(serviceClass, filterString, serviceTrackerCustomizer);
            return (T)field.get(null);
        }
        catch (ReflectiveOperationException roe) {
            return ReflectionUtil.throwException(roe);
        }
    }

    private static void _openServiceTracker(Class<?> serviceClass, String filterString, ServiceTrackerCustomizer<?, ?> serviceTrackerCustomizer) throws ReflectiveOperationException {
        ServiceTracker serviceTracker = null;
        String serviceName = serviceClass.getName();
        Registry registry = RegistryUtil.getRegistry();
        if (Validator.isNull(filterString)) {
            serviceTracker = registry.trackServices(serviceName, serviceTrackerCustomizer);
        } else {
            StringBundler sb = new StringBundler(5);
            sb.append("(&(objectClass=");
            sb.append(serviceName);
            sb.append(")");
            sb.append(filterString);
            sb.append(")");
            serviceTracker = registry.trackServices(registry.getFilter(sb.toString()), serviceTrackerCustomizer);
        }
        serviceTracker.open();
    }

    private static class AwaitServiceTrackerFieldUpdaterCustomizer<S, T>
    extends ServiceTrackerFieldUpdaterCustomizer<S, T> {
        private final T _awaitService;
        private final Lock _lock;
        private final Condition _realServiceSet;

        protected void doServiceUpdate(T newService) {
            this._lock.lock();
            try {
                super.doServiceUpdate(newService);
                if (newService != this._awaitService) {
                    this._realServiceSet.signalAll();
                }
            }
            finally {
                this._lock.unlock();
            }
        }

        private AwaitServiceTrackerFieldUpdaterCustomizer(Field serviceField, Object serviceHolder, T awaitService, Condition realServiceSet, Lock lock) {
            super(serviceField, serviceHolder, awaitService);
            this._awaitService = awaitService;
            this._realServiceSet = realServiceSet;
            this._lock = lock;
        }
    }

    private static class AwaitServiceInvocationHandler
    implements InvocationHandler {
        private final Field _field;
        private final Lock _lock;
        private final Condition _realServiceSet;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
            while (true) {
                this._lock.lock();
                try {
                    Object service = this._field.get(null);
                    if (!ProxyUtil.isProxyClass(service.getClass()) || ProxyUtil.getInvocationHandler(service) != this) {
                        Object object = method.invoke(service, arguments);
                        return object;
                    }
                    this._realServiceSet.await();
                    continue;
                }
                finally {
                    this._lock.unlock();
                    continue;
                }
                break;
            }
        }

        private AwaitServiceInvocationHandler(Field field, Condition realServiceSet, Lock lock) {
            this._field = field;
            this._realServiceSet = realServiceSet;
            this._lock = lock;
        }
    }
}

