/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.NaturalOrderStringComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.BaseSourceProcessor;
import com.liferay.source.formatter.util.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;

public class PropertiesSourceProcessor
extends BaseSourceProcessor {
    public static final String AUTOMATIC_COPY = " (Automatic Copy)";
    public static final String AUTOMATIC_TRANSLATION = " (Automatic Translation)";
    private final Map<String, Map<String, String>> _duplicateFileLanguageKeysMap = new ConcurrentHashMap<String, Map<String, String>>();
    private Map<String, Properties> _languagePropertiesMap;
    private final Pattern _licensesPattern = Pattern.compile("\nlicenses=(\\w+)\n");
    private int _maxLineLength;
    private String _portalPortalPropertiesContent;
    private final Pattern _singleValueOnMultipleLinesPattern = Pattern.compile("\n.*=(\\\\\n *).*(\n[^ ]|\\Z)");

    protected void addDuplicateLanguageKey(String fileName, String key, String value) {
        if (fileName.endsWith("portal-impl/src/content/Language.properties")) {
            return;
        }
        Map<String, String> duplicateLanguageKeysMap = this._duplicateFileLanguageKeysMap.get(fileName);
        if (duplicateLanguageKeysMap == null) {
            duplicateLanguageKeysMap = new HashMap<String, String>();
        }
        duplicateLanguageKeysMap.put(key, value);
        this._duplicateFileLanguageKeysMap.put(fileName, duplicateLanguageKeysMap);
    }

    protected Map<String, Map<String, String>> addTranslations(String fileName, Map<String, String> duplicateLanguageKeysMap, Map<String, Map<String, String>> languagePropertiesTranslationsMap) throws Exception {
        String dirName = StringUtil.replaceLast(fileName, "Language.properties", "");
        String[] includes = new String[]{"**/Language_*.properties"};
        List<String> translationFileNames = this.getFileNames(dirName, null, new String[0], includes, true);
        for (String translationFileName : translationFileNames) {
            translationFileName = StringUtil.replace(translationFileName, '\\', '/');
            File translationFile = new File(translationFileName);
            String content = FileUtil.read(translationFile);
            int pos = translationFileName.lastIndexOf("/");
            String shortTranslationFileName = translationFileName.substring(pos + 1);
            Map<String, String> translationMap = languagePropertiesTranslationsMap.get(shortTranslationFileName);
            if (translationMap == null) {
                translationMap = new HashMap<String, String>();
            }
            for (Map.Entry<String, String> entry : duplicateLanguageKeysMap.entrySet()) {
                String value;
                String key = entry.getKey();
                if (translationMap.containsKey(key) || !Validator.isNotNull(value = this.getTranslatedKey(content, key)) || value.endsWith(AUTOMATIC_COPY) || value.endsWith(AUTOMATIC_TRANSLATION)) continue;
                translationMap.put(key, value);
            }
            languagePropertiesTranslationsMap.put(shortTranslationFileName, translationMap);
        }
        return languagePropertiesTranslationsMap;
    }

    protected void checkLanguageProperties(String fileName) throws Exception {
        Properties languageProperties1;
        if (this._languagePropertiesMap == null) {
            this.populateLanguagePropertiesMap();
        }
        if ((languageProperties1 = this._languagePropertiesMap.get(fileName)) == null) {
            return;
        }
        for (Map.Entry<String, Properties> propertiesEntry : this._languagePropertiesMap.entrySet()) {
            String fileName2 = propertiesEntry.getKey();
            if (fileName.equals(fileName2)) continue;
            Properties languageProperties2 = propertiesEntry.getValue();
            for (Map.Entry<Object, Object> entry : languageProperties1.entrySet()) {
                String value2;
                String value1;
                String key = (String)entry.getKey();
                if (!languageProperties2.containsKey(key) || !(value1 = (String)entry.getValue()).equals(value2 = (String)languageProperties2.get(key))) continue;
                this.addDuplicateLanguageKey(fileName, key, value1);
                this.addDuplicateLanguageKey(fileName2, key, value1);
            }
        }
    }

    protected void checkMaxLineLength(String line, String fileName, int lineCount) {
        int y;
        String trimmedLine = StringUtil.trimLeading(line);
        if (!trimmedLine.startsWith("# ")) {
            return;
        }
        int lineLength = this.getLineLength(line);
        if (lineLength <= this._maxLineLength) {
            return;
        }
        int x = line.indexOf("# ");
        if (x + 1 == (y = line.lastIndexOf(" ", this._maxLineLength))) {
            return;
        }
        int z = line.indexOf(" ", this._maxLineLength + 1);
        if (z == -1) {
            z = lineLength;
        }
        if (z - y + x + 2 <= this._maxLineLength) {
            this.processMessage(fileName, "> " + this._maxLineLength, lineCount);
        }
    }

    @Override
    protected String doFormat(File file, String fileName, String absolutePath, String content) throws Exception {
        String newContent = content;
        if (fileName.endsWith("/dependencies.properties")) {
            newContent = this.formatDependenciesProperties(content);
        } else if (portalSource && !fileName.contains("/samples/") && fileName.endsWith("/Language.properties") && !this.isExcludedPath("language.keys.check.excludes", absolutePath)) {
            this.checkLanguageProperties(fileName);
        } else if (fileName.endsWith("/liferay-plugin-package.properties")) {
            newContent = this.formatPluginPackageProperties(fileName, absolutePath, content);
        } else if (fileName.endsWith("/portlet.properties")) {
            newContent = this.formatPortletProperties(fileName, content);
        } else if (fileName.endsWith("/source-formatter.properties")) {
            this.formatSourceFormatterProperties(fileName, content);
        } else if (!portalSource && !subrepository || !fileName.endsWith("/portal.properties")) {
            this.formatPortalProperties(fileName, content);
        }
        return this.formatProperties(fileName, newContent);
    }

    @Override
    protected List<String> doGetFileNames() throws Exception {
        return this.getFileNames(new String[0], this.getIncludes());
    }

    @Override
    protected String[] doGetIncludes() {
        if (portalSource) {
            return new String[]{"**/lib/*/dependencies.properties", "**/Language.properties", "**/liferay-plugin-package.properties", "**/portal.properties", "**/portal-ext.properties", "**/portal-legacy-*.properties", "**/portlet.properties", "**/source-formatter.properties"};
        }
        return new String[]{"**/liferay-plugin-package.properties", "**/portal.properties", "**/portal-ext.properties", "**/portlet.properties", "**/source-formatter.properties"};
    }

    protected String fixIncorrectLicenses(String absolutePath, String content) {
        if (!absolutePath.contains("/modules/apps/") && !absolutePath.contains("/modules/private/apps/")) {
            return content;
        }
        Matcher matcher = this._licensesPattern.matcher(content);
        if (!matcher.find()) {
            return content;
        }
        String licenses = matcher.group(1);
        String expectedLicenses = "LGPL";
        if (absolutePath.contains("/modules/private/apps/")) {
            expectedLicenses = "DXP";
        }
        if (licenses.equals(expectedLicenses)) {
            return content;
        }
        return StringUtil.replace(content, "licenses=" + licenses, "licenses=" + expectedLicenses, matcher.start());
    }

    protected String formatDependenciesProperties(String content) {
        List<String> lines = ListUtil.fromString(content);
        lines = ListUtil.sort(lines);
        StringBundler sb = new StringBundler(content.length() * 2);
        for (String line : lines) {
            if (!Validator.isNotNull(line = StringUtil.removeChar(line, ' ')) || line.charAt(0) == '#') continue;
            sb.append(line);
            sb.append('\n');
        }
        if (sb.index() > 0) {
            sb.setIndex(sb.index() - 1);
        }
        return sb.toString();
    }

    protected void formatDuplicateLanguageKeys() throws Exception {
        if (this._duplicateFileLanguageKeysMap.isEmpty()) {
            return;
        }
        Map<String, Map<String, String>> languagePropertiesTranslationsMap = new HashMap<String, Map<String, String>>();
        HashMap<String, String> allDuplicateLanguageKeysMap = new HashMap<String, String>();
        for (Map.Entry<String, Map<String, String>> entry : this._duplicateFileLanguageKeysMap.entrySet()) {
            String fileName = entry.getKey();
            Map<String, String> duplicateLanguageKeysMap = entry.getValue();
            this.removeDuplicateKeys(fileName, duplicateLanguageKeysMap);
            languagePropertiesTranslationsMap = this.addTranslations(fileName, duplicateLanguageKeysMap, languagePropertiesTranslationsMap);
            allDuplicateLanguageKeysMap.putAll(duplicateLanguageKeysMap);
        }
        this.writeLanguageKeysToFile("Language.properties", allDuplicateLanguageKeysMap, true);
        for (Map.Entry<String, Map<String, String>> entry : languagePropertiesTranslationsMap.entrySet()) {
            this.writeLanguageKeysToFile(entry.getKey(), entry.getValue(), false);
        }
    }

    protected String formatPluginPackageProperties(String fileName, String absolutePath, String content) {
        content = StringUtil.replace(content, "\n\n", "\n");
        Matcher matcher = this._singleValueOnMultipleLinesPattern.matcher(content = StringUtil.replace(content, "\t", "    "));
        if (matcher.find()) {
            content = StringUtil.replaceFirst(content, matcher.group(1), "", matcher.start());
        }
        content = this.sortDefinitions(fileName, content, new NaturalOrderStringComparator());
        return this.fixIncorrectLicenses(absolutePath, content);
    }

    protected void formatPortalProperties(String fileName, String content) throws Exception {
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            int lineCount = 0;
            String line = null;
            int previousPos = -1;
            String portalPortalPropertiesContent = this.getPortalPortalProperties();
            while ((line = unsyncBufferedReader.readLine()) != null) {
                ++lineCount;
                int pos = line.indexOf(61);
                if (pos == -1) continue;
                String property = StringUtil.trim(line.substring(0, pos + 1));
                pos = portalPortalPropertiesContent.indexOf("    " + property);
                if (pos == -1) continue;
                if (pos < previousPos) {
                    this.processMessage(fileName, "Follow order as in portal-impl/src/portal.properties", lineCount);
                }
                previousPos = pos;
            }
        }
    }

    protected String formatPortletProperties(String fileName, String content) throws Exception {
        if (!content.contains("include-and-override=portlet-ext.properties")) {
            content = "include-and-override=portlet-ext.properties\n\n" + content;
        }
        if (!portalSource && !subrepository) {
            return content;
        }
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            int lineCount = 0;
            String line = null;
            String previousProperty = "";
            while ((line = unsyncBufferedReader.readLine()) != null) {
                int pos;
                if (++lineCount == 1 || line.startsWith("#") || line.startsWith(" ") || line.startsWith("\t") || (pos = line.indexOf(61)) == -1) continue;
                String property = StringUtil.trim(line.substring(0, pos));
                if ((pos = property.indexOf(91)) != -1) {
                    property = property.substring(0, pos);
                }
                if (Validator.isNotNull(previousProperty) && previousProperty.compareToIgnoreCase(property) > 0) {
                    this.processMessage(fileName, "Unsorted property '" + property + "'", lineCount);
                }
                previousProperty = property;
            }
        }
        return content;
    }

    protected String formatProperties(String fileName, String content) throws Exception {
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            int lineCount = 0;
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                line = this.trimLine(line, true);
                this.checkMaxLineLength(line, fileName, ++lineCount);
                if (line.startsWith("\t")) {
                    line = line.replace("\t", "    ");
                }
                if (line.contains(" \t")) {
                    line = line.replace(" \t", "    ");
                }
                sb.append(line);
                sb.append("\n");
            }
        }
        String newContent = sb.toString();
        if (newContent.endsWith("\n")) {
            newContent = newContent.substring(0, newContent.length() - 1);
        }
        return newContent;
    }

    protected void formatSourceFormatterProperties(String fileName, String content) throws Exception {
        boolean hasPrivateAppsDir = false;
        int level = 3;
        if (portalSource) {
            File privateAppsDir = this.getFile("modules/private/apps", 7);
            if (privateAppsDir != null) {
                hasPrivateAppsDir = true;
            }
            level = 7;
        }
        Properties properties = new Properties();
        FileInputStream inputStream = new FileInputStream(fileName);
        properties.load(inputStream);
        Enumeration<?> enu = properties.propertyNames();
        while (enu.hasMoreElements()) {
            String value;
            String key = (String)enu.nextElement();
            if (!key.endsWith("excludes") || Validator.isNull(value = properties.getProperty(key))) continue;
            List<String> propertyFileNames = ListUtil.fromString(value, ",");
            for (String propertyFileName : propertyFileNames) {
                File file;
                if (propertyFileName.contains("*") || propertyFileName.endsWith("-ext.properties") || portalSource && !hasPrivateAppsDir && propertyFileName.contains("/private/apps/")) continue;
                int pos = propertyFileName.indexOf(64);
                if (pos != -1) {
                    propertyFileName = propertyFileName.substring(0, pos);
                }
                if ((file = this.getFile(propertyFileName, level)) != null) continue;
                this.processMessage(fileName, "Property value '" + propertyFileName + "' points to file that does not exist");
            }
        }
    }

    protected String getCategoryName(String line, String[][] categoryPrefixAndNameArray) {
        for (String[] categoryPrefixAndName : categoryPrefixAndNameArray) {
            String prefix = categoryPrefixAndName[0];
            if (!line.startsWith(prefix)) continue;
            return categoryPrefixAndName[1];
        }
        return "Messages";
    }

    protected String[][] getCategoryPrefixAndNameArray() {
        return new String[][]{{"action.", "Action names"}, {"category.", "Category titles"}, {"country.", "Country"}, {"currency.", "Currency"}, {"javax.portlet.", "Portlet descriptions and titles"}, {"lang.", "Language settings"}, {"language.", "Language"}, {"model.resource.", "Model resources"}};
    }

    protected String getPortalPortalProperties() throws Exception {
        if (this._portalPortalPropertiesContent != null) {
            return this._portalPortalPropertiesContent;
        }
        String portalPortalPropertiesContent = null;
        if (portalSource) {
            File file = this.getFile("portal-impl/src/portal.properties", 7);
            this._portalPortalPropertiesContent = portalPortalPropertiesContent = FileUtil.read(file);
            return this._portalPortalPropertiesContent;
        }
        ClassLoader classLoader = PropertiesSourceProcessor.class.getClassLoader();
        URL url = classLoader.getResource("portal.properties");
        portalPortalPropertiesContent = url != null ? IOUtils.toString((URL)url) : "";
        this._portalPortalPropertiesContent = portalPortalPropertiesContent;
        return this._portalPortalPropertiesContent;
    }

    protected String getTranslatedKey(String content, String key) {
        if (content.startsWith(key + "=")) {
            int x = content.indexOf("\n");
            if (x == -1) {
                return content.substring(key.length() + 1);
            }
            return content.substring(key.length() + 1, x);
        }
        int x = content.indexOf("\n" + key + "=");
        if (x == -1) {
            return null;
        }
        int y = x + key.length() + 2;
        int z = content.indexOf("\n", y);
        if (z == -1) {
            return content.substring(y);
        }
        return content.substring(y, z);
    }

    protected void populateLanguagePropertiesMap() throws Exception {
        ConcurrentHashMap<String, Properties> languagePropertiesMap = new ConcurrentHashMap<String, Properties>();
        String[] includes = new String[]{"**/Language.properties"};
        List<String> modulesLanguagePropertiesNames = this.getFileNames(this.sourceFormatterArgs.getBaseDirName(), null, new String[0], includes, true);
        for (String fileName : modulesLanguagePropertiesNames) {
            if (this.isExcludedPath("language.keys.check.excludes", fileName = StringUtil.replace(fileName, '\\', '/'))) continue;
            Properties properties = new Properties();
            FileInputStream inputStream = new FileInputStream(fileName);
            properties.load(inputStream);
            languagePropertiesMap.put(fileName, properties);
        }
        this._languagePropertiesMap = languagePropertiesMap;
    }

    @Override
    protected void postFormat() throws Exception {
        this.formatDuplicateLanguageKeys();
    }

    @Override
    protected void preFormat() throws Exception {
        this._maxLineLength = this.sourceFormatterArgs.getMaxLineLength();
    }

    protected void removeDuplicateKeys(String fileName, Map<String, String> duplicateLanguageKeysMap) throws Exception {
        String content;
        File file = new File(fileName);
        String newContent = content = FileUtil.read(file);
        for (Map.Entry<String, String> entry : duplicateLanguageKeysMap.entrySet()) {
            String line = entry.getKey() + "=" + entry.getValue();
            if (newContent.startsWith(line)) {
                if (newContent.equals(line)) {
                    newContent = "";
                    continue;
                }
                newContent = StringUtil.replace(newContent, line + "\n", "");
                continue;
            }
            newContent = StringUtil.replace(newContent, "\n" + line, "");
        }
        this.processFormattedFile(file, fileName, content, newContent);
    }

    protected void writeLanguageKeysToFile(String fileName, Map<String, String> languageKeysMap, boolean processMessage) throws Exception {
        String languagePropertiesContent;
        File languagePropertiesFile = new File(this.getFile("portal-impl", 7), "src/content/" + fileName);
        if (!languagePropertiesFile.exists()) {
            return;
        }
        String newLanguagePropertiesContent = languagePropertiesContent = FileUtil.read(languagePropertiesFile);
        String[][] categoryPrefixAndNameArray = this.getCategoryPrefixAndNameArray();
        StringBundler sb = new StringBundler();
        if (processMessage) {
            sb.append("The following language keys were used in multiple ");
            sb.append("modules and have been consolidated, or they already ");
            sb.append("existed in ");
            sb.append("portal-impl\\src\\content\\Language.properties:");
            sb.append("\n");
        }
        for (Map.Entry<String, String> entry : languageKeysMap.entrySet()) {
            String line = entry.getKey() + "=" + entry.getValue();
            if (processMessage) {
                sb.append(line);
                sb.append("\n");
            }
            String categoryName = this.getCategoryName(line, categoryPrefixAndNameArray);
            int pos = newLanguagePropertiesContent.indexOf("## " + categoryName);
            for (int i = 0; i < 3; ++i) {
                pos = newLanguagePropertiesContent.indexOf("\n", pos + 1);
            }
            if (newLanguagePropertiesContent.contains("\n" + line + "\n")) continue;
            newLanguagePropertiesContent = StringUtil.insert(newLanguagePropertiesContent, line + "\n", pos + 1);
        }
        if (processMessage) {
            this.processMessage("portal-impl/src/content/" + fileName, sb.toString());
        }
        this.processFormattedFile(languagePropertiesFile, "portal-impl/src/content/" + fileName, languagePropertiesContent, newLanguagePropertiesContent);
    }
}

