/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.BaseSourceProcessor;
import com.liferay.source.formatter.ElementComparator;
import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.Element;

public class TLDSourceProcessor
extends BaseSourceProcessor {
    private static final String[] _INCLUDES = new String[]{"**/*.tld"};
    private static final Pattern _typePattern = Pattern.compile("\n\t*<type>(.*)</type>\n");

    @Override
    protected String doFormat(File file, String fileName, String absolutePath, String content) throws Exception {
        content = this.trimContent(content, false);
        Matcher matcher = _typePattern.matcher(content);
        while (matcher.find()) {
            String typeName = matcher.group(1);
            if (typeName.matches("[A-Z]\\w*")) {
                this.processMessage(fileName, "Use fully qualified class name, see LPS-61841", this.getLineCount(content, matcher.start(1)));
                continue;
            }
            if (!typeName.equals("java.lang.String")) continue;
            content = StringUtil.replaceFirst(content, matcher.group(), "\n");
        }
        Document document = this.readXML(content);
        Element rootElement = document.getRootElement();
        List tagElements = rootElement.elements("tag");
        for (Element tagElement : tagElements) {
            Element nameElement = tagElement.element("name");
            this.checkOrder(fileName, tagElement, "attribute", nameElement.getText(), new TagElementComparator());
        }
        this.checkOrder(fileName, rootElement, "tag", null, new TagElementComparator());
        return StringUtil.replace(content, "\n\n\n", "\n\n");
    }

    @Override
    protected List<String> doGetFileNames() throws Exception {
        String[] excludes = new String[]{"**/WEB-INF/tld/**", "**/test_*.tld"};
        return this.getFileNames(excludes, this.getIncludes());
    }

    @Override
    protected String[] doGetIncludes() {
        return _INCLUDES;
    }

    private static class TagElementComparator
    extends ElementComparator {
        private TagElementComparator() {
        }

        @Override
        protected String getElementName(Element element) {
            Element nameElement = element.element(this.getNameAttribute());
            return nameElement.getText();
        }
    }
}

