/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.liferay.source.formatter.util.ThreadSafeClassLibrary;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.ClassLibrary;
import com.thoughtworks.qdox.model.DefaultDocletTagFactory;
import com.thoughtworks.qdox.model.DocletTagFactory;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaPackage;
import com.thoughtworks.qdox.model.JavaSource;
import java.io.Reader;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class UnprocessedExceptionCheck
extends AbstractCheck {
    public static final String MSG_UNPROCESSED_EXCEPTION = "exception.unprocessed";

    public int[] getDefaultTokens() {
        return new int[]{96};
    }

    public void visitToken(DetailAST detailAST) {
        String packageName;
        JavaClass exceptionClass;
        FileContents fileContents = this.getFileContents();
        String fileName = StringUtil.replace(fileContents.getFileName(), '\\', '/');
        if (fileName.contains("/test/") || fileName.contains("/testIntegration/")) {
            return;
        }
        DetailAST parameterDefAST = detailAST.findFirstToken(21);
        String exceptionVariableName = this._getName(parameterDefAST);
        this._checkUnthrownException(detailAST, exceptionVariableName);
        if (this._containsVariable(detailAST.findFirstToken(7), exceptionVariableName)) {
            return;
        }
        String exceptionClassName = this._getExceptionClassName(parameterDefAST);
        if (exceptionClassName == null) {
            return;
        }
        String originalExceptionClassName = exceptionClassName;
        JavaDocBuilder javaDocBuilder = this._getJavaDocBuilder();
        if (!exceptionClassName.contains(".")) {
            for (String importedExceptionClassName : this._getImportedExceptionClassNames(javaDocBuilder)) {
                if (!importedExceptionClassName.endsWith("." + exceptionClassName)) continue;
                exceptionClassName = importedExceptionClassName;
                break;
            }
        }
        if (!exceptionClassName.contains(".")) {
            exceptionClassName = this._getPackagePath(javaDocBuilder) + "." + exceptionClassName;
        }
        if ((exceptionClass = javaDocBuilder.getClassByName(exceptionClassName)) == null) {
            return;
        }
        while ((packageName = exceptionClass.getPackageName()).contains("com.liferay")) {
            exceptionClassName = exceptionClass.getName();
            if (exceptionClassName.equals("PortalException") || exceptionClassName.equals("SystemException")) {
                this.log(parameterDefAST.getLineNo(), MSG_UNPROCESSED_EXCEPTION, new Object[]{originalExceptionClassName});
                break;
            }
            JavaClass exceptionSuperClass = exceptionClass.getSuperJavaClass();
            if (exceptionSuperClass == null) break;
            exceptionClass = exceptionSuperClass;
        }
    }

    private void _checkUnthrownException(DetailAST detailAST, String variableName) {
        List<DetailAST> literalNewASTList = DetailASTUtil.getAllChildTokens(detailAST, true, 136);
        for (DetailAST literalNewAST : literalNewASTList) {
            DetailAST parentAST;
            String name = this._getName(literalNewAST);
            if (name == null || !name.endsWith("Exception") || (parentAST = literalNewAST.getParent()).getType() != 28 || (parentAST = parentAST.getParent()).getType() != 7) continue;
            this.log(literalNewAST.getLineNo(), MSG_UNPROCESSED_EXCEPTION, new Object[]{variableName});
        }
    }

    private boolean _containsVariable(DetailAST detailAST, String variableName) {
        List<DetailAST> nameASTList = DetailASTUtil.getAllChildTokens(detailAST, true, 58);
        for (DetailAST nameAST : nameASTList) {
            String name = nameAST.getText();
            if (!name.equals(variableName)) continue;
            return true;
        }
        return false;
    }

    private String _getExceptionClassName(DetailAST parameterDefAST) {
        DetailAST typeAST = parameterDefAST.findFirstToken(13);
        FullIdent typeIdent = FullIdent.createFullIdentBelow((DetailAST)typeAST);
        return typeIdent.getText();
    }

    private Set<String> _getImportedExceptionClassNames(JavaDocBuilder javaDocBuilder) {
        HashSet<String> exceptionClassNames = new HashSet<String>();
        JavaSource javaSource = javaDocBuilder.getSources()[0];
        for (String importClassName : javaSource.getImports()) {
            if (!importClassName.endsWith("Exception")) continue;
            exceptionClassNames.add(importClassName);
        }
        return exceptionClassNames;
    }

    private JavaDocBuilder _getJavaDocBuilder() {
        JavaDocBuilder javaDocBuilder = new JavaDocBuilder((DocletTagFactory)new DefaultDocletTagFactory(), (ClassLibrary)new ThreadSafeClassLibrary());
        FileContents fileContents = this.getFileContents();
        FileText fileText = fileContents.getText();
        javaDocBuilder.addSource((Reader)new UnsyncStringReader((String)fileText.getFullText()));
        return javaDocBuilder;
    }

    private String _getName(DetailAST detailAST) {
        DetailAST nameAST = detailAST.findFirstToken(58);
        if (nameAST != null) {
            return nameAST.getText();
        }
        DetailAST dotAST = detailAST.findFirstToken(59);
        if (dotAST != null) {
            nameAST = dotAST.findFirstToken(58);
            return nameAST.getText();
        }
        return null;
    }

    private String _getPackagePath(JavaDocBuilder javaDocBuilder) {
        JavaPackage javaPackage = javaDocBuilder.getPackages()[0];
        return javaPackage.getName();
    }
}

