/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import aQute.bnd.osgi.Constants;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.NaturalOrderStringComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ImportPackage;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.BNDImportsFormatter;
import com.liferay.source.formatter.BaseSourceProcessor;
import java.io.File;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BNDSourceProcessor
extends BaseSourceProcessor {
    private static final String[] _INCLUDE_RESOURCE_DIRS_BLACKLIST = new String[]{"classes", "META-INF/resources=src/main/resources/META-INF/resources", "META-INF/resources/content=src/main/resources/content", "WEB-INF=src/main/resources/WEB-INF"};
    private static final String[] _INCLUDES = new String[]{"**/*.bnd"};
    private final Pattern _apiOrServiceBundleSymbolicNamePattern = Pattern.compile("\\.(api|service)$");
    private final Pattern _bundleClassPathPattern = Pattern.compile("^Bundle-ClassPath:[\\s\\S]*?([^\\\\]\n|\\Z)", 8);
    private final Pattern _capabilityLineBreakPattern1 = Pattern.compile(",[^\\\\]");
    private final Pattern _capabilityLineBreakPattern2 = Pattern.compile(";[^\\\\]");
    private Map<String, String> _definitionKeysMap;
    private final Pattern _exportContentsPattern = Pattern.compile("\n-exportcontents:(\\\\\n| )((.*?)(\n[^\t]|\\Z))", 40);
    private final Pattern _exportsPattern = Pattern.compile("\nExport-Package:(\\\\\n| )((.*?)(\n[^\t]|\\Z))", 40);
    private Map<String, Map<String, String>> _fileSpecificDefinitionKeysMap;
    private final Pattern _importsPattern = Pattern.compile("\nImport-Package:(\\\\\n| )((.*?)(\n[^\t]|\\Z))", 40);
    private final Pattern _includeResourceJarPattern = Pattern.compile("-[0-9\\.]+\\.jar");
    private final Pattern _includeResourcePattern = Pattern.compile("^(-includeresource|Include-Resource):[\\s\\S]*?([^\\\\]\n|\\Z)", 8);
    private final Pattern _incorrectTabPattern = Pattern.compile("\n[^\t].*:\\\\\n(\t{2,})[^\t]");
    private final Pattern _singleValueOnMultipleLinesPattern = Pattern.compile("\n.*:(\\\\\n\t).*(\n[^\t]|\\Z)");
    private final Pattern _trailingSemiColonPattern = Pattern.compile(";(\n|\\Z)");
    private final Pattern _wilcardImportPattern = Pattern.compile("(\\S+\\*)(,\\\\\n|\n|\\Z)");

    protected void checkDirectoryAndBundleName(String fileName, String absolutePath, String content) {
        String webContextPath;
        String expectedBundleSymbolicName;
        String bundleName;
        int z;
        String applicationName;
        int x = absolutePath.lastIndexOf("/");
        int y = absolutePath.lastIndexOf("/", x - 1);
        String moduleName = absolutePath.substring(y + 1, x);
        if (absolutePath.matches(".*/apps(/.*){3,}") && !moduleName.startsWith(applicationName = absolutePath.substring((z = absolutePath.lastIndexOf("/", y - 1)) + 1, y))) {
            this.processMessage(fileName, "Module '" + moduleName + "' should start with '" + applicationName + "'");
        }
        if (moduleName.endsWith("-taglib-web")) {
            String newModuleName = moduleName.substring(0, moduleName.length() - 4);
            this.processMessage(fileName, "Rename module '" + moduleName + "' to '" + newModuleName + "'");
        }
        if ((bundleName = this.getDefinitionValue(content, "Bundle-Name")) != null) {
            String expectedBundleName;
            String strippedBundleName = StringUtil.removeChars(bundleName, '-', ' ');
            strippedBundleName = strippedBundleName.replaceAll("Implementation$", "Impl");
            if (!StringUtil.equalsIgnoreCase(strippedBundleName = strippedBundleName.replaceAll("Utilities$", "Util"), expectedBundleName = "liferay" + StringUtil.removeChars(moduleName, '-'))) {
                this.processMessage(fileName, "Incorrect Bundle-Name '" + bundleName + "'");
            }
        }
        if (moduleName.contains("-import-") || moduleName.contains("-private-")) {
            return;
        }
        String bundleSymbolicName = this.getDefinitionValue(content, "Bundle-SymbolicName");
        if (bundleSymbolicName != null && !bundleSymbolicName.equals(expectedBundleSymbolicName = "com.liferay." + StringUtil.replace(moduleName, '-', '.'))) {
            this.processMessage(fileName, "Incorrect Bundle-SymbolicName '" + bundleSymbolicName + "'");
        }
        if ((webContextPath = this.getDefinitionValue(content, "Web-ContextPath")) != null && !webContextPath.equals("/" + moduleName)) {
            this.processMessage(fileName, "Incorrect Web-ContextPath '" + webContextPath + "'");
        }
    }

    protected void checkExports(String fileName, String content, Pattern pattern, String definitionKey) {
        String bundleSymbolicName = this.getDefinitionValue(content, "Bundle-SymbolicName");
        if (bundleSymbolicName == null || bundleSymbolicName.endsWith(".compat")) {
            return;
        }
        Matcher matcher = this._apiOrServiceBundleSymbolicNamePattern.matcher(bundleSymbolicName);
        bundleSymbolicName = matcher.replaceAll("");
        matcher = pattern.matcher(content);
        if (!matcher.find()) {
            return;
        }
        String[] lines = StringUtil.splitLines(matcher.group(2));
        for (int i = 0; i < lines.length; ++i) {
            String line = StringUtil.removeChar(StringUtil.trim(lines[i]), '\\');
            if (Validator.isNull(line) || !line.startsWith("com.liferay.") || line.startsWith(bundleSymbolicName)) continue;
            StringBundler sb = new StringBundler(6);
            sb.append(definitionKey);
            sb.append(" '");
            sb.append(line);
            sb.append("' should match Bundle-SymbolicName '");
            sb.append(bundleSymbolicName);
            sb.append("'");
            this.processMessage(fileName, sb.toString(), this.getLineCount(content, matcher.start(2)) + i);
        }
    }

    protected void checkMissingSchemaVersion(String fileName, String absolutePath, String content) {
        if (content.contains("Liferay-Require-SchemaVersion:") || !content.contains("Liferay-Service: true")) {
            return;
        }
        int pos = absolutePath.lastIndexOf(47);
        File serviceXMLfile = new File(absolutePath.substring(0, pos + 1) + "service.xml");
        if (serviceXMLfile.exists()) {
            this.processMessage(fileName, "Missing 'Liferay-Require-SchemaVersion', see LPS-69385");
        }
    }

    protected void checkRange(String fileName, String content) {
        int pos = content.indexOf("\"${range");
        if (pos != -1) {
            this.processMessage(fileName, "Do not use range expression, see LPS-70519", this.getLineCount(content, pos));
        }
    }

    protected void checkWildcardImports(String fileName, String absolutePath, String content, Pattern pattern) {
        if (absolutePath.contains("/portal-kernel/") || absolutePath.contains("/third-party/") || absolutePath.contains("/util-bridges/") || absolutePath.contains("/util-java/") || absolutePath.contains("/util-taglib/") || fileName.endsWith("/system.packages.extra.bnd")) {
            return;
        }
        Matcher matcher = pattern.matcher(content);
        if (!matcher.find()) {
            return;
        }
        String imports = matcher.group(3);
        matcher = this._wilcardImportPattern.matcher(imports);
        while (matcher.find()) {
            String wildcardImport = matcher.group(1);
            if (!wildcardImport.matches("^!?com\\.liferay\\..+")) continue;
            this.processMessage(fileName, "Do not use wildcard in Export-Package '" + wildcardImport + "'");
        }
    }

    @Override
    protected String doFormat(File file, String fileName, String absolutePath, String content) throws Exception {
        Matcher matcher;
        content = this.trimContent(content, false);
        content = StringUtil.replace(content, new String[]{"/\n", "/,\\\n"}, new String[]{"\n", ",\\\n"});
        if (fileName.endsWith("-web/bnd.bnd") && content.contains("Liferay-Require-SchemaVersion: 1.0.0")) {
            this.processMessage(fileName, "Do not include the header Liferay-Require-SchemaVersion in web modules");
        }
        if ((matcher = this._trailingSemiColonPattern.matcher(content = StringUtil.replace(content, " \\\n", "\\\n"))).find()) {
            content = StringUtil.replaceFirst(content, ";", "", matcher.start());
        }
        if ((matcher = this._incorrectTabPattern.matcher(content)).find()) {
            content = StringUtil.replaceFirst(content, matcher.group(1), "\t", matcher.start());
        }
        if ((matcher = this._singleValueOnMultipleLinesPattern.matcher(content)).find()) {
            content = StringUtil.replaceFirst(content, matcher.group(1), " ", matcher.start());
        }
        this.checkWildcardImports(fileName, absolutePath, content, this._exportContentsPattern);
        this.checkWildcardImports(fileName, absolutePath, content, this._exportsPattern);
        this.checkMissingSchemaVersion(fileName, absolutePath, content);
        BNDImportsFormatter importsFormatter = new BNDImportsFormatter();
        content = importsFormatter.format(content, this._exportContentsPattern);
        content = importsFormatter.format(content, this._exportsPattern);
        content = importsFormatter.format(content, this._importsPattern);
        if ((portalSource || subrepository) && this.isModulesFile(absolutePath) && fileName.endsWith("/bnd.bnd") && !absolutePath.contains("/testIntegration/") && !absolutePath.contains("/third-party/")) {
            this.checkDirectoryAndBundleName(fileName, absolutePath, content);
            this.checkExports(fileName, content, this._exportContentsPattern, "-exportcontents");
            this.checkExports(fileName, content, this._exportsPattern, "Export-Package");
        }
        content = this.formatBundleClassPath(content);
        int pos = fileName.lastIndexOf("/");
        String shortFileName = fileName.substring(pos + 1);
        content = this.formatLineBreaks(shortFileName, content);
        content = this.formatWhitespace(shortFileName, content);
        this.checkRange(fileName, content);
        if ((portalSource || subrepository) && this.isModulesFile(absolutePath) && !fileName.endsWith("test-bnd.bnd")) {
            content = this.formatIncludeResource(content);
        }
        content = this.formatCapability(content, "Provide-Capability");
        content = this.formatCapability(content, "Require-Capability");
        return this.sortDefinitions(fileName, content, new DefinitionComparator());
    }

    @Override
    protected List<String> doGetFileNames() throws Exception {
        return this.getFileNames(new String[0], this.getIncludes());
    }

    @Override
    protected String[] doGetIncludes() {
        return _INCLUDES;
    }

    protected String formatBundleClassPath(String content) {
        Matcher matcher = this._bundleClassPathPattern.matcher(content);
        if (matcher.find()) {
            return this.sortDefinitionProperties(content, matcher.group(), new NaturalOrderStringComparator());
        }
        return content;
    }

    protected String formatCapability(String content, String definitionKey) {
        Pattern pattern = Pattern.compile("^" + definitionKey + ":[\\s\\S]*?([^\\\\]\n|\\Z)", 8);
        Matcher matcher = pattern.matcher(content);
        if (!matcher.find()) {
            return content;
        }
        String match = matcher.group();
        String replacement = StringUtil.replace(match, ": ", ":\\\n\t");
        block0: while (true) {
            matcher = this._capabilityLineBreakPattern1.matcher(replacement);
            while (matcher.find()) {
                if (ToolsUtil.isInsideQuotes(replacement, matcher.start())) continue;
                replacement = StringUtil.replaceFirst(replacement, ",", ",\\\n\t", matcher.start());
                continue block0;
            }
            break;
        }
        block2: while (true) {
            matcher = this._capabilityLineBreakPattern2.matcher(replacement);
            while (matcher.find()) {
                if (ToolsUtil.isInsideQuotes(replacement, matcher.start())) continue;
                replacement = StringUtil.replaceFirst(replacement, ";", ";\\\n\t\t", matcher.start());
                continue block2;
            }
            break;
        }
        return StringUtil.replace(content, match, replacement);
    }

    @Override
    protected String formatDefinitionKey(String fileName, String content, String definitionKey) {
        String lowerCaseDefinitionKey;
        Map<String, String> generalDefinitionKeysMap = this.getDefinitionKeysMap();
        String correctKey = generalDefinitionKeysMap.get(lowerCaseDefinitionKey = StringUtil.toLowerCase(definitionKey));
        if (correctKey == null) {
            int pos = fileName.lastIndexOf("/");
            String shortFileName = fileName.substring(pos + 1);
            Map<String, Map<String, String>> fileSpecificDefinitionKeysMap = this.getFileSpecificDefinitionKeysMap();
            Map<String, String> definitionKeysMap = fileSpecificDefinitionKeysMap.get(shortFileName);
            if (definitionKeysMap != null) {
                correctKey = definitionKeysMap.get(lowerCaseDefinitionKey);
            }
        }
        if (correctKey == null) {
            this.processMessage(fileName, "Unknown key \"" + definitionKey + "\"");
            return content;
        }
        if (correctKey.equals(definitionKey)) {
            return StringUtil.replace(content, definitionKey + "=", definitionKey + ":");
        }
        if (content.startsWith(definitionKey)) {
            return StringUtil.replaceFirst(content, definitionKey, correctKey);
        }
        return StringUtil.replace(content, "\n" + definitionKey + ":", "\n" + correctKey + ":");
    }

    protected String formatIncludeResource(String content) {
        Matcher matcher = this._includeResourcePattern.matcher(content);
        if (!matcher.find()) {
            return content;
        }
        String includeResources = matcher.group();
        if ((matcher = this._includeResourceJarPattern.matcher(includeResources)).find()) {
            String replacement = StringUtil.replace(includeResources, matcher.group(), "-[0-9]*.jar");
            return StringUtil.replace(content, includeResources, replacement);
        }
        for (String includeResourceDir : _INCLUDE_RESOURCE_DIRS_BLACKLIST) {
            Pattern includeResourceDirPattern = Pattern.compile("(\t|: )" + includeResourceDir + "(,\\\\\n|\n||\\Z)");
            Matcher matcher2 = includeResourceDirPattern.matcher(includeResources);
            if (!matcher2.find()) continue;
            String beforeIncludeResourceDir = matcher2.group(1);
            if (!beforeIncludeResourceDir.equals("\t")) {
                return StringUtil.replace(content, includeResources, "");
            }
            String afterIncludeResourceDir = matcher2.group(2);
            int x = includeResources.lastIndexOf("\\", matcher2.start());
            int y = matcher2.end();
            String replacement = null;
            if (afterIncludeResourceDir.equals(",\\\n")) {
                replacement = includeResources.substring(0, x + 1) + includeResources.substring(y - 1);
            } else {
                replacement = includeResources.substring(0, x - 1);
                if (afterIncludeResourceDir.equals("\n")) {
                    replacement = replacement + "\n";
                }
            }
            return StringUtil.replace(content, includeResources, replacement);
        }
        return this.sortDefinitionProperties(content, includeResources, new IncludeResourceComparator());
    }

    protected String formatLineBreaks(String content, Map<String, String> definitionsKeysMap) {
        if (definitionsKeysMap == null) {
            return content;
        }
        for (Map.Entry<String, String> entry : definitionsKeysMap.entrySet()) {
            String definitionKey = entry.getValue();
            Pattern pattern = Pattern.compile(" " + definitionKey + ":");
            Matcher matcher = pattern.matcher(content);
            if (!matcher.find()) continue;
            return StringUtil.replaceFirst(content, " ", "\n", matcher.start());
        }
        return content;
    }

    protected String formatLineBreaks(String shortFileName, String content) {
        content = this.formatLineBreaks(content, this.getDefinitionKeysMap());
        Map<String, Map<String, String>> fileSpecificDefinitionKeysMap = this.getFileSpecificDefinitionKeysMap();
        return this.formatLineBreaks(content, fileSpecificDefinitionKeysMap.get(shortFileName));
    }

    protected String formatWhitespace(String content, Map<String, String> definitionsKeysMap) {
        if (definitionsKeysMap == null) {
            return content;
        }
        for (Map.Entry<String, String> entry : definitionsKeysMap.entrySet()) {
            String definitionKey = entry.getValue();
            Pattern pattern = Pattern.compile("(\\A|\n)" + definitionKey + ":[^ \\\\\n]");
            Matcher matcher = pattern.matcher(content);
            if (!matcher.find()) continue;
            return StringUtil.insert(content, " ", matcher.end() - 1);
        }
        return content;
    }

    protected String formatWhitespace(String shortFileName, String content) {
        content = this.formatWhitespace(content, this.getDefinitionKeysMap());
        Map<String, Map<String, String>> fileSpecificDefinitionKeysMap = this.getFileSpecificDefinitionKeysMap();
        return this.formatWhitespace(content, fileSpecificDefinitionKeysMap.get(shortFileName));
    }

    protected Map<String, String> getDefinitionKeysMap() {
        if (this._definitionKeysMap != null) {
            return this._definitionKeysMap;
        }
        Map<Object, Object> definitionKeysMap = new HashMap();
        definitionKeysMap = this.populateDefinitionKeysMap(ArrayUtil.append(Constants.BUNDLE_SPECIFIC_HEADERS, Constants.headers, Constants.options));
        this._definitionKeysMap = definitionKeysMap;
        return this._definitionKeysMap;
    }

    protected String getDefinitionValue(String content, String key) {
        Pattern pattern = Pattern.compile("^" + key + ": (.*)(\n|\\Z)", 8);
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    protected Map<String, Map<String, String>> getFileSpecificDefinitionKeysMap() {
        if (this._fileSpecificDefinitionKeysMap != null) {
            return this._fileSpecificDefinitionKeysMap;
        }
        HashMap<String, Map<String, String>> fileSpecificDefinitionKeysMap = new HashMap<String, Map<String, String>>();
        fileSpecificDefinitionKeysMap.put("app.bnd", this.populateDefinitionKeysMap("Liferay-Releng-App-Description", "Liferay-Releng-App-Title", "Liferay-Releng-Bundle", "Liferay-Releng-Category", "Liferay-Releng-Demo-Url", "Liferay-Releng-Deprecated", "Liferay-Releng-Labs", "Liferay-Releng-Marketplace", "Liferay-Releng-Portal-Required", "Liferay-Releng-Public", "Liferay-Releng-Restart-Required", "Liferay-Releng-Support-Url", "Liferay-Releng-Supported"));
        fileSpecificDefinitionKeysMap.put("bnd.bnd", this.populateDefinitionKeysMap("-metatype-inherit", "Can-Redefine-Classes", "Can-Retransform-Classes", "Implementation-Version", "JPM-Command", "Liferay-Configuration-Path", "Liferay-Export-JS-Submodules", "Liferay-JS-Config", "Liferay-Releng-App-Description", "Liferay-Releng-Module-Group-Description", "Liferay-Releng-Module-Group-Title", "Liferay-Require-SchemaVersion", "Liferay-Service", "Liferay-Theme-Contributor-Type", "Liferay-Theme-Contributor-Weight", "Main-Class", "Premain-Class", "Web-ContextPath"));
        fileSpecificDefinitionKeysMap.put("common.bnd", this.populateDefinitionKeysMap("Git-Descriptor", "Git-SHA", "Javac-Compiler", "Javac-Debug", "Javac-Deprecation", "Javac-Encoding", "Liferay-Portal-Build-Date", "Liferay-Portal-Build-Number", "Liferay-Portal-Build-Time", "Liferay-Portal-Code-Name", "Liferay-Portal-Parent-Build-Number", "Liferay-Portal-Release-Info", "Liferay-Portal-Server-Info", "Liferay-Portal-Version"));
        this._fileSpecificDefinitionKeysMap = fileSpecificDefinitionKeysMap;
        return this._fileSpecificDefinitionKeysMap;
    }

    protected Map<String, String> populateDefinitionKeysMap(String ... keys) {
        HashMap<String, String> definitionKeysMap = new HashMap<String, String>();
        for (String key : keys) {
            definitionKeysMap.put(StringUtil.toLowerCase(key), key);
        }
        return definitionKeysMap;
    }

    protected String sortDefinitionProperties(String content, String properties, Comparator<String> comparator) {
        String[] lines = StringUtil.splitLines(properties);
        if (lines.length == 1) {
            return content;
        }
        String previousProperty = null;
        for (int i = 1; i < lines.length; ++i) {
            int value;
            String property = StringUtil.trim(lines[i]);
            if (property.endsWith(",\\")) {
                property = property.substring(0, property.length() - 2);
            }
            if (previousProperty != null && (value = comparator.compare(previousProperty, property)) > 0) {
                String replacement = StringUtil.replaceFirst(properties, previousProperty, property);
                replacement = StringUtil.replaceLast(replacement, property, previousProperty);
                return StringUtil.replace(content, properties, replacement);
            }
            previousProperty = property;
        }
        return content;
    }

    private static class IncludeResourceComparator
    implements Comparator<String> {
        private IncludeResourceComparator() {
        }

        @Override
        public int compare(String includeResource1, String includeResource2) {
            String jarFileName2;
            if (includeResource1.startsWith("@") ^ includeResource2.startsWith("@")) {
                if (includeResource1.startsWith("@")) {
                    return 1;
                }
                return -1;
            }
            int pos1 = includeResource1.indexOf(".jar!/");
            int pos2 = includeResource2.indexOf(".jar!/");
            if (pos1 == -1 || pos2 == -1) {
                return includeResource1.compareToIgnoreCase(includeResource2);
            }
            String jarFileName1 = includeResource1.substring(0, pos1);
            if (!jarFileName1.equals(jarFileName2 = includeResource1.substring(0, pos2))) {
                return includeResource1.compareToIgnoreCase(includeResource2);
            }
            String importString1 = includeResource1.substring(pos1 + 6);
            String importString2 = includeResource2.substring(pos2 + 6);
            if (importString1.endsWith(".class")) {
                importString1 = importString1.substring(0, importString1.length() - 6);
            }
            if (importString2.endsWith(".class")) {
                importString2 = importString2.substring(0, importString2.length() - 6);
            }
            ImportPackage importPackage1 = new ImportPackage(importString1, false, includeResource1);
            ImportPackage importPackage2 = new ImportPackage(importString2, false, includeResource2);
            return importPackage1.compareTo(importPackage2);
        }
    }

    private static class DefinitionComparator
    implements Comparator<String> {
        private DefinitionComparator() {
        }

        @Override
        public int compare(String definition1, String definition2) {
            if (definition1.startsWith("-") ^ definition2.startsWith("-")) {
                return -definition1.compareTo(definition2);
            }
            return definition1.compareTo(definition2);
        }
    }
}

