/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.nio.charset.CharsetDecoderUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.NaturalOrderStringComparator;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.portal.xml.SAXReaderFactory;
import com.liferay.source.formatter.BNDSettings;
import com.liferay.source.formatter.ElementComparator;
import com.liferay.source.formatter.JSPSourceProcessor;
import com.liferay.source.formatter.JavaClass;
import com.liferay.source.formatter.JavaSourceProcessor;
import com.liferay.source.formatter.SourceFormatterArgs;
import com.liferay.source.formatter.SourceFormatterHelper;
import com.liferay.source.formatter.SourceFormatterMessage;
import com.liferay.source.formatter.SourceMismatchException;
import com.liferay.source.formatter.SourceProcessor;
import com.liferay.source.formatter.util.FileUtil;
import java.awt.Desktop;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.tools.ant.types.selectors.SelectorUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.Text;
import org.dom4j.io.SAXReader;

public abstract class BaseSourceProcessor
implements SourceProcessor {
    public static final int PLUGINS_MAX_DIR_LEVEL = 3;
    public static final int PORTAL_MAX_DIR_LEVEL = 7;
    protected static final String LANGUAGE_KEYS_CHECK_EXCLUDES = "language.keys.check.excludes";
    protected static final String METHOD_CALL_SORT_EXCLUDES = "method.call.sort.excludes";
    protected static final String RUN_OUTSIDE_PORTAL_EXCLUDES = "run.outside.portal.excludes";
    protected static Pattern applyLangMergerPluginPattern = Pattern.compile("^apply[ \t]+plugin[ \t]*:[ \t]+\"com.liferay.lang.merger\"$", 8);
    protected static Pattern attributeNamePattern = Pattern.compile("[a-z]+[-_a-zA-Z0-9]*");
    protected static Pattern emptyArrayPattern = Pattern.compile("((\\[\\])+) \\{\\}");
    protected static Pattern emptyCollectionPattern = Pattern.compile("Collections\\.EMPTY_(LIST|MAP|SET)");
    protected static Pattern getterUtilGetPattern = Pattern.compile("GetterUtil\\.get(Boolean|Double|Float|Integer|Number|Object|Short|String)\\((.*?)\\);\n", 32);
    protected static Pattern javaSourceInsideJSPLinePattern = Pattern.compile("<%=(.+?)%>");
    protected static Pattern languageKeyPattern = Pattern.compile("LanguageUtil.(?:get|format)\\([^;%]+|Liferay.Language.get\\('([^']+)");
    protected static Pattern mergeLangPattern = Pattern.compile("mergeLang \\{\\s*sourceDirs = \\[(.*?)\\]", 32);
    protected static boolean portalSource;
    protected static Pattern principalExceptionPattern;
    protected static Pattern sbAppendPattern;
    protected static Pattern sbAppendWithStartingSpacePattern;
    protected static Pattern sessionKeyPattern;
    protected static Pattern singleLengthStringPattern;
    protected static Pattern stringUtilReplacePattern;
    protected static boolean subrepository;
    protected static Pattern taglibSessionKeyPattern;
    protected static Pattern unparameterizedClassTypePattern1;
    protected static Pattern unparameterizedClassTypePattern2;
    protected static Pattern validatorEqualsPattern;
    protected SourceFormatterArgs sourceFormatterArgs;
    private static final String _DOCUMENTATION_URL = "https://github.com/liferay/liferay-portal/blob/master/modules/util/source-formatter/documentation/";
    private Set<String> _annotationsExclusions;
    private Map<String, BNDSettings> _bndSettingsMap = new ConcurrentHashMap<String, BNDSettings>();
    private boolean _browserStarted;
    private Map<String, String> _compatClassNamesMap;
    private String _copyright;
    private final Pattern _definitionPattern = Pattern.compile("^([A-Za-z-]+?)[:=](\n|[\\s\\S]*?([^\\\\]\n|\\Z))", 8);
    private final Pattern _emptyLineBetweenTagsPattern = Pattern.compile("\n(\t*)</([-\\w:]+)>(\n*)(\t*)<([-\\w:]+)[> \n]");
    private final Pattern _emtpyLineInMultiLineTagsPattern = Pattern.compile("\n\t*<[-\\w:#]+\n\n\t*\\w");
    private final Pattern _emptyLineInNestedTagsPattern1 = Pattern.compile("\n(\t*)(?:<\\w.*[^/])?>\n\n(\t*)(<.*)\n");
    private final Pattern _emptyLineInNestedTagsPattern2 = Pattern.compile("\n(\t*)(.*>)\n\n(\t*)</.*(\n|$)");
    private String[] _excludes;
    private Map<String, List<String>> _exclusionPropertiesMap = new HashMap<String, List<String>>();
    private SourceMismatchException _firstSourceMismatchException;
    private Set<String> _immutableFieldTypes;
    private ComparableVersion _mainReleaseComparableVersion;
    private final Pattern _missingEmptyLineBetweenTagsPattern1 = Pattern.compile("\n(\t*)/>\n(\t*)<[-\\w:]+[> \n]");
    private final Pattern _missingEmptyLineBetweenTagsPattern2 = Pattern.compile("\n(\t*)<.* />\n(\t*)<([-\\w:]+|\\w((?!</| />).)*[^/]>)\n");
    private final List<String> _modifiedFileNames = new CopyOnWriteArrayList<String>();
    private final Map<String, Properties> _moduleLangLanguageProperties = new HashMap<String, Properties>();
    private final Map<String, Properties> _moduleLanguageProperties = new HashMap<String, Properties>();
    private String _oldCopyright;
    private List<String> _pluginsInsideModulesDirectoryNames;
    private Properties _portalLanguageProperties;
    private String _projectPathPrefix;
    private Properties _properties;
    private SourceFormatterHelper _sourceFormatterHelper;
    private Map<String, Set<SourceFormatterMessage>> _sourceFormatterMessagesMap = new ConcurrentHashMap<String, Set<SourceFormatterMessage>>();
    private boolean _usePortalCompatImport;

    @Override
    public final void format() throws Exception {
        List<String> fileNames;
        if (this.sourceFormatterArgs.isShowDocumentation()) {
            System.setProperty("java.awt.headless", "false");
        }
        if ((fileNames = this.getFileNames()).isEmpty()) {
            return;
        }
        this.preFormat();
        ExecutorService executorService = Executors.newFixedThreadPool(this.sourceFormatterArgs.getProcessorThreadCount());
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>(fileNames.size());
        for (final String string : fileNames) {
            Future<Void> future = executorService.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        BaseSourceProcessor.this.format(string);
                        return null;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Unable to format " + string, e);
                    }
                }
            });
            futures.add(future);
        }
        for (Future future : futures) {
            future.get();
        }
        executorService.shutdown();
        this.postFormat();
        this._sourceFormatterHelper.close();
    }

    public final List<String> getFileNames() throws Exception {
        List<String> fileNames = this.sourceFormatterArgs.getFileNames();
        if (fileNames != null) {
            return fileNames;
        }
        return this.doGetFileNames();
    }

    @Override
    public SourceMismatchException getFirstSourceMismatchException() {
        return this._firstSourceMismatchException;
    }

    @Override
    public String[] getIncludes() {
        return this.filterIncludes(this.doGetIncludes());
    }

    @Override
    public List<String> getModifiedFileNames() {
        return this._modifiedFileNames;
    }

    @Override
    public Set<SourceFormatterMessage> getSourceFormatterMessages() {
        TreeSet<SourceFormatterMessage> sourceFormatterMessages = new TreeSet<SourceFormatterMessage>();
        for (Map.Entry<String, Set<SourceFormatterMessage>> entry : this._sourceFormatterMessagesMap.entrySet()) {
            sourceFormatterMessages.addAll((Collection<SourceFormatterMessage>)entry.getValue());
        }
        return sourceFormatterMessages;
    }

    @Override
    public void processMessage(String fileName, String message) {
        this.processMessage(fileName, message, -1);
    }

    @Override
    public void processMessage(String fileName, String message, int lineCount) {
        this.processMessage(fileName, message, null, lineCount);
    }

    @Override
    public void processMessage(String fileName, String message, String markdownFileName) {
        this.processMessage(fileName, message, markdownFileName, -1);
    }

    @Override
    public void processMessage(String fileName, String message, String markdownFileName, int lineCount) {
        Set<SourceFormatterMessage> sourceFormatterMessages = this._sourceFormatterMessagesMap.get(fileName);
        if (sourceFormatterMessages == null) {
            sourceFormatterMessages = new TreeSet<SourceFormatterMessage>();
        }
        sourceFormatterMessages.add(new SourceFormatterMessage(fileName, message, markdownFileName, lineCount));
        this._sourceFormatterMessagesMap.put(fileName, sourceFormatterMessages);
    }

    @Override
    public void setProperties(Properties properties) {
        this._properties = properties;
    }

    @Override
    public void setSourceFormatterArgs(SourceFormatterArgs sourceFormatterArgs) {
        this.sourceFormatterArgs = sourceFormatterArgs;
        this._init();
    }

    protected boolean addExtraEmptyLine(String previousLine, String line, boolean javaSource) {
        String trimmedLine = StringUtil.trimLeading(line);
        String trimmedPreviousLine = StringUtil.trimLeading(previousLine);
        if (this instanceof JSPSourceProcessor) {
            if (trimmedPreviousLine.matches("(--)?%>") && Validator.isNotNull(line) && !trimmedLine.equals("-->")) {
                return true;
            }
            if (Validator.isNotNull(previousLine) && !trimmedPreviousLine.equals("<!--") && trimmedLine.matches("<%(--)?")) {
                return true;
            }
            if (trimmedPreviousLine.equals("<%") && trimmedLine.startsWith("//")) {
                return true;
            }
            if (trimmedPreviousLine.startsWith("//") && trimmedLine.equals("%>")) {
                return true;
            }
        }
        if (!javaSource) {
            return false;
        }
        if (Validator.isNull(previousLine) || Validator.isNull(line) || previousLine.contains("/*") || previousLine.endsWith("*/")) {
            return false;
        }
        if (trimmedPreviousLine.startsWith("// ") && !trimmedLine.startsWith("// ") || !trimmedPreviousLine.startsWith("// ") && trimmedLine.startsWith("// ")) {
            return true;
        }
        if (!trimmedPreviousLine.endsWith("{") && !trimmedPreviousLine.endsWith(":") && (trimmedLine.startsWith("for (") || trimmedLine.startsWith("if (") || trimmedLine.startsWith("try {"))) {
            return true;
        }
        return previousLine.endsWith("\t}") && !trimmedLine.startsWith("}") && !trimmedLine.startsWith(")") && !trimmedLine.startsWith("//") && !trimmedLine.equals("*/") && !trimmedLine.startsWith("catch ") && !trimmedLine.startsWith("else ") && !trimmedLine.startsWith("finally ") && !trimmedLine.startsWith("while ");
    }

    protected int adjustLevel(int level, String text, String s, int diff) {
        String[] lines;
        for (String line : lines = StringUtil.splitLines(text)) {
            if ((line = StringUtil.trim(line)).startsWith("//")) continue;
            int x = -1;
            while ((x = line.indexOf(s, x + 1)) != -1) {
                if (ToolsUtil.isInsideQuotes(line, x)) continue;
                level += diff;
            }
        }
        return level;
    }

    protected void checkEmptyCollection(String line, String fileName, int lineCount) {
        Matcher matcher = emptyCollectionPattern.matcher(line);
        if (matcher.find()) {
            String collectionType = TextFormatter.format(matcher.group(1), 9);
            this.processMessage(fileName, "Use Collections.empty" + collectionType + "()", lineCount);
        }
    }

    protected void checkGetterUtilGet(String fileName, String content) throws Exception {
        Matcher matcher = getterUtilGetPattern.matcher(content);
        while (matcher.find()) {
            List<String> parametersList = this.getParameterList(matcher.group());
            if (parametersList.size() != 2) continue;
            String defaultVariableName = "DEFAULT_" + StringUtil.toUpperCase(matcher.group(1));
            Field defaultValuefield = GetterUtil.class.getDeclaredField(defaultVariableName);
            String defaultValue = String.valueOf(defaultValuefield.get(null));
            String value = parametersList.get(1);
            if (value.equals("StringPool.BLANK")) {
                value = "";
            }
            if (!Objects.equals(value, defaultValue)) continue;
            this.processMessage(fileName, "No need to pass default value '" + parametersList.get(1) + "'", this.getLineCount(content, matcher.start()));
        }
    }

    protected void checkIfClauseParentheses(String ifClause, String fileName, int lineCount) {
        if ((ifClause = this.stripQuotes(ifClause)).matches("[^()]*\\((\\(?\\w+ instanceof \\w+\\)?( \\|\\| )?)+\\)[^()]*") && !ifClause.matches("[^()]*\\([^()]*\\)[^()]*")) {
            this.processMessage(fileName, "Redundant parentheses in if-statement", lineCount);
            return;
        }
        if (ifClause.contains("//") || ifClause.contains("/*") || ifClause.contains("*/")) {
            return;
        }
        if (this.hasRedundantParentheses(ifClause, "||", "&&") || this.hasRedundantParentheses(ifClause, "&&", "||")) {
            this.processMessage(fileName, "Redundant parentheses in if-statement", lineCount);
            return;
        }
        int previousParenthesisPos = -1;
        for (int i = 0; i < ifClause.length(); ++i) {
            String s;
            char previousChar;
            String s2;
            char c = ifClause.charAt(i);
            if (c != '(' && c != ')') continue;
            if (previousParenthesisPos != -1 && this.hasMissingParentheses(s2 = ifClause.substring(previousParenthesisPos + 1, i))) {
                this.processMessage(fileName, "Missing parentheses in if-statement", lineCount);
                return;
            }
            if (previousParenthesisPos == -1) {
                previousParenthesisPos = i;
                continue;
            }
            previousParenthesisPos = i;
            if (c != '(' || (previousChar = ifClause.charAt(i - 1)) != '(' && previousChar != ' ') continue;
            int j = i;
            while (this.getLevel(s = ifClause.substring(i + 1, j = ifClause.indexOf(")", j + 1))) != 0) {
            }
            char nextChar = ifClause.charAt(j + 1);
            if ((previousChar != '(' || nextChar != ')') && (nextChar != ')' && nextChar != ' ' || !this.hasRedundantParentheses(s))) continue;
            this.processMessage(fileName, "Redundant parentheses in if-statement", lineCount);
        }
    }

    protected void checkInefficientStringMethods(String line, String fileName, int lineCount) {
        String methodName = "toLowerCase";
        int pos = line.indexOf(".toLowerCase()");
        if (pos == -1) {
            methodName = "toUpperCase";
            pos = line.indexOf(".toUpperCase()");
        }
        if (pos == -1 && !line.contains("StringUtil.equalsIgnoreCase(")) {
            methodName = "equalsIgnoreCase";
            pos = line.indexOf(".equalsIgnoreCase(");
        }
        if (pos != -1) {
            this.processMessage(fileName, "Use StringUtil." + methodName, lineCount);
        }
    }

    protected void checkInefficientStringMethods(String line, String fileName, String absolutePath, int lineCount, boolean javaSource) {
        if (this.isExcludedPath(RUN_OUTSIDE_PORTAL_EXCLUDES, absolutePath)) {
            return;
        }
        if (javaSource) {
            this.checkInefficientStringMethods(line, fileName, lineCount);
            return;
        }
        Matcher matcher = javaSourceInsideJSPLinePattern.matcher(line);
        while (matcher.find()) {
            this.checkInefficientStringMethods(matcher.group(1), fileName, lineCount);
        }
    }

    protected void checkLanguageKeys(String fileName, String absolutePath, String content, Pattern pattern) throws Exception {
        String fileExtension = FilenameUtils.getExtension((String)fileName);
        if (!portalSource || fileExtension.equals("vm") || this.isExcludedPath(LANGUAGE_KEYS_CHECK_EXCLUDES, absolutePath)) {
            return;
        }
        if (this._portalLanguageProperties == null) {
            Properties portalLanguageProperties = new Properties();
            File portalLanguagePropertiesFile = this.getFile("portal-impl/src/content/Language.properties", 7);
            if (portalLanguagePropertiesFile != null) {
                FileInputStream inputStream = new FileInputStream(portalLanguagePropertiesFile);
                portalLanguageProperties.load(inputStream);
            }
            this._portalLanguageProperties = portalLanguageProperties;
        }
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            String[] languageKeys;
            for (String languageKey : languageKeys = this.getLanguageKeys(matcher)) {
                Properties moduleLangLanguageProperties;
                Properties moduleLanguageProperties;
                if (Validator.isNumber(languageKey) || languageKey.endsWith("}") || languageKey.endsWith("-") || languageKey.endsWith("[") || languageKey.endsWith(".") || languageKey.endsWith("_") || languageKey.startsWith("-") || languageKey.startsWith("$") || languageKey.startsWith("[") || languageKey.startsWith("{") || languageKey.startsWith(".") || languageKey.startsWith("_") || this._portalLanguageProperties.containsKey(languageKey) || (moduleLanguageProperties = this.getModuleLanguageProperties(fileName)) != null && moduleLanguageProperties.containsKey(languageKey) || (moduleLangLanguageProperties = this.getModuleLangLanguageProperties(absolutePath)) != null && moduleLangLanguageProperties.containsKey(languageKey)) continue;
                BNDSettings bndSettings = this.getBNDSettings(fileName);
                if (bndSettings == null) {
                    this.processMessage(fileName, "Missing language key '" + languageKey + "'");
                    continue;
                }
                Properties bndFileLanguageProperties = bndSettings.getLanguageProperties();
                if (bndFileLanguageProperties != null && !bndFileLanguageProperties.containsKey(languageKey)) {
                    this.processMessage(fileName, "Missing language key '" + languageKey + "'");
                }
                this.putBNDSettings(bndSettings);
            }
        }
    }

    protected void checkOrder(String fileName, Element rootElement, String elementName, String parentElementName, ElementComparator elementComparator) {
        if (rootElement == null) {
            return;
        }
        Node previousNode = null;
        Iterator iterator = rootElement.nodeIterator();
        while (iterator.hasNext()) {
            Node curNode = (Node)iterator.next();
            if (curNode instanceof Text) continue;
            if (previousNode == null) {
                previousNode = curNode;
                continue;
            }
            if (curNode instanceof Element && previousNode instanceof Element) {
                Element curElement = (Element)curNode;
                Element previousElement = (Element)previousNode;
                String curElementName = curElement.getName();
                String previousElementName = previousElement.getName();
                if (curElementName.equals(elementName) && previousElementName.equals(elementName) && elementComparator.compare(previousElement, curElement) > 0) {
                    StringBundler sb = new StringBundler(7);
                    sb.append("Incorrect order '");
                    sb.append(elementName);
                    sb.append("':");
                    if (Validator.isNotNull(parentElementName)) {
                        sb.append(" ");
                        sb.append(parentElementName);
                    }
                    sb.append(" ");
                    sb.append(elementComparator.getElementName(curElement));
                    this.processMessage(fileName, sb.toString());
                }
            }
            previousNode = curNode;
        }
    }

    protected String checkPrincipalException(String content) {
        String newContent = content;
        Matcher matcher = principalExceptionPattern.matcher(content);
        while (matcher.find()) {
            String match = matcher.group();
            String replacement = StringUtil.replace(match, "class.getName", "getNestedClasses");
            newContent = StringUtil.replace(newContent, match, replacement);
        }
        return newContent;
    }

    protected void checkPropertyUtils(String fileName, String content) {
        if (fileName.endsWith("TypeConvertorUtil.java")) {
            return;
        }
        if (content.contains("org.apache.commons.beanutils.PropertyUtils")) {
            this.processMessage(fileName, "Do not use org.apache.commons.beanutils.PropertyUtils, see LPS-62786");
        }
    }

    protected void checkResourceUtil(String line, String fileName, String absolutePath, int lineCount) {
        if (!portalSource && !subrepository || fileName.endsWith("ResourceBundleUtil.java") || this.isExcludedPath(RUN_OUTSIDE_PORTAL_EXCLUDES, absolutePath)) {
            return;
        }
        if (line.contains("ResourceBundle.getBundle(")) {
            this.processMessage(fileName, "Use ResourceBundleUtil.getBundle instead of ResourceBundle.getBundle, see LPS-58529", lineCount);
        }
        if (line.contains("resourceBundle.getString(")) {
            this.processMessage(fileName, "Use ResourceBundleUtil.getString instead of resourceBundle.getString, see LPS-58529", lineCount);
        }
    }

    protected void checkStringUtilReplace(String fileName, String content) throws Exception {
        Matcher matcher = stringUtilReplacePattern.matcher(content);
        while (matcher.find()) {
            Field field;
            String value;
            String fieldName;
            List<String> parametersList = this.getParameterList(matcher.group());
            if (parametersList.size() != 3) {
                return;
            }
            String secondParameter = parametersList.get(1);
            Matcher singleLengthMatcher = singleLengthStringPattern.matcher(secondParameter);
            if (!singleLengthMatcher.find() || (fieldName = singleLengthMatcher.group(2)) != null && (value = (String)(field = StringPool.class.getDeclaredField(fieldName)).get(null)).length() != 1) continue;
            String method = matcher.group(1);
            StringBundler sb = new StringBundler(5);
            sb.append("Use StringUtil.");
            sb.append(method);
            sb.append("(String, char, char) or StringUtil.");
            sb.append(method);
            sb.append("(String, char, String) instead");
            this.processMessage(fileName, sb.toString(), this.getLineCount(content, matcher.start()));
        }
    }

    protected void checkUTF8(File file, String fileName) throws Exception {
        byte[] bytes = FileUtil.getBytes(file);
        try {
            CharsetDecoder charsetDecoder = CharsetDecoderUtil.getCharsetDecoder("UTF-8", CodingErrorAction.REPORT);
            charsetDecoder.decode(ByteBuffer.wrap(bytes));
        }
        catch (Exception e) {
            this.processMessage(fileName, "UTF-8");
        }
    }

    protected abstract String doFormat(File var1, String var2, String var3, String var4) throws Exception;

    protected abstract List<String> doGetFileNames() throws Exception;

    protected abstract String[] doGetIncludes();

    protected String[] filterIncludes(String[] includes) {
        List<String> fileExtensions = this.sourceFormatterArgs.getFileExtensions();
        if (fileExtensions.isEmpty()) {
            return includes;
        }
        String[] filteredIncludes = new String[]{};
        for (String include : includes) {
            for (String fileExtension : fileExtensions) {
                if (!include.endsWith(fileExtension)) continue;
                filteredIncludes = ArrayUtil.append(filteredIncludes, include);
            }
        }
        return filteredIncludes;
    }

    protected String fixCompatClassImports(String absolutePath, String content) throws Exception {
        if (portalSource || subrepository || !this._usePortalCompatImport || absolutePath.contains("/ext-") || absolutePath.contains("/portal-compat-shared/")) {
            return content;
        }
        Map<String, String> compatClassNamesMap = this.getCompatClassNamesMap();
        String newContent = content;
        for (Map.Entry<String, String> entry : compatClassNamesMap.entrySet()) {
            Matcher matcher;
            String compatClassName = entry.getKey();
            String extendedClassName = entry.getValue();
            Pattern pattern = Pattern.compile(extendedClassName + "\\W");
            while ((matcher = pattern.matcher(newContent)).find()) {
                newContent = newContent.substring(0, matcher.start()) + compatClassName + newContent.substring(matcher.end() - 1);
            }
        }
        return newContent;
    }

    protected String fixCopyright(String content, String absolutePath, String fileName, String className) throws IOException {
        int x;
        if (this._copyright == null) {
            this._copyright = this.getContent(this.sourceFormatterArgs.getCopyrightFileName(), 7);
        }
        String copyright = this._copyright;
        if (fileName.endsWith(".tpl") || fileName.endsWith(".vm") || Validator.isNull(copyright)) {
            return content;
        }
        if (this._oldCopyright == null) {
            this._oldCopyright = this.getContent("old-copyright.txt", 7);
        }
        if (Validator.isNotNull(this._oldCopyright) && content.contains(this._oldCopyright)) {
            content = StringUtil.replace(content, this._oldCopyright, copyright);
            this.processMessage(fileName, "File contains old copyright information");
        }
        if (!content.contains(copyright)) {
            String customCopyright = this.getCustomCopyright(absolutePath);
            if (Validator.isNotNull(customCopyright)) {
                copyright = customCopyright;
            }
            if (!content.contains(copyright)) {
                this.processMessage(fileName, "(c)");
            } else if (!content.startsWith(copyright) && !content.startsWith("<%--\n" + copyright)) {
                this.processMessage(fileName, "File must start with copyright");
            }
        } else if (!content.startsWith(copyright) && !content.startsWith("<%--\n" + copyright)) {
            this.processMessage(fileName, "File must start with copyright");
        }
        if (fileName.endsWith(".jsp") || fileName.endsWith(".jspf")) {
            content = StringUtil.replace(content, "<%\n" + copyright + "\n%>", "<%--\n" + copyright + "\n--%>");
        }
        if ((x = content.indexOf("* Copyright (c) 2000-")) == -1) {
            return content;
        }
        int y = content.indexOf("Liferay", x);
        String contentCopyrightYear = content.substring(x, y);
        x = copyright.indexOf("* Copyright (c) 2000-");
        if (x == -1) {
            return content;
        }
        y = copyright.indexOf("Liferay", x);
        String copyrightYear = copyright.substring(x, y);
        return StringUtil.replace(content, contentCopyrightYear, copyrightYear);
    }

    protected String fixEmptyLinesBetweenTags(String content) {
        String tabs2;
        String tabs1;
        Matcher matcher = this._emptyLineBetweenTagsPattern.matcher(content);
        while (matcher.find()) {
            tabs1 = matcher.group(1);
            if (!tabs1.equals(tabs2 = matcher.group(4))) continue;
            String lineBreaks = matcher.group(3);
            String tagName1 = matcher.group(2);
            String tagName2 = matcher.group(5);
            if (tagName1.endsWith(":when") || tagName1.matches("dd|dt|li|span|td|th|tr") && tagName2.matches("dd|dt|li|span|td|th|tr")) {
                if (!lineBreaks.equals("\n\n")) continue;
                return StringUtil.replaceFirst(content, "\n\n", "\n", matcher.end(1));
            }
            if (!lineBreaks.equals("\n")) continue;
            return StringUtil.replaceFirst(content, "\n", "\n\n", matcher.end(1));
        }
        matcher = this._missingEmptyLineBetweenTagsPattern1.matcher(content);
        while (matcher.find()) {
            tabs1 = matcher.group(1);
            if (!tabs1.equals(tabs2 = matcher.group(2))) continue;
            return StringUtil.replaceFirst(content, "\n", "\n\n", matcher.end(1));
        }
        matcher = this._missingEmptyLineBetweenTagsPattern2.matcher(content);
        while (matcher.find()) {
            tabs1 = matcher.group(1);
            if (!tabs1.equals(tabs2 = matcher.group(2))) continue;
            return StringUtil.replaceFirst(content, "\n", "\n\n", matcher.end(1));
        }
        return content;
    }

    protected String fixEmptyLinesInMultiLineTags(String content) {
        Matcher matcher = this._emtpyLineInMultiLineTagsPattern.matcher(content);
        if (matcher.find()) {
            return StringUtil.replaceFirst(content, "\n\n", "\n", matcher.start());
        }
        return content;
    }

    protected String fixEmptyLinesInNestedTags(String content) {
        content = this.fixEmptyLinesInNestedTags(content, this._emptyLineInNestedTagsPattern1, true);
        return this.fixEmptyLinesInNestedTags(content, this._emptyLineInNestedTagsPattern2, false);
    }

    protected String fixEmptyLinesInNestedTags(String content, Pattern pattern, boolean startTag) {
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            String tabs2 = null;
            if (startTag) {
                String secondLine = matcher.group(3);
                if (secondLine.equals("<%") || secondLine.startsWith("<%--") || secondLine.startsWith("<!--")) continue;
                tabs2 = matcher.group(2);
            } else {
                String firstLine = matcher.group(2);
                if (firstLine.equals("%>")) continue;
                tabs2 = matcher.group(3);
            }
            String tabs1 = matcher.group(1);
            if ((!startTag || tabs1.length() + 1 != tabs2.length()) && (startTag || tabs1.length() - 1 != tabs2.length())) continue;
            content = StringUtil.replaceFirst(content, "\n", "", matcher.end(1));
        }
        return content;
    }

    protected String fixIncorrectParameterTypeForLanguageUtil(String content, boolean autoFix, String fileName) {
        if (portalSource || subrepository) {
            return content;
        }
        String expectedParameter = this.getProperty("languageutil.expected.parameter");
        String incorrectParameter = this.getProperty("languageutil.incorrect.parameter");
        if (!content.contains("LanguageUtil.format(" + incorrectParameter + ", ") && !content.contains("LanguageUtil.get(" + incorrectParameter + ", ")) {
            return content;
        }
        if (autoFix) {
            content = StringUtil.replace(content, new String[]{"LanguageUtil.format(" + incorrectParameter + ", ", "LanguageUtil.get(" + incorrectParameter + ", "}, new String[]{"LanguageUtil.format(" + expectedParameter + ", ", "LanguageUtil.get(" + expectedParameter + ", "});
        } else {
            this.processMessage(fileName, "(Unicode)LanguageUtil.format/get methods require " + expectedParameter + " parameter instead of " + incorrectParameter);
        }
        return content;
    }

    protected String fixSessionKey(String fileName, String content, Pattern pattern) {
        Matcher matcher = pattern.matcher(content);
        if (!matcher.find()) {
            return content;
        }
        String newContent = content;
        do {
            String match = matcher.group();
            String s = null;
            if (pattern.equals(sessionKeyPattern)) {
                s = ",";
            } else if (pattern.equals(taglibSessionKeyPattern)) {
                s = "key=";
            }
            int x = match.indexOf(s);
            if (x == -1) continue;
            String substring = match.substring(x += s.length()).trim();
            String quote = "";
            if (substring.startsWith("'")) {
                quote = "'";
            } else {
                if (!substring.startsWith("\"")) continue;
                quote = "\"";
            }
            int y = match.indexOf(quote, x);
            int z = match.indexOf(quote, y + 1);
            if (y == -1 || z == -1) continue;
            String prefix = match.substring(0, y + 1);
            String suffix = match.substring(z);
            String oldKey = match.substring(y + 1, z);
            boolean alphaNumericKey = true;
            for (char c : oldKey.toCharArray()) {
                if (Validator.isChar(c) || Validator.isDigit(c) || c == '-' || c == '_') continue;
                alphaNumericKey = false;
            }
            if (!alphaNumericKey) continue;
            String newKey = TextFormatter.format(oldKey, 14);
            if ((newKey = TextFormatter.format(newKey, 12)).equals(oldKey)) continue;
            String oldSub = prefix.concat(oldKey).concat(suffix);
            String newSub = prefix.concat(newKey).concat(suffix);
            newContent = StringUtil.replaceFirst(newContent, oldSub, newSub);
        } while (matcher.find());
        return newContent;
    }

    protected String fixUnparameterizedClassType(String content) {
        Matcher matcher = unparameterizedClassTypePattern1.matcher(content);
        if (matcher.find()) {
            return StringUtil.replaceFirst(content, "Class", "Class<?>", matcher.start());
        }
        matcher = unparameterizedClassTypePattern2.matcher(content);
        if (matcher.find()) {
            return StringUtil.replaceFirst(content, "Class", "Class<?>", matcher.start());
        }
        return content;
    }

    protected final String format(File file, String fileName, String absolutePath, String content) throws Exception {
        this._sourceFormatterMessagesMap.remove(fileName);
        this.checkUTF8(file, fileName);
        if (!(this instanceof JavaSourceProcessor) && absolutePath.matches(".*\\/modules\\/.*\\/src\\/.*\\/java\\/.*")) {
            this.processMessage(fileName, "Only *.java files are allowed in /src/*/java/");
        }
        String newContent = this.doFormat(file, fileName, absolutePath, content);
        if (content.equals(newContent = StringUtil.replace(newContent, "\r", ""))) {
            return content;
        }
        return this.format(file, fileName, absolutePath, newContent);
    }

    protected final void format(String fileName) throws Exception {
        if (!this._isMatchPath(fileName)) {
            return;
        }
        fileName = StringUtil.replace(fileName, '\\', '/');
        String absolutePath = this.getAbsolutePath(fileName);
        File file = new File(absolutePath);
        String content = FileUtil.read(file);
        String newContent = this.format(file, fileName, absolutePath, content);
        this.processFormattedFile(file, fileName, content, newContent);
    }

    protected String formatAttributes(String fileName, String line, String tag, int lineCount, boolean escapeQuotes) throws Exception {
        String s = tag;
        int y = s.indexOf(32);
        if (y == -1) {
            return line;
        }
        String tagName = s.substring(1, y);
        s = s.substring(y + 1);
        String previousAttribute = null;
        String previousAttributeAndValue = null;
        boolean wrongOrder = false;
        int x = 0;
        while ((x = s.indexOf(61)) != -1 && s.length() > x + 1) {
            String newLine;
            char delimeter;
            String attribute = s.substring(0, x);
            String trimmedAttribute = StringUtil.trim(attribute);
            if (!this.isAttributName(trimmedAttribute)) {
                return line;
            }
            if (!attribute.equals(trimmedAttribute)) {
                return StringUtil.replace(line, attribute + "=", trimmedAttribute + "=");
            }
            if (Validator.isNotNull(previousAttribute) && previousAttribute.compareToIgnoreCase(attribute) > 0) {
                wrongOrder = true;
            }
            if ((delimeter = (s = s.substring(x + 1)).charAt(0)) != '\'' && delimeter != '\"') {
                if (delimeter == ' ') {
                    return StringUtil.replace(line, attribute + "= ", attribute + "=");
                }
                if (delimeter != '&') {
                    this.processMessage(fileName, "Incorrect delimeter '" + delimeter + "'", lineCount);
                }
                return line;
            }
            s = s.substring(1);
            String value = null;
            y = -1;
            do {
                if ((y = s.indexOf(delimeter, y + 1)) != -1 && s.length() > y + 1) continue;
                return line;
            } while (!((value = s.substring(0, y)).startsWith("<%") ? this.getLevel(value, "<%", "%>") == 0 : this.getLevel(value, "<", ">") == 0));
            if (delimeter == '\'') {
                if (escapeQuotes) {
                    String newValue = StringUtil.replace(value, "\"", "&quot;");
                    return StringUtil.replace(line, "'" + value + "'", "\"" + newValue + "\"");
                }
                if (!value.contains("\"") || !tagName.contains(":")) {
                    return StringUtil.replace(line, "'" + value + "'", "\"" + value + "\"");
                }
            }
            if (delimeter == '\"' && value.contains("\"") && tagName.contains(":")) {
                return StringUtil.replace(line, "\"" + value + "\"", "'" + value + "'");
            }
            StringBundler sb = new StringBundler(5);
            sb.append(attribute);
            sb.append("=");
            sb.append(delimeter);
            sb.append(value);
            sb.append(delimeter);
            String currentAttributeAndValue = sb.toString();
            if (!tagName.contains(":") && !(newLine = this.sortHTMLAttributes(line, value, currentAttributeAndValue)).equals(line)) {
                return newLine;
            }
            newLine = this.formatTagAttributeType(line, tagName, currentAttributeAndValue);
            if (!newLine.equals(line)) {
                return newLine;
            }
            if (wrongOrder) {
                if (StringUtil.count(line, currentAttributeAndValue) == 1 && StringUtil.count(line, previousAttributeAndValue) == 1) {
                    line = StringUtil.replaceFirst(line, previousAttributeAndValue, currentAttributeAndValue);
                    return StringUtil.replaceLast(line, currentAttributeAndValue, previousAttributeAndValue);
                }
                return line;
            }
            if ((s = s.substring(y + 1)).startsWith(">")) {
                return line;
            }
            s = StringUtil.trimLeading(s);
            previousAttribute = attribute;
            previousAttributeAndValue = currentAttributeAndValue;
        }
        return line;
    }

    protected String formatDefinitionKey(String fileName, String content, String definitionKey) {
        return content;
    }

    protected String formatEmptyArray(String line) {
        Matcher matcher = emptyArrayPattern.matcher(line);
        while (matcher.find()) {
            if (ToolsUtil.isInsideQuotes(line, matcher.end(1))) continue;
            String replacement = StringUtil.replace(matcher.group(1), "[]", "[0]");
            return StringUtil.replaceFirst(line, matcher.group(), replacement, matcher.start());
        }
        return line;
    }

    protected String formatIncorrectSyntax(String line, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(line);
        if (!matcher.find()) {
            return line;
        }
        if (ToolsUtil.isInsideQuotes(line, matcher.start(1))) {
            return line;
        }
        String whitespace = matcher.group(2);
        if (whitespace.length() > 0) {
            return line;
        }
        return line.substring(0, matcher.start(2)) + " " + line.substring(matcher.start(2));
    }

    protected String formatIncorrectSyntax(String line, String incorrectSyntax, String correctSyntax, boolean lineStart) {
        if (lineStart) {
            if (line.startsWith(incorrectSyntax)) {
                line = StringUtil.replaceFirst(line, incorrectSyntax, correctSyntax);
            }
            return line;
        }
        int x = -1;
        while ((x = line.indexOf(incorrectSyntax, x + 1)) != -1) {
            if (ToolsUtil.isInsideQuotes(line, x)) continue;
            line = StringUtil.replaceFirst(line, incorrectSyntax, correctSyntax, x);
        }
        return line;
    }

    protected String formatJavaTerms(String javaClassName, String packagePath, File file, String fileName, String absolutePath, String content, String javaClassContent, int javaClassLineCount, String indent, String checkJavaFieldTypesExcludesProperty, String javaTermSortExcludesProperty, String testAnnotationsExcludesProperty) throws Exception {
        JavaSourceProcessor javaSourceProcessor = null;
        if (this instanceof JavaSourceProcessor) {
            javaSourceProcessor = (JavaSourceProcessor)this;
        } else {
            javaSourceProcessor = new JavaSourceProcessor();
            javaSourceProcessor.setProperties(this._properties);
            javaSourceProcessor.setSourceFormatterArgs(this.sourceFormatterArgs);
        }
        JavaClass javaClass = new JavaClass(javaClassName, packagePath, file, fileName, absolutePath, content, javaClassContent, javaClassLineCount, indent + "\t", null, javaSourceProcessor);
        String newJavaClassContent = javaClass.formatJavaTerms(this.getAnnotationsExclusions(), this.getImmutableFieldTypes(), checkJavaFieldTypesExcludesProperty, javaTermSortExcludesProperty, testAnnotationsExcludesProperty);
        if (!javaClassContent.equals(newJavaClassContent)) {
            return StringUtil.replaceFirst(content, javaClassContent, newJavaClassContent);
        }
        return content;
    }

    protected String formatStringBundler(String fileName, String content, int maxLineLength) {
        Matcher matcher = sbAppendPattern.matcher(content);
        block0: while (matcher.find()) {
            String[] appendValueParts;
            String appendValue = this.stripQuotes(matcher.group(2), '\"');
            if (!(appendValue = StringUtil.replace(appendValue, "+\n", "+ ")).contains(" + ")) continue;
            for (String appendValuePart : appendValueParts = StringUtil.split(appendValue, " + ")) {
                if (this.getLevel(appendValuePart) != 0 || Validator.isNumber(appendValuePart)) continue block0;
            }
            this.processMessage(fileName, "Incorrect use of '+' inside StringBundler", this.getLineCount(content, matcher.start(1)));
        }
        matcher = sbAppendWithStartingSpacePattern.matcher(content);
        while (matcher.find()) {
            String firstLine = matcher.group(1);
            if (firstLine.endsWith("\\n\");")) continue;
            if (maxLineLength != -1 && this.getLineLength(firstLine) >= maxLineLength) {
                this.processMessage(fileName, "Do not append string starting with space to StringBundler", this.getLineCount(content, matcher.start(3)));
                continue;
            }
            content = StringUtil.replaceFirst(content, "\");\n", " \");\n", matcher.start(2));
            content = StringUtil.replaceFirst(content, "(\" ", "(\"", matcher.start(3));
        }
        return content;
    }

    protected String formatTagAttributeType(String line, String tagName, String attributeAndValue) throws Exception {
        return line;
    }

    protected String formatWhitespace(String line, boolean javaSource) {
        String trimmedLine = StringUtil.trimLeading(line);
        line = this.formatWhitespace(line, trimmedLine, javaSource);
        if (javaSource) {
            return line;
        }
        Matcher matcher = javaSourceInsideJSPLinePattern.matcher(line);
        while (matcher.find()) {
            String linePart = matcher.group(1);
            if (!linePart.startsWith(" ")) {
                return StringUtil.replace(line, matcher.group(), "<%= " + linePart + "%>");
            }
            if (!linePart.endsWith(" ")) {
                return StringUtil.replace(line, matcher.group(), "<%=" + linePart + " %>");
            }
            line = this.formatWhitespace(line, linePart, true);
        }
        return line;
    }

    protected String formatWhitespace(String line, String linePart, boolean javaSource) {
        String linePart2;
        String originalLinePart = linePart;
        linePart = this.formatIncorrectSyntax(linePart, "catch(", "catch (", true);
        linePart = this.formatIncorrectSyntax(linePart, "else{", "else {", true);
        linePart = this.formatIncorrectSyntax(linePart, "else if(", "else if (", true);
        linePart = this.formatIncorrectSyntax(linePart, "for(", "for (", true);
        linePart = this.formatIncorrectSyntax(linePart, "if(", "if (", true);
        linePart = this.formatIncorrectSyntax(linePart, "while(", "while (", true);
        linePart = this.formatIncorrectSyntax(linePart, "List <", "List<", false);
        if (javaSource) {
            linePart = this.formatIncorrectSyntax(linePart, " ...", "...", false);
            linePart = this.formatIncorrectSyntax(linePart, " [", "[", false);
            linePart = this.formatIncorrectSyntax(linePart, "{ ", "{", false);
            linePart = this.formatIncorrectSyntax(linePart, " }", "}", false);
            linePart = this.formatIncorrectSyntax(linePart, " )", ")", false);
            linePart = this.formatIncorrectSyntax(linePart, "( ", "(", false);
            linePart = this.formatIncorrectSyntax(linePart, "){", ") {", false);
            linePart = this.formatIncorrectSyntax(linePart, "]{", "] {", false);
            linePart = this.formatIncorrectSyntax(linePart, "\\w(( ?)=)");
            linePart = this.formatIncorrectSyntax(linePart, "(=( ?))\\w");
            linePart = this.formatIncorrectSyntax(linePart, "for \\(.*(( ?):)");
            linePart = this.formatIncorrectSyntax(linePart, "for \\(.*(:( ?)).+");
        }
        if (!linePart.startsWith("##")) {
            int x = 0;
            while ((x = linePart.indexOf("  ", x + 1)) != -1) {
                if (ToolsUtil.isInsideQuotes(linePart, x)) continue;
                linePart = StringUtil.replaceFirst(linePart, "  ", " ", x);
            }
        }
        if (!javaSource) {
            line = StringUtil.replace(line, originalLinePart, linePart);
            return this.formatIncorrectSyntax(line, " \t", "\t", false);
        }
        if (!line.contains("//")) {
            while (linePart.contains("\t")) {
                linePart = StringUtil.replaceLast(linePart, "\t", " ");
            }
        }
        if (line.contains("//")) {
            line = StringUtil.replace(line, originalLinePart, linePart);
            return this.formatIncorrectSyntax(line, " \t", "\t", false);
        }
        int pos = linePart.indexOf(") ");
        if (!(pos == -1 || pos + 2 >= linePart.length() || linePart.contains("@") || ToolsUtil.isInsideQuotes(linePart, pos) || !Character.isLetter((linePart2 = linePart.substring(pos + 2)).charAt(0)) || linePart2.startsWith("default") || linePart2.startsWith("instanceof") || linePart2.startsWith("return") || linePart2.startsWith("throws"))) {
            linePart = StringUtil.replaceFirst(linePart, " ", "", pos);
        }
        if ((pos = linePart.indexOf(" (")) != -1 && !linePart.contains("=") && !ToolsUtil.isInsideQuotes(linePart, pos) && (linePart.startsWith("private ") || linePart.startsWith("protected ") || linePart.startsWith("public "))) {
            linePart = StringUtil.replaceFirst(linePart, " (", "(", pos);
        }
        int x = -1;
        while (true) {
            char previousChar;
            char nextChar;
            int posComma = linePart.indexOf(44, x + 1);
            int posSemicolon = linePart.indexOf(59, x + 1);
            if (posComma == -1 && posSemicolon == -1) break;
            x = Math.min(posComma, posSemicolon);
            if (x == -1) {
                x = Math.max(posComma, posSemicolon);
            }
            if (ToolsUtil.isInsideQuotes(linePart, x)) continue;
            if (linePart.length() > x + 1 && (nextChar = linePart.charAt(x + 1)) != '\'' && nextChar != ')' && nextChar != ' ' && nextChar != '*') {
                linePart = StringUtil.insert(linePart, " ", x + 1);
            }
            if (x <= 0 || (previousChar = linePart.charAt(x - 1)) != ' ') continue;
            linePart = linePart.substring(0, x - 1).concat(linePart.substring(x));
        }
        line = StringUtil.replace(line, originalLinePart, linePart);
        return this.formatIncorrectSyntax(line, " \t", "\t", false);
    }

    protected String getAbsolutePath(String fileName) {
        Path filePath = Paths.get(fileName, new String[0]);
        filePath = filePath.toAbsolutePath();
        filePath = filePath.normalize();
        return StringUtil.replace(filePath.toString(), '\\', '/');
    }

    protected Set<String> getAnnotationsExclusions() {
        if (this._annotationsExclusions != null) {
            return this._annotationsExclusions;
        }
        this._annotationsExclusions = SetUtil.fromArray(new String[]{"ArquillianResource", "Autowired", "BeanReference", "Captor", "Inject", "Mock", "Parameter", "Reference", "ServiceReference", "SuppressWarnings"});
        return this._annotationsExclusions;
    }

    protected BNDSettings getBNDSettings(String fileName) throws Exception {
        for (Map.Entry<String, BNDSettings> entry : this._bndSettingsMap.entrySet()) {
            String bndFileLocation = entry.getKey();
            if (!fileName.startsWith(bndFileLocation)) continue;
            return entry.getValue();
        }
        String bndFileLocation = fileName;
        int pos;
        while ((pos = bndFileLocation.lastIndexOf("/")) != -1) {
            File file = new File((bndFileLocation = bndFileLocation.substring(0, pos + 1)) + "bnd.bnd");
            if (file.exists()) {
                return new BNDSettings(bndFileLocation, FileUtil.read(file));
            }
            bndFileLocation = StringUtil.replaceLast(bndFileLocation, "/", "");
        }
        return null;
    }

    protected Map<String, BNDSettings> getBNDSettingsMap() {
        return this._bndSettingsMap;
    }

    protected Map<String, String> getCompatClassNamesMap() throws Exception {
        if (this._compatClassNamesMap != null) {
            return this._compatClassNamesMap;
        }
        HashMap<String, String> compatClassNamesMap = new HashMap<String, String>();
        String[] includes = new String[]{"**/portal-compat-shared/src/com/liferay/compat/**/*.java"};
        String basedir = this.sourceFormatterArgs.getBaseDirName();
        List<Object> fileNames = new ArrayList();
        for (int i = 0; i < 3; ++i) {
            File sharedDir = new File(basedir + "shared");
            if (sharedDir.exists()) {
                fileNames = this.getFileNames(basedir, new String[0], includes);
                break;
            }
            basedir = basedir + "../";
        }
        for (String fileName : fileNames) {
            File file = new File(fileName);
            String content = FileUtil.read(file);
            fileName = StringUtil.replace(fileName, '\\', '/');
            fileName = StringUtil.replace(fileName, '/', '.');
            int pos = fileName.indexOf("com.");
            String compatClassName = fileName.substring(pos);
            compatClassName = compatClassName.substring(0, compatClassName.length() - 5);
            String extendedClassName = StringUtil.replace(compatClassName, "compat.", "");
            if (!content.contains("extends " + extendedClassName)) continue;
            compatClassNamesMap.put(compatClassName, extendedClassName);
        }
        this._compatClassNamesMap = compatClassNamesMap;
        return this._compatClassNamesMap;
    }

    protected String getContent(String fileName, int level) throws IOException {
        String content;
        File file = this.getFile(fileName, level);
        if (file != null && Validator.isNotNull(content = FileUtil.read(file))) {
            return content;
        }
        return "";
    }

    protected String getCustomCopyright(String absolutePath) throws IOException {
        int x = absolutePath.length();
        while ((x = absolutePath.lastIndexOf(47, x)) != -1) {
            String copyright = FileUtil.read(new File(absolutePath.substring(0, x + 1) + "copyright.txt"));
            if (Validator.isNotNull(copyright)) {
                return copyright;
            }
            --x;
        }
        return null;
    }

    protected File getFile(String fileName, int level) {
        return this._sourceFormatterHelper.getFile(this.sourceFormatterArgs.getBaseDirName(), fileName, level);
    }

    protected List<String> getFileNames(String basedir, List<String> recentChangesFileNames, String[] excludes, String[] includes) throws Exception {
        return this.getFileNames(basedir, recentChangesFileNames, excludes, includes, this.sourceFormatterArgs.isIncludeSubrepositories());
    }

    protected List<String> getFileNames(String basedir, List<String> recentChangesFileNames, String[] excludes, String[] includes, boolean includeSubrepositories) throws Exception {
        if (this._excludes != null) {
            excludes = ArrayUtil.append(excludes, this._excludes);
        }
        return this._sourceFormatterHelper.getFileNames(basedir, recentChangesFileNames, excludes, includes, includeSubrepositories);
    }

    protected List<String> getFileNames(String basedir, String[] excludes, String[] includes) throws Exception {
        return this.getFileNames(basedir, this.sourceFormatterArgs.getRecentChangesFileNames(), excludes, includes);
    }

    protected List<String> getFileNames(String[] excludes, String[] includes) throws Exception {
        return this.getFileNames(this.sourceFormatterArgs.getBaseDirName(), excludes, includes);
    }

    protected Set<String> getImmutableFieldTypes() {
        if (this._immutableFieldTypes != null) {
            return this._immutableFieldTypes;
        }
        Set<String> immutableFieldTypes = SetUtil.fromArray(new String[]{"boolean", "byte", "char", "double", "float", "int", "long", "short", "Boolean", "Byte", "Character", "Class", "Double", "Float", "Int", "Long", "Number", "Short", "String"});
        immutableFieldTypes.addAll(this.getPropertyList("immutable.field.types"));
        this._immutableFieldTypes = immutableFieldTypes;
        return this._immutableFieldTypes;
    }

    protected String[] getLanguageKeys(Matcher matcher) {
        int groupCount = matcher.groupCount();
        if (groupCount == 1) {
            String languageKey = matcher.group(1);
            if (Validator.isNotNull(languageKey)) {
                return new String[]{languageKey};
            }
        } else if (groupCount == 2) {
            String languageKey = matcher.group(2);
            languageKey = TextFormatter.format(languageKey, 10);
            return new String[]{languageKey};
        }
        StringBundler sb = new StringBundler();
        String match = matcher.group();
        int count = 0;
        block5: for (int i = 0; i < match.length(); ++i) {
            char c = match.charAt(i);
            switch (c) {
                case ')': {
                    if (count <= 1) {
                        return new String[0];
                    }
                    --count;
                    continue block5;
                }
                case '(': {
                    ++count;
                    continue block5;
                }
                case '\"': {
                    if (count > 1) continue block5;
                    while (i < match.length()) {
                        if (match.charAt(++i) == '\"') {
                            String languageKey = sb.toString();
                            if (match.startsWith("names")) {
                                return StringUtil.split(languageKey);
                            }
                            return new String[]{languageKey};
                        }
                        sb.append(match.charAt(i));
                    }
                    continue block5;
                }
            }
        }
        return new String[0];
    }

    protected int getLeadingTabCount(String line) {
        int leadingTabCount = 0;
        while (line.startsWith("\t")) {
            line = line.substring(1);
            ++leadingTabCount;
        }
        return leadingTabCount;
    }

    protected int getLevel(String s) {
        return this.getLevel(s, new String[]{"("}, new String[]{")"}, 0);
    }

    protected int getLevel(String s, String increaseLevelString, String decreaseLevelString) {
        return this.getLevel(s, new String[]{increaseLevelString}, new String[]{decreaseLevelString}, 0);
    }

    protected int getLevel(String s, String[] increaseLevelStrings, String[] decreaseLevelStrings) {
        return this.getLevel(s, increaseLevelStrings, decreaseLevelStrings, 0);
    }

    protected int getLevel(String s, String[] increaseLevelStrings, String[] decreaseLevelStrings, int startLevel) {
        int level = startLevel;
        for (String increaseLevelString : increaseLevelStrings) {
            level = this.adjustLevel(level, s, increaseLevelString, 1);
        }
        for (String decreaseLevelString : decreaseLevelStrings) {
            level = this.adjustLevel(level, s, decreaseLevelString, -1);
        }
        return level;
    }

    protected String getLine(String content, int lineCount) {
        int nextLineStartPos = this.getLineStartPos(content, lineCount);
        if (nextLineStartPos == -1) {
            return null;
        }
        int nextLineEndPos = content.indexOf(10, nextLineStartPos);
        if (nextLineEndPos == -1) {
            return content.substring(nextLineStartPos);
        }
        return content.substring(nextLineStartPos, nextLineEndPos);
    }

    protected int getLineCount(String content, int pos) {
        return StringUtil.count(content, 0, pos, '\n') + 1;
    }

    protected int getLineLength(String line) {
        int lineLength = 0;
        int tabLength = 4;
        for (char c : line.toCharArray()) {
            if (c == '\t') {
                for (int i = 0; i < tabLength; ++i) {
                    ++lineLength;
                }
                tabLength = 4;
                continue;
            }
            ++lineLength;
            if (--tabLength > 0) continue;
            tabLength = 4;
        }
        return lineLength;
    }

    protected int getLineStartPos(String content, int lineCount) {
        int x = 0;
        for (int i = 1; i < lineCount; ++i) {
            if ((x = content.indexOf(10, x + 1)) != -1) continue;
            return x;
        }
        return x + 1;
    }

    protected ComparableVersion getMainReleaseComparableVersion(String fileName, String absolutePath, boolean checkModuleVersion) throws Exception {
        boolean usePortalReleaseVersion = true;
        if (checkModuleVersion && (!portalSource || this.isModulesFile(absolutePath))) {
            usePortalReleaseVersion = false;
        }
        String releaseVersion = "";
        if (usePortalReleaseVersion) {
            if (this._mainReleaseComparableVersion != null) {
                return this._mainReleaseComparableVersion;
            }
            releaseVersion = ReleaseInfo.getVersion();
        } else {
            BNDSettings bndSettings = this.getBNDSettings(fileName);
            if (bndSettings == null) {
                return null;
            }
            releaseVersion = bndSettings.getReleaseVersion();
            if (releaseVersion == null) {
                return null;
            }
            this.putBNDSettings(bndSettings);
        }
        int pos = releaseVersion.lastIndexOf(46);
        String mainReleaseVersion = releaseVersion.substring(0, pos) + ".0";
        ComparableVersion mainReleaseComparableVersion = new ComparableVersion(mainReleaseVersion);
        if (usePortalReleaseVersion) {
            this._mainReleaseComparableVersion = mainReleaseComparableVersion;
        }
        return mainReleaseComparableVersion;
    }

    protected List<String> getModuleLangDirNames(String moduleLocation, String buildGradleContent) {
        ArrayList<String> moduleLangDirNames = new ArrayList<String>();
        Matcher matcher = mergeLangPattern.matcher(buildGradleContent);
        if (matcher.find()) {
            String[] sourceDirs;
            for (String sourceDir : sourceDirs = StringUtil.split(matcher.group(1))) {
                sourceDir = StringUtil.trim(sourceDir);
                moduleLangDirNames.add(moduleLocation + "/" + sourceDir.substring(1, sourceDir.length() - 1));
            }
            return moduleLangDirNames;
        }
        int x = moduleLocation.lastIndexOf("/");
        String baseModuleName = moduleLocation.substring(0, x);
        int y = baseModuleName.lastIndexOf("/");
        baseModuleName = baseModuleName.substring(y + 1, baseModuleName.length());
        String moduleLangDirName = moduleLocation.substring(0, x + 1) + baseModuleName + "-lang/src/main/resources/content";
        File moduleLangDir = new File(moduleLangDirName);
        if (!moduleLangDir.exists() && moduleLangDirName.contains("/modules/ee/")) {
            moduleLangDirName = StringUtil.replaceFirst(moduleLangDirName, "/modules/ee/", "/modules/");
        }
        moduleLangDirNames.add(moduleLangDirName);
        return moduleLangDirNames;
    }

    protected Properties getModuleLangLanguageProperties(String absolutePath) throws Exception {
        File file;
        Properties properties = this._moduleLangLanguageProperties.get(absolutePath);
        if (properties != null) {
            return properties;
        }
        String buildGradleContent = null;
        String buildGradleFileLocation = absolutePath;
        while (true) {
            int pos;
            if ((pos = buildGradleFileLocation.lastIndexOf("/")) == -1) {
                return null;
            }
            file = new File((buildGradleFileLocation = buildGradleFileLocation.substring(0, pos + 1)) + "build.gradle");
            if (file.exists()) break;
            buildGradleFileLocation = StringUtil.replaceLast(buildGradleFileLocation, "/", "");
        }
        buildGradleContent = FileUtil.read(file);
        Matcher matcher = applyLangMergerPluginPattern.matcher(buildGradleContent);
        if (!matcher.find()) {
            return null;
        }
        String moduleLocation = StringUtil.replaceLast(buildGradleFileLocation, "/", "");
        List<String> moduleLangDirNames = this.getModuleLangDirNames(moduleLocation, buildGradleContent);
        properties = new Properties();
        for (String moduleLangDirName : moduleLangDirNames) {
            String moduleLangLanguagePropertiesFileName = moduleLangDirName + "/Language.properties";
            File file2 = new File(moduleLangLanguagePropertiesFileName);
            if (!file2.exists()) continue;
            FileInputStream inputStream = new FileInputStream(file2);
            properties.load(inputStream);
        }
        this._moduleLangLanguageProperties.put(absolutePath, properties);
        return properties;
    }

    protected Properties getModuleLanguageProperties(String fileName) {
        Properties properties = this._moduleLanguageProperties.get(fileName);
        if (properties != null) {
            return properties;
        }
        StringBundler sb = new StringBundler(3);
        int pos = fileName.indexOf("/docroot/");
        if (pos != -1) {
            sb.append(fileName.substring(0, pos + 9));
            sb.append("WEB-INF/src/");
        } else {
            pos = fileName.indexOf("src/");
            if (pos == -1) {
                return null;
            }
            sb.append(fileName.substring(0, pos + 4));
            if (fileName.contains("src/main/")) {
                sb.append("main/resources/");
            }
        }
        sb.append("content/Language.properties");
        try {
            properties = new Properties();
            FileInputStream inputStream = new FileInputStream(sb.toString());
            properties.load(inputStream);
            this._moduleLanguageProperties.put(fileName, properties);
            return properties;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected List<String> getParameterList(String methodCall) {
        String parameters = null;
        int x = -1;
        while (this.getLevel(parameters = methodCall.substring(0, (x = methodCall.indexOf(")", x + 1)) + 1), "(", ")") != 0 || this.getLevel(parameters, "{", "}") != 0) {
        }
        x = parameters.indexOf("(");
        parameters = parameters.substring(x + 1, parameters.length() - 1);
        return this.splitParameters(parameters);
    }

    protected List<String> getPluginsInsideModulesDirectoryNames() throws Exception {
        if (this._pluginsInsideModulesDirectoryNames != null) {
            return this._pluginsInsideModulesDirectoryNames;
        }
        ArrayList<String> pluginsInsideModulesDirectoryNames = new ArrayList<String>();
        List<String> pluginBuildFileNames = this.getFileNames(new String[0], new String[]{"**/modules/apps/**/build.xml", "**/modules/private/apps/**/build.xml"});
        for (String pluginBuildFileName : pluginBuildFileNames) {
            String absolutePath = this.getAbsolutePath(pluginBuildFileName = StringUtil.replace(pluginBuildFileName, "\\", "/"));
            int x = absolutePath.indexOf("/modules/apps/");
            if (x == -1) {
                x = absolutePath.indexOf("/modules/private/apps/");
            }
            int y = absolutePath.lastIndexOf("/");
            pluginsInsideModulesDirectoryNames.add(absolutePath.substring(x, y + 1));
        }
        this._pluginsInsideModulesDirectoryNames = pluginsInsideModulesDirectoryNames;
        return this._pluginsInsideModulesDirectoryNames;
    }

    protected String getProperty(String key) {
        return this._properties.getProperty(key);
    }

    protected List<String> getPropertyList(String key) {
        return ListUtil.fromString(GetterUtil.getString(this.getProperty(key)), ",");
    }

    protected boolean hasMissingParentheses(String s) {
        if (Validator.isNull(s)) {
            return false;
        }
        boolean containsAndOperator = s.contains("&&");
        boolean containsOrOperator = s.contains("||");
        if (containsAndOperator && containsOrOperator) {
            return true;
        }
        boolean containsCompareOperator = false;
        if (s.contains(" == ") || s.contains(" != ") || s.contains(" < ") || s.contains(" > ") || s.contains(" =< ") || s.contains(" => ") || s.contains(" <= ") || s.contains(" >= ")) {
            containsCompareOperator = true;
        }
        boolean containsMathOperator = false;
        if (s.contains(" = ") || s.contains(" - ") || s.contains(" + ") || s.contains(" & ") || s.contains(" % ") || s.contains(" * ") || s.contains(" / ")) {
            containsMathOperator = true;
        }
        return containsCompareOperator && (containsAndOperator || containsOrOperator || containsMathOperator && !s.contains("["));
    }

    protected boolean hasRedundantParentheses(String s) {
        int x = -1;
        while ((x = s.indexOf(" ", x + 1)) != -1) {
            if (this.getLevel(s.substring(0, x)) != 0) continue;
            return false;
        }
        return true;
    }

    protected boolean hasRedundantParentheses(String s, String operator1, String operator2) {
        int x;
        while ((x = s.indexOf("!(")) != -1) {
            String linePart;
            int y = x;
            while (this.getLevel(linePart = s.substring(x, (y = s.indexOf(")", y + 1)) + 1)) != 0) {
            }
            s = StringUtil.replaceFirst(s, ")", "", y);
            s = StringUtil.replaceFirst(s, "!(", "", x);
        }
        String[] parts = StringUtil.split(s, operator1);
        if (parts.length < 3) {
            return false;
        }
        for (int i = 1; i < parts.length - 1; ++i) {
            String part = parts[i];
            if (part.contains(operator2) || Math.abs(this.getLevel(part)) != 1) continue;
            return true;
        }
        return false;
    }

    protected boolean isAllowedVariableType(String content, String variableName, String[] variableTypeRegexStrings) {
        if (variableTypeRegexStrings.length == 0) {
            return true;
        }
        for (String variableTypeRegex : variableTypeRegexStrings) {
            StringBundler sb = new StringBundler(5);
            sb.append("[\\s\\S]*\\W");
            sb.append(variableTypeRegex);
            sb.append("\\s+");
            sb.append(variableName);
            sb.append("\\W[\\s\\S]*");
            if (content.matches(sb.toString())) {
                return true;
            }
            sb = new StringBundler(5);
            sb.append("[\\s\\S]*\\W");
            sb.append(variableName);
            sb.append(" =\\s+new ");
            sb.append(variableTypeRegex);
            sb.append("[\\s\\S]*");
            if (!content.matches(sb.toString())) continue;
            return true;
        }
        return false;
    }

    protected boolean isAttributName(String attributeName) {
        if (Validator.isNull(attributeName)) {
            return false;
        }
        Matcher matcher = attributeNamePattern.matcher(attributeName);
        return matcher.matches();
    }

    protected boolean isExcludedPath(String property, String path) {
        return this.isExcludedPath(property, path, -1);
    }

    protected boolean isExcludedPath(String property, String path, int lineCount) {
        return this.isExcludedPath(property, path, lineCount, null);
    }

    protected boolean isExcludedPath(String property, String path, int lineCount, String parameter) {
        if (property == null) {
            return false;
        }
        List<String> excludes = this._exclusionPropertiesMap.get(property);
        if (excludes == null) {
            excludes = this.getPropertyList(property);
            this._exclusionPropertiesMap.put(property, excludes);
        }
        if (ListUtil.isEmpty(excludes)) {
            return false;
        }
        String pathWithParameter = null;
        if (Validator.isNotNull(parameter)) {
            pathWithParameter = path + "@" + parameter;
        }
        String pathWithLineCount = null;
        if (lineCount > 0) {
            pathWithLineCount = path + "@" + lineCount;
        }
        for (String exclude : excludes) {
            if (Validator.isNull(exclude)) continue;
            if (exclude.startsWith("**")) {
                exclude = exclude.substring(2);
            }
            if (!(exclude.endsWith("**") ? path.contains(exclude = exclude.substring(0, exclude.length() - 2)) : path.endsWith(exclude) || pathWithParameter != null && pathWithParameter.endsWith(exclude) || pathWithLineCount != null && pathWithLineCount.endsWith(exclude))) continue;
            return true;
        }
        return false;
    }

    protected boolean isExcludedPath(String property, String path, String parameter) {
        return this.isExcludedPath(property, path, -1, parameter);
    }

    protected boolean isModulesApp(String absolutePath, boolean privateOnly) {
        if (absolutePath.contains("/modules/private/apps/") || !privateOnly && absolutePath.contains("/modules/apps/")) {
            return true;
        }
        if (this._projectPathPrefix == null) {
            return false;
        }
        return this._projectPathPrefix.startsWith(":private:apps") || !privateOnly && this._projectPathPrefix.startsWith(":apps:");
    }

    protected boolean isModulesFile(String absolutePath) {
        return this.isModulesFile(absolutePath, false);
    }

    protected boolean isModulesFile(String absolutePath, boolean includePlugins) {
        if (subrepository) {
            return true;
        }
        if (includePlugins) {
            return absolutePath.contains("/modules/");
        }
        try {
            for (String directoryName : this.getPluginsInsideModulesDirectoryNames()) {
                if (!absolutePath.contains(directoryName)) continue;
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return absolutePath.contains("/modules/");
    }

    protected void postFormat() throws Exception {
    }

    protected void preFormat() throws Exception {
    }

    protected void printError(String fileName, String message) {
        if (this.sourceFormatterArgs.isPrintErrors()) {
            this._sourceFormatterHelper.printError(fileName, message);
        }
    }

    protected void processFormattedFile(File file, String fileName, String content, String newContent) throws Exception {
        Set<SourceFormatterMessage> sourceFormatterMessages;
        if (!content.equals(newContent)) {
            if (this.sourceFormatterArgs.isPrintErrors()) {
                this._sourceFormatterHelper.printError(fileName, file);
            }
            if (this.sourceFormatterArgs.isAutoFix()) {
                FileUtil.write(file, newContent);
            } else if (this._firstSourceMismatchException == null) {
                this._firstSourceMismatchException = new SourceMismatchException(fileName, content, newContent);
            }
        }
        if (this.sourceFormatterArgs.isPrintErrors() && (sourceFormatterMessages = this._sourceFormatterMessagesMap.get(fileName)) != null) {
            for (SourceFormatterMessage sourceFormatterMessage : sourceFormatterMessages) {
                String markdownFileName;
                this._sourceFormatterHelper.printError(fileName, sourceFormatterMessage.toString());
                if (this._browserStarted || !this.sourceFormatterArgs.isShowDocumentation() || !Desktop.isDesktopSupported() || !Validator.isNotNull(markdownFileName = sourceFormatterMessage.getMarkdownFileName())) continue;
                Desktop desktop = Desktop.getDesktop();
                desktop.browse(new URI(_DOCUMENTATION_URL + markdownFileName));
                this._browserStarted = true;
            }
        }
        this._modifiedFileNames.add(file.getAbsolutePath());
    }

    protected void putBNDSettings(BNDSettings bndSettings) {
        this._bndSettingsMap.put(bndSettings.getFileLocation(), bndSettings);
    }

    protected Document readXML(String content) throws DocumentException {
        SAXReader saxReader = SAXReaderFactory.getSAXReader(null, false, false);
        return saxReader.read((Reader)new UnsyncStringReader(content));
    }

    protected String replacePrimitiveWrapperInstantiation(String line) {
        return StringUtil.replace(line, new String[]{"new Boolean(", "new Byte(", "new Character(", "new Double(", "new Float(", "new Integer(", "new Long(", "new Short("}, new String[]{"Boolean.valueOf(", "Byte.valueOf(", "Character.valueOf(", "Double.valueOf(", "Float.valueOf(", "Integer.valueOf(", "Long.valueOf(", "Short.valueOf("});
    }

    protected String sortDefinitions(String fileName, String content, Comparator<String> comparator) {
        String previousDefinition = null;
        Matcher matcher = this._definitionPattern.matcher(content);
        while (matcher.find()) {
            String newContent = this.formatDefinitionKey(fileName, content, matcher.group(1));
            if (!newContent.equals(content)) {
                return newContent;
            }
            String definition = matcher.group();
            if (Validator.isNotNull(matcher.group(1)) && definition.endsWith("\n")) {
                definition = definition.substring(0, definition.length() - 1);
            }
            if (Validator.isNotNull(previousDefinition)) {
                int value = comparator.compare(previousDefinition, definition);
                if (value > 0) {
                    content = StringUtil.replaceFirst(content, previousDefinition, definition);
                    content = StringUtil.replaceLast(content, definition, previousDefinition);
                    return content;
                }
                if (value == 0) {
                    return StringUtil.replaceFirst(content, previousDefinition + "\n", "");
                }
            }
            previousDefinition = definition;
        }
        return content;
    }

    protected String sortHTMLAttributes(String line, String value, String attributeAndValue) {
        return line;
    }

    protected String sortMethodCall(String content, String methodName, String ... variableTypeRegexStrings) {
        Pattern codeBlockPattern = Pattern.compile("(\t+(\\w*)\\." + methodName + "\\(\\s*\".*?\\);\n)+", 32);
        Matcher codeBlockMatcher = codeBlockPattern.matcher(content);
        PutOrSetParameterNameComparator putOrSetParameterNameComparator = new PutOrSetParameterNameComparator();
        while (codeBlockMatcher.find()) {
            if (!this.isAllowedVariableType(content, codeBlockMatcher.group(2), variableTypeRegexStrings)) continue;
            String codeBlock = codeBlockMatcher.group();
            Pattern singleLineMethodCallPattern = Pattern.compile("\t*\\w*\\." + methodName + "\\((.*?)\\);\n", 32);
            Matcher singleLineMatcher = singleLineMethodCallPattern.matcher(codeBlock);
            String previousParameters = null;
            String previousPutOrSetParameterName = null;
            while (singleLineMatcher.find()) {
                String parameters = singleLineMatcher.group(1);
                List<String> parametersList = this.splitParameters(parameters);
                String putOrSetParameterName = parametersList.get(0);
                if (previousPutOrSetParameterName != null && putOrSetParameterNameComparator.compare(previousPutOrSetParameterName, putOrSetParameterName) > 0) {
                    String newCodeBlock = StringUtil.replaceFirst(codeBlock, previousParameters, parameters);
                    newCodeBlock = StringUtil.replaceLast(newCodeBlock, parameters, previousParameters);
                    return StringUtil.replace(content, codeBlock, newCodeBlock);
                }
                previousParameters = parameters;
                previousPutOrSetParameterName = putOrSetParameterName;
            }
        }
        return content;
    }

    protected String sortMethodCalls(String absolutePath, String content) {
        if (this.isExcludedPath(METHOD_CALL_SORT_EXCLUDES, absolutePath)) {
            return content;
        }
        content = this.sortMethodCall(content, "add", "ConcurrentSkipListSet<.*>", "HashSet<.*>", "TreeSet<.*>");
        content = this.sortMethodCall(content, "put", "ConcurrentHashMap<.*>", "HashMap<.*>", "JSONObject", "TreeMap<.*>");
        content = this.sortMethodCall(content, "setAttribute", new String[0]);
        return content;
    }

    protected List<String> splitParameters(String parameters) {
        ArrayList<String> parametersList = new ArrayList<String>();
        int x = -1;
        while (true) {
            String linePart;
            if ((x = parameters.indexOf(",", x + 1)) == -1) {
                parametersList.add(StringUtil.trim(parameters));
                return parametersList;
            }
            if (ToolsUtil.isInsideQuotes(parameters, x) || this.getLevel(linePart = parameters.substring(0, x), "(", ")") != 0 || this.getLevel(linePart, "{", "}") != 0) continue;
            parametersList.add(StringUtil.trim(linePart));
            parameters = parameters.substring(x + 1);
            x = -1;
        }
    }

    protected String stripQuotes(String s) {
        return this.stripQuotes(s, '\'', '\"');
    }

    protected String stripQuotes(String s, char ... delimeters) {
        List<Character> delimetersList = ListUtil.toList(delimeters);
        char delimeter = ' ';
        boolean insideQuotes = false;
        StringBundler sb = new StringBundler();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (insideQuotes) {
                if (c != delimeter) continue;
                int precedingBackSlashCount = 0;
                for (int j = i - 1; j >= 0 && s.charAt(j) == '\\'; --j) {
                    ++precedingBackSlashCount;
                }
                if (precedingBackSlashCount != 0 && precedingBackSlashCount % 2 != 0) continue;
                insideQuotes = false;
                continue;
            }
            if (delimetersList.contains(Character.valueOf(c))) {
                delimeter = c;
                insideQuotes = true;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    protected String trimContent(String content, boolean allowLeadingSpaces) throws IOException {
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                sb.append(this.trimLine(line, allowLeadingSpaces));
                sb.append("\n");
            }
        }
        content = sb.toString();
        if (content.endsWith("\n")) {
            content = content.substring(0, content.length() - 1);
        }
        return content;
    }

    protected String trimLine(String line, boolean allowLeadingSpaces) {
        if (line.trim().length() == 0) {
            return "";
        }
        line = StringUtil.trimTrailing(line);
        if (allowLeadingSpaces || line.startsWith(" *")) {
            return line;
        }
        while (line.matches("^\t*    .*")) {
            line = StringUtil.replaceFirst(line, "    ", "\t");
        }
        while (line.startsWith(" ")) {
            line = StringUtil.replaceFirst(line, " ", "");
        }
        return line;
    }

    private String[] _getExcludes() {
        if (this.sourceFormatterArgs.getFileNames() != null) {
            return new String[0];
        }
        List<String> excludesList = ListUtil.fromString(GetterUtil.getString(System.getProperty("source.formatter.excludes")));
        excludesList.addAll(this.getPropertyList("source.formatter.excludes"));
        return excludesList.toArray(new String[excludesList.size()]);
    }

    private String _getProjectPathPrefix() throws Exception {
        if (!subrepository) {
            return null;
        }
        File file = this.getFile("gradle.properties", 7);
        if (!file.exists()) {
            return null;
        }
        Properties properties = new Properties();
        properties.load(new FileInputStream(file));
        return properties.getProperty("project.path.prefix");
    }

    private void _init() {
        try {
            this._sourceFormatterHelper = new SourceFormatterHelper(this.sourceFormatterArgs.isUseProperties());
            this._sourceFormatterHelper.init();
            portalSource = this._isPortalSource();
            subrepository = this._isSubrepository();
            this._projectPathPrefix = this._getProjectPathPrefix();
            this._sourceFormatterMessagesMap = new HashMap<String, Set<SourceFormatterMessage>>();
        }
        catch (Exception e) {
            ReflectionUtil.throwException(e);
        }
        this._excludes = this._getExcludes();
        this._usePortalCompatImport = GetterUtil.getBoolean(this.getProperty("use.portal.compat.import"));
    }

    private boolean _isMatchPath(String fileName) {
        for (String pattern : this.getIncludes()) {
            if (!SelectorUtils.matchPath((String)this._normalizePattern(pattern), (String)fileName)) continue;
            return true;
        }
        return false;
    }

    private boolean _isPortalSource() {
        return this.getFile("portal-impl", 7) != null;
    }

    private boolean _isSubrepository() {
        String baseDirAbsolutePath = this.getAbsolutePath(this.sourceFormatterArgs.getBaseDirName());
        int x = baseDirAbsolutePath.length();
        for (int i = 0; i < 2; ++i) {
            if ((x = baseDirAbsolutePath.lastIndexOf(47, x - 1)) == -1) {
                return false;
            }
            String dirName = baseDirAbsolutePath.substring(x + 1);
            if (!dirName.startsWith("com-liferay-")) continue;
            return true;
        }
        return false;
    }

    private String _normalizePattern(String originalPattern) {
        String pattern = originalPattern.replace('/', File.separatorChar);
        if ((pattern = pattern.replace('\\', File.separatorChar)).endsWith(File.separator)) {
            pattern = pattern + "**";
        }
        return pattern;
    }

    static {
        principalExceptionPattern = Pattern.compile("SessionErrors\\.contains\\(\n?\t*(renderR|r)equest, PrincipalException\\.class\\.getName\\(\\)");
        sbAppendPattern = Pattern.compile("\\s*\\w*(sb|SB)[0-9]?\\.append\\(\\s*(\\S.*?)\\);\n", 32);
        sbAppendWithStartingSpacePattern = Pattern.compile("\n(\t*\\w*(sb|SB)[0-9]?\\.append\\(\".*\"\\);)\n\\s*\\w*(sb|SB)[0-9]?\\.append\\(\" .*\"\\);\n");
        sessionKeyPattern = Pattern.compile("SessionErrors.(?:add|contains|get)\\([^;%&|!]+|".concat("SessionMessages.(?:add|contains|get)\\([^;%&|!]+"), 8);
        singleLengthStringPattern = Pattern.compile("^(\".\"|StringPool\\.([A-Z_]+))$");
        stringUtilReplacePattern = Pattern.compile("StringUtil\\.(replace(First|Last)?)\\((.*?)\\);\n", 32);
        taglibSessionKeyPattern = Pattern.compile("<liferay-ui:error [^>]+>|<liferay-ui:success [^>]+>", 8);
        unparameterizedClassTypePattern1 = Pattern.compile("\\Wnew Class[^<\\w]");
        unparameterizedClassTypePattern2 = Pattern.compile("\\WClass[\\[\\]]* \\w+ =");
        validatorEqualsPattern = Pattern.compile("\\WValidator\\.equals\\(");
    }

    private class PutOrSetParameterNameComparator
    extends NaturalOrderStringComparator {
        private final Pattern _multipleLineParameterNamePattern = Pattern.compile("\" \\+\n\t+\"");

        private PutOrSetParameterNameComparator() {
        }

        @Override
        public int compare(String putOrSetParameterName1, String putOrSetParameterName2) {
            String strippedParameterName1 = BaseSourceProcessor.this.stripQuotes(putOrSetParameterName1);
            String strippedParameterName2 = BaseSourceProcessor.this.stripQuotes(putOrSetParameterName2);
            if (strippedParameterName1.contains("(") || strippedParameterName2.contains("(")) {
                return 0;
            }
            Matcher matcher = this._multipleLineParameterNamePattern.matcher(putOrSetParameterName1);
            if (matcher.find()) {
                putOrSetParameterName1 = matcher.replaceAll("");
            }
            if ((matcher = this._multipleLineParameterNamePattern.matcher(putOrSetParameterName2)).find()) {
                putOrSetParameterName2 = matcher.replaceAll("");
            }
            if (putOrSetParameterName1.matches("\".*\"") && putOrSetParameterName2.matches("\".*\"")) {
                String strippedQuotes1 = putOrSetParameterName1.substring(1, putOrSetParameterName1.length() - 1);
                String strippedQuotes2 = putOrSetParameterName2.substring(1, putOrSetParameterName2.length() - 1);
                return super.compare(strippedQuotes1, strippedQuotes2);
            }
            int value = super.compare(putOrSetParameterName1, putOrSetParameterName2);
            if (putOrSetParameterName1.startsWith("\"") ^ putOrSetParameterName2.startsWith("\"")) {
                return -value;
            }
            return value;
        }
    }
}

