/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ArgumentsUtil;
import com.liferay.portal.tools.GitException;
import com.liferay.portal.tools.GitUtil;
import com.liferay.source.formatter.BNDSourceProcessor;
import com.liferay.source.formatter.BaseSourceProcessor;
import com.liferay.source.formatter.CSSSourceProcessor;
import com.liferay.source.formatter.FTLSourceProcessor;
import com.liferay.source.formatter.GradleSourceProcessor;
import com.liferay.source.formatter.GroovySourceProcessor;
import com.liferay.source.formatter.JSONSourceProcessor;
import com.liferay.source.formatter.JSPSourceProcessor;
import com.liferay.source.formatter.JSSourceProcessor;
import com.liferay.source.formatter.JavaSourceProcessor;
import com.liferay.source.formatter.MarkdownSourceProcessor;
import com.liferay.source.formatter.PropertiesSourceProcessor;
import com.liferay.source.formatter.SHSourceProcessor;
import com.liferay.source.formatter.SQLSourceProcessor;
import com.liferay.source.formatter.SourceFormatterArgs;
import com.liferay.source.formatter.SourceFormatterHelper;
import com.liferay.source.formatter.SourceFormatterMessage;
import com.liferay.source.formatter.SourceMismatchException;
import com.liferay.source.formatter.SourceProcessor;
import com.liferay.source.formatter.SoySourceProcessor;
import com.liferay.source.formatter.TLDSourceProcessor;
import com.liferay.source.formatter.XMLSourceProcessor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class SourceFormatter {
    private static final List<String> _defaultExcludes = Arrays.asList("**/.git/**", "**/.gradle/**", "**/bin/**", "**/build/**", "**/classes/**", "**/node_modules/**", "**/npm-shrinkwrap.json", "**/test-classes/**", "**/test-coverage/**", "**/test-results/**", "**/tmp/**");
    private volatile SourceMismatchException _firstSourceMismatchException;
    private final List<String> _modifiedFileNames = new CopyOnWriteArrayList<String>();
    private Properties _properties;
    private final SourceFormatterArgs _sourceFormatterArgs;
    private final Set<SourceFormatterMessage> _sourceFormatterMessages = new ConcurrentSkipListSet<SourceFormatterMessage>();

    public static void main(String[] args) throws Exception {
        Map<String, String> arguments = ArgumentsUtil.parseArguments(args);
        try {
            SourceFormatterArgs sourceFormatterArgs = new SourceFormatterArgs();
            boolean autoFix = ArgumentsUtil.getBoolean(arguments, "source.auto.fix", true);
            sourceFormatterArgs.setAutoFix(autoFix);
            String baseDirName = ArgumentsUtil.getString(arguments, "source.base.dir", "./");
            sourceFormatterArgs.setBaseDirName(baseDirName);
            boolean formatCurrentBranch = ArgumentsUtil.getBoolean(arguments, "format.current.branch", false);
            sourceFormatterArgs.setFormatCurrentBranch(formatCurrentBranch);
            boolean formatLatestAuthor = ArgumentsUtil.getBoolean(arguments, "format.latest.author", false);
            sourceFormatterArgs.setFormatLatestAuthor(formatLatestAuthor);
            boolean formatLocalChanges = ArgumentsUtil.getBoolean(arguments, "format.local.changes", false);
            sourceFormatterArgs.setFormatLocalChanges(formatLocalChanges);
            if (formatCurrentBranch) {
                String gitWorkingBranchName = ArgumentsUtil.getString(arguments, "git.working.branch.name", "master");
                sourceFormatterArgs.setGitWorkingBranchName(gitWorkingBranchName);
                sourceFormatterArgs.setRecentChangesFileNames(GitUtil.getCurrentBranchFileNames(baseDirName, gitWorkingBranchName));
            } else if (formatLatestAuthor) {
                sourceFormatterArgs.setRecentChangesFileNames(GitUtil.getLatestAuthorFileNames(baseDirName));
            } else if (formatLocalChanges) {
                sourceFormatterArgs.setRecentChangesFileNames(GitUtil.getLocalChangesFileNames(baseDirName));
            }
            String copyrightFileName = ArgumentsUtil.getString(arguments, "source.copyright.file", "copyright.txt");
            sourceFormatterArgs.setCopyrightFileName(copyrightFileName);
            String fileNamesString = ArgumentsUtil.getString(arguments, "source.files", "");
            Object[] fileNames = StringUtil.split(fileNamesString, ",");
            if (ArrayUtil.isNotEmpty(fileNames)) {
                sourceFormatterArgs.setFileNames(Arrays.asList(fileNames));
            } else {
                String fileExtensionsString = ArgumentsUtil.getString(arguments, "source.file.extensions", "");
                String[] fileExtensions = StringUtil.split(fileExtensionsString, ",");
                sourceFormatterArgs.setFileExtensions(Arrays.asList(fileExtensions));
            }
            boolean includeSubrepositories = ArgumentsUtil.getBoolean(arguments, "include.subrepositories", false);
            sourceFormatterArgs.setIncludeSubrepositories(includeSubrepositories);
            int maxLineLength = ArgumentsUtil.getInteger(arguments, "max.line.length", 80);
            sourceFormatterArgs.setMaxLineLength(maxLineLength);
            boolean printErrors = ArgumentsUtil.getBoolean(arguments, "source.print.errors", true);
            sourceFormatterArgs.setPrintErrors(printErrors);
            int processorThreadCount = ArgumentsUtil.getInteger(arguments, "processor.thread.count", 5);
            sourceFormatterArgs.setProcessorThreadCount(processorThreadCount);
            boolean showDocumentation = ArgumentsUtil.getBoolean(arguments, "show.documentation", true);
            sourceFormatterArgs.setShowDocumentation(showDocumentation);
            boolean throwException = ArgumentsUtil.getBoolean(arguments, "source.throw.exception", false);
            sourceFormatterArgs.setThrowException(throwException);
            boolean useProperties = ArgumentsUtil.getBoolean(arguments, "source.use.properties", false);
            sourceFormatterArgs.setUseProperties(useProperties);
            SourceFormatter sourceFormatter = new SourceFormatter(sourceFormatterArgs);
            sourceFormatter.format();
        }
        catch (GitException ge) {
            System.out.println(ge.getMessage());
            System.exit(0);
        }
        catch (Exception e) {
            ArgumentsUtil.processMainException(arguments, e);
        }
    }

    public SourceFormatter(SourceFormatterArgs sourceFormatterArgs) {
        this._sourceFormatterArgs = sourceFormatterArgs;
    }

    public void format() throws Exception {
        this._properties = this._getProperties();
        ArrayList<BaseSourceProcessor> sourceProcessors = new ArrayList<BaseSourceProcessor>();
        sourceProcessors.add(new BNDSourceProcessor());
        sourceProcessors.add(new CSSSourceProcessor());
        sourceProcessors.add(new FTLSourceProcessor());
        sourceProcessors.add(new GradleSourceProcessor());
        sourceProcessors.add(new GroovySourceProcessor());
        sourceProcessors.add(new JavaSourceProcessor());
        sourceProcessors.add(new JSONSourceProcessor());
        sourceProcessors.add(new JSPSourceProcessor());
        sourceProcessors.add(new JSSourceProcessor());
        sourceProcessors.add(new MarkdownSourceProcessor());
        sourceProcessors.add(new PropertiesSourceProcessor());
        sourceProcessors.add(new SHSourceProcessor());
        sourceProcessors.add(new SoySourceProcessor());
        sourceProcessors.add(new SQLSourceProcessor());
        sourceProcessors.add(new TLDSourceProcessor());
        sourceProcessors.add(new XMLSourceProcessor());
        ExecutorService executorService = Executors.newFixedThreadPool(sourceProcessors.size());
        ArrayList<Future> futures = new ArrayList<Future>(sourceProcessors.size());
        for (final SourceProcessor sourceProcessor : sourceProcessors) {
            Future future = executorService.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    SourceFormatter.this._runSourceProcessor(sourceProcessor);
                    return null;
                }
            });
            futures.add(future);
        }
        ExecutionException ee1 = null;
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (ExecutionException ee2) {
                if (ee1 == null) {
                    ee1 = ee2;
                    continue;
                }
                ee1.addSuppressed(ee2);
            }
        }
        executorService.shutdown();
        while (!executorService.isTerminated()) {
            Thread.sleep(20L);
        }
        if (ee1 != null) {
            throw ee1;
        }
        if (this._sourceFormatterArgs.isThrowException()) {
            if (!this._sourceFormatterMessages.isEmpty()) {
                StringBundler stringBundler = new StringBundler(this._sourceFormatterMessages.size() * 2);
                for (SourceFormatterMessage sourceFormatterMessage : this._sourceFormatterMessages) {
                    stringBundler.append(sourceFormatterMessage.toString());
                    stringBundler.append("\n");
                }
                throw new Exception(stringBundler.toString());
            }
            if (this._firstSourceMismatchException != null) {
                throw this._firstSourceMismatchException;
            }
        }
    }

    public List<String> getModifiedFileNames() {
        return this._modifiedFileNames;
    }

    public SourceFormatterArgs getSourceFormatterArgs() {
        return this._sourceFormatterArgs;
    }

    public Set<SourceFormatterMessage> getSourceFormatterMessages() {
        return this._sourceFormatterMessages;
    }

    public SourceMismatchException getSourceMismatchException() {
        return this._firstSourceMismatchException;
    }

    private Properties _getProperties() throws Exception {
        SourceFormatterHelper sourceFormatterHelper = new SourceFormatterHelper(this._sourceFormatterArgs.isUseProperties());
        String fileName = "source-formatter.properties";
        File portalImplDir = sourceFormatterHelper.getFile(this._sourceFormatterArgs.getBaseDirName(), "portal-impl", 7);
        if (portalImplDir == null) {
            String excludesValue;
            Properties properties = null;
            for (int i = 0; i <= 3; ++i) {
                try {
                    FileInputStream inputStream = new FileInputStream(this._sourceFormatterArgs.getBaseDirName() + fileName);
                    Properties props = new Properties();
                    props.load(inputStream);
                    properties = props;
                    break;
                }
                catch (FileNotFoundException inputStream) {
                    fileName = "../" + fileName;
                    continue;
                }
            }
            if (properties == null) {
                properties = new Properties();
            }
            excludesValue = Validator.isNull(excludesValue = properties.getProperty("source.formatter.excludes")) ? StringUtil.merge(_defaultExcludes) : excludesValue + "," + StringUtil.merge(_defaultExcludes);
            properties.setProperty("source.formatter.excludes", excludesValue);
            return properties;
        }
        HashSet<String> excludes = new HashSet<String>(_defaultExcludes);
        ArrayList<Properties> propertiesList = new ArrayList<Properties>();
        File propertiesFile = sourceFormatterHelper.getFile(this._sourceFormatterArgs.getBaseDirName(), "portal-impl/src/" + fileName, 7);
        if (propertiesFile != null) {
            FileInputStream inputStream = new FileInputStream(propertiesFile);
            Properties properties = new Properties();
            properties.load(inputStream);
            propertiesList.add(properties);
            String excludesValue = properties.getProperty("source.formatter.excludes");
            List<String> excludesList = ListUtil.fromString(GetterUtil.getString(excludesValue), ",");
            excludes.addAll(excludesList);
        }
        String parentDirName = this._sourceFormatterArgs.getBaseDirName() + "../";
        for (int i = 0; i < 6; ++i) {
            try {
                FileInputStream inputStream = new FileInputStream(parentDirName + fileName);
                Properties properties = new Properties();
                properties.load(inputStream);
                propertiesList.add(properties);
            }
            catch (FileNotFoundException inputStream) {
                // empty catch block
            }
            parentDirName = parentDirName + "../";
        }
        List<String> modulePropertiesFileNames = sourceFormatterHelper.getFileNames(this._sourceFormatterArgs.getBaseDirName(), null, excludes.toArray(new String[excludes.size()]), new String[]{"**/modules/**/" + fileName}, this._sourceFormatterArgs.isIncludeSubrepositories());
        for (String modulePropertiesFileName : modulePropertiesFileNames) {
            FileInputStream inputStream = new FileInputStream(modulePropertiesFileName);
            Properties properties = new Properties();
            properties.load(inputStream);
            propertiesList.add(properties);
        }
        Properties properties = new Properties();
        properties.setProperty("source.formatter.excludes", StringUtil.merge(excludes));
        if (propertiesList.isEmpty()) {
            return properties;
        }
        for (int i = 0; i < propertiesList.size(); ++i) {
            Properties props = (Properties)propertiesList.get(i);
            Enumeration<?> enu = props.propertyNames();
            while (enu.hasMoreElements()) {
                String key = (String)enu.nextElement();
                String value = props.getProperty(key);
                if (Validator.isNull(value)) continue;
                if (key.contains("excludes")) {
                    String existingValue = properties.getProperty(key);
                    if (Validator.isNotNull(existingValue)) {
                        value = existingValue + "," + value;
                    }
                    properties.put(key, value);
                    continue;
                }
                if (properties.containsKey(key)) continue;
                properties.put(key, value);
            }
        }
        return properties;
    }

    private void _runSourceProcessor(SourceProcessor sourceProcessor) throws Exception {
        sourceProcessor.setProperties(this._properties);
        sourceProcessor.setSourceFormatterArgs(this._sourceFormatterArgs);
        sourceProcessor.format();
        this._sourceFormatterMessages.addAll(sourceProcessor.getSourceFormatterMessages());
        this._modifiedFileNames.addAll(sourceProcessor.getModifiedFileNames());
        if (this._firstSourceMismatchException == null) {
            this._firstSourceMismatchException = sourceProcessor.getFirstSourceMismatchException();
        }
    }
}

