/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.NaturalOrderStringComparator;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ImportPackage;
import com.liferay.source.formatter.BaseSourceProcessor;
import com.liferay.source.formatter.ElementComparator;
import com.liferay.source.formatter.util.FileUtil;
import com.liferay.util.ContentUtil;
import com.liferay.util.xml.Dom4jUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

public class XMLSourceProcessor
extends BaseSourceProcessor {
    private static final String[] _INCLUDES = new String[]{"**/*.action", "**/*.function", "**/*.jrxml", "**/*.macro", "**/*.testcase", "**/*.toggle", "**/*.xml"};
    private static final String _NUMERICAL_PORTLET_NAME_ELEMENT_EXCLUDES = "numerical.portlet.name.element.excludes";
    private static final String _SERVICE_FINDER_COLUMN_SORT_EXCLUDES = "service.finder.column.sort.excludes";
    private static final String _XML_EXCLUDES = "xml.excludes";
    private static final Pattern _commentPattern1 = Pattern.compile(">\n\t+<!--[\n ]");
    private static final Pattern _commentPattern2 = Pattern.compile("[\t ]-->\n[\t<]");
    private final Pattern _emptyLineBetweenTagsPattern = Pattern.compile("\n(\t*)<[\\w/].*>(\n\n)(\t*)<(\\w)");
    private final Pattern _importFilePattern = Pattern.compile("<import file=\"(.*)\"");
    private final Pattern _incorrectDefaultPreferencesFileName = Pattern.compile("/default-([\\w-]+)-portlet-preferences\\.xml$");
    private final Pattern _poshiClosingTagPattern = Pattern.compile("</[^>/]*>");
    private final Pattern _poshiCommandsPattern = Pattern.compile("\\<command.*name=\\\"([^\\\"]*)\\\".*\\>[\\s\\S]*?\\</command\\>[\\n|\\t]*?(?:[^(?:/\\>)]*?--\\>)*+");
    private final Pattern _poshiElementWithNoChildPattern = Pattern.compile("\\\"[\\s]*\\>[\\n\\s\\t]*\\</[a-z\\-]+>");
    private final Pattern _poshiEndLinesAfterClosingElementPattern = Pattern.compile("(\\</[a-z\\-]+>)(\\n+)\\t*\\<[a-z]+");
    private final Pattern _poshiEndLinesBeforeClosingElementPattern = Pattern.compile("(\\n+)(\\t*</[a-z\\-]+>)");
    private final Pattern _poshiEndLinesPattern = Pattern.compile("\\>\\n\\n\\n+(\\t*\\<)");
    private final Pattern _poshiOpeningTagPattern = Pattern.compile("<[^/][^>]*[^/]>");
    private final Pattern _poshiQuoteWithSlashPattern = Pattern.compile("\"[^\"]*\\>[^\"]*\"");
    private final Pattern _poshiSetUpPattern = Pattern.compile("\\n[\\t]++\\<set-up\\>([\\s\\S]*?)\\</set-up\\>[\\n|\\t]*?(?:[^(?:/\\>)]*?--\\>)*+\\n");
    private final Pattern _poshiTabsPattern = Pattern.compile("\\n*([ \\t]*<).*");
    private final Pattern _poshiTearDownPattern = Pattern.compile("\\n[\\t]++\\<tear-down\\>([\\s\\S]*?)\\</tear-down\\>[\\n|\\t]*?(?:[^(?:/\\>)]*?--\\>)*+\\n");
    private final Pattern _poshiVariableLinePattern = Pattern.compile("([\\t]*+)(\\<var.*?name=\\\"([^\\\"]*)\\\".*?/\\>.*+(?:\\</var\\>)??)");
    private final Pattern _poshiVariablesBlockPattern = Pattern.compile("((?:[\\t]*+\\<var.*?\\>\\n[\\t]*+){2,}?)(?:(?:\\n){1,}+|\\</execute\\>)");
    private final Pattern _poshiWholeTagPattern = Pattern.compile("<[^\\>^/]*\\/>");
    private final Pattern _projectNamePattern = Pattern.compile("/(\\w*-(ext|hooks|layouttpl|portlet|theme|web))/build\\.xml$");
    private String _tablesContent;
    private final Map<String, String> _tablesContentMap = new ConcurrentHashMap<String, String>();
    private final Pattern _whereNotInSQLPattern = Pattern.compile("WHERE[ \t\n]+\\(*[a-zA-z0-9.]+ NOT IN");

    public static String formatXML(String content) {
        String newContent = StringUtil.replace(content, "\"/>\n", "\" />\n");
        while (true) {
            Matcher matcher;
            if ((matcher = _commentPattern1.matcher(newContent)).find()) {
                newContent = StringUtil.replaceFirst(newContent, ">\n", ">\n\n", matcher.start());
                continue;
            }
            matcher = _commentPattern2.matcher(newContent);
            if (!matcher.find()) break;
            newContent = StringUtil.replaceFirst(newContent, "-->\n", "-->\n\n", matcher.start());
        }
        return newContent;
    }

    @Deprecated
    public static void sortAttributes(Element element, boolean recursive) {
        TreeMap<String, Attribute> attributesMap = new TreeMap<String, Attribute>();
        ArrayList attributes = new ArrayList(element.attributes());
        for (Attribute attribute : attributes) {
            attribute.detach();
            attributesMap.put(attribute.getName(), attribute);
        }
        for (Map.Entry entry : attributesMap.entrySet()) {
            Attribute attribute = (Attribute)entry.getValue();
            element.add(attribute);
        }
        if (!recursive) {
            return;
        }
        List elements = element.elements();
        for (Element curElement : elements) {
            XMLSourceProcessor.sortAttributes(curElement, recursive);
        }
    }

    @Deprecated
    public static String sortAttributes(String content) throws Exception {
        XMLSourceProcessor xmlSourceProcessor = new XMLSourceProcessor();
        Document document = xmlSourceProcessor.readXML(content);
        XMLSourceProcessor.sortAttributes(document.getRootElement(), true);
        return Dom4jUtil.toString((Node)document);
    }

    /*
     * WARNING - void declaration
     */
    public static void sortElementsByAttribute(Element element, String elementName, String attributeName) {
        void var6_13;
        Element curElement;
        Element element2;
        TreeMap<String, Element> elementsMap = new TreeMap<String, Element>();
        List elements = element.elements();
        for (Element element3 : elements) {
            element3.detach();
            if (!elementName.equals(element3.getName())) continue;
            String attributeValue = element3.attributeValue(attributeName);
            elementsMap.put(attributeValue, element3);
        }
        Iterator<Object> iterator = elements.iterator();
        while (iterator.hasNext() && !elementName.equals((element2 = (Element)iterator.next()).getName())) {
            element.add(element2);
        }
        for (Map.Entry entry : elementsMap.entrySet()) {
            curElement = (Element)entry.getValue();
            element.add(curElement);
        }
        boolean foundLastElementWithElementName = false;
        boolean bl = false;
        while (var6_13 < elements.size()) {
            curElement = (Element)elements.get((int)var6_13);
            if (!foundLastElementWithElementName) {
                Element nextElement;
                if (elementName.equals(curElement.getName()) && var6_13 + true < elements.size() && !elementName.equals((nextElement = (Element)elements.get((int)(var6_13 + true))).getName())) {
                    foundLastElementWithElementName = true;
                }
            } else {
                element.add(curElement);
            }
            ++var6_13;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void sortElementsByChildElement(Element element, String elementName, String childElementName) {
        void var6_13;
        Element curElement;
        Element element2;
        TreeMap<String, Element> elementsMap = new TreeMap<String, Element>();
        List elements = element.elements();
        for (Element element3 : elements) {
            element3.detach();
            if (!elementName.equals(element3.getName())) continue;
            String childElementValue = element3.elementText(childElementName);
            elementsMap.put(childElementValue, element3);
        }
        Iterator<Object> iterator = elements.iterator();
        while (iterator.hasNext() && !elementName.equals((element2 = (Element)iterator.next()).getName())) {
            element.add(element2);
        }
        for (Map.Entry entry : elementsMap.entrySet()) {
            curElement = (Element)entry.getValue();
            element.add(curElement);
        }
        boolean foundLastElementWithElementName = false;
        boolean bl = false;
        while (var6_13 < elements.size()) {
            curElement = (Element)elements.get((int)var6_13);
            if (!foundLastElementWithElementName) {
                Element nextElement;
                if (elementName.equals(curElement.getName()) && var6_13 + true < elements.size() && !elementName.equals((nextElement = (Element)elements.get((int)(var6_13 + true))).getName())) {
                    foundLastElementWithElementName = true;
                }
            } else {
                element.add(curElement);
            }
            ++var6_13;
        }
    }

    protected void checkAntXMLProjectName(String fileName, Document document) {
        Matcher matcher = this._projectNamePattern.matcher(fileName);
        if (!matcher.find()) {
            return;
        }
        String expectedProjectName = matcher.group(1);
        Element rootElement = document.getRootElement();
        String projectName = rootElement.attributeValue("name");
        if (!projectName.equals(expectedProjectName)) {
            this.processMessage(fileName, "Incorrect project name '" + projectName + "'");
        }
    }

    protected void checkImportFiles(String fileName, String content) {
        Matcher matcher = this._importFilePattern.matcher(content);
        while (matcher.find()) {
            String importFileName = fileName;
            int pos = importFileName.lastIndexOf("/");
            if (pos == -1) {
                return;
            }
            importFileName = importFileName.substring(0, pos + 1);
            File file = new File(importFileName = importFileName + matcher.group(1));
            if (file.exists()) continue;
            this.processMessage(fileName, "Incorrect import file '" + matcher.group(1) + "'");
        }
    }

    protected void checkPoshiCharactersAfterDefinition(String fileName, String content) {
        if (content.contains("/definition>") && !content.endsWith("/definition>")) {
            this.processMessage(fileName, "Characters found after definition element");
        }
    }

    protected void checkPoshiCharactersBeforeDefinition(String fileName, String content) {
        if (!content.startsWith("<definition")) {
            this.processMessage(fileName, "Characters found before definition element");
        }
    }

    protected void checkTargetName(String targetName, String buildFileName, String fileName) throws Exception {
        List<String> targetNames = this.getTargetNames(buildFileName, fileName, null, false);
        if (targetNames == null || targetNames.contains(targetName)) {
            return;
        }
        int x = targetName.lastIndexOf(46);
        if (x != -1) {
            targetName = targetName.substring(x + 1);
        }
        if (!targetNames.contains(targetName)) {
            this.processMessage(fileName, "Target '" + targetName + "' does not exist");
        }
    }

    protected void checkTargetNames(String fileName, String absolutePath, String content) throws Exception {
        Document document = this.readXML(content);
        Element rootElement = document.getRootElement();
        List<Element> antCallElements = this.getElementsByName("antcall", rootElement, null);
        for (Element antCallElement : antCallElements) {
            String targetName = antCallElement.attributeValue("target");
            if (targetName == null || targetName.contains("{")) continue;
            this.checkTargetName(targetName, absolutePath, fileName);
        }
        String fileDirName = fileName.substring(0, fileName.lastIndexOf(47) + 1);
        List<Element> antElements = this.getElementsByName("ant", rootElement, null);
        for (Element antElement : antElements) {
            String antFileName;
            String targetName = antElement.attributeValue("target");
            if (targetName == null || targetName.contains("{")) continue;
            String fullDirName = fileDirName;
            String dirName = antElement.attributeValue("dir");
            if (dirName != null) {
                if (dirName.contains("{")) continue;
                fullDirName = fullDirName + dirName + "/";
            }
            if ((antFileName = antElement.attributeValue("antfile")) == null) {
                antFileName = "build.xml";
            }
            this.checkTargetName(targetName, fullDirName + antFileName, fileName);
        }
    }

    @Override
    protected String doFormat(File file, String fileName, String absolutePath, String content) throws Exception {
        if (this.isExcludedPath(_XML_EXCLUDES, absolutePath)) {
            return content;
        }
        String newContent = content;
        if (!fileName.startsWith(this.sourceFormatterArgs.getBaseDirName() + "build") && !fileName.contains("/build")) {
            newContent = this.trimContent(newContent, false);
        }
        if (fileName.startsWith(this.sourceFormatterArgs.getBaseDirName() + "build") || fileName.contains("/build") && !fileName.contains("/tools/")) {
            newContent = this.formatAntXML(fileName, absolutePath, newContent);
        } else if (fileName.contains("/custom-sql/")) {
            newContent = this.formatCustomSQLXML(fileName, newContent);
        } else if (fileName.endsWith("structures.xml")) {
            newContent = this.formatDDLStructuresXML(newContent);
        } else if (fileName.endsWith("routes.xml")) {
            newContent = this.formatFriendlyURLRoutesXML(fileName, absolutePath, newContent);
        } else if (fileName.endsWith("-hbm.xml")) {
            newContent = this.formatHBMXML(fileName, newContent);
        } else if (fileName.endsWith("-log4j.xml")) {
            newContent = this.formatLog4jXML(fileName, newContent);
        } else if (fileName.endsWith("-look-and-feel.xml")) {
            newContent = this.formatLookAndFeelXML(fileName, newContent);
        } else if (fileName.endsWith("-model-hints.xml")) {
            newContent = this.formatModelHintsXML(fileName, newContent);
        } else if (fileName.endsWith("portlet-preferences.xml")) {
            newContent = this.formatPortletPreferencesXML(fileName, newContent);
        } else if (fileName.endsWith("/liferay-portlet.xml") || (portalSource || subrepository) && fileName.endsWith("/portlet-custom.xml") || !portalSource && !subrepository && fileName.endsWith("/portlet.xml")) {
            newContent = this.formatPortletXML(fileName, absolutePath, newContent);
        } else if (fileName.endsWith(".action") || fileName.endsWith(".function") || fileName.endsWith(".macro") || fileName.endsWith(".testcase")) {
            newContent = this.formatPoshiXML(fileName, newContent);
        } else if (fileName.contains("/resource-actions/")) {
            newContent = this.formatResourceActionXML(fileName, newContent, "model");
            newContent = this.formatResourceActionXML(fileName, newContent, "portlet");
        } else if (fileName.endsWith("/service.xml")) {
            newContent = this.formatServiceXML(fileName, absolutePath, newContent);
        } else if (fileName.endsWith("/schema.xml") && absolutePath.contains("solr")) {
            newContent = this.formatSolrSchemaXML(fileName, newContent);
        } else if (fileName.endsWith("-spring.xml")) {
            newContent = this.formatSpringXML(fileName, newContent);
        } else if ((portalSource || subrepository) && fileName.endsWith("/struts-config.xml")) {
            newContent = this.formatStrutsConfigXML(fileName, newContent);
        } else if ((portalSource || subrepository) && fileName.endsWith("/test-ignorable-error-lines.xml")) {
            newContent = this.formatTestIgnorableErrorLinesXml(fileName, newContent);
        } else if ((portalSource || subrepository) && fileName.endsWith("/tiles-defs.xml")) {
            this.formatTilesDefsXML(fileName, newContent);
        } else if (fileName.endsWith(".toggle")) {
            newContent = this.formatToggleXML(fileName, newContent);
        } else if ((portalSource || subrepository) && fileName.endsWith("portal-web/docroot/WEB-INF/web.xml") || !portalSource && !subrepository && fileName.endsWith("/web.xml")) {
            newContent = this.formatWebXML(fileName, newContent);
        }
        newContent = this.sortAttributes(fileName, newContent);
        newContent = this.fixEmptyLinesInMultiLineTags(newContent);
        newContent = this.fixEmptyLinesInNestedTags(newContent);
        return XMLSourceProcessor.formatXML(newContent);
    }

    @Override
    protected List<String> doGetFileNames() throws Exception {
        String[] excludes = new String[]{"**/.bnd/**", "**/.idea/**", "**/.ivy/**", "**/bin/**", "**/javadocs-*.xml", "**/logs/**", "**/portal-impl/**/*.action", "**/portal-impl/**/*.function", "**/portal-impl/**/*.macro", "**/portal-impl/**/*.testcase", "**/src/test/**", "**/test-classes/unit/**", "**/test-results/**", "**/test/unit/**", "**/tools/node**"};
        return this.getFileNames(excludes, this.getIncludes());
    }

    @Override
    protected String[] doGetIncludes() {
        return _INCLUDES;
    }

    protected String fixEmptyLinesBetweenTags(String content, boolean allowEmptyLinesBetweenTags) {
        if (allowEmptyLinesBetweenTags) {
            return this.fixEmptyLinesBetweenTags(content);
        }
        Matcher matcher = this._emptyLineBetweenTagsPattern.matcher(content);
        if (matcher.find()) {
            return StringUtil.replaceFirst(content, "\n\n", "\n", matcher.end(1));
        }
        return content;
    }

    protected String fixPoshiXMLElementWithNoChild(String content) {
        Matcher matcher = this._poshiElementWithNoChildPattern.matcher(content);
        while (matcher.find()) {
            content = StringUtil.replace(content, matcher.group(), "\" />");
        }
        return content;
    }

    protected String fixPoshiXMLEndLines(String content) {
        Matcher matcher = this._poshiEndLinesPattern.matcher(content);
        while (matcher.find()) {
            String statement = matcher.group();
            String newStatement = StringUtil.replace(statement, matcher.group(), ">\n\n" + matcher.group(1));
            content = StringUtil.replace(content, statement, newStatement);
        }
        return content;
    }

    protected String fixPoshiXMLEndLinesAfterClosingElement(String content) {
        Matcher matcher = this._poshiEndLinesAfterClosingElementPattern.matcher(content);
        while (matcher.find()) {
            String newStatement;
            String statement = matcher.group();
            String closingElementName = matcher.group(1);
            if (StringUtil.equalsIgnoreCase("</and>", closingElementName) || StringUtil.equalsIgnoreCase("</elseif>", closingElementName) || StringUtil.equalsIgnoreCase("</not>", closingElementName) || StringUtil.equalsIgnoreCase("</or>", closingElementName) || StringUtil.equalsIgnoreCase("</then>", closingElementName)) {
                newStatement = StringUtil.replace(statement, matcher.group(2), "\n");
                content = StringUtil.replace(content, statement, newStatement);
                continue;
            }
            if (StringUtil.equalsIgnoreCase("</var>", closingElementName)) continue;
            newStatement = StringUtil.replace(statement, matcher.group(2), "\n\n");
            content = StringUtil.replace(content, statement, newStatement);
        }
        return content;
    }

    protected String fixPoshiXMLEndLinesBeforeClosingElement(String content) {
        Matcher matcher = this._poshiEndLinesBeforeClosingElementPattern.matcher(content);
        while (matcher.find()) {
            String statement = matcher.group();
            String newStatement = StringUtil.replace(statement, matcher.group(1), "\n");
            content = StringUtil.replace(content, statement, newStatement);
        }
        return content;
    }

    protected String fixPoshiXMLNumberOfTabs(String content) {
        Matcher matcher = this._poshiTabsPattern.matcher(content);
        int tabCount = 0;
        boolean ignoredCdataBlock = false;
        boolean ignoredCommentBlock = false;
        while (matcher.find()) {
            String statement = matcher.group();
            Matcher quoteWithSlashMatcher = this._poshiQuoteWithSlashPattern.matcher(statement);
            String fixedQuoteStatement = statement;
            if (quoteWithSlashMatcher.find()) {
                fixedQuoteStatement = StringUtil.replace(statement, quoteWithSlashMatcher.group(), "\"\"");
            }
            Matcher closingTagMatcher = this._poshiClosingTagPattern.matcher(fixedQuoteStatement);
            Matcher openingTagMatcher = this._poshiOpeningTagPattern.matcher(fixedQuoteStatement);
            Matcher wholeTagMatcher = this._poshiWholeTagPattern.matcher(fixedQuoteStatement);
            if (!(!closingTagMatcher.find() || openingTagMatcher.find() || wholeTagMatcher.find() || statement.contains("<!--") || statement.contains("-->") || statement.contains("<![CDATA[") || statement.contains("]]>"))) {
                --tabCount;
            }
            if (statement.contains("]]>")) {
                ignoredCdataBlock = false;
            } else if (statement.contains("<![CDATA[")) {
                ignoredCdataBlock = true;
            }
            if (statement.contains("-->")) {
                ignoredCommentBlock = false;
            } else if (statement.contains("<!--")) {
                ignoredCommentBlock = true;
            }
            if (!ignoredCommentBlock && !ignoredCdataBlock) {
                StringBundler sb = new StringBundler(tabCount + 1);
                for (int i = 0; i < tabCount; ++i) {
                    sb.append("\t");
                }
                sb.append("<");
                String replacement = sb.toString();
                if (!replacement.equals(matcher.group(1))) {
                    String newStatement = StringUtil.replace(statement, matcher.group(1), replacement);
                    return StringUtil.replaceFirst(content, statement, newStatement, matcher.start());
                }
            }
            if (!openingTagMatcher.find() || closingTagMatcher.find() || wholeTagMatcher.find() || statement.contains("<!--") || statement.contains("-->") || statement.contains("<![CDATA[") || statement.contains("]]>")) continue;
            ++tabCount;
        }
        return content;
    }

    protected String formatAntXML(String fileName, String absolutePath, String content) throws Exception {
        int z;
        String newContent = this.trimContent(content, true);
        Document document = this.readXML(content);
        this.checkAntXMLProjectName(fileName, document);
        this.checkOrder(fileName, document.getRootElement(), "macrodef", null, new ElementComparator());
        this.checkOrder(fileName, document.getRootElement(), "target", null, new ElementComparator());
        int x = content.lastIndexOf("\n\t</macrodef>");
        int y = content.indexOf("\n\t<process-ivy");
        if (y != -1 && x > y) {
            this.processMessage(fileName, "Macrodefs go before process-ivy");
        }
        if ((z = content.indexOf("\n\t</target>")) != -1 && x > z) {
            this.processMessage(fileName, "Macrodefs go before targets");
        }
        this.checkImportFiles(fileName, newContent);
        this.checkTargetNames(fileName, absolutePath, content);
        return newContent;
    }

    protected String formatCustomSQLXML(String fileName, String content) throws Exception {
        Document document = this.readXML(content);
        this.checkOrder(fileName, document.getRootElement(), "sql", null, new CustomSQLElementComparator("id"));
        Matcher matcher = this._whereNotInSQLPattern.matcher(content);
        if (matcher.find()) {
            int x = content.lastIndexOf("<sql id=", matcher.start());
            int y = content.indexOf(34, x);
            int z = content.indexOf(34, y + 1);
            this.processMessage(fileName, "Avoid using WHERE ... NOT IN: " + content.substring(y + 1, z) + ", see LPS-51315");
        }
        return this.fixEmptyLinesBetweenTags(content, false);
    }

    protected String formatDDLStructuresXML(String content) throws Exception {
        Document document = this.readXML(content);
        Element rootElement = document.getRootElement();
        XMLSourceProcessor.sortElementsByChildElement(rootElement, "structure", "name");
        List structureElements = rootElement.elements("structure");
        for (Element structureElement : structureElements) {
            Element structureRootElement = structureElement.element("root");
            XMLSourceProcessor.sortElementsByAttribute(structureRootElement, "dynamic-element", "name");
            List dynamicElementElements = structureRootElement.elements("dynamic-element");
            for (Element dynamicElementElement : dynamicElementElements) {
                Element metaDataElement = dynamicElementElement.element("meta-data");
                XMLSourceProcessor.sortElementsByAttribute(metaDataElement, "entry", "name");
            }
        }
        return Dom4jUtil.toString((Node)document);
    }

    protected String formatFriendlyURLRoutesXML(String fileName, String absolutePath, String content) throws Exception {
        Document document = this.readXML(content);
        Element rootElement = document.getRootElement();
        List routeElements = rootElement.elements("route");
        ElementComparator elementComparator = new ElementComparator();
        for (Element routeElement : routeElements) {
            this.checkOrder(fileName, routeElement, "ignored-parameter", null, elementComparator);
            this.checkOrder(fileName, routeElement, "implicit-parameter", null, elementComparator);
            this.checkOrder(fileName, routeElement, "overridden-parameter", null, elementComparator);
        }
        int pos = content.indexOf("<routes>\n");
        if (pos == -1) {
            return this.fixEmptyLinesBetweenTags(content, false);
        }
        StringBundler sb = new StringBundler(9);
        ComparableVersion mainReleaseComparableVersion = this.getMainReleaseComparableVersion(fileName, absolutePath, false);
        String mainReleaseVersion = mainReleaseComparableVersion.toString();
        sb.append("<?xml version=\"1.0\"?>\n");
        sb.append("<!DOCTYPE routes PUBLIC \"-//Liferay//DTD Friendly URL ");
        sb.append("Routes ");
        sb.append(mainReleaseVersion);
        sb.append("//EN\" \"http://www.liferay.com/dtd/");
        sb.append("liferay-friendly-url-routes_");
        sb.append(StringUtil.replace(mainReleaseVersion, ".", "_"));
        sb.append(".dtd\">\n\n");
        sb.append(content.substring(pos));
        return this.fixEmptyLinesBetweenTags(sb.toString(), false);
    }

    protected String formatHBMXML(String fileName, String content) throws Exception {
        Document document = this.readXML(content);
        this.checkOrder(fileName, document.getRootElement(), "import", null, new ElementComparator("class"));
        return this.fixEmptyLinesBetweenTags(content, false);
    }

    protected String formatLog4jXML(String fileName, String content) throws Exception {
        Document document = this.readXML(content);
        this.checkOrder(fileName, document.getRootElement(), "category", null, new ElementComparator(true));
        return this.fixEmptyLinesBetweenTags(content, true);
    }

    protected String formatLookAndFeelXML(String fileName, String content) throws Exception {
        Document document = this.readXML(content);
        Element rootElement = document.getRootElement();
        List themeElements = rootElement.elements("theme");
        for (Element themeElement : themeElements) {
            this.checkOrder(fileName, themeElement, "portlet-decorator", null, new ElementComparator("id"));
            Element settingsElement = themeElement.element("settings");
            this.checkOrder(fileName, settingsElement, "setting", null, new ElementComparator("key"));
        }
        return this.fixEmptyLinesBetweenTags(content, false);
    }

    protected String formatModelHintsXML(String fileName, String content) throws Exception {
        Document document = this.readXML(content);
        Element rootElement = document.getRootElement();
        this.checkOrder(fileName, rootElement, "hint-collection", null, new ElementComparator());
        this.checkOrder(fileName, rootElement, "model", null, new ElementComparator());
        return this.fixEmptyLinesBetweenTags(content, false);
    }

    protected String formatPortletPreferencesXML(String fileName, String content) throws Exception {
        Document document = this.readXML(content);
        this.checkOrder(fileName, document.getRootElement(), "preference", null, new PortletPreferenceElementComparator());
        Matcher matcher = this._incorrectDefaultPreferencesFileName.matcher(fileName);
        if (matcher.find()) {
            String correctFileName = matcher.group(1) + "-default-portlet-preferences.xml";
            this.processMessage(fileName, "Rename file to " + correctFileName);
        }
        return this.fixEmptyLinesBetweenTags(content, false);
    }

    protected String formatPortletXML(String fileName, String absolutePath, String content) throws Exception {
        Document document = this.readXML(content);
        Element rootElement = document.getRootElement();
        boolean checkNumericalPortletNameElement = !this.isExcludedPath(_NUMERICAL_PORTLET_NAME_ELEMENT_EXCLUDES, absolutePath);
        List portletElements = rootElement.elements("portlet");
        for (Element portletElement : portletElements) {
            Element portletNameElement;
            String portletNameText;
            if (checkNumericalPortletNameElement && !Validator.isNumber(portletNameText = (portletNameElement = portletElement.element("portlet-name")).getText())) {
                this.processMessage(fileName, "Nonstandard portlet-name element '" + portletNameText + "'");
            }
            if (fileName.endsWith("/liferay-portlet.xml")) continue;
            XMLSourceProcessor.sortElementsByChildElement(portletElement, "init-param", "name");
            Element portletPreferencesElement = portletElement.element("portlet-preferences");
            if (portletPreferencesElement == null) continue;
            XMLSourceProcessor.sortElementsByChildElement(portletPreferencesElement, "preference", "name");
        }
        return Dom4jUtil.toString((Node)document);
    }

    protected String formatPoshiXML(String fileName, String content) throws Exception {
        this.checkPoshiCharactersAfterDefinition(fileName, content);
        this.checkPoshiCharactersBeforeDefinition(fileName, content);
        try {
            Document document = this.readXML(content);
            Element rootElement = document.getRootElement();
            List commandElements = rootElement.elements("command");
            for (Element commandElement : commandElements) {
                this.checkOrder(fileName, commandElement, "property", null, new ElementComparator());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        content = this.sortPoshiCommands(content);
        content = this.sortPoshiVariables(content);
        content = this.fixPoshiXMLElementWithNoChild(content);
        content = this.fixPoshiXMLEndLinesAfterClosingElement(content);
        content = this.fixPoshiXMLEndLinesBeforeClosingElement(content);
        content = this.fixPoshiXMLEndLines(content);
        return this.fixPoshiXMLNumberOfTabs(content);
    }

    protected String formatResourceActionXML(String fileName, String content, String type) throws Exception {
        Document document = this.readXML(content);
        Element rootElement = document.getRootElement();
        List resourceElements = rootElement.elements(type + "-resource");
        for (Element resourceElement : resourceElements) {
            Element nameElement = resourceElement.element(type + "-name");
            if (nameElement == null) continue;
            String name = nameElement.getText();
            Element permissionsElement = resourceElement.element("permissions");
            if (permissionsElement == null) continue;
            List permissionsChildElements = permissionsElement.elements();
            for (Element permissionsChildElement : permissionsChildElements) {
                this.checkOrder(fileName, permissionsChildElement, "action-key", name, new ResourceActionActionKeyElementComparator());
            }
        }
        this.checkOrder(fileName, rootElement, type + "-resource", null, new ResourceActionResourceElementComparator(type + "-name"));
        return this.fixEmptyLinesBetweenTags(content, false);
    }

    protected String formatServiceXML(String fileName, String absolutePath, String content) throws Exception {
        Document document = this.readXML(content);
        Element rootElement = document.getRootElement();
        ServiceReferenceElementComparator serviceReferenceElementComparator = new ServiceReferenceElementComparator("entity");
        for (Element entityElement : rootElement.elements("entity")) {
            String entityName = entityElement.attributeValue("name");
            List<String> columnNames = this.getColumnNames(fileName, absolutePath, entityName);
            ServiceFinderColumnElementComparator serviceFinderColumnElementComparator = new ServiceFinderColumnElementComparator(columnNames);
            if (!this.isExcludedPath(_SERVICE_FINDER_COLUMN_SORT_EXCLUDES, absolutePath, entityName)) {
                for (Element finderElement : entityElement.elements("finder")) {
                    String finderName = finderElement.attributeValue("name");
                    this.checkOrder(fileName, finderElement, "finder-column", entityName + "#" + finderName, serviceFinderColumnElementComparator);
                }
            }
            this.checkOrder(fileName, entityElement, "finder", entityName, new ServiceFinderElementComparator(columnNames));
            this.checkOrder(fileName, entityElement, "reference", entityName, serviceReferenceElementComparator);
        }
        this.checkOrder(fileName, rootElement, "entity", null, new ElementComparator());
        this.checkOrder(fileName, rootElement.element("exceptions"), "exception", null, new ServiceExceptionElementComparator());
        return this.fixEmptyLinesBetweenTags(content, false);
    }

    protected String formatSolrSchemaXML(String fileName, String content) throws Exception {
        Document document = this.readXML(content);
        Element rootElement = document.getRootElement();
        this.checkOrder(fileName, rootElement.element("fields"), "field", null, new ElementComparator());
        this.checkOrder(fileName, rootElement.element("types"), "fieldType", null, new ElementComparator());
        return this.fixEmptyLinesBetweenTags(content, false);
    }

    protected String formatSpringXML(String fileName, String content) throws Exception {
        Document document = this.readXML(content);
        this.checkOrder(fileName, document.getRootElement(), "bean", null, new SpringBeanElementComparator("id"));
        return this.fixEmptyLinesBetweenTags(content, false);
    }

    protected String formatStrutsConfigXML(String fileName, String content) throws Exception {
        Document document = this.readXML(content);
        Element rootElement = document.getRootElement();
        this.checkOrder(fileName, rootElement.element("action-mappings"), "action", null, new StrutsActionElementComparator("path"));
        return this.fixEmptyLinesBetweenTags(content, true);
    }

    protected String formatTestIgnorableErrorLinesXml(String fileName, String content) throws Exception {
        Document document = this.readXML(content);
        Element rootElement = document.getRootElement();
        List javascriptElements = rootElement.elements("javascript");
        for (Element javascriptElement : javascriptElements) {
            this.checkOrder(fileName, javascriptElement, "ignore-error", null, new ElementComparator("description"));
        }
        List logElements = rootElement.elements("log");
        for (Element logElement : logElements) {
            this.checkOrder(fileName, logElement, "ignore-error", null, new ElementComparator("description"));
        }
        return this.fixEmptyLinesBetweenTags(content, false);
    }

    protected String formatTilesDefsXML(String fileName, String content) throws Exception {
        Document document = this.readXML(content);
        this.checkOrder(fileName, document.getRootElement(), "definition", null, new TilesDefinitionElementComparator());
        return this.fixEmptyLinesBetweenTags(content, true);
    }

    protected String formatToggleXML(String fileName, String content) throws Exception {
        Document document = this.readXML(content);
        this.checkOrder(fileName, document.getRootElement(), "toggle", null, new ElementComparator());
        return this.fixEmptyLinesBetweenTags(content, false);
    }

    /*
     * WARNING - void declaration
     */
    protected String formatWebXML(String fileName, String content) throws Exception {
        void var10_14;
        if (!portalSource && !subrepository) {
            String webXML = ContentUtil.get("com/liferay/portal/deploy/dependencies/web.xml");
            if (content.equals(webXML)) {
                this.processMessage(fileName, "");
            }
            return this.fixEmptyLinesBetweenTags(content, false);
        }
        Properties properties = new Properties();
        File propertiesFile = new File(this.sourceFormatterArgs.getBaseDirName(), "portal-impl/src/portal.properties");
        String propertiesContent = FileUtil.read(propertiesFile);
        PropertiesUtil.load(properties, propertiesContent);
        Object[] locales = StringUtil.split(properties.getProperty("locales"));
        Arrays.sort(locales);
        TreeSet<Object> urlPatterns = new TreeSet<Object>();
        Object[] objectArray = locales;
        int n = objectArray.length;
        boolean bl = false;
        while (var10_14 < n) {
            Object locale = objectArray[var10_14];
            int pos = ((String)locale).indexOf(95);
            String string = ((String)locale).substring(0, pos);
            urlPatterns.add(string);
            urlPatterns.add(locale);
            ++var10_14;
        }
        StringBundler sb = new StringBundler(6 * urlPatterns.size());
        for (String string : urlPatterns) {
            sb.append("\t<servlet-mapping>\n");
            sb.append("\t\t<servlet-name>I18n Servlet</servlet-name>\n");
            sb.append("\t\t<url-pattern>/");
            sb.append(string);
            sb.append("/*</url-pattern>\n");
            sb.append("\t</servlet-mapping>\n");
        }
        int x = content.indexOf("<servlet-mapping>");
        x = content.indexOf("<servlet-name>I18n Servlet</servlet-name>", x);
        x = content.lastIndexOf("<servlet-mapping>", x) - 1;
        int n3 = content.lastIndexOf("<servlet-name>I18n Servlet</servlet-name>");
        n3 = content.indexOf("</servlet-mapping>", n3) + 19;
        String newContent = content.substring(0, x) + sb.toString() + content.substring(n3);
        x = newContent.indexOf("<security-constraint>");
        x = newContent.indexOf("<web-resource-collection>", x);
        x = newContent.indexOf("<url-pattern>", x) - 3;
        int n5 = newContent.indexOf("</web-resource-collection>", x);
        n5 = newContent.lastIndexOf("</url-pattern>", n5) + 15;
        sb = new StringBundler(3 * urlPatterns.size() + 1);
        sb.append("\t\t\t<url-pattern>/c/portal/protected</url-pattern>\n");
        for (String string : urlPatterns) {
            sb.append("\t\t\t<url-pattern>/");
            sb.append(string);
            sb.append("/c/portal/protected</url-pattern>\n");
        }
        newContent = newContent.substring(0, x) + sb.toString() + newContent.substring(n5);
        return this.fixEmptyLinesBetweenTags(newContent, false);
    }

    protected List<String> getColumnNames(String fileName, String absolutePath, String entityName) throws Exception {
        ArrayList<String> columnNames = new ArrayList<String>();
        Pattern pattern = Pattern.compile("create table " + entityName + "_? \\(\n([\\s\\S]*?)\n\\);");
        String tablesContent = this.getTablesContent(fileName, absolutePath);
        if (tablesContent == null) {
            return columnNames;
        }
        Matcher matcher = pattern.matcher(tablesContent);
        if (!matcher.find()) {
            return columnNames;
        }
        String tableContent = matcher.group(1);
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(tableContent));
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            line = StringUtil.trim(line);
            String columnName = line.substring(0, line.indexOf(32));
            columnName = StringUtil.replace(columnName, "_", "");
            columnNames.add(columnName);
        }
        return columnNames;
    }

    protected List<Element> getElementsByName(String name, Element element, List<Element> elements) {
        if (elements == null) {
            elements = new ArrayList<Element>();
        }
        List childElements = element.elements();
        for (Element childElement : childElements) {
            String elementName = childElement.getName();
            if (elementName.equals(name)) {
                elements.add(childElement);
            }
            elements = this.getElementsByName(name, childElement, elements);
        }
        return elements;
    }

    protected String getTablesContent(String fileName, String absolutePath) throws Exception {
        if (portalSource && !this.isModulesFile(absolutePath)) {
            if (this._tablesContent == null) {
                String tablesContent;
                this._tablesContent = tablesContent = this.getContent("sql/portal-tables.sql", 7);
            }
            return this._tablesContent;
        }
        String tablesContent = this._tablesContentMap.get(fileName);
        if (tablesContent != null) {
            return tablesContent;
        }
        int pos = fileName.lastIndexOf(47);
        String moduleOrPluginFolder = fileName.substring(0, pos);
        tablesContent = FileUtil.read(new File(moduleOrPluginFolder + "/src/main/resources/META-INF/sql/tables.sql"));
        if (tablesContent == null) {
            tablesContent = FileUtil.read(new File(moduleOrPluginFolder + "/src/META-INF/sql/tables.sql"));
        }
        if (tablesContent == null) {
            tablesContent = FileUtil.read(new File(moduleOrPluginFolder + "/sql/tables.sql"));
        }
        if (tablesContent != null) {
            this._tablesContentMap.put(fileName, tablesContent);
        }
        return tablesContent;
    }

    protected List<String> getTargetNames(String buildFileName, String fileName, List<String> targetNames, boolean importFile) throws Exception {
        if (buildFileName.contains("{")) {
            return null;
        }
        File file = new File(buildFileName);
        if (!file.exists()) {
            if (!importFile) {
                this.processMessage(fileName, "Ant element points to non-existing build file '" + buildFileName + "'");
            }
            return null;
        }
        Document document = this.readXML(FileUtil.read(file));
        Element rootElement = document.getRootElement();
        if (targetNames == null) {
            targetNames = new ArrayList<String>();
        }
        List targetElements = rootElement.elements("target");
        for (Element targetElement : targetElements) {
            targetNames.add(targetElement.attributeValue("name"));
        }
        List importElements = rootElement.elements("import");
        for (Element importElement : importElements) {
            String buildDirName = buildFileName.substring(0, buildFileName.lastIndexOf(47) + 1);
            String importFileName = buildDirName + importElement.attributeValue("file");
            targetNames = this.getTargetNames(importFileName, fileName, targetNames, true);
        }
        return targetNames;
    }

    protected String sortAttributes(String fileName, String content) throws Exception {
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            int lineCount = 0;
            boolean sortAttributes = true;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                ++lineCount;
                String trimmedLine = StringUtil.trimLeading(line);
                if (sortAttributes) {
                    if (!(!trimmedLine.startsWith("<") || !trimmedLine.endsWith(">") || trimmedLine.startsWith("<?") || trimmedLine.startsWith("<%") || trimmedLine.startsWith("<!") || line.contains("<![CDATA[") && line.contains("]]>"))) {
                        line = this.formatAttributes(fileName, line, trimmedLine, lineCount, true);
                    } else if (trimmedLine.startsWith("<![CDATA[") && !trimmedLine.endsWith("]]>")) {
                        sortAttributes = false;
                    }
                } else if (trimmedLine.endsWith("]]>")) {
                    sortAttributes = true;
                }
                sb.append(line);
                sb.append("\n");
            }
        }
        content = sb.toString();
        if (content.endsWith("\n")) {
            content = content.substring(0, content.length() - 1);
        }
        return content;
    }

    protected String sortPoshiCommands(String content) {
        Matcher matcher = this._poshiCommandsPattern.matcher(content);
        TreeMap<String, String> commandBlocksMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        String previousName = "";
        boolean hasUnsortedCommands = false;
        while (matcher.find()) {
            String commandBlock = matcher.group();
            String commandName = matcher.group(1);
            commandBlocksMap.put(commandName, commandBlock);
            if (!hasUnsortedCommands && commandName.compareToIgnoreCase(previousName) < 0) {
                hasUnsortedCommands = true;
            }
            previousName = commandName;
        }
        if (!hasUnsortedCommands) {
            return content;
        }
        StringBundler sb = new StringBundler();
        matcher = this._poshiSetUpPattern.matcher(content);
        if (matcher.find()) {
            String setUpBlock = matcher.group();
            content = content.replace(setUpBlock, "");
            sb.append(setUpBlock);
        }
        if ((matcher = this._poshiTearDownPattern.matcher(content)).find()) {
            String tearDownBlock = matcher.group();
            content = content.replace(tearDownBlock, "");
            sb.append(tearDownBlock);
        }
        for (Map.Entry entry : commandBlocksMap.entrySet()) {
            sb.append("\n\t");
            sb.append((String)entry.getValue());
            sb.append("\n");
        }
        int x = content.indexOf("<command");
        int n = content.lastIndexOf("</command>");
        String commandBlock = content.substring(x, n);
        commandBlock = "\n\t" + commandBlock + "</command>\n";
        String newCommandBlock = sb.toString();
        return StringUtil.replaceFirst(content, commandBlock, newCommandBlock);
    }

    protected String sortPoshiVariables(String content) {
        Matcher matcher = this._poshiVariablesBlockPattern.matcher(content);
        while (matcher.find()) {
            Object previousName = "";
            String tabs = "";
            TreeMap<Object, String> variableLinesMap = new TreeMap<Object, String>(String.CASE_INSENSITIVE_ORDER);
            String variableBlock = matcher.group(1);
            variableBlock = variableBlock.trim();
            Matcher variableLineMatcher = this._poshiVariableLinePattern.matcher(variableBlock);
            boolean hasUnsortedVariables = false;
            while (variableLineMatcher.find()) {
                if (tabs.equals("")) {
                    tabs = variableLineMatcher.group(1);
                }
                String variableLine = variableLineMatcher.group(2);
                String variableName = variableLineMatcher.group(3);
                variableLinesMap.put(variableName, variableLine);
                if (!hasUnsortedVariables && variableName.compareToIgnoreCase((String)previousName) < 0) {
                    hasUnsortedVariables = true;
                }
                previousName = variableName;
            }
            if (!hasUnsortedVariables) continue;
            StringBundler sb = new StringBundler();
            for (Map.Entry entry : variableLinesMap.entrySet()) {
                sb.append(tabs);
                sb.append((String)entry.getValue());
                sb.append("\n");
            }
            String newVariableBlock = sb.toString();
            newVariableBlock = newVariableBlock.trim();
            content = StringUtil.replaceFirst(content, variableBlock, newVariableBlock);
        }
        return content;
    }

    private class TilesDefinitionElementComparator
    extends ElementComparator {
        private TilesDefinitionElementComparator() {
        }

        @Override
        public int compare(Element definitionElement1, Element definitionElement2) {
            String definitionName1 = this.getElementName(definitionElement1);
            if (definitionName1.equals("portlet")) {
                return -1;
            }
            return super.compare(definitionElement1, definitionElement2);
        }
    }

    private class StrutsActionElementComparator
    extends ElementComparator {
        public StrutsActionElementComparator(String nameAttribute) {
            super(nameAttribute);
        }

        @Override
        public int compare(Element actionElement1, Element actionElement2) {
            String path1 = actionElement1.attributeValue("path");
            String path2 = actionElement2.attributeValue("path");
            if (!path1.startsWith("/portal/") && path2.startsWith("/portal/")) {
                return 1;
            }
            if (path1.startsWith("/portal/") && !path2.startsWith("/portal/")) {
                return -1;
            }
            return path1.compareTo(path2);
        }
    }

    private class SpringBeanElementComparator
    extends ElementComparator {
        public SpringBeanElementComparator(String nameAttribute) {
            super(nameAttribute);
        }

        @Override
        public int compare(Element element1, Element element2) {
            String startKey;
            String elementName1 = this.getElementName(element1);
            String elementName2 = this.getElementName(element2);
            if (elementName1 == null || elementName2 == null) {
                return 0;
            }
            int startsWithWeight = StringUtil.startsWithWeight(elementName1, elementName2);
            if (startsWithWeight != 0 && (startKey = elementName1.substring(0, startsWithWeight)).contains(".service.")) {
                return this._compareServiceElements(elementName1, elementName2);
            }
            if (StringUtil.count(elementName1, ".") > 1 && StringUtil.count(elementName2, ".") > 1) {
                ImportPackage importPackage1 = new ImportPackage(elementName1, false, elementName1);
                ImportPackage importPackage2 = new ImportPackage(elementName2, false, elementName2);
                return importPackage1.compareTo(importPackage2);
            }
            if (StringUtil.count(elementName1, ".") > 1) {
                return -1;
            }
            return super.compare(element1, element2);
        }

        @Override
        protected String getElementName(Element element) {
            String elementName = super.getElementName(element);
            if (elementName != null && StringUtil.count(elementName, ".") > 1) {
                return elementName;
            }
            return element.attributeValue("class");
        }

        private int _compareServiceElements(String name1, String name2) {
            SpringBeanServiceElement springBeanServiceElemen1 = new SpringBeanServiceElement(name1);
            SpringBeanServiceElement springBeanServiceElemen2 = new SpringBeanServiceElement(name2);
            return springBeanServiceElemen1.compareTo(springBeanServiceElemen2);
        }

        private class SpringBeanServiceElement
        implements Comparable<SpringBeanServiceElement> {
            private static final int _FINDER = 4;
            private static final int _LOCAL_SERVICE = 1;
            private static final int _PERSISTENCE = 3;
            private static final int _SERVICE = 2;
            private String _beanObjectName = "";
            private final Pattern _finderPattern = Pattern.compile("\\.service\\.persistence\\.(\\w+)Finder");
            private final Pattern _localServicePattern = Pattern.compile("\\.service\\.(\\w+)LocalService");
            private final Pattern _persistencePattern = Pattern.compile("\\.service\\.persistence\\.(\\w+)Persistence");
            private final Pattern _servicePattern = Pattern.compile("\\.service\\.(\\w+)Service");
            private int _type = -1;

            public SpringBeanServiceElement(String name) {
                Matcher matcher = this._localServicePattern.matcher(name);
                if (matcher.find()) {
                    this._beanObjectName = matcher.group(1);
                    this._type = 1;
                    return;
                }
                matcher = this._servicePattern.matcher(name);
                if (matcher.find()) {
                    this._beanObjectName = matcher.group(1);
                    this._type = 2;
                    return;
                }
                matcher = this._persistencePattern.matcher(name);
                if (matcher.find()) {
                    this._beanObjectName = matcher.group(1);
                    this._type = 3;
                    return;
                }
                matcher = this._finderPattern.matcher(name);
                if (matcher.find()) {
                    this._beanObjectName = matcher.group(1);
                    this._type = 4;
                }
            }

            @Override
            public int compareTo(SpringBeanServiceElement springBeanServiceElement) {
                if (this._beanObjectName.equals(springBeanServiceElement.getBeanObjectName())) {
                    return this._type - springBeanServiceElement.getType();
                }
                NaturalOrderStringComparator comparator = new NaturalOrderStringComparator();
                return comparator.compare(this._beanObjectName, springBeanServiceElement.getBeanObjectName());
            }

            public String getBeanObjectName() {
                return this._beanObjectName;
            }

            public int getType() {
                return this._type;
            }
        }
    }

    private class ServiceReferenceElementComparator
    extends ElementComparator {
        public ServiceReferenceElementComparator(String nameAttribute) {
            super(nameAttribute);
        }

        @Override
        public int compare(Element referenceElement1, Element referenceElement2) {
            String packagePath2;
            String packagePath1 = referenceElement1.attributeValue("package-path");
            if (!packagePath1.equals(packagePath2 = referenceElement2.attributeValue("package-path"))) {
                return packagePath1.compareToIgnoreCase(packagePath2);
            }
            String entityName1 = referenceElement1.attributeValue("entity");
            String entityName2 = referenceElement2.attributeValue("entity");
            return entityName1.compareToIgnoreCase(entityName2);
        }
    }

    private class ServiceFinderElementComparator
    extends ElementComparator {
        private final List<String> _columnNames;

        public ServiceFinderElementComparator(List<String> columnNames) {
            this._columnNames = columnNames;
        }

        @Override
        public int compare(Element finderElement1, Element finderElement2) {
            int finderColumnCount2;
            List finderColumnElements1 = finderElement1.elements("finder-column");
            List finderColumnElements2 = finderElement2.elements("finder-column");
            int finderColumnCount1 = finderColumnElements1.size();
            if (finderColumnCount1 != (finderColumnCount2 = finderColumnElements2.size())) {
                return finderColumnCount1 - finderColumnCount2;
            }
            for (int i = 0; i < finderColumnCount1; ++i) {
                int index2;
                Element finderColumnElement1 = (Element)finderColumnElements1.get(i);
                Element finderColumnElement2 = (Element)finderColumnElements2.get(i);
                String finderColumnName1 = finderColumnElement1.attributeValue("name");
                String finderColumnName2 = finderColumnElement2.attributeValue("name");
                int index1 = this._columnNames.indexOf(finderColumnName1);
                if (index1 == (index2 = this._columnNames.indexOf(finderColumnName2))) continue;
                return index1 - index2;
            }
            String finderName1 = finderElement1.attributeValue("name");
            String finderName2 = finderElement2.attributeValue("name");
            int startsWithWeight = StringUtil.startsWithWeight(finderName1, finderName2);
            String strippedFinderName1 = finderName1.substring(startsWithWeight);
            String strippedFinderName2 = finderName2.substring(startsWithWeight);
            if (strippedFinderName1.startsWith("Gt") || strippedFinderName1.startsWith("Like") || strippedFinderName1.startsWith("Lt") || strippedFinderName1.startsWith("Not")) {
                if (!(strippedFinderName2.startsWith("Gt") || strippedFinderName2.startsWith("Like") || strippedFinderName2.startsWith("Lt") || strippedFinderName2.startsWith("Not"))) {
                    return 1;
                }
                return strippedFinderName1.compareTo(strippedFinderName2);
            }
            return 0;
        }
    }

    private class ServiceFinderColumnElementComparator
    extends ElementComparator {
        private final List<String> _columnNames;

        public ServiceFinderColumnElementComparator(List<String> columnNames) {
            this._columnNames = columnNames;
        }

        @Override
        public int compare(Element finderColumnElement1, Element finderColumnElement2) {
            String finderColumnName1 = finderColumnElement1.attributeValue("name");
            String finderColumnName2 = finderColumnElement2.attributeValue("name");
            int index1 = this._columnNames.indexOf(finderColumnName1);
            int index2 = this._columnNames.indexOf(finderColumnName2);
            return index1 - index2;
        }
    }

    private class ServiceExceptionElementComparator
    extends ElementComparator {
        private ServiceExceptionElementComparator() {
        }

        @Override
        protected String getElementName(Element exceptionElement) {
            return exceptionElement.getStringValue();
        }
    }

    private class ResourceActionResourceElementComparator
    extends ElementComparator {
        public ResourceActionResourceElementComparator(String nameAttribute) {
            super(nameAttribute);
        }

        @Override
        protected String getElementName(Element portletResourceElement) {
            Element portletNameElement = portletResourceElement.element(this.getNameAttribute());
            if (portletNameElement == null) {
                return null;
            }
            return portletNameElement.getText();
        }
    }

    private class ResourceActionActionKeyElementComparator
    extends ElementComparator {
        private ResourceActionActionKeyElementComparator() {
        }

        @Override
        protected String getElementName(Element actionKeyElement) {
            return actionKeyElement.getStringValue();
        }
    }

    private class PortletPreferenceElementComparator
    extends ElementComparator {
        private PortletPreferenceElementComparator() {
        }

        @Override
        protected String getElementName(Element preferenceElement) {
            Element nameElement = preferenceElement.element(this.getNameAttribute());
            return nameElement.getStringValue();
        }
    }

    private class CustomSQLElementComparator
    extends ElementComparator {
        public CustomSQLElementComparator(String nameAttribute) {
            super(nameAttribute);
        }

        @Override
        public int compare(Element sqlElement1, Element sqlElement2) {
            String finderKeyName2;
            String sqlElementName1 = this.getElementName(sqlElement1);
            String sqlElementName2 = this.getElementName(sqlElement2);
            String finderObjectName1 = this._getFinderObjectName(sqlElementName1);
            String finderObjectName2 = this._getFinderObjectName(sqlElementName2);
            if (finderObjectName1 == null || finderObjectName2 == null) {
                return 0;
            }
            int value = finderObjectName1.compareToIgnoreCase(finderObjectName2);
            if (value != 0) {
                return value;
            }
            String finderKeyName1 = this._getFinderKeyName(sqlElementName1);
            int startsWithWeight = StringUtil.startsWithWeight(finderKeyName1, finderKeyName2 = this._getFinderKeyName(sqlElementName2));
            if (startsWithWeight == 0) {
                return finderKeyName1.compareTo(finderKeyName2);
            }
            String startFinder = finderKeyName1.substring(0, startsWithWeight);
            if (!startFinder.contains("By")) {
                NaturalOrderStringComparator comparator = new NaturalOrderStringComparator();
                return comparator.compare(finderKeyName1, finderKeyName2);
            }
            int columnCount1 = StringUtil.count(sqlElementName1, '_');
            int columnCount2 = StringUtil.count(sqlElementName2, '_');
            return columnCount1 - columnCount2;
        }

        private String _getFinderKeyName(String elementName) {
            if (Validator.isNull(elementName)) {
                return null;
            }
            int pos = elementName.lastIndexOf(".");
            if (pos == -1) {
                return null;
            }
            return elementName.substring(pos + 1);
        }

        private String _getFinderObjectName(String elementName) {
            if (Validator.isNull(elementName)) {
                return null;
            }
            int pos = elementName.lastIndexOf(".");
            if (pos == -1) {
                return null;
            }
            return elementName.substring(0, pos);
        }
    }
}

