/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class IndentationCheck
extends AbstractCheck {
    public static final String MSG_INCORRECT_INDENTATION = "indentation.incorrect";
    private static final int[] _ARITHMETIC_OPERATORS = new int[]{127, 126, 128, 125, 60};

    public int[] getDefaultTokens() {
        return new int[]{162, 29, 170, 145, 182, 138, 43, 175, 18, 39, 172, 58, 19, 30, 129, 11, 50, 86, 51, 93, 96, 52, 69, 87, 94, 85, 57, 92, 134, 97, 55, 91, 83, 54, 56, 136, 135, 61, 63, 62, 88, 53, 64, 79, 89, 67, 78, 90, 81, 133, 95, 49, 84, 132, 76, 142, 140, 137, 141, 16, 73, 77, 144, 152, 12, 139, 42, 23, 31};
    }

    public boolean isCommentNodesRequired() {
        return true;
    }

    public void visitToken(DetailAST detailAST) {
        int leadingTabCount;
        if (!this._isAtLineStart(detailAST) || this._isInsideChainedConcatMethod(detailAST) || this._isInsideDoIfOrWhileStatementCriterium(detailAST) || this._isInsideOperatorCriterium(detailAST)) {
            return;
        }
        int expectedTabCount = this._getExpectedTabCount(detailAST);
        if (expectedTabCount != (leadingTabCount = this._getLeadingTabCount(detailAST))) {
            this.log(detailAST.getLineNo(), MSG_INCORRECT_INDENTATION, new Object[]{leadingTabCount, expectedTabCount});
        }
    }

    private int _addExtraTabForExtendsOrImplements(int expectedTabCount, DetailAST detailAST) {
        DetailAST parentAST = detailAST;
        DetailAST grandParentAST = parentAST.getParent();
        while (grandParentAST != null) {
            if (grandParentAST.getType() == 18 || grandParentAST.getType() == 19) {
                DetailAST previousSibling = parentAST.getPreviousSibling();
                if (previousSibling == null || previousSibling.getType() != 74) {
                    return expectedTabCount;
                }
                int lineNo = grandParentAST.getLineNo();
                if (lineNo < detailAST.getLineNo()) {
                    return expectedTabCount + 1;
                }
            }
            parentAST = grandParentAST;
            grandParentAST = grandParentAST.getParent();
        }
        return expectedTabCount;
    }

    private int _addExtraTabForForStatement(int expectedTabCount, DetailAST detailAST) {
        if (this._findParent(detailAST, 156) != null) {
            return expectedTabCount + 1;
        }
        return expectedTabCount;
    }

    private int _addExtraTabForParameterWithThrows(int expectedTabCount, DetailAST detailAST) {
        DetailAST parentAST = detailAST;
        DetailAST grandParentAST = parentAST.getParent();
        while (grandParentAST != null) {
            if (grandParentAST.getType() == 8 || grandParentAST.getType() == 9) {
                DetailAST literalThrowsAST = grandParentAST.findFirstToken(81);
                if (literalThrowsAST == null) {
                    return expectedTabCount;
                }
                int literalThrowsLineNo = literalThrowsAST.getLineNo();
                int modifierLineNo = this._getModifierLineNo(grandParentAST);
                if (parentAST.getType() == 20 || detailAST.getLineNo() < literalThrowsLineNo && detailAST.getLineNo() > modifierLineNo) {
                    return expectedTabCount + 1;
                }
                return expectedTabCount;
            }
            parentAST = grandParentAST;
            grandParentAST = grandParentAST.getParent();
        }
        return expectedTabCount;
    }

    private int _addExtraTabForSwitch(int expectedTabCount, DetailAST detailAST) {
        if (detailAST.getType() == 93 || detailAST.getType() == 94) {
            return expectedTabCount;
        }
        DetailAST parentAST = detailAST.getParent();
        while (parentAST != null) {
            if (parentAST.getType() == 33) {
                return expectedTabCount + 1;
            }
            parentAST = parentAST.getParent();
        }
        return expectedTabCount;
    }

    private int _addExtraTabForTryStatement(int expectedTabCount, DetailAST detailAST) {
        DetailAST parentAST = detailAST.getParent();
        while (parentAST != null) {
            DetailAST previousSibling;
            if (parentAST.getType() == 178 && (previousSibling = parentAST.getPreviousSibling()) != null) {
                return expectedTabCount;
            }
            if (parentAST.getType() == 176) {
                if ((parentAST = parentAST.getParent()).getType() != 95) continue;
                return expectedTabCount + 1;
            }
            parentAST = parentAST.getParent();
        }
        return expectedTabCount;
    }

    private int _addExtraTabsForLambda(int expectedTabCount, DetailAST detailAST) {
        DetailAST parentAST = detailAST.getParent();
        while (parentAST != null) {
            if (parentAST.getType() == 7) {
                if ((parentAST = parentAST.getParent()).getType() != 181) continue;
                expectedTabCount += this._getLineBreakTabs(parentAST);
                continue;
            }
            parentAST = parentAST.getParent();
        }
        return expectedTabCount;
    }

    private int _addExtraTabsForLiteralNew(int expectedTabCount, DetailAST detailAST) {
        DetailAST parentAST = detailAST.getParent();
        while (parentAST != null) {
            if (parentAST.getType() == 6) {
                if ((parentAST = parentAST.getParent()).getType() != 136) continue;
                expectedTabCount += this._getLineBreakTabs(parentAST);
                continue;
            }
            parentAST = parentAST.getParent();
        }
        return expectedTabCount;
    }

    private Set<Integer> _addTabsForArithmeticOperators(Set<Integer> lineNumbers, int lineCount, DetailAST detailAST) {
        DetailAST firstChild = detailAST;
        while (true) {
            int lineNo;
            if ((lineNo = firstChild.getLineNo()) < lineCount) {
                lineNumbers.add(lineNo);
            }
            if (!ArrayUtil.contains(_ARITHMETIC_OPERATORS, firstChild.getType())) break;
            firstChild = firstChild.getFirstChild();
        }
        return lineNumbers;
    }

    private Set<Integer> _addTabsForDot(Set<Integer> lineNumbers, int lineCount, DetailAST detailAST) {
        if (detailAST == null) {
            return lineNumbers;
        }
        DetailAST firstChild = detailAST;
        while (firstChild.getType() == 59) {
            int lineNo = firstChild.getLineNo();
            if (lineNo < lineCount) {
                lineNumbers.add(lineNo);
            }
            firstChild = firstChild.getFirstChild();
        }
        return lineNumbers;
    }

    private Set<Integer> _addTabsForGenerics(Set<Integer> lineNumbers, int lineCount, DetailAST detailAST) {
        if (detailAST == null) {
            return lineNumbers;
        }
        List<DetailAST> genericASTList = DetailASTUtil.getAllChildTokens(detailAST, true, 173, 172);
        for (DetailAST genericAST : genericASTList) {
            int lineNo = genericAST.getLineNo();
            if (lineNo >= lineCount) continue;
            lineNumbers.add(lineNo);
        }
        return lineNumbers;
    }

    private Set<Integer> _addTabsForTypecast(Set<Integer> lineNumbers, int lineCount, DetailAST detailAST) {
        DetailAST previousSibling = detailAST.getPreviousSibling();
        if (previousSibling == null || previousSibling.getType() != 23) {
            return lineNumbers;
        }
        int lineNo = previousSibling.getLineNo();
        if (lineNo < lineCount) {
            lineNumbers.add(lineNo);
        }
        return lineNumbers;
    }

    private DetailAST _findParent(DetailAST detailAST, int type) {
        DetailAST match = null;
        DetailAST parentAST = detailAST.getParent();
        while (parentAST != null && parentAST.getType() != 6 && parentAST.getType() != 7) {
            if (parentAST.getType() == type) {
                match = parentAST;
            }
            parentAST = parentAST.getParent();
        }
        return match;
    }

    private int _getExpectedTabCount(DetailAST detailAST) {
        int expectedTabCount = this._getLevel(detailAST) + this._getLineBreakTabs(detailAST);
        expectedTabCount = this._addExtraTabForExtendsOrImplements(expectedTabCount, detailAST);
        expectedTabCount = this._addExtraTabForForStatement(expectedTabCount, detailAST);
        expectedTabCount = this._addExtraTabsForLambda(expectedTabCount, detailAST);
        expectedTabCount = this._addExtraTabsForLiteralNew(expectedTabCount, detailAST);
        expectedTabCount = this._addExtraTabForParameterWithThrows(expectedTabCount, detailAST);
        expectedTabCount = this._addExtraTabForSwitch(expectedTabCount, detailAST);
        expectedTabCount = this._addExtraTabForTryStatement(expectedTabCount, detailAST);
        if (detailAST.getType() == 182 || detailAST.getType() == 73 || detailAST.getType() == 77) {
            return expectedTabCount - 1;
        }
        return expectedTabCount;
    }

    private int _getLeadingTabCount(DetailAST detailAST) {
        FileContents fileContents = this.getFileContents();
        String line = fileContents.getLine(DetailASTUtil.getStartLine(detailAST) - 1);
        int leadingTabCount = 0;
        while (line.startsWith("\t")) {
            line = line.substring(1);
            ++leadingTabCount;
        }
        return leadingTabCount;
    }

    private int _getLevel(DetailAST detailAST) {
        int level = 0;
        DetailAST parentAST = detailAST.getParent();
        while (parentAST != null) {
            if (parentAST.getType() == 6 || parentAST.getType() == 7) {
                ++level;
            }
            parentAST = parentAST.getParent();
        }
        return level;
    }

    private int _getLineBreakTabs(DetailAST detailAST) {
        if (detailAST.getType() == 175 || detailAST.getType() == 96 || detailAST.getType() == 92 || detailAST.getType() == 97) {
            return 0;
        }
        Set<Integer> lineNumbers = new HashSet<Integer>();
        DetailAST parentAST = detailAST;
        while (parentAST != null && parentAST.getType() != 22 && parentAST.getType() != 6 && parentAST.getType() != 7) {
            DetailAST colonAST;
            int lineNo;
            DetailAST nameAST;
            int lineNo2;
            if (parentAST.getType() == 157 || parentAST.getType() == 161 || parentAST.getType() == 14 || parentAST.getType() == 8 || parentAST.getType() == 155 || parentAST.getType() == 154 || parentAST.getType() == 15 || parentAST.getType() == 9 || parentAST.getType() == 5 || parentAST.getType() == 10) {
                DetailAST nameAST2;
                DetailAST typeAST = parentAST.findFirstToken(13);
                int lineNo3 = this._getModifierLineNo(parentAST);
                if (lineNo3 == -1 && typeAST != null) {
                    lineNo3 = typeAST.getLineNo();
                }
                if (lineNo3 != -1 && lineNo3 < detailAST.getLineNo()) {
                    lineNumbers.add(lineNo3);
                }
                if ((parentAST.getType() == 14 || parentAST.getType() == 155 || parentAST.getType() == 154 || parentAST.getType() == 15) && (lineNo3 = (nameAST2 = parentAST.findFirstToken(58)).getLineNo()) < detailAST.getLineNo()) {
                    lineNumbers.add(lineNo3);
                }
                lineNumbers = this._addTabsForGenerics(lineNumbers, detailAST.getLineNo(), typeAST);
                DetailAST typeParametersAST = parentAST.findFirstToken(165);
                lineNumbers = this._addTabsForGenerics(lineNumbers, detailAST.getLineNo(), typeParametersAST);
            } else if (parentAST.getType() == 34 || parentAST.getType() == 20) {
                int lineNo4;
                DetailAST lParenAST = parentAST.getPreviousSibling();
                if (lParenAST != null && (lineNo4 = lParenAST.getLineNo()) < detailAST.getLineNo()) {
                    lineNumbers.add(lineNo4);
                }
            } else if (parentAST.getType() != 33 && (lineNo2 = parentAST.getLineNo()) < detailAST.getLineNo()) {
                lineNumbers.add(lineNo2);
            }
            DetailAST dotAST = parentAST.findFirstToken(59);
            lineNumbers = this._addTabsForDot(lineNumbers, detailAST.getLineNo(), dotAST);
            if ((parentAST.getType() == 18 || parentAST.getType() == 19) && (nameAST = parentAST.findFirstToken(58)) != null && (lineNo = nameAST.getLineNo()) < detailAST.getLineNo()) {
                lineNumbers.add(lineNo);
            }
            if (parentAST.getType() == 156) {
                DetailAST colonAST2 = parentAST.findFirstToken(82);
                if (colonAST2 != null && (lineNo = colonAST2.getLineNo()) < detailAST.getLineNo()) {
                    lineNumbers.add(lineNo);
                }
                lineNumbers = this._addTabsForGenerics(lineNumbers, detailAST.getLineNo(), parentAST);
            }
            if (parentAST.getType() == 21) {
                lineNumbers = this._addTabsForGenerics(lineNumbers, detailAST.getLineNo(), parentAST);
            }
            if (parentAST.getType() == 109 && (lineNo = (colonAST = parentAST.findFirstToken(82)).getLineNo()) < detailAST.getLineNo()) {
                lineNumbers.add(lineNo);
            }
            if (ArrayUtil.contains(_ARITHMETIC_OPERATORS, parentAST.getType())) {
                lineNumbers = this._addTabsForArithmeticOperators(lineNumbers, detailAST.getLineNo(), parentAST);
            }
            if (parentAST.getType() == 13) {
                lineNumbers = this._addTabsForTypecast(lineNumbers, detailAST.getLineNo(), parentAST);
                lineNumbers = this._addTabsForGenerics(lineNumbers, detailAST.getLineNo(), parentAST);
            }
            if (parentAST.getType() == 23) {
                DetailAST typeAST = parentAST.findFirstToken(13);
                lineNumbers = this._addTabsForGenerics(lineNumbers, detailAST.getLineNo(), typeAST);
            }
            if (parentAST.getType() == 159) {
                if ((parentAST = parentAST.getParent()).getType() != 5 || this._findParent(parentAST, 21) != null) continue;
                return lineNumbers.size();
            }
            parentAST = parentAST.getParent();
        }
        return lineNumbers.size();
    }

    private int _getModifierLineNo(DetailAST detailAST) {
        DetailAST modifiersAST = detailAST.findFirstToken(5);
        if (modifiersAST == null) {
            return -1;
        }
        DetailAST modifierAST = modifiersAST.findFirstToken(61);
        if (modifierAST == null) {
            modifierAST = modifiersAST.findFirstToken(63);
        }
        if (modifierAST == null) {
            modifierAST = modifiersAST.findFirstToken(62);
        }
        if (modifierAST != null) {
            return modifierAST.getLineNo();
        }
        return -1;
    }

    private boolean _isAtLineStart(DetailAST detailAST) {
        FileContents fileContents = this.getFileContents();
        String line = fileContents.getLine(DetailASTUtil.getStartLine(detailAST) - 1);
        for (int i = 0; i < detailAST.getColumnNo(); ++i) {
            char c = line.charAt(i);
            if (c == ' ' || c == '\t') continue;
            return false;
        }
        return true;
    }

    private boolean _isConcatMethod(DetailAST detailAST) {
        if (detailAST.getType() != 27) {
            return false;
        }
        DetailAST firstChild = detailAST.getFirstChild();
        if (firstChild == null || firstChild.getType() != 59) {
            return false;
        }
        DetailAST lastChild = firstChild.getLastChild();
        if (lastChild == null || lastChild.getType() != 58) {
            return false;
        }
        String name = lastChild.getText();
        return name.equals("concat");
    }

    private boolean _isInsideChainedConcatMethod(DetailAST detailAST) {
        DetailAST parentAST = detailAST.getParent();
        while (parentAST != null) {
            if (!this._isConcatMethod(parentAST)) {
                parentAST = parentAST.getParent();
                continue;
            }
            DetailAST firstChild = parentAST.getFirstChild();
            if (this._isConcatMethod(firstChild = firstChild.getFirstChild())) {
                return true;
            }
            parentAST = parentAST.getParent();
        }
        return false;
    }

    private boolean _isInsideDoIfOrWhileStatementCriterium(DetailAST detailAST) {
        DetailAST parentAST = detailAST.getParent();
        while (true) {
            if (parentAST == null) {
                return false;
            }
            if (parentAST.getType() != 28) {
                parentAST = parentAST.getParent();
                continue;
            }
            if ((parentAST = parentAST.getParent()).getType() == 85 || parentAST.getType() == 83 || parentAST.getType() == 84) break;
        }
        return true;
    }

    private boolean _isInsideOperatorCriterium(DetailAST detailAST) {
        return this._findParent(detailAST, 114) != null || this._findParent(detailAST, 112) != null || this._findParent(detailAST, 113) != null || this._findParent(detailAST, 111) != null || this._findParent(detailAST, 110) != null;
    }
}

