/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class JSONNamingCheck
extends AbstractCheck {
    public static final String MSG_RENAME_VARIABLE = "variable.rename";
    public static final String MSG_RESERVED_VARIABLE_NAME = "variable.name.reserved";

    public int[] getDefaultTokens() {
        return new int[]{21, 10};
    }

    public void visitToken(DetailAST detailAST) {
        String name = this._getVariableName(detailAST);
        String typeName = DetailASTUtil.getTypeName(detailAST);
        this._checkVariable(name, typeName, "String", "JSON", "Json", detailAST.getLineNo());
        this._checkVariable(name, typeName, "JSONArray", "JSONArray", "JsonArray", detailAST.getLineNo());
        this._checkVariable(name, typeName, "JSONObject", "JSONObject", "JsonObject", detailAST.getLineNo());
    }

    private void _checkVariable(String name, String typeName, String type, String reservedNameEnding, String incorrectNameEnding, int lineNo) {
        String lowerCaseName = StringUtil.toLowerCase(name);
        if (!lowerCaseName.endsWith(StringUtil.toLowerCase(reservedNameEnding))) {
            return;
        }
        if (!typeName.equals(type) && !typeName.endsWith("." + type)) {
            String lowerCaseTypeName = StringUtil.toLowerCase(typeName);
            if (!lowerCaseTypeName.endsWith(StringUtil.toLowerCase(type))) {
                this.log(lineNo, MSG_RESERVED_VARIABLE_NAME, new Object[]{reservedNameEnding, type});
            }
            return;
        }
        if (name.endsWith(incorrectNameEnding)) {
            this.log(lineNo, MSG_RENAME_VARIABLE, new Object[]{name, StringUtil.replaceLast(name, incorrectNameEnding, reservedNameEnding)});
        }
    }

    private String _getVariableName(DetailAST detailAST) {
        DetailAST nameAST = detailAST.findFirstToken(58);
        return nameAST.getText();
    }
}

