/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.announcements.kernel.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.Team;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.OrganizationLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.TeamLocalServiceUtil;
import com.liferay.portal.kernel.service.UserGroupLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.service.permission.OrganizationPermissionUtil;
import com.liferay.portal.kernel.service.permission.RolePermissionUtil;
import com.liferay.portal.kernel.service.permission.UserGroupPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class AnnouncementsUtil {
    private static final long _GROUP_CLASS_NAME_ID = PortalUtil.getClassNameId(Group.class.getName());
    private static final long _ORGANIZATION_CLASS_NAME_ID = PortalUtil.getClassNameId(Organization.class.getName());
    private static final boolean _PERMISSIONS_CHECK_GUEST_ENABLED = GetterUtil.getBoolean(PropsUtil.get("permissions.check.guest.enabled"));
    private static final long _ROLE_CLASS_NAME_ID = PortalUtil.getClassNameId(Role.class.getName());
    private static final long _USER_CLASS_NAME_ID = PortalUtil.getClassNameId(User.class.getName());
    private static final long _USER_GROUP_CLASS_NAME_ID = PortalUtil.getClassNameId(UserGroup.class.getName());

    public static LinkedHashMap<Long, long[]> getAnnouncementScopes(long userId) throws PortalException {
        List<UserGroup> userGroups;
        List<Group> groups;
        LinkedHashMap<Long, long[]> scopes = new LinkedHashMap<Long, long[]>();
        scopes.put(0L, new long[]{0L});
        scopes.put(_USER_CLASS_NAME_ID, new long[]{userId});
        ArrayList<Group> groupsList = new ArrayList<Group>();
        List<Organization> organizations = OrganizationLocalServiceUtil.getUserOrganizations(userId);
        if (!organizations.isEmpty()) {
            ArrayList<Organization> organizationsList = new ArrayList<Organization>();
            organizationsList.addAll(organizations);
            for (Organization organization : organizations) {
                groupsList.add(organization.getGroup());
                List<Organization> list = OrganizationLocalServiceUtil.getParentOrganizations(organization.getOrganizationId());
                for (Organization parentOrganization : list) {
                    organizationsList.add(parentOrganization);
                    groupsList.add(parentOrganization.getGroup());
                }
            }
            scopes.put(_ORGANIZATION_CLASS_NAME_ID, AnnouncementsUtil._getOrganizationIds(organizationsList));
        }
        if (!(groups = GroupLocalServiceUtil.getUserGroups(userId, true)).isEmpty()) {
            scopes.put(_GROUP_CLASS_NAME_ID, AnnouncementsUtil._getGroupIds(groups));
            groupsList.addAll(groups);
        }
        if (!(userGroups = UserGroupLocalServiceUtil.getUserUserGroups(userId)).isEmpty()) {
            scopes.put(_USER_GROUP_CLASS_NAME_ID, AnnouncementsUtil._getUserGroupIds(userGroups));
            for (UserGroup userGroup : userGroups) {
                groupsList.add(userGroup.getGroup());
            }
        }
        LinkedHashSet<Role> linkedHashSet = new LinkedHashSet<Role>();
        if (!groupsList.isEmpty()) {
            linkedHashSet.addAll(RoleLocalServiceUtil.getUserRelatedRoles(userId, groupsList));
            for (Group group : groupsList) {
                linkedHashSet.addAll(RoleLocalServiceUtil.getUserGroupRoles(userId, group.getGroupId()));
                linkedHashSet.addAll(RoleLocalServiceUtil.getUserGroupGroupRoles(userId, group.getGroupId()));
            }
        } else {
            linkedHashSet.addAll(RoleLocalServiceUtil.getUserRoles(userId));
        }
        List<Team> list = TeamLocalServiceUtil.getUserTeams(userId);
        for (Team team : list) {
            linkedHashSet.add(team.getRole());
        }
        if (_PERMISSIONS_CHECK_GUEST_ENABLED) {
            User user = UserLocalServiceUtil.getUserById(userId);
            Role guestRole = RoleLocalServiceUtil.getRole(user.getCompanyId(), "Guest");
            linkedHashSet.add(guestRole);
        }
        if (!linkedHashSet.isEmpty()) {
            scopes.put(_ROLE_CLASS_NAME_ID, AnnouncementsUtil._getRoleIds(linkedHashSet));
        }
        return scopes;
    }

    public static List<Group> getGroups(ThemeDisplay themeDisplay) throws Exception {
        ArrayList<Group> filteredGroups = new ArrayList<Group>();
        List<Group> groups = GroupLocalServiceUtil.getUserGroups(themeDisplay.getUserId(), true);
        for (Group group : groups) {
            if ((!group.isOrganization() || !group.isSite()) && !group.isRegularSite() || !GroupPermissionUtil.contains(themeDisplay.getPermissionChecker(), group.getGroupId(), "MANAGE_ANNOUNCEMENTS")) continue;
            filteredGroups.add(group);
        }
        return filteredGroups;
    }

    public static List<Organization> getOrganizations(ThemeDisplay themeDisplay) throws Exception {
        ArrayList<Organization> filteredOrganizations = new ArrayList<Organization>();
        List<Organization> organizations = OrganizationLocalServiceUtil.getUserOrganizations(themeDisplay.getUserId());
        for (Organization organization : organizations) {
            if (!OrganizationPermissionUtil.contains(themeDisplay.getPermissionChecker(), organization.getOrganizationId(), "MANAGE_ANNOUNCEMENTS")) continue;
            filteredOrganizations.add(organization);
        }
        return filteredOrganizations;
    }

    public static List<Role> getRoles(ThemeDisplay themeDisplay) throws Exception {
        ArrayList<Role> filteredRoles = new ArrayList<Role>();
        List<Role> roles = RoleLocalServiceUtil.getRoles(themeDisplay.getCompanyId());
        for (Role role : roles) {
            if (role.isTeam()) {
                Team team = TeamLocalServiceUtil.getTeam(role.getClassPK());
                if (!GroupPermissionUtil.contains(themeDisplay.getPermissionChecker(), team.getGroupId(), "MANAGE_ANNOUNCEMENTS") && !RolePermissionUtil.contains(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroupId(), role.getRoleId(), "MANAGE_ANNOUNCEMENTS")) continue;
                filteredRoles.add(role);
                continue;
            }
            if (!RolePermissionUtil.contains(themeDisplay.getPermissionChecker(), role.getRoleId(), "MANAGE_ANNOUNCEMENTS")) continue;
            filteredRoles.add(role);
        }
        return filteredRoles;
    }

    public static List<UserGroup> getUserGroups(ThemeDisplay themeDisplay) throws Exception {
        ArrayList<UserGroup> filteredUserGroups = new ArrayList<UserGroup>();
        List<UserGroup> userGroups = UserGroupLocalServiceUtil.getUserGroups(themeDisplay.getCompanyId());
        for (UserGroup userGroup : userGroups) {
            if (!UserGroupPermissionUtil.contains(themeDisplay.getPermissionChecker(), userGroup.getUserGroupId(), "MANAGE_ANNOUNCEMENTS")) continue;
            filteredUserGroups.add(userGroup);
        }
        return filteredUserGroups;
    }

    private static long[] _getGroupIds(List<Group> groups) {
        long[] groupIds = new long[groups.size()];
        int i = 0;
        for (Group group : groups) {
            groupIds[i++] = group.getGroupId();
        }
        return groupIds;
    }

    private static long[] _getOrganizationIds(List<Organization> organizations) {
        long[] organizationIds = new long[organizations.size()];
        int i = 0;
        for (Organization organization : organizations) {
            organizationIds[i++] = organization.getOrganizationId();
        }
        return organizationIds;
    }

    private static long[] _getRoleIds(Set<Role> roles) {
        long[] roleIds = new long[roles.size()];
        int i = 0;
        for (Role role : roles) {
            roleIds[i++] = role.getRoleId();
        }
        return roleIds;
    }

    private static long[] _getUserGroupIds(List<UserGroup> userGroups) {
        long[] userGroupIds = new long[userGroups.size()];
        int i = 0;
        for (UserGroup userGroup : userGroups) {
            userGroupIds[i++] = userGroup.getUserGroupId();
        }
        return userGroupIds;
    }
}

