/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.concurrent;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.LoggingTimer;

public abstract class ThrowableAwareRunnable
implements Runnable {
    private static final Log _log = LogFactoryUtil.getLog(ThrowableAwareRunnable.class);
    private Throwable _throwable;

    public Throwable getThrowable() {
        return this._throwable;
    }

    public boolean hasException() {
        return this._throwable != null;
    }

    @Override
    public void run() {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this.doRun();
        }
        catch (Exception e) {
            _log.error("Unable to process runnable: " + e.getMessage(), e);
            this._throwable = e;
        }
    }

    protected abstract void doRun() throws Exception;
}

