/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.jsonwebservice;

import com.liferay.portal.kernel.jsonwebservice.JSONWebService;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceNaming;
import java.lang.reflect.Method;

public class JSONWebServiceMappingResolver {
    private final JSONWebServiceNaming _jsonWebServiceNaming;

    public JSONWebServiceMappingResolver(JSONWebServiceNaming jsonWebServiceNaming) {
        this._jsonWebServiceNaming = jsonWebServiceNaming;
    }

    public String resolveHttpMethod(Method method) {
        JSONWebService jsonWebServiceAnnotation = method.getAnnotation(JSONWebService.class);
        String httpMethod = null;
        if (jsonWebServiceAnnotation != null) {
            httpMethod = jsonWebServiceAnnotation.method().trim();
        }
        if (httpMethod != null && httpMethod.length() != 0) {
            return httpMethod;
        }
        return this._jsonWebServiceNaming.convertMethodToHttpMethod(method);
    }

    public String resolvePath(Class<?> clazz, Method method) {
        JSONWebService jsonWebServiceAnnotation = method.getAnnotation(JSONWebService.class);
        String path = null;
        if (jsonWebServiceAnnotation != null) {
            path = jsonWebServiceAnnotation.value().trim();
        }
        if (path == null || path.length() == 0) {
            path = this._jsonWebServiceNaming.convertMethodToPath(method);
        }
        if (path.startsWith("/")) {
            return path;
        }
        path = "/" + path;
        String pathFromClass = null;
        jsonWebServiceAnnotation = clazz.getAnnotation(JSONWebService.class);
        if (jsonWebServiceAnnotation != null) {
            pathFromClass = jsonWebServiceAnnotation.value().trim();
        }
        if (pathFromClass == null || pathFromClass.length() == 0) {
            pathFromClass = this._jsonWebServiceNaming.convertServiceClassToPath(clazz);
        }
        if (!pathFromClass.startsWith("/")) {
            pathFromClass = "/" + pathFromClass;
        }
        return pathFromClass + path;
    }
}

