/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging.proxy;

import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.proxy.MessageValuesThreadLocal;
import com.liferay.portal.kernel.messaging.proxy.ProxyRequest;
import com.liferay.portal.kernel.messaging.proxy.ProxyResponse;
import com.liferay.portal.kernel.messaging.sender.SingleDestinationMessageSender;
import com.liferay.portal.kernel.messaging.sender.SingleDestinationMessageSenderFactoryUtil;
import com.liferay.portal.kernel.messaging.sender.SingleDestinationSynchronousMessageSender;
import com.liferay.portal.kernel.messaging.sender.SynchronousMessageSender;

public abstract class BaseProxyBean {
    private String _destinationName;
    private String _synchronousDestinationName;
    private SynchronousMessageSender.Mode _synchronousMessageSenderMode;

    @Deprecated
    public void afterPropertiesSet() {
    }

    public void send(ProxyRequest proxyRequest) {
        SingleDestinationMessageSender singleDestinationMessageSender = SingleDestinationMessageSenderFactoryUtil.createSingleDestinationMessageSender(this._destinationName);
        singleDestinationMessageSender.send(this.buildMessage(proxyRequest));
    }

    public void setDestinationName(String destinationName) {
        this._destinationName = destinationName;
    }

    @Deprecated
    public void setSingleDestinationMessageSender(SingleDestinationMessageSender singleDestinationMessageSender) {
    }

    @Deprecated
    public void setSingleDestinationSynchronousMessageSender(SingleDestinationSynchronousMessageSender singleDestinationSynchronousMessageSender) {
    }

    public void setSynchronousDestinationName(String synchronousDestinationName) {
        this._synchronousDestinationName = synchronousDestinationName;
    }

    public void setSynchronousMessageSenderMode(SynchronousMessageSender.Mode synchronousMessageSenderMode) {
        this._synchronousMessageSenderMode = synchronousMessageSenderMode;
    }

    public Object synchronousSend(ProxyRequest proxyRequest) throws Exception {
        SingleDestinationSynchronousMessageSender singleDestinationSynchronousMessageSender = SingleDestinationMessageSenderFactoryUtil.createSingleDestinationSynchronousMessageSender(this._synchronousDestinationName, this._synchronousMessageSenderMode);
        ProxyResponse proxyResponse = (ProxyResponse)singleDestinationSynchronousMessageSender.send(this.buildMessage(proxyRequest));
        if (proxyResponse == null) {
            return proxyRequest.execute(this);
        }
        if (proxyResponse.hasError()) {
            throw proxyResponse.getException();
        }
        return proxyResponse.getResult();
    }

    protected Message buildMessage(ProxyRequest proxyRequest) {
        Message message = new Message();
        message.setPayload(proxyRequest);
        MessageValuesThreadLocal.populateMessageFromThreadLocals(message);
        if (proxyRequest.isLocal()) {
            message.put("LOCAL_MESSAGE", Boolean.TRUE);
        }
        return message;
    }
}

