/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.model;

import com.liferay.portal.kernel.util.DigesterUtil;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class ResourceBlockPermissionsContainer {
    private final SortedMap<Long, Long> _permissions = new TreeMap<Long, Long>();

    public void addPermission(long roleId, long actionIdsLong) {
        this.setPermissions(roleId, actionIdsLong |= this.getActionIds(roleId));
    }

    public long getActionIds(long roleId) {
        Long actionIdsLong = (Long)this._permissions.get(roleId);
        if (actionIdsLong == null) {
            actionIdsLong = 0L;
        }
        return actionIdsLong;
    }

    public SortedMap<Long, Long> getPermissions() {
        return this._permissions;
    }

    public String getPermissionsHash() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(this._permissions.size() * 16);
        for (Map.Entry<Long, Long> entry : this._permissions.entrySet()) {
            byteBuffer.putLong(entry.getKey());
            byteBuffer.putLong(entry.getValue());
        }
        byteBuffer.flip();
        return DigesterUtil.digestHex("SHA-1", byteBuffer);
    }

    public Set<Long> getRoleIds() {
        return this._permissions.keySet();
    }

    public boolean hasPermission(long roleId, long actionIdsLong) {
        return (this.getActionIds(roleId) & actionIdsLong) == actionIdsLong;
    }

    public void removePermission(long roleId, long actionIdsLong) {
        actionIdsLong = this.getActionIds(roleId) & (actionIdsLong ^ 0xFFFFFFFFFFFFFFFFL);
        this.setPermissions(roleId, actionIdsLong);
    }

    public void setPermissions(long roleId, long actionIdsLong) {
        if (actionIdsLong == 0L) {
            this._permissions.remove(roleId);
        } else {
            this._permissions.put(roleId, actionIdsLong);
        }
    }
}

