/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.process;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.process.OutputProcessor;
import com.liferay.portal.kernel.process.ProcessException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class LoggingOutputProcessor
implements OutputProcessor<Void, Void> {
    private static final Log _log = LogFactoryUtil.getLog(LoggingOutputProcessor.class);

    @Override
    public Void processStdErr(InputStream stdErrInputStream) throws ProcessException {
        this._processOut(true, stdErrInputStream);
        return null;
    }

    @Override
    public Void processStdOut(InputStream stdOutInputStream) throws ProcessException {
        this._processOut(false, stdOutInputStream);
        return null;
    }

    private void _processOut(boolean stdErr, InputStream inputStream) throws ProcessException {
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new InputStreamReader(inputStream));
        String line = null;
        try {
            while ((line = unsyncBufferedReader.readLine()) != null) {
                if (stdErr && _log.isErrorEnabled()) {
                    _log.error(line);
                    continue;
                }
                if (stdErr || !_log.isInfoEnabled()) continue;
                _log.info(line);
            }
        }
        catch (IOException ioe) {
            throw new ProcessException(ioe);
        }
        finally {
            try {
                unsyncBufferedReader.close();
            }
            catch (IOException ioe) {
                throw new ProcessException(ioe);
            }
        }
    }
}

