/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.resiliency.spi.agent.annotation;

import com.liferay.portal.kernel.resiliency.spi.agent.annotation.Direction;
import com.liferay.portal.kernel.resiliency.spi.agent.annotation.Distributed;
import com.liferay.portal.kernel.resiliency.spi.agent.annotation.MatchType;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class DistributedRegistry {
    private static final ConcurrentMap<String, Direction> _exactDirections = new ConcurrentHashMap<String, Direction>();
    private static final ConcurrentMap<String, Direction> _postfixDirections = new ConcurrentHashMap<String, Direction>();
    private static final ConcurrentMap<String, Direction> _prefixDirections = new ConcurrentHashMap<String, Direction>();

    public static boolean isDistributed(String name, Direction direction) {
        Direction registeredDirection = (Direction)((Object)_exactDirections.get(name));
        if (registeredDirection == direction || registeredDirection == Direction.DUPLEX) {
            return true;
        }
        if (registeredDirection != null) {
            return false;
        }
        for (Map.Entry entry : _postfixDirections.entrySet()) {
            String postfix = (String)entry.getKey();
            if (!name.endsWith(postfix) || (registeredDirection = (Direction)((Object)entry.getValue())) != direction && registeredDirection != Direction.DUPLEX) continue;
            return true;
        }
        for (Map.Entry entry : _prefixDirections.entrySet()) {
            String prefix = (String)entry.getKey();
            if (!name.startsWith(prefix) || (registeredDirection = (Direction)((Object)entry.getValue())) != direction && registeredDirection != Direction.DUPLEX) continue;
            return true;
        }
        return false;
    }

    public static void registerDistributed(Class<?> clazz) {
        DistributedRegistry.processDistributed(clazz, true);
    }

    public static void registerDistributed(String name, Direction direction, MatchType matchType) {
        if (matchType.equals((Object)MatchType.POSTFIX)) {
            _postfixDirections.put(name, direction);
        } else if (matchType.equals((Object)MatchType.PREFIX)) {
            _prefixDirections.put(name, direction);
        } else {
            _exactDirections.put(name, direction);
        }
    }

    public static void unregisterDistributed(Class<?> clazz) {
        DistributedRegistry.processDistributed(clazz, false);
    }

    public static boolean unregisterDistributed(String name, Direction direction, MatchType matchType) {
        if (matchType.equals((Object)MatchType.POSTFIX)) {
            if (direction == null) {
                direction = (Direction)((Object)_postfixDirections.remove(name));
                return direction != null;
            }
            return _postfixDirections.remove(name, (Object)direction);
        }
        if (matchType.equals((Object)MatchType.PREFIX)) {
            if (direction == null) {
                direction = (Direction)((Object)_prefixDirections.remove(name));
                return direction != null;
            }
            return _prefixDirections.remove(name, (Object)direction);
        }
        if (direction == null) {
            direction = (Direction)((Object)_exactDirections.remove(name));
            return direction != null;
        }
        return _exactDirections.remove(name, (Object)direction);
    }

    protected static void processDistributed(Class<?> clazz, boolean register) {
        LinkedList queue = new LinkedList();
        queue.offer(clazz);
        Class currentClass = null;
        while ((currentClass = (Class)queue.poll()) != null) {
            Class<?>[] interfaceClasses;
            Field[] fields;
            for (Field field : fields = currentClass.getDeclaredFields()) {
                int modifiers;
                Distributed distributed = field.getAnnotation(Distributed.class);
                if (distributed == null || !Modifier.isPublic(modifiers = field.getModifiers()) || !Modifier.isStatic(modifiers) || !Modifier.isFinal(modifiers) || field.getType() != String.class) continue;
                try {
                    String name = (String)field.get(null);
                    if (register) {
                        DistributedRegistry.registerDistributed(name, distributed.direction(), distributed.matchType());
                        continue;
                    }
                    DistributedRegistry.unregisterDistributed(name, distributed.direction(), distributed.matchType());
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }
            Class supperClass = currentClass.getSuperclass();
            if (supperClass != null && supperClass != Object.class) {
                queue.offer(supperClass);
            }
            for (Class<?> interfaceClass : interfaceClasses = currentClass.getInterfaces()) {
                if (queue.contains(interfaceClass)) continue;
                queue.offer(interfaceClass);
            }
        }
    }
}

