/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BaseSearchResultPermissionFilter;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.ArrayList;

public class DefaultSearchResultPermissionFilter
extends BaseSearchResultPermissionFilter {
    private static final Log _log = LogFactoryUtil.getLog(DefaultSearchResultPermissionFilter.class);
    private final BaseIndexer<?> _baseIndexer;
    private final PermissionChecker _permissionChecker;

    public DefaultSearchResultPermissionFilter(BaseIndexer<?> baseIndexer, PermissionChecker permissionChecker) {
        this._baseIndexer = baseIndexer;
        this._permissionChecker = permissionChecker;
    }

    @Override
    protected void filterHits(Hits hits, SearchContext searchContext) {
        ArrayList<Document> docs = new ArrayList<Document>();
        int excludeDocsSize = 0;
        ArrayList<Float> scores = new ArrayList<Float>();
        boolean companyAdmin = this._permissionChecker.isCompanyAdmin(this._permissionChecker.getCompanyId());
        int status = GetterUtil.getInteger(searchContext.getAttribute("status"), 0);
        Document[] documents = hits.getDocs();
        for (int i = 0; i < documents.length; ++i) {
            if (this._isIncludeDocument(documents[i], this._permissionChecker.getCompanyId(), companyAdmin, status)) {
                docs.add(documents[i]);
                scores.add(Float.valueOf(hits.score(i)));
                continue;
            }
            ++excludeDocsSize;
        }
        hits.setDocs(docs.toArray(new Document[docs.size()]));
        hits.setScores(ArrayUtil.toFloatArray(scores));
        hits.setSearchTime((float)(System.currentTimeMillis() - hits.getStart()) / 1000.0f);
        hits.setLength(hits.getLength() - excludeDocsSize);
    }

    @Override
    protected Hits getHits(SearchContext searchContext) throws SearchException {
        return this._baseIndexer.doSearch(searchContext);
    }

    @Override
    protected boolean isGroupAdmin(SearchContext searchContext) {
        long groupId = GetterUtil.getLong(searchContext.getAttribute("groupId"));
        if (groupId == 0L) {
            return false;
        }
        return this._permissionChecker.isGroupAdmin(groupId);
    }

    private boolean _isIncludeDocument(Document document, long companyId, boolean companyAdmin, int status) {
        block7: {
            long entryCompanyId = GetterUtil.getLong(document.get("companyId"));
            if (entryCompanyId != companyId) {
                return false;
            }
            if (companyAdmin) {
                return true;
            }
            String entryClassName = document.get("entryClassName");
            Indexer indexer = IndexerRegistryUtil.getIndexer(entryClassName);
            if (indexer == null) {
                return true;
            }
            if (!indexer.isFilterSearch()) {
                return true;
            }
            long entryClassPK = GetterUtil.getLong(document.get("entryClassPK"));
            try {
                if (indexer.hasPermission(this._permissionChecker, entryClassName, entryClassPK, "VIEW") && indexer.isVisibleRelatedEntry(entryClassPK, status)) {
                    return true;
                }
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) break block7;
                _log.debug(e, e);
            }
        }
        return false;
    }
}

