/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search.facet;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.search.BooleanClause;
import com.liferay.portal.kernel.search.BooleanClauseFactoryUtil;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.facet.BaseFacet;
import com.liferay.portal.kernel.search.facet.config.FacetConfiguration;
import com.liferay.portal.kernel.search.facet.util.FacetValueValidator;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;

public class MultiValueFacet
extends BaseFacet {
    public MultiValueFacet(SearchContext searchContext) {
        super(searchContext);
    }

    public void setValues(boolean[] values) {
        if (ArrayUtil.isEmpty(values)) {
            return;
        }
        JSONArray valuesJSONArray = JSONFactoryUtil.createJSONArray();
        for (boolean value : values) {
            valuesJSONArray.put(value);
        }
        this.doSetValues(valuesJSONArray);
    }

    public void setValues(double[] values) {
        if (ArrayUtil.isEmpty(values)) {
            return;
        }
        JSONArray valuesJSONArray = JSONFactoryUtil.createJSONArray();
        for (double value : values) {
            valuesJSONArray.put(value);
        }
        this.doSetValues(valuesJSONArray);
    }

    public void setValues(int[] values) {
        if (ArrayUtil.isEmpty(values)) {
            return;
        }
        JSONArray valuesJSONArray = JSONFactoryUtil.createJSONArray();
        for (int value : values) {
            valuesJSONArray.put(value);
        }
        this.doSetValues(valuesJSONArray);
    }

    public void setValues(JSONArray values) {
        this.doSetValues(values);
    }

    public void setValues(JSONObject[] values) {
        if (ArrayUtil.isEmpty(values)) {
            return;
        }
        JSONArray valuesJSONArray = JSONFactoryUtil.createJSONArray();
        for (JSONObject value : values) {
            valuesJSONArray.put(value);
        }
        this.doSetValues(valuesJSONArray);
    }

    public void setValues(long[] values) {
        if (ArrayUtil.isEmpty(values)) {
            return;
        }
        JSONArray valuesJSONArray = JSONFactoryUtil.createJSONArray();
        for (long value : values) {
            valuesJSONArray.put(value);
        }
        this.doSetValues(valuesJSONArray);
    }

    public void setValues(String[] values) {
        if (ArrayUtil.isEmpty(values)) {
            return;
        }
        JSONArray valuesJSONArray = JSONFactoryUtil.createJSONArray();
        for (String value : values) {
            valuesJSONArray.put(value);
        }
        this.doSetValues(valuesJSONArray);
    }

    @Override
    protected BooleanClause<Filter> doGetFacetFilterBooleanClause() {
        SearchContext searchContext = this.getSearchContext();
        FacetConfiguration facetConfiguration = this.getFacetConfiguration();
        JSONObject dataJSONObject = facetConfiguration.getData();
        Object[] values = null;
        if (this.isStatic() && dataJSONObject.has("values")) {
            JSONArray valuesJSONArray = dataJSONObject.getJSONArray("values");
            values = new String[valuesJSONArray.length()];
            for (int i = 0; i < valuesJSONArray.length(); ++i) {
                values[i] = valuesJSONArray.getString(i);
            }
        }
        String[] valuesParam = StringUtil.split(GetterUtil.getString(searchContext.getAttribute(this.getFieldId())));
        if (!this.isStatic() && valuesParam != null && valuesParam.length > 0) {
            values = valuesParam;
        }
        if (ArrayUtil.isEmpty(values)) {
            return null;
        }
        TermsFilter facetTermsFilter = new TermsFilter(this.getFieldName());
        for (Object value : values) {
            FacetValueValidator facetValueValidator = this.getFacetValueValidator();
            if (searchContext.getUserId() > 0L && !facetValueValidator.check(searchContext, (String)value)) continue;
            facetTermsFilter.addValue((String)value);
        }
        if (facetTermsFilter.isEmpty()) {
            return null;
        }
        return BooleanClauseFactoryUtil.createFilter(searchContext, facetTermsFilter, BooleanClauseOccur.MUST);
    }

    protected void doSetValues(JSONArray valuesJSONArray) {
        FacetConfiguration facetConfiguration = this.getFacetConfiguration();
        JSONObject dataJSONObject = facetConfiguration.getData();
        dataJSONObject.put("values", valuesJSONArray);
    }
}

