/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.servlet.PortalWebResources;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;

public class PortalWebResourcesUtil {
    private static final Map<String, PortalWebResources> _portalWebResourcesMap = new ConcurrentHashMap<String, PortalWebResources>();
    private static final ServiceTracker<PortalWebResources, PortalWebResources> _serviceTracker;

    public static String getContextPath(String resourceType) {
        String pathProxy = PortalUtil.getPathProxy();
        return pathProxy.concat(PortalWebResourcesUtil.getModuleContextPath(resourceType));
    }

    public static long getLastModified(String resourceType) {
        PortalWebResources portalWebResources = _portalWebResourcesMap.get(resourceType);
        return portalWebResources.getLastModified();
    }

    public static String getModuleContextPath(String resourceType) {
        PortalWebResources portalWebResources = _portalWebResourcesMap.get(resourceType);
        if (portalWebResources == null) {
            return "";
        }
        return portalWebResources.getContextPath();
    }

    public static String getPathResourceType(String path) {
        for (PortalWebResources portalWebResources : _portalWebResourcesMap.values()) {
            if (!path.contains(portalWebResources.getContextPath())) continue;
            return portalWebResources.getResourceType();
        }
        return null;
    }

    public static ServletContext getPathServletContext(String path) {
        for (PortalWebResources portalWebResources : _portalWebResourcesMap.values()) {
            ServletContext servletContext = portalWebResources.getServletContext();
            URL url = PortalWebResourcesUtil.getResource(servletContext, path);
            if (url == null) continue;
            return servletContext;
        }
        return null;
    }

    public static PortalWebResources getPortalWebResources(String resourceType) {
        return _portalWebResourcesMap.get(resourceType);
    }

    public static URL getResource(ServletContext servletContext, String path) {
        path = PortalWebResourcesUtil.stripContextPath(servletContext, path);
        try {
            URL url = servletContext.getResource(path);
            if (url != null) {
                return url;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }

    public static URL getResource(String path) {
        ServletContext servletContext = PortalWebResourcesUtil.getPathServletContext(path);
        if (servletContext != null) {
            return PortalWebResourcesUtil.getResource(servletContext, path);
        }
        return null;
    }

    public static ServletContext getServletContext(String resourceType) {
        PortalWebResources portalWebResources = _portalWebResourcesMap.get(resourceType);
        return portalWebResources.getServletContext();
    }

    public static boolean hasContextPath(String requestURI) {
        for (PortalWebResources portalWebResources : _portalWebResourcesMap.values()) {
            if (!requestURI.startsWith(portalWebResources.getContextPath())) continue;
            return true;
        }
        return false;
    }

    public static boolean isAvailable(String path) {
        URL url = PortalWebResourcesUtil.getResource(path);
        return url != null;
    }

    public static String stripContextPath(ServletContext servletContext, String path) {
        String contextPath = servletContext.getContextPath();
        if (path.startsWith(contextPath)) {
            path = path.substring(contextPath.length());
        }
        return path;
    }

    static {
        Registry registry = RegistryUtil.getRegistry();
        _serviceTracker = registry.trackServices(PortalWebResources.class, (ServiceTrackerCustomizer)new PortalWebResourcesServiceTrackerCustomizer());
        _serviceTracker.open();
    }

    private static class PortalWebResourcesServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<PortalWebResources, PortalWebResources> {
        private PortalWebResourcesServiceTrackerCustomizer() {
        }

        public PortalWebResources addingService(ServiceReference<PortalWebResources> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            PortalWebResources portalWebResources = (PortalWebResources)registry.getService(serviceReference);
            _portalWebResourcesMap.put(portalWebResources.getResourceType(), portalWebResources);
            return portalWebResources;
        }

        public void modifiedService(ServiceReference<PortalWebResources> serviceReference, PortalWebResources portalWebResources) {
        }

        public void removedService(ServiceReference<PortalWebResources> serviceReference, PortalWebResources portalWebResources) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
            _portalWebResourcesMap.remove(portalWebResources.getResourceType(), portalWebResources);
        }
    }
}

