/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet.filters.compoundsessionid;

import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.Validator;

public class CompoundSessionIdSplitterUtil {
    private static final String _SESSION_ID_DELIMITER;

    public static String getSessionIdDelimiter() {
        return _SESSION_ID_DELIMITER;
    }

    public static boolean hasSessionDelimiter() {
        return _SESSION_ID_DELIMITER != null;
    }

    public static String parseSessionId(String sessionId) {
        if (_SESSION_ID_DELIMITER == null) {
            return sessionId;
        }
        int pos = sessionId.indexOf(_SESSION_ID_DELIMITER);
        if (pos == -1) {
            return sessionId;
        }
        return sessionId.substring(0, pos);
    }

    static {
        String sessionIdDelimiter = PropsUtil.get("session.id.delimiter");
        if (Validator.isNull(sessionIdDelimiter)) {
            sessionIdDelimiter = PropsUtil.get("session.id." + ServerDetector.getServerId() + ".delimiter");
        }
        _SESSION_ID_DELIMITER = Validator.isNotNull(sessionIdDelimiter) ? sessionIdDelimiter : null;
    }
}

