/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet.filters.invoker;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.filters.invoker.Dispatcher;
import com.liferay.portal.kernel.util.Validator;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.http.HttpServletRequest;

public class FilterMapping {
    private static final String _SLASH_STAR = "/*";
    private static final String _STAR_PERIOD = "*.";
    private static final Log _log = LogFactoryUtil.getLog(FilterMapping.class);
    private final Set<Dispatcher> _dispatchers;
    private final Filter _filter;
    private final String _filterName;
    private final List<String> _urlPatterns;
    private final Pattern _urlRegexIgnorePattern;
    private final Pattern _urlRegexPattern;

    public FilterMapping(String filterName, Filter filter, FilterConfig filterConfig, List<String> urlPatterns, List<String> dispatchers) {
        this._filterName = filterName;
        this._filter = filter;
        this._urlPatterns = urlPatterns;
        String urlRegexPattern = filterConfig.getInitParameter("url-regex-pattern");
        this._urlRegexPattern = Validator.isNull(urlRegexPattern) ? null : Pattern.compile(urlRegexPattern);
        String urlRegexIgnorePattern = filterConfig.getInitParameter("url-regex-ignore-pattern");
        this._urlRegexIgnorePattern = Validator.isNull(urlRegexIgnorePattern) ? null : Pattern.compile(urlRegexIgnorePattern);
        this._dispatchers = EnumSet.noneOf(Dispatcher.class);
        for (String dispatcher : dispatchers) {
            this._dispatchers.add(Dispatcher.valueOf(dispatcher));
        }
        if (this._dispatchers.isEmpty()) {
            this._dispatchers.add(Dispatcher.REQUEST);
        }
    }

    public Filter getFilter() {
        return this._filter;
    }

    public String getFilterName() {
        return this._filterName;
    }

    public boolean isMatch(HttpServletRequest request, Dispatcher dispatcher, String uri) {
        if (!this._dispatchers.contains((Object)dispatcher) || uri == null) {
            return false;
        }
        boolean matchURLPattern = false;
        for (String urlPattern : this._urlPatterns) {
            if (!this.isMatchURLPattern(uri, urlPattern)) continue;
            matchURLPattern = true;
            break;
        }
        if (_log.isDebugEnabled()) {
            if (matchURLPattern) {
                _log.debug(this._filter.getClass() + " has a pattern match with " + uri);
            } else {
                _log.debug(this._filter.getClass() + " does not have a pattern match with " + uri);
            }
        }
        return matchURLPattern && this.isMatchURLRegexPattern(request, uri);
    }

    public boolean isMatchURLRegexPattern(HttpServletRequest request, String uri) {
        Matcher matcher;
        String url = uri;
        String queryString = request.getQueryString();
        if (Validator.isNotNull(queryString)) {
            url = url.concat("?").concat(queryString);
        }
        boolean matchURLRegexPattern = true;
        if (this._urlRegexPattern != null) {
            matcher = this._urlRegexPattern.matcher(url);
            matchURLRegexPattern = matcher.find();
        }
        if (matchURLRegexPattern && this._urlRegexIgnorePattern != null) {
            matcher = this._urlRegexIgnorePattern.matcher(url);
            boolean bl = matchURLRegexPattern = !matcher.find();
        }
        if (_log.isDebugEnabled()) {
            if (matchURLRegexPattern) {
                _log.debug(this._filter.getClass() + " has a regex match with " + url);
            } else {
                _log.debug(this._filter.getClass() + " does not have a regex match with " + url);
            }
        }
        return matchURLRegexPattern;
    }

    public FilterMapping replaceFilter(Filter filter) {
        return new FilterMapping(this._filterName, filter, this._urlPatterns, this._dispatchers, this._urlRegexIgnorePattern, this._urlRegexPattern);
    }

    protected boolean isMatchURLPattern(String uri, String urlPattern) {
        if (urlPattern.equals(uri) || urlPattern.equals(_SLASH_STAR)) {
            return true;
        }
        return urlPattern.endsWith(_SLASH_STAR) ? uri.equals(urlPattern.substring(0, urlPattern.length() - 2)) || uri.startsWith(urlPattern.substring(0, urlPattern.length() - 1)) : urlPattern.startsWith(_STAR_PERIOD) && uri.indexOf(47) != -1 && uri.endsWith(urlPattern.substring(1));
    }

    private FilterMapping(String filterName, Filter filter, List<String> urlPatterns, Set<Dispatcher> dispatchers, Pattern urlRegexIgnorePattern, Pattern urlRegexPattern) {
        this._filterName = filterName;
        this._filter = filter;
        this._urlPatterns = urlPatterns;
        this._dispatchers = dispatchers;
        this._urlRegexIgnorePattern = urlRegexIgnorePattern;
        this._urlRegexPattern = urlRegexPattern;
    }
}

