/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet.taglib.ui;

import com.liferay.portal.kernel.exception.ImageResolutionException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.image.ImageBag;
import com.liferay.portal.kernel.image.ImageToolUtil;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import java.awt.image.RenderedImage;
import java.io.IOException;

public class ImageSelectorProcessor {
    private final byte[] _bytes;

    public ImageSelectorProcessor(byte[] bytes) {
        this._bytes = bytes;
    }

    public byte[] cropImage(String cropRegion) throws IOException, PortalException {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject(cropRegion);
        int height = jsonObject.getInt("height");
        int width = jsonObject.getInt("width");
        int x = jsonObject.getInt("x");
        int y = jsonObject.getInt("y");
        if (x > 0 || y > 0 || width > 0 || height > 0) {
            ImageBag imageBag = ImageToolUtil.read(this._bytes);
            RenderedImage renderedImage = imageBag.getRenderedImage();
            renderedImage = ImageToolUtil.crop(renderedImage, height, width, x, y);
            return ImageToolUtil.getBytes(renderedImage, imageBag.getType());
        }
        return this._bytes;
    }

    public byte[] scaleImage(int width) throws ImageResolutionException, IOException {
        ImageBag imageBag = ImageToolUtil.read(this._bytes);
        RenderedImage renderedImage = imageBag.getRenderedImage();
        renderedImage = ImageToolUtil.scale(renderedImage, width);
        return ImageToolUtil.getBytes(renderedImage, imageBag.getType());
    }
}

