/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.settings;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.settings.BaseModifiableSettings;
import com.liferay.portal.kernel.settings.ModifiableSettings;
import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import javax.portlet.PortletPreferences;
import javax.portlet.ReadOnlyException;
import javax.portlet.ValidatorException;

public class PortletPreferencesSettings
extends BaseModifiableSettings {
    private static final String _NULL_VALUE = "NULL_VALUE";
    private static final Log _log = LogFactoryUtil.getLog(PortletPreferencesSettings.class);
    private final PortletPreferences _portletPreferences;

    public PortletPreferencesSettings(PortletPreferences portletPreferences) {
        this(portletPreferences, null);
    }

    public PortletPreferencesSettings(PortletPreferences portletPreferences, Settings parentSettings) {
        super(parentSettings);
        this._portletPreferences = portletPreferences;
    }

    @Override
    public Collection<String> getModifiedKeys() {
        HashSet<String> keys = new HashSet<String>();
        Enumeration names = this._portletPreferences.getNames();
        while (names.hasMoreElements()) {
            keys.add((String)names.nextElement());
        }
        return keys;
    }

    public PortletPreferences getPortletPreferences() {
        return this._portletPreferences;
    }

    @Override
    public void reset(String key) {
        try {
            this._portletPreferences.reset(key);
        }
        catch (ReadOnlyException roe) {
            _log.error("Portlet preferences used to persist settings should never be read only", roe);
        }
    }

    @Override
    public ModifiableSettings setValue(String key, String value) {
        try {
            this._portletPreferences.setValue(key, value);
        }
        catch (ReadOnlyException roe) {
            _log.error("Portlet preferences used to persist settings should never be read only", roe);
        }
        return this;
    }

    @Override
    public ModifiableSettings setValues(String key, String[] values) {
        try {
            this._portletPreferences.setValues(key, values);
        }
        catch (ReadOnlyException roe) {
            _log.error("Portlet preferences used to persist settings should never be read only", roe);
        }
        return this;
    }

    @Override
    public void store() throws IOException, ValidatorException {
        this._portletPreferences.store();
    }

    @Override
    protected String doGetValue(String key) {
        return this._portletPreferences.getValue(key, null);
    }

    @Override
    protected String[] doGetValues(String key) {
        return this._portletPreferences.getValues(key, null);
    }

    @Deprecated
    protected boolean isNull(String value) {
        return value == null || value.equals(_NULL_VALUE);
    }

    @Deprecated
    protected String normalizeValue(String value) {
        if (this.isNull(value)) {
            return null;
        }
        return StringUtil.replace(value, "[$NEW_LINE$]", "\n");
    }

    @Deprecated
    protected String[] normalizeValues(String[] values) {
        if (values == null) {
            return null;
        }
        if (values.length == 1) {
            String actualValue = this.normalizeValue(values[0]);
            if (actualValue == null) {
                return null;
            }
            return new String[]{actualValue};
        }
        String[] actualValues = new String[values.length];
        for (int i = 0; i < actualValues.length; ++i) {
            actualValues[i] = this.normalizeValue(values[i]);
        }
        return actualValues;
    }
}

