/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutSetPrototype;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetPrototypeLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public class DefaultLayoutSetPrototypesUtil {
    public static LayoutSet addLayoutSetPrototype(long companyId, long defaultUserId, String nameKey, String descriptionKey, List<LayoutSetPrototype> layoutSetPrototypes, ClassLoader classLoader) throws Exception {
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle("content.Language", LocaleUtil.getDefault(), classLoader);
        String name = LanguageUtil.get(resourceBundle, nameKey);
        String description = LanguageUtil.get(resourceBundle, descriptionKey);
        for (LayoutSetPrototype layoutSetPrototype : layoutSetPrototypes) {
            String curName = layoutSetPrototype.getName(LocaleUtil.getDefault());
            String curDescription = layoutSetPrototype.getDescription(LocaleUtil.getDefault());
            if (!name.equals(curName) || !description.equals(curDescription)) continue;
            return null;
        }
        HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
        HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
        for (Locale locale : LanguageUtil.getAvailableLocales()) {
            resourceBundle = ResourceBundleUtil.getBundle("content.Language", locale, classLoader);
            nameMap.put(locale, LanguageUtil.get(resourceBundle, nameKey));
            descriptionMap.put(locale, LanguageUtil.get(resourceBundle, descriptionKey));
        }
        LayoutSetPrototype layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.addLayoutSetPrototype(defaultUserId, companyId, nameMap, descriptionMap, true, true, new ServiceContext());
        LayoutSet layoutSet = layoutSetPrototype.getLayoutSet();
        ServiceContext serviceContext = new ServiceContext();
        LayoutLocalServiceUtil.deleteLayouts(layoutSet.getGroupId(), layoutSet.isPrivateLayout(), serviceContext);
        return layoutSetPrototype.getLayoutSet();
    }
}

