/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class NamedThreadFactory
implements ThreadFactory {
    private final ClassLoader _contextClassLoader;
    private final AtomicInteger _counter = new AtomicInteger();
    private final ThreadGroup _group;
    private final String _name;
    private final int _priority;

    public NamedThreadFactory(String name, int priority, ClassLoader contextClassLoader) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            this._group = securityManager.getThreadGroup();
        } else {
            Thread currentThread = Thread.currentThread();
            this._group = currentThread.getThreadGroup();
        }
        this._name = name;
        this._priority = priority;
        this._contextClassLoader = contextClassLoader;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = new Thread(this._group, runnable, this._name.concat("-").concat(String.valueOf(this._counter.incrementAndGet())));
        thread.setDaemon(true);
        thread.setPriority(this._priority);
        if (this._contextClassLoader != null) {
            thread.setContextClassLoader(this._contextClassLoader);
        }
        return thread;
    }
}

