/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.action;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.exportimport.kernel.staging.StagingUtil;
import com.liferay.portal.action.RenderPortletAction;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutRevision;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.AddPortletProvider;
import com.liferay.portal.kernel.portlet.PortletJSONUtil;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.LayoutRevisionLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutServiceUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.servlet.BufferCacheServletResponse;
import com.liferay.portal.kernel.servlet.DynamicServletRequest;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PropertiesParamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.servlet.NamespaceServletRequest;
import com.liferay.portal.struts.JSONAction;
import com.liferay.portal.util.LayoutClone;
import com.liferay.portal.util.LayoutCloneFactory;
import com.liferay.registry.collections.ServiceTrackerCollections;
import com.liferay.registry.collections.ServiceTrackerMap;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

public class UpdateLayoutAction
extends JSONAction {
    private static final ServiceTrackerMap<String, AddPortletProvider> _serviceTrackerMap = ServiceTrackerCollections.openSingleValueMap(AddPortletProvider.class, (String)"model.class.name");

    @Override
    public String getJSON(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long userId = themeDisplay.getUserId();
        Layout layout = themeDisplay.getLayout();
        LayoutTypePortlet layoutTypePortlet = themeDisplay.getLayoutTypePortlet();
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        String cmd = ParamUtil.getString((HttpServletRequest)request, (String)"cmd");
        String portletId = ParamUtil.getString((HttpServletRequest)request, (String)"p_p_id");
        boolean updateLayout = true;
        if (cmd.equals("add")) {
            String columnId = ParamUtil.getString((HttpServletRequest)request, (String)"p_p_col_id", null);
            int columnPos = ParamUtil.getInteger((HttpServletRequest)request, (String)"p_p_col_pos", (int)-1);
            portletId = layoutTypePortlet.addPortletId(userId, portletId, columnId, columnPos);
            this.storeAddContentPortletPreferences(request, layout, portletId, themeDisplay);
            if (layoutTypePortlet.isCustomizable() && layoutTypePortlet.isCustomizedView() && !layoutTypePortlet.isColumnDisabled(columnId)) {
                updateLayout = false;
            }
        } else if (cmd.equals("delete")) {
            if (layoutTypePortlet.hasPortletId(portletId)) {
                layoutTypePortlet.removePortletId(userId, portletId);
                if (layoutTypePortlet.isCustomizable() && layoutTypePortlet.isCustomizedView()) {
                    updateLayout = false;
                }
            }
        } else if (cmd.equals("drag")) {
            if (LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (String)"UPDATE")) {
                String height = ParamUtil.getString((HttpServletRequest)request, (String)"height");
                String width = ParamUtil.getString((HttpServletRequest)request, (String)"width");
                String top = ParamUtil.getString((HttpServletRequest)request, (String)"top");
                String left = ParamUtil.getString((HttpServletRequest)request, (String)"left");
                PortletPreferences portletPreferences = PortletPreferencesFactoryUtil.getLayoutPortletSetup((Layout)layout, (String)portletId);
                StringBundler sb = new StringBundler(12);
                sb.append("height=");
                sb.append(height);
                sb.append("\n");
                sb.append("width=");
                sb.append(width);
                sb.append("\n");
                sb.append("top=");
                sb.append(top);
                sb.append("\n");
                sb.append("left=");
                sb.append(left);
                sb.append("\n");
                portletPreferences.setValue("portlet-freeform-styles", sb.toString());
                portletPreferences.store();
            }
        } else if (cmd.equals("minimize")) {
            boolean restore = ParamUtil.getBoolean((HttpServletRequest)request, (String)"p_p_restore");
            if (restore) {
                layoutTypePortlet.removeStateMinPortletId(portletId);
            } else {
                layoutTypePortlet.addStateMinPortletId(portletId);
            }
            updateLayout = false;
        } else if (cmd.equals("move")) {
            String columnId = ParamUtil.getString((HttpServletRequest)request, (String)"p_p_col_id");
            int columnPos = ParamUtil.getInteger((HttpServletRequest)request, (String)"p_p_col_pos");
            layoutTypePortlet.movePortletId(userId, portletId, columnId, columnPos);
            if (layoutTypePortlet.isCustomizable() && layoutTypePortlet.isCustomizedView() && !layoutTypePortlet.isColumnDisabled(columnId)) {
                updateLayout = false;
            }
        } else if (cmd.equals("redo_layout_revision")) {
            long layoutRevisionId = ParamUtil.getLong((HttpServletRequest)request, (String)"layoutRevisionId");
            long layoutSetBranchId = ParamUtil.getLong((HttpServletRequest)request, (String)"layoutSetBranchId");
            ServiceContext serviceContext = ServiceContextFactory.getInstance((HttpServletRequest)request);
            LayoutRevisionLocalServiceUtil.updateStatus((long)userId, (long)layoutRevisionId, (int)2, (ServiceContext)serviceContext);
            StagingUtil.setRecentLayoutRevisionId((HttpServletRequest)request, (long)layoutSetBranchId, (long)layout.getPlid(), (long)layoutRevisionId);
            updateLayout = false;
        } else if (cmd.equals("select_layout_revision")) {
            long layoutRevisionId = ParamUtil.getLong((HttpServletRequest)request, (String)"layoutRevisionId");
            long layoutSetBranchId = ParamUtil.getLong((HttpServletRequest)request, (String)"layoutSetBranchId");
            StagingUtil.setRecentLayoutRevisionId((HttpServletRequest)request, (long)layoutSetBranchId, (long)layout.getPlid(), (long)layoutRevisionId);
            updateLayout = false;
        } else if (cmd.equals("update_type_settings")) {
            UnicodeProperties layoutTypeSettingsProperties = layout.getTypeSettingsProperties();
            UnicodeProperties formTypeSettingsProperties = PropertiesParamUtil.getProperties((HttpServletRequest)request, (String)"TypeSettingsProperties--");
            layoutTypeSettingsProperties.putAll((Map)formTypeSettingsProperties);
        } else if (cmd.equals("undo_layout_revision")) {
            long layoutRevisionId = ParamUtil.getLong((HttpServletRequest)request, (String)"layoutRevisionId");
            long layoutSetBranchId = ParamUtil.getLong((HttpServletRequest)request, (String)"layoutSetBranchId");
            ServiceContext serviceContext = ServiceContextFactory.getInstance((HttpServletRequest)request);
            LayoutRevision layoutRevision = LayoutRevisionLocalServiceUtil.updateStatus((long)userId, (long)layoutRevisionId, (int)5, (ServiceContext)serviceContext);
            StagingUtil.setRecentLayoutRevisionId((HttpServletRequest)request, (long)layoutSetBranchId, (long)layout.getPlid(), (long)layoutRevision.getParentLayoutRevisionId());
            updateLayout = false;
        }
        if (updateLayout) {
            layoutTypePortlet.resetModes();
            layoutTypePortlet.resetStates();
            layout = LayoutServiceUtil.updateLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)layout.getTypeSettings());
        } else {
            LayoutClone layoutClone = LayoutCloneFactory.getInstance();
            if (layoutClone != null) {
                layoutClone.update(request, layout.getPlid(), layout.getTypeSettings());
            }
        }
        if (cmd.equals("add") && portletId != null) {
            this.addPortlet(actionMapping, actionForm, request, response, portletId);
        }
        return "";
    }

    protected void addPortlet(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response, String portletId) throws Exception {
        Action renderPortletAction = (Action)InstancePool.get((String)RenderPortletAction.class.getName());
        long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)companyId, (String)portletId);
        DynamicServletRequest dynamicRequest = null;
        if (portlet.isPrivateRequestAttributes()) {
            String portletNamespace = PortalUtil.getPortletNamespace((String)portlet.getPortletId());
            dynamicRequest = new NamespaceServletRequest(request, portletNamespace, portletNamespace);
        } else {
            dynamicRequest = new DynamicServletRequest(request);
        }
        dynamicRequest.setParameter("p_p_id", portletId);
        String dataType = StringUtil.toLowerCase((String)ParamUtil.getString((HttpServletRequest)request, (String)"dataType"));
        if (dataType.equals("json")) {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
            BufferCacheServletResponse bufferCacheServletResponse = new BufferCacheServletResponse(response);
            renderPortletAction.execute(actionMapping, actionForm, (HttpServletRequest)dynamicRequest, (HttpServletResponse)bufferCacheServletResponse);
            String portletHTML = bufferCacheServletResponse.getString();
            portletHTML = portletHTML.trim();
            PortletJSONUtil.populatePortletJSONObject((HttpServletRequest)request, (String)portletHTML, (Portlet)portlet, (JSONObject)jsonObject);
            response.setContentType("application/json");
            ServletResponseUtil.write((HttpServletResponse)response, (String)jsonObject.toString());
        } else {
            renderPortletAction.execute(actionMapping, actionForm, (HttpServletRequest)dynamicRequest, response);
        }
    }

    protected void storeAddContentPortletPreferences(HttpServletRequest request, Layout layout, String portletId, ThemeDisplay themeDisplay) throws Exception {
        PortletPreferences portletSetup = PortletPreferencesFactoryUtil.getLayoutPortletSetup((Layout)layout, (String)portletId);
        String[] portletData = StringUtil.split((String)ParamUtil.getString((HttpServletRequest)request, (String)"portletData"));
        if (portletData.length == 0) {
            return;
        }
        long classPK = GetterUtil.getLong((String)portletData[0]);
        String className = GetterUtil.getString((String)portletData[1]);
        if (classPK <= 0L || Validator.isNull((String)className)) {
            return;
        }
        AddPortletProvider addPortletProvider = (AddPortletProvider)_serviceTrackerMap.getService((Object)className);
        if (addPortletProvider == null) {
            addPortletProvider = (AddPortletProvider)_serviceTrackerMap.getService((Object)AssetEntry.class.getName());
        }
        if (addPortletProvider != null) {
            addPortletProvider.updatePortletPreferences(portletSetup, portletId, className, classPK, themeDisplay);
        }
        portletSetup.store();
    }
}

