/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.javadoc;

import com.liferay.portal.kernel.util.ClassLoaderUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Arrays;

public class JavadocUtil {
    private static final char[] _PRIMITIVE_BYTECODE_NAME = new char[]{'Z', 'B', 'C', 'D', 'F', 'I', 'J', 'S'};
    private static final String[] _PRIMITIVE_TYPE_NAMES = new String[]{"boolean", "byte", "char", "double", "float", "int", "long", "short"};
    private static final Class<?>[] _PRIMITIVE_TYPES = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE};

    public static Class<?> loadClass(ClassLoader classLoader, String className) throws ClassNotFoundException {
        ClassLoader contextClassLoader;
        int primitiveIndex2;
        if (((className = JavadocUtil._getLoadableClassName(className)).indexOf(46) == -1 || className.indexOf(91) == -1) && (primitiveIndex2 = JavadocUtil._getPrimitiveIndex(className)) >= 0) {
            return _PRIMITIVE_TYPES[primitiveIndex2];
        }
        if (classLoader != null) {
            try {
                return classLoader.loadClass(className);
            }
            catch (ClassNotFoundException primitiveIndex2) {
                // empty catch block
            }
        }
        if (classLoader != (contextClassLoader = ClassLoaderUtil.getContextClassLoader())) {
            try {
                return contextClassLoader.loadClass(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return Class.forName(className);
    }

    private static String _getLoadableClassName(String className) {
        int bracketCount = StringUtil.count((String)className, (char)'[');
        if (bracketCount == 0) {
            return className;
        }
        StringBuilder sb = new StringBuilder(bracketCount);
        for (int i = 0; i < bracketCount; ++i) {
            sb.append('[');
        }
        int bracketIndex = className.indexOf(91);
        int primitiveIndex = JavadocUtil._getPrimitiveIndex(className = className.substring(0, bracketIndex));
        if (primitiveIndex >= 0) {
            className = String.valueOf(_PRIMITIVE_BYTECODE_NAME[primitiveIndex]);
            return sb.toString() + className;
        }
        return sb.toString() + 'L' + className + ';';
    }

    private static int _getPrimitiveIndex(String className) {
        if (className.indexOf(46) != -1) {
            return -1;
        }
        return Arrays.binarySearch(_PRIMITIVE_TYPE_NAMES, className);
    }
}

