/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.CountryA2Exception;
import com.liferay.portal.kernel.exception.CountryA3Exception;
import com.liferay.portal.kernel.exception.CountryIddException;
import com.liferay.portal.kernel.exception.CountryNameException;
import com.liferay.portal.kernel.exception.CountryNumberException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.security.access.control.AccessControlled;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.service.base.CountryServiceBaseImpl;
import java.util.List;

public class CountryServiceImpl
extends CountryServiceBaseImpl {
    public Country addCountry(String name, String a2, String a3, String number, String idd, boolean active) throws PortalException {
        if (!this.getPermissionChecker().isOmniadmin()) {
            throw new PrincipalException.MustBeOmniadmin(this.getPermissionChecker());
        }
        if (Validator.isNull((String)name)) {
            throw new CountryNameException();
        }
        if (Validator.isNull((String)a2)) {
            throw new CountryA2Exception();
        }
        if (Validator.isNull((String)a3)) {
            throw new CountryA3Exception();
        }
        if (Validator.isNull((String)number)) {
            throw new CountryNumberException();
        }
        if (Validator.isNull((String)idd)) {
            throw new CountryIddException();
        }
        long countryId = this.counterLocalService.increment();
        Country country = this.countryPersistence.create(countryId);
        country.setName(name);
        country.setA2(a2);
        country.setA3(a3);
        country.setNumber(number);
        country.setIdd(idd);
        country.setActive(active);
        this.countryPersistence.update((BaseModel)country);
        return country;
    }

    public Country fetchCountry(long countryId) {
        return this.countryPersistence.fetchByPrimaryKey(countryId);
    }

    public Country fetchCountryByA2(String a2) {
        return this.countryPersistence.fetchByA2(a2);
    }

    public Country fetchCountryByA3(String a3) {
        return this.countryPersistence.fetchByA3(a3);
    }

    public List<Country> getCountries() {
        return this.countryPersistence.findAll();
    }

    @AccessControlled(guestAccessEnabled=true)
    public List<Country> getCountries(boolean active) {
        return this.countryPersistence.findByActive(active);
    }

    public Country getCountry(long countryId) throws PortalException {
        return this.countryPersistence.findByPrimaryKey(countryId);
    }

    public Country getCountryByA2(String a2) throws PortalException {
        return this.countryPersistence.findByA2(a2);
    }

    public Country getCountryByA3(String a3) throws PortalException {
        return this.countryPersistence.findByA3(a3);
    }

    public Country getCountryByName(String name) throws PortalException {
        return this.countryPersistence.findByName(name);
    }
}

