/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.LayoutFriendlyURLException;
import com.liferay.portal.kernel.exception.LayoutFriendlyURLsException;
import com.liferay.portal.kernel.exception.LayoutNameException;
import com.liferay.portal.kernel.exception.LayoutParentLayoutIdException;
import com.liferay.portal.kernel.exception.LayoutTypeException;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutSetPrototype;
import com.liferay.portal.kernel.model.LayoutType;
import com.liferay.portal.kernel.model.LayoutTypeController;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.portlet.FriendlyURLMapper;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.persistence.LayoutFriendlyURLPersistence;
import com.liferay.portal.kernel.service.persistence.LayoutPersistence;
import com.liferay.portal.kernel.service.persistence.LayoutSetPersistence;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.util.comparator.LayoutPriorityComparator;
import com.liferay.portal.model.impl.LayoutImpl;
import com.liferay.portal.util.LayoutTypeControllerTracker;
import com.liferay.sites.kernel.util.SitesUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class LayoutLocalServiceHelper
implements IdentifiableOSGiService {
    @BeanReference(type=LayoutFriendlyURLPersistence.class)
    protected LayoutFriendlyURLPersistence layoutFriendlyURLPersistence;
    @BeanReference(type=LayoutPersistence.class)
    protected LayoutPersistence layoutPersistence;
    @BeanReference(type=LayoutSetPersistence.class)
    protected LayoutSetPersistence layoutSetPersistence;
    @BeanReference(type=ResourcePermissionLocalService.class)
    protected ResourcePermissionLocalService resourcePermissionLocalService;
    private static final int _PRIORITY_BUFFER = 1000000;

    public String getFriendlyURL(long groupId, boolean privateLayout, long layoutId, String name, String friendlyURL) throws PortalException {
        if (Validator.isNotNull((String)(friendlyURL = this.getFriendlyURL(friendlyURL)))) {
            return friendlyURL;
        }
        String originalFriendlyURL = friendlyURL = "/" + this.getFriendlyURL(name);
        int i = 1;
        while (true) {
            try {
                this.validateFriendlyURL(groupId, privateLayout, layoutId, friendlyURL);
            }
            catch (LayoutFriendlyURLException lfurle) {
                int type = lfurle.getType();
                if (type != 6) {
                    friendlyURL = "/" + layoutId;
                    break;
                }
                friendlyURL = originalFriendlyURL + i;
                ++i;
                continue;
            }
            break;
        }
        return friendlyURL;
    }

    public String getFriendlyURL(String friendlyURL) {
        return FriendlyURLNormalizerUtil.normalize((String)friendlyURL);
    }

    public Map<Locale, String> getFriendlyURLMap(long groupId, boolean privateLayout, long layoutId, String name, Map<Locale, String> friendlyURLMap) throws PortalException {
        HashMap<Locale, String> newFriendlyURLMap = new HashMap<Locale, String>();
        for (Locale locale : LanguageUtil.getAvailableLocales((long)groupId)) {
            String friendlyURL = friendlyURLMap.get(locale);
            if (!Validator.isNotNull((String)friendlyURL)) continue;
            friendlyURL = this.getFriendlyURL(groupId, privateLayout, layoutId, name, friendlyURL);
            newFriendlyURLMap.put(locale, friendlyURL);
        }
        Locale siteDefaultLocale = LocaleUtil.getSiteDefault();
        if (newFriendlyURLMap.isEmpty() || Validator.isNull((String)((String)newFriendlyURLMap.get(siteDefaultLocale)))) {
            String friendlyURL = this.getFriendlyURL(groupId, privateLayout, layoutId, name, "");
            newFriendlyURLMap.put(siteDefaultLocale, friendlyURL);
        }
        return newFriendlyURLMap;
    }

    public int getNextPriority(long groupId, boolean privateLayout, long parentLayoutId, String sourcePrototypeLayoutUuid, int defaultPriority) {
        try {
            LayoutSet layoutSet;
            int priority = defaultPriority;
            if (priority < 0) {
                Layout layout = this.layoutPersistence.findByG_P_P_First(groupId, privateLayout, parentLayoutId, (OrderByComparator)new LayoutPriorityComparator(false));
                priority = layout.getPriority() + 1;
            }
            if (priority < 1000000 && Validator.isNull((String)sourcePrototypeLayoutUuid) && Validator.isNotNull((String)(layoutSet = this.layoutSetPersistence.fetchByG_P(groupId, privateLayout)).getLayoutSetPrototypeUuid()) && layoutSet.isLayoutSetPrototypeLinkEnabled()) {
                priority += 1000000;
            }
            return priority;
        }
        catch (NoSuchLayoutException nsle) {
            return 0;
        }
    }

    public String getOSGiServiceIdentifier() {
        return LayoutLocalServiceHelper.class.getName();
    }

    public long getParentLayoutId(long groupId, boolean privateLayout, long parentLayoutId) {
        Layout parentLayout;
        if (parentLayoutId != 0L && (parentLayout = this.layoutPersistence.fetchByG_P_L(groupId, privateLayout, parentLayoutId)) == null) {
            parentLayoutId = 0L;
        }
        return parentLayoutId;
    }

    public boolean hasLayoutSetPrototypeLayout(LayoutSetPrototype layoutSetPrototype, String layoutUuid) throws PortalException {
        Layout layout = this.layoutPersistence.fetchByUUID_G_P(layoutUuid, layoutSetPrototype.getGroupId(), true);
        return layout != null;
    }

    public void validate(long groupId, boolean privateLayout, long layoutId, long parentLayoutId, String name, String type, boolean hidden, Map<Locale, String> friendlyURLMap, ServiceContext serviceContext) throws PortalException {
        boolean layoutInstanceableAllowed;
        LayoutTypeController layoutTypeController;
        this.validateName(name);
        boolean firstLayout = false;
        if (parentLayoutId == 0L) {
            List layouts = this.layoutPersistence.findByG_P_P(groupId, privateLayout, parentLayoutId, 0, 1);
            if (layouts.isEmpty()) {
                firstLayout = true;
            } else {
                long firstLayoutId = ((Layout)layouts.get(0)).getLayoutId();
                if (firstLayoutId == layoutId) {
                    firstLayout = true;
                }
            }
        } else {
            Layout layout = this.layoutPersistence.fetchByG_P_L(groupId, privateLayout, layoutId);
            Layout parentLayout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, parentLayoutId);
            if ((layout == null || Validator.isNull((String)layout.getSourcePrototypeLayoutUuid())) && !SitesUtil.isLayoutSortable((Layout)parentLayout)) {
                throw new LayoutParentLayoutIdException(5);
            }
        }
        if (firstLayout) {
            this.validateFirstLayout(type);
        }
        if (!(layoutTypeController = LayoutTypeControllerTracker.getLayoutTypeController(type)).isInstanceable() && !(layoutInstanceableAllowed = GetterUtil.getBoolean((Object)serviceContext.getAttribute("layout.instanceable.allowed")))) {
            throw new LayoutTypeException(4);
        }
        if (!layoutTypeController.isParentable() && this.layoutPersistence.countByG_P_P(groupId, privateLayout, layoutId) > 0) {
            throw new LayoutTypeException(1);
        }
        this.validateFriendlyURLs(groupId, privateLayout, layoutId, friendlyURLMap);
    }

    public void validateFirstLayout(Layout layout) throws PortalException {
        Group group = layout.getGroup();
        if (group.isGuest() && layout.isPublicLayout() && !this.hasGuestViewPermission(layout)) {
            LayoutTypeException lte = new LayoutTypeException(3);
            throw lte;
        }
        this.validateFirstLayout(layout.getType());
    }

    public void validateFirstLayout(String type) throws PortalException {
        LayoutTypeController layoutTypeController = LayoutTypeControllerTracker.getLayoutTypeController(type);
        if (Validator.isNull((String)type) || !layoutTypeController.isFirstPageable()) {
            LayoutTypeException lte = new LayoutTypeException(2);
            lte.setLayoutType(type);
            throw lte;
        }
    }

    public void validateFriendlyURL(long groupId, boolean privateLayout, long layoutId, String friendlyURL) throws PortalException {
        if (Validator.isNull((String)friendlyURL)) {
            return;
        }
        int exceptionType = LayoutImpl.validateFriendlyURL(friendlyURL);
        if (exceptionType != -1) {
            throw new LayoutFriendlyURLException(exceptionType);
        }
        List layoutFriendlyURLs = this.layoutFriendlyURLPersistence.findByG_P_F(groupId, privateLayout, friendlyURL);
        for (Object layoutFriendlyURL : layoutFriendlyURLs) {
            Layout layout = this.layoutPersistence.findByPrimaryKey(layoutFriendlyURL.getPlid());
            if (layout.getLayoutId() == layoutId) continue;
            LayoutFriendlyURLException lfurle = new LayoutFriendlyURLException(6);
            lfurle.setDuplicateClassPK(layout.getPlid());
            lfurle.setDuplicateClassName(Layout.class.getName());
            throw lfurle;
        }
        LayoutImpl.validateFriendlyURLKeyword(friendlyURL);
        if (friendlyURL.contains("/-/")) {
            LayoutFriendlyURLException lfurle = new LayoutFriendlyURLException(7);
            lfurle.setKeywordConflict("/-/");
            throw lfurle;
        }
        List friendlyURLMappers = PortletLocalServiceUtil.getFriendlyURLMappers();
        for (FriendlyURLMapper friendlyURLMapper : friendlyURLMappers) {
            String mapping;
            if (friendlyURLMapper.isCheckMappingWithPrefix() || !friendlyURL.contains((mapping = "/" + friendlyURLMapper.getMapping()) + "/") && !friendlyURL.endsWith(mapping)) continue;
            LayoutFriendlyURLException lfurle = new LayoutFriendlyURLException(7);
            lfurle.setKeywordConflict(friendlyURLMapper.getMapping());
            throw lfurle;
        }
        for (Locale locale : LanguageUtil.getAvailableLocales()) {
            String languageId = StringUtil.toLowerCase((String)LocaleUtil.toLanguageId((Locale)locale));
            String i18nPathLanguageId = "/" + PortalUtil.getI18nPathLanguageId((Locale)locale, (String)languageId);
            if (!friendlyURL.startsWith(i18nPathLanguageId + "/") && !friendlyURL.startsWith("/" + languageId + "/") && !friendlyURL.equals(i18nPathLanguageId) && !friendlyURL.equals("/" + languageId)) continue;
            LayoutFriendlyURLException lfurle = new LayoutFriendlyURLException(7);
            lfurle.setKeywordConflict(i18nPathLanguageId);
            throw lfurle;
        }
        String layoutIdFriendlyURL = friendlyURL.substring(1);
        if (Validator.isNumber((String)layoutIdFriendlyURL) && !layoutIdFriendlyURL.equals(String.valueOf(layoutId))) {
            LayoutFriendlyURLException lfurle = new LayoutFriendlyURLException(8);
            lfurle.setKeywordConflict(layoutIdFriendlyURL);
            throw lfurle;
        }
    }

    public void validateFriendlyURLs(long groupId, boolean privateLayout, long layoutId, Map<Locale, String> friendlyURLMap) throws PortalException {
        LayoutFriendlyURLsException layoutFriendlyURLsException = null;
        for (Map.Entry<Locale, String> entry : friendlyURLMap.entrySet()) {
            try {
                String friendlyURL = entry.getValue();
                this.validateFriendlyURL(groupId, privateLayout, layoutId, friendlyURL);
            }
            catch (LayoutFriendlyURLException lfurle) {
                Locale locale = entry.getKey();
                if (layoutFriendlyURLsException == null) {
                    layoutFriendlyURLsException = new LayoutFriendlyURLsException((Throwable)lfurle);
                } else {
                    layoutFriendlyURLsException.addSuppressed((Throwable)lfurle);
                }
                layoutFriendlyURLsException.addLocalizedException(locale, (Exception)((Object)lfurle));
            }
        }
        if (layoutFriendlyURLsException != null) {
            throw layoutFriendlyURLsException;
        }
    }

    public void validateName(String name) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new LayoutNameException();
        }
    }

    public void validateName(String name, String languageId) throws PortalException {
        String defaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault());
        if (defaultLanguageId.equals(languageId)) {
            this.validateName(name);
        }
    }

    public void validateParentLayoutId(long groupId, boolean privateLayout, long layoutId, long parentLayoutId) throws PortalException {
        List layouts;
        long firstLayoutId;
        Layout layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
        if (parentLayoutId == layout.getParentLayoutId()) {
            return;
        }
        if (parentLayoutId == 0L) {
            return;
        }
        Layout parentLayout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, parentLayoutId);
        LayoutType parentLayoutType = parentLayout.getLayoutType();
        if (!parentLayoutType.isParentable()) {
            throw new LayoutParentLayoutIdException(1);
        }
        if (Validator.isNull((String)layout.getSourcePrototypeLayoutUuid()) && !SitesUtil.isLayoutSortable((Layout)parentLayout)) {
            throw new LayoutParentLayoutIdException(5);
        }
        if (PortalUtil.isLayoutDescendant((Layout)layout, (long)parentLayoutId)) {
            throw new LayoutParentLayoutIdException(2);
        }
        if (layout.getParentLayoutId() == 0L && (firstLayoutId = ((Layout)(layouts = this.layoutPersistence.findByG_P_P(groupId, privateLayout, 0L, 0, 2)).get(0)).getLayoutId()) == layoutId) {
            Layout secondLayout = (Layout)layouts.get(1);
            LayoutType layoutType = secondLayout.getLayoutType();
            if (Validator.isNull((String)secondLayout.getType()) || !layoutType.isFirstPageable()) {
                throw new LayoutParentLayoutIdException(3);
            }
        }
    }

    protected boolean hasGuestViewPermission(Layout layout) throws PortalException {
        Role role = RoleLocalServiceUtil.getRole((long)layout.getCompanyId(), (String)"Guest");
        return this.resourcePermissionLocalService.hasResourcePermission(layout.getCompanyId(), Layout.class.getName(), 4, String.valueOf(layout.getPlid()), role.getRoleId(), "VIEW");
    }
}

