/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.exportimport.kernel.staging.LayoutStagingUtil;
import com.liferay.exportimport.kernel.staging.MergeLayoutPrototypesThreadLocal;
import com.liferay.exportimport.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutRevision;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutStagingHandler;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.LayoutFriendlyURLLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutRevisionLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.SystemEventLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.service.persistence.LayoutRevisionUtil;
import com.liferay.portal.kernel.service.persistence.LayoutUtil;
import com.liferay.portal.kernel.systemevent.SystemEventHierarchyEntry;
import com.liferay.portal.kernel.systemevent.SystemEventHierarchyEntryThreadLocal;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ClassLoaderUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.service.impl.LayoutLocalServiceHelper;
import com.liferay.portlet.exportimport.staging.ProxiedLayoutsThreadLocal;
import com.liferay.portlet.exportimport.staging.StagingAdvicesThreadLocal;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.core.annotation.Order;

@Order(value=1)
public class LayoutLocalServiceStagingAdvice
implements MethodInterceptor {
    @BeanReference(type=LayoutLocalServiceHelper.class)
    protected LayoutLocalServiceHelper layoutLocalServiceHelper;
    private static final Class<?>[] _GET_LAYOUTS_TYPES = new Class[]{Long.TYPE, Boolean.TYPE, Long.TYPE};
    private static final Class<?>[] _UPDATE_LAYOUT_PARAMETER_TYPES = new Class[]{Long.TYPE, Boolean.TYPE, Long.TYPE, Long.TYPE, Map.class, Map.class, Map.class, Map.class, Map.class, String.class, Boolean.TYPE, String.class, Boolean.class, byte[].class, ServiceContext.class};
    private static final Log _log = LogFactoryUtil.getLog(LayoutLocalServiceStagingAdvice.class);
    private static final Set<String> _layoutLocalServiceStagingAdviceMethodNames = new HashSet<String>();

    public LayoutLocalServiceStagingAdvice() {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Instantiating " + this.hashCode()));
        }
    }

    public void deleteLayout(LayoutLocalService layoutLocalService, Layout layout, boolean updateLayoutSet, ServiceContext serviceContext) throws PortalException {
        long layoutSetBranchId = ParamUtil.getLong((ServiceContext)serviceContext, (String)"layoutSetBranchId");
        if (layoutSetBranchId > 0L) {
            LayoutRevisionLocalServiceUtil.deleteLayoutRevisions((long)layoutSetBranchId, (long)layout.getPlid());
            List notIncompleteLayoutRevisions = LayoutRevisionUtil.findByP_NotS((long)layout.getPlid(), (int)6);
            if (notIncompleteLayoutRevisions.isEmpty()) {
                LayoutRevisionLocalServiceUtil.deleteLayoutLayoutRevisions((long)layout.getPlid());
                this.doDeleteLayout(layoutLocalService, layout, updateLayoutSet, serviceContext);
            }
        } else {
            this.doDeleteLayout(layoutLocalService, layout, updateLayoutSet, serviceContext);
        }
    }

    public void deleteLayout(LayoutLocalService layoutLocalService, long groupId, boolean privateLayout, long layoutId, ServiceContext serviceContext) throws PortalException {
        Layout layout = layoutLocalService.getLayout(groupId, privateLayout, layoutId);
        this.deleteLayout(layoutLocalService, layout, true, serviceContext);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        if (!StagingAdvicesThreadLocal.isEnabled()) {
            return methodInvocation.proceed();
        }
        Method method = methodInvocation.getMethod();
        String methodName = method.getName();
        boolean showIncomplete = false;
        if (!_layoutLocalServiceStagingAdviceMethodNames.contains(methodName)) {
            return this.wrapReturnValue(methodInvocation.proceed(), showIncomplete);
        }
        Object returnValue = null;
        Object[] parameterTypes = method.getParameterTypes();
        Object thisObject = methodInvocation.getThis();
        Object[] arguments = methodInvocation.getArguments();
        if (methodName.equals("createLayout")) {
            return methodInvocation.proceed();
        }
        if (methodName.equals("deleteLayout")) {
            if (arguments.length == 3) {
                this.deleteLayout((LayoutLocalService)thisObject, (Layout)arguments[0], (Boolean)arguments[1], (ServiceContext)arguments[2]);
                return this.wrapReturnValue(returnValue, showIncomplete);
            } else {
                if (arguments.length != 4) return this.wrapReturnValue(methodInvocation.proceed(), showIncomplete);
                this.deleteLayout((LayoutLocalService)thisObject, (Long)arguments[0], (Boolean)arguments[1], (Long)arguments[2], (ServiceContext)arguments[3]);
            }
            return this.wrapReturnValue(returnValue, showIncomplete);
        }
        if (methodName.equals("getLayouts")) {
            if (arguments.length == 6) {
                showIncomplete = (Boolean)arguments[3];
                return this.wrapReturnValue(methodInvocation.proceed(), showIncomplete);
            } else {
                if (!Arrays.equals(parameterTypes, _GET_LAYOUTS_TYPES)) return this.wrapReturnValue(methodInvocation.proceed(), showIncomplete);
                showIncomplete = true;
            }
            return this.wrapReturnValue(methodInvocation.proceed(), showIncomplete);
        }
        if (methodName.equals("updateLayout") && arguments.length == 15) {
            HashMap<Locale, String> friendlyURLMap = null;
            if (Arrays.equals(parameterTypes, _UPDATE_LAYOUT_PARAMETER_TYPES)) {
                friendlyURLMap = new HashMap<Locale, String>();
                friendlyURLMap.put(LocaleUtil.getSiteDefault(), (String)arguments[11]);
            } else {
                friendlyURLMap = (Map)arguments[11];
            }
            returnValue = this.updateLayout((LayoutLocalService)thisObject, (Long)arguments[0], (Boolean)arguments[1], (Long)arguments[2], (Long)arguments[3], (Map)arguments[4], (Map)arguments[5], (Map)arguments[6], (Map)arguments[7], (Map)arguments[8], (String)arguments[9], (Boolean)arguments[10], friendlyURLMap, (Boolean)arguments[12], (byte[])arguments[13], (ServiceContext)arguments[14]);
            return this.wrapReturnValue(returnValue, showIncomplete);
        }
        try {
            Class<?> clazz = this.getClass();
            parameterTypes = (Class[])ArrayUtil.append((Object[])new Class[]{LayoutLocalService.class}, (Object[])parameterTypes);
            Method layoutLocalServiceStagingAdviceMethod = clazz.getMethod(methodName, (Class<?>[])parameterTypes);
            arguments = ArrayUtil.append((Object[])new Object[]{thisObject}, (Object[])arguments);
            returnValue = layoutLocalServiceStagingAdviceMethod.invoke((Object)this, arguments);
            return this.wrapReturnValue(returnValue, showIncomplete);
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
        catch (NoSuchMethodException nsme) {
            returnValue = methodInvocation.proceed();
        }
        return this.wrapReturnValue(returnValue, showIncomplete);
    }

    public Layout updateLayout(LayoutLocalService layoutLocalService, long groupId, boolean privateLayout, long layoutId, long parentLayoutId, Map<Locale, String> nameMap, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, Map<Locale, String> keywordsMap, Map<Locale, String> robotsMap, String type, boolean hidden, Map<Locale, String> friendlyURLMap, boolean iconImage, byte[] iconBytes, ServiceContext serviceContext) throws PortalException {
        parentLayoutId = this.layoutLocalServiceHelper.getParentLayoutId(groupId, privateLayout, parentLayoutId);
        String name = nameMap.get(LocaleUtil.getSiteDefault());
        friendlyURLMap = this.layoutLocalServiceHelper.getFriendlyURLMap(groupId, privateLayout, layoutId, name, friendlyURLMap);
        String friendlyURL = friendlyURLMap.get(LocaleUtil.getSiteDefault());
        this.layoutLocalServiceHelper.validate(groupId, privateLayout, layoutId, parentLayoutId, name, type, hidden, friendlyURLMap, serviceContext);
        this.layoutLocalServiceHelper.validateParentLayoutId(groupId, privateLayout, layoutId, parentLayoutId);
        Layout originalLayout = LayoutUtil.findByG_P_L((long)groupId, (boolean)privateLayout, (long)layoutId);
        Layout layout = this.wrapLayout(originalLayout);
        LayoutRevision layoutRevision = LayoutStagingUtil.getLayoutRevision((Layout)layout);
        if (layoutRevision == null) {
            return layoutLocalService.updateLayout(groupId, privateLayout, layoutId, parentLayoutId, nameMap, titleMap, descriptionMap, keywordsMap, robotsMap, type, hidden, friendlyURLMap, iconImage, iconBytes, serviceContext);
        }
        if (parentLayoutId != originalLayout.getParentLayoutId()) {
            int priority = this.layoutLocalServiceHelper.getNextPriority(groupId, privateLayout, parentLayoutId, originalLayout.getSourcePrototypeLayoutUuid(), -1);
            originalLayout.setPriority(priority);
        }
        originalLayout.setParentLayoutId(parentLayoutId);
        layoutRevision.setNameMap(nameMap);
        layoutRevision.setTitleMap(titleMap);
        layoutRevision.setDescriptionMap(descriptionMap);
        layoutRevision.setKeywordsMap(keywordsMap);
        layoutRevision.setRobotsMap(robotsMap);
        originalLayout.setType(type);
        originalLayout.setHidden(hidden);
        originalLayout.setFriendlyURL(friendlyURL);
        PortalUtil.updateImageId((BaseModel)layoutRevision, (boolean)iconImage, (byte[])iconBytes, (String)"iconImageId", (long)0L, (int)0, (int)0);
        boolean layoutPrototypeLinkEnabled = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"layoutPrototypeLinkEnabled");
        originalLayout.setLayoutPrototypeLinkEnabled(layoutPrototypeLinkEnabled);
        originalLayout.setExpandoBridgeAttributes(serviceContext);
        LayoutUtil.update((Layout)originalLayout);
        LayoutFriendlyURLLocalServiceUtil.updateLayoutFriendlyURLs((long)originalLayout.getUserId(), (long)originalLayout.getCompanyId(), (long)originalLayout.getGroupId(), (long)originalLayout.getPlid(), (boolean)originalLayout.isPrivateLayout(), friendlyURLMap, (ServiceContext)serviceContext);
        boolean hasWorkflowTask = StagingUtil.hasWorkflowTask((long)serviceContext.getUserId(), (LayoutRevision)layoutRevision);
        serviceContext.setAttribute("revisionInProgress", (Serializable)Boolean.valueOf(hasWorkflowTask));
        serviceContext.setWorkflowAction(2);
        LayoutRevisionLocalServiceUtil.updateLayoutRevision((long)serviceContext.getUserId(), (long)layoutRevision.getLayoutRevisionId(), (long)layoutRevision.getLayoutBranchId(), (String)layoutRevision.getName(), (String)layoutRevision.getTitle(), (String)layoutRevision.getDescription(), (String)layoutRevision.getKeywords(), (String)layoutRevision.getRobots(), (String)layoutRevision.getTypeSettings(), (boolean)layoutRevision.getIconImage(), (long)layoutRevision.getIconImageId(), (String)layoutRevision.getThemeId(), (String)layoutRevision.getColorSchemeId(), (String)layoutRevision.getCss(), (ServiceContext)serviceContext);
        return layout;
    }

    public Layout updateLayout(LayoutLocalService layoutLocalService, long groupId, boolean privateLayout, long layoutId, String typeSettings) throws PortalException {
        Layout layout = LayoutUtil.findByG_P_L((long)groupId, (boolean)privateLayout, (long)layoutId);
        LayoutRevision layoutRevision = LayoutStagingUtil.getLayoutRevision((Layout)(layout = this.wrapLayout(layout)));
        if (layoutRevision == null) {
            return layoutLocalService.updateLayout(groupId, privateLayout, layoutId, typeSettings);
        }
        layout.setTypeSettings(typeSettings);
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        boolean hasWorkflowTask = StagingUtil.hasWorkflowTask((long)serviceContext.getUserId(), (LayoutRevision)layoutRevision);
        serviceContext.setAttribute("revisionInProgress", (Serializable)Boolean.valueOf(hasWorkflowTask));
        if (!MergeLayoutPrototypesThreadLocal.isInProgress()) {
            serviceContext.setWorkflowAction(2);
        }
        LayoutRevisionLocalServiceUtil.updateLayoutRevision((long)serviceContext.getUserId(), (long)layoutRevision.getLayoutRevisionId(), (long)layoutRevision.getLayoutBranchId(), (String)layoutRevision.getName(), (String)layoutRevision.getTitle(), (String)layoutRevision.getDescription(), (String)layoutRevision.getKeywords(), (String)layoutRevision.getRobots(), (String)layoutRevision.getTypeSettings(), (boolean)layoutRevision.getIconImage(), (long)layoutRevision.getIconImageId(), (String)layoutRevision.getThemeId(), (String)layoutRevision.getColorSchemeId(), (String)layoutRevision.getCss(), (ServiceContext)serviceContext);
        return layout;
    }

    public Layout updateLookAndFeel(LayoutLocalService layoutLocalService, long groupId, boolean privateLayout, long layoutId, String themeId, String colorSchemeId, String css) throws PortalException {
        Layout layout = LayoutUtil.findByG_P_L((long)groupId, (boolean)privateLayout, (long)layoutId);
        LayoutRevision layoutRevision = LayoutStagingUtil.getLayoutRevision((Layout)(layout = this.wrapLayout(layout)));
        if (layoutRevision == null) {
            return layoutLocalService.updateLookAndFeel(groupId, privateLayout, layoutId, themeId, colorSchemeId, css);
        }
        layout.setThemeId(themeId);
        layout.setColorSchemeId(colorSchemeId);
        layout.setCss(css);
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        boolean hasWorkflowTask = StagingUtil.hasWorkflowTask((long)serviceContext.getUserId(), (LayoutRevision)layoutRevision);
        serviceContext.setAttribute("revisionInProgress", (Serializable)Boolean.valueOf(hasWorkflowTask));
        if (!MergeLayoutPrototypesThreadLocal.isInProgress()) {
            serviceContext.setWorkflowAction(2);
        }
        LayoutRevisionLocalServiceUtil.updateLayoutRevision((long)serviceContext.getUserId(), (long)layoutRevision.getLayoutRevisionId(), (long)layoutRevision.getLayoutBranchId(), (String)layoutRevision.getName(), (String)layoutRevision.getTitle(), (String)layoutRevision.getDescription(), (String)layoutRevision.getKeywords(), (String)layoutRevision.getRobots(), (String)layoutRevision.getTypeSettings(), (boolean)layoutRevision.getIconImage(), (long)layoutRevision.getIconImageId(), (String)layoutRevision.getThemeId(), (String)layoutRevision.getColorSchemeId(), (String)layoutRevision.getCss(), (ServiceContext)serviceContext);
        return layout;
    }

    public Layout updateName(LayoutLocalService layoutLocalService, Layout layout, String name, String languageId) throws PortalException {
        LayoutRevision layoutRevision = LayoutStagingUtil.getLayoutRevision((Layout)(layout = this.wrapLayout(layout)));
        if (layoutRevision == null) {
            return layoutLocalService.updateName(layout, name, languageId);
        }
        this.layoutLocalServiceHelper.validateName(name, languageId);
        layout.setName(name, LocaleUtil.fromLanguageId((String)languageId));
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        boolean hasWorkflowTask = StagingUtil.hasWorkflowTask((long)serviceContext.getUserId(), (LayoutRevision)layoutRevision);
        serviceContext.setAttribute("revisionInProgress", (Serializable)Boolean.valueOf(hasWorkflowTask));
        serviceContext.setWorkflowAction(2);
        LayoutRevisionLocalServiceUtil.updateLayoutRevision((long)serviceContext.getUserId(), (long)layoutRevision.getLayoutRevisionId(), (long)layoutRevision.getLayoutBranchId(), (String)layoutRevision.getName(), (String)layoutRevision.getTitle(), (String)layoutRevision.getDescription(), (String)layoutRevision.getKeywords(), (String)layoutRevision.getRobots(), (String)layoutRevision.getTypeSettings(), (boolean)layoutRevision.getIconImage(), (long)layoutRevision.getIconImageId(), (String)layoutRevision.getThemeId(), (String)layoutRevision.getColorSchemeId(), (String)layoutRevision.getCss(), (ServiceContext)serviceContext);
        return layout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDeleteLayout(LayoutLocalService layoutLocalService, Layout layout, boolean updateLayoutSet, ServiceContext serviceContext) throws PortalException {
        if (SystemEventHierarchyEntryThreadLocal.push(Layout.class, (long)layout.getPlid()) == null) {
            layoutLocalService.deleteLayout(layout, updateLayoutSet, serviceContext);
        } else {
            try {
                layoutLocalService.deleteLayout(layout, updateLayoutSet, serviceContext);
                SystemEventHierarchyEntry systemEventHierarchyEntry = SystemEventHierarchyEntryThreadLocal.peek();
                SystemEventLocalServiceUtil.addSystemEvent((long)0L, (long)layout.getGroupId(), (String)Layout.class.getName(), (long)layout.getPlid(), (String)layout.getUuid(), null, (int)1, (String)systemEventHierarchyEntry.getExtraData());
            }
            finally {
                SystemEventHierarchyEntryThreadLocal.pop(Layout.class, (long)layout.getPlid());
            }
        }
    }

    protected Layout getProxiedLayout(Layout layout) {
        Map<Layout, Object> proxiedLayouts = ProxiedLayoutsThreadLocal.getProxiedLayouts();
        Object proxiedLayout = proxiedLayouts.get(layout);
        if (proxiedLayout != null) {
            return (Layout)proxiedLayout;
        }
        proxiedLayout = ProxyUtil.newProxyInstance((ClassLoader)ClassLoaderUtil.getPortalClassLoader(), (Class[])new Class[]{Layout.class}, (InvocationHandler)new LayoutStagingHandler(layout));
        proxiedLayouts.put(layout, proxiedLayout);
        return (Layout)proxiedLayout;
    }

    protected Layout unwrapLayout(Layout layout) {
        LayoutStagingHandler layoutStagingHandler = LayoutStagingUtil.getLayoutStagingHandler((Layout)layout);
        if (layoutStagingHandler == null) {
            return layout;
        }
        return layoutStagingHandler.getLayout();
    }

    protected Layout wrapLayout(Layout layout) {
        LayoutStagingHandler layoutStagingHandler = LayoutStagingUtil.getLayoutStagingHandler((Layout)layout);
        if (layoutStagingHandler != null) {
            return layout;
        }
        if (!LayoutStagingUtil.isBranchingLayout((Layout)layout)) {
            return layout;
        }
        return this.getProxiedLayout(layout);
    }

    protected List<Layout> wrapLayouts(List<Layout> layouts, boolean showIncomplete) {
        long layoutSetBranchId;
        block7: {
            if (layouts.isEmpty()) {
                return layouts;
            }
            Layout firstLayout = layouts.get(0);
            Layout wrappedFirstLayout = this.wrapLayout(firstLayout);
            if (wrappedFirstLayout == firstLayout) {
                return layouts;
            }
            layoutSetBranchId = 0L;
            if (!showIncomplete) {
                long userId = 0L;
                try {
                    userId = GetterUtil.getLong((String)PrincipalThreadLocal.getName());
                    if (userId > 0L) {
                        User user = UserLocalServiceUtil.getUser((long)userId);
                        LayoutSet layoutSet = firstLayout.getLayoutSet();
                        layoutSetBranchId = StagingUtil.getRecentLayoutSetBranchId((User)user, (long)layoutSet.getLayoutSetId());
                    }
                }
                catch (Exception e) {
                    if (!_log.isDebugEnabled()) break block7;
                    _log.debug((Object)("No layout set branch found for user " + userId));
                }
            }
        }
        ArrayList<Layout> wrappedLayouts = new ArrayList<Layout>(layouts.size());
        for (int i = 0; i < layouts.size(); ++i) {
            Layout wrappedLayout = this.wrapLayout(layouts.get(i));
            if (!showIncomplete && StagingUtil.isIncomplete((Layout)wrappedLayout, (long)layoutSetBranchId)) continue;
            wrappedLayouts.add(wrappedLayout);
        }
        return wrappedLayouts;
    }

    protected Object wrapReturnValue(Object returnValue, boolean showIncomplete) {
        Object object;
        List list;
        if (returnValue instanceof Layout) {
            returnValue = this.wrapLayout((Layout)returnValue);
        } else if (returnValue instanceof List && !(list = (List)returnValue).isEmpty() && (object = list.get(0)) instanceof Layout) {
            returnValue = this.wrapLayouts(returnValue, showIncomplete);
        }
        return returnValue;
    }

    static {
        _layoutLocalServiceStagingAdviceMethodNames.add("createLayout");
        _layoutLocalServiceStagingAdviceMethodNames.add("deleteLayout");
        _layoutLocalServiceStagingAdviceMethodNames.add("getLayouts");
        _layoutLocalServiceStagingAdviceMethodNames.add("updateLayout");
        _layoutLocalServiceStagingAdviceMethodNames.add("updateLookAndFeel");
        _layoutLocalServiceStagingAdviceMethodNames.add("updateName");
    }
}

