/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.webserver;

import com.liferay.portal.kernel.cache.MultiVMPool;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.webserver.WebServerServletToken;
import com.liferay.portal.servlet.filters.cache.CacheUtil;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.dependency.ServiceDependencyListener;
import com.liferay.registry.dependency.ServiceDependencyManager;
import java.io.Serializable;

@DoPrivileged
public class WebServerServletTokenImpl
implements WebServerServletToken {
    private static final String _CACHE_NAME = WebServerServletToken.class.getName();
    private PortalCache<Long, String> _portalCache;

    public void afterPropertiesSet() {
        ServiceDependencyManager serviceDependencyManager = new ServiceDependencyManager();
        serviceDependencyManager.addServiceDependencyListener(new ServiceDependencyListener(){

            public void dependenciesFulfilled() {
                Registry registry = RegistryUtil.getRegistry();
                MultiVMPool multiVMPool = (MultiVMPool)registry.getService(MultiVMPool.class);
                WebServerServletTokenImpl.this._portalCache = multiVMPool.getPortalCache(_CACHE_NAME);
            }

            public void destroy() {
            }
        });
        serviceDependencyManager.registerDependencies(new Class[]{MultiVMPool.class});
    }

    public String getToken(long imageId) {
        Long key = imageId;
        String token = (String)this._portalCache.get((Serializable)key);
        if (token == null) {
            token = this._createToken();
            this._portalCache.put((Serializable)key, (Object)token);
        }
        return token;
    }

    public void resetToken(long imageId) {
        this._portalCache.remove((Serializable)Long.valueOf(imageId));
        CacheUtil.clearCache();
    }

    private String _createToken() {
        return String.valueOf(System.currentTimeMillis());
    }
}

