/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class RenderParametersPool {
    public static Map<String, Map<String, String[]>> clear(HttpServletRequest request, long plid) {
        HttpSession session = request.getSession();
        if (plid <= 0L) {
            return null;
        }
        Map pool = (Map)session.getAttribute("PORTLET_RENDER_PARAMETERS_");
        if (pool == null) {
            return null;
        }
        return (Map)pool.remove(plid);
    }

    public static Map<String, String[]> clear(HttpServletRequest request, long plid, String portletId) {
        Map<String, Map<String, String[]>> plidPool = RenderParametersPool.clear(request, plid);
        if (plidPool == null) {
            return null;
        }
        return plidPool.remove(portletId);
    }

    public static Map<String, Map<String, String[]>> get(HttpServletRequest request, long plid) {
        HttpSession session = request.getSession();
        if (plid <= 0L) {
            return null;
        }
        Map pool = (Map)session.getAttribute("PORTLET_RENDER_PARAMETERS_");
        if (pool == null) {
            return null;
        }
        return (Map)pool.get(plid);
    }

    public static Map<String, String[]> get(HttpServletRequest request, long plid, String portletId) {
        Map<String, Map<String, String[]>> plidPool = RenderParametersPool.get(request, plid);
        if (plidPool == null) {
            return null;
        }
        return plidPool.get(portletId);
    }

    public static Map<String, Map<String, String[]>> getOrCreate(HttpServletRequest request, long plid) {
        HttpSession session = request.getSession();
        if (plid <= 0L) {
            return new ConcurrentHashMap<String, Map<String, String[]>>();
        }
        Map<Long, Map<String, Map<String, String[]>>> pool = RenderParametersPool._getOrCreateRenderParametersPool(session);
        Map<String, Map<String, String[]>> plidPool = pool.get(plid);
        if (plidPool == null) {
            plidPool = new ConcurrentHashMap<String, Map<String, String[]>>();
            pool.put(plid, plidPool);
        }
        return plidPool;
    }

    public static Map<String, String[]> getOrCreate(HttpServletRequest request, long plid, String portletId) {
        Map<String, Map<String, String[]>> plidPool = RenderParametersPool.getOrCreate(request, plid);
        Map<String, String[]> params = plidPool.get(portletId);
        if (params == null) {
            params = new HashMap<String, String[]>();
            plidPool.put(portletId, params);
        }
        return params;
    }

    public static void put(HttpServletRequest request, long plid, String portletId, Map<String, String[]> params) {
        if (params.isEmpty()) {
            return;
        }
        Map<String, Map<String, String[]>> plidPool = RenderParametersPool.getOrCreate(request, plid);
        plidPool.put(portletId, params);
    }

    private static Map<Long, Map<String, Map<String, String[]>>> _getOrCreateRenderParametersPool(HttpSession session) {
        ConcurrentHashMap renderParametersPool = (ConcurrentHashMap)session.getAttribute("PORTLET_RENDER_PARAMETERS_");
        if (renderParametersPool == null) {
            renderParametersPool = new ConcurrentHashMap();
            session.setAttribute("PORTLET_RENDER_PARAMETERS_", renderParametersPool);
        }
        return renderParametersPool;
    }
}

