/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.service.permission;

import com.liferay.exportimport.kernel.staging.permission.StagingPermissionUtil;
import com.liferay.message.boards.kernel.exception.NoSuchCategoryException;
import com.liferay.message.boards.kernel.model.MBCategory;
import com.liferay.message.boards.kernel.model.MBMessage;
import com.liferay.message.boards.kernel.model.MBThread;
import com.liferay.message.boards.kernel.service.MBBanLocalServiceUtil;
import com.liferay.message.boards.kernel.service.MBCategoryLocalServiceUtil;
import com.liferay.message.boards.kernel.service.MBMessageLocalServiceUtil;
import com.liferay.message.boards.kernel.service.MBThreadLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.BaseModelPermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.spring.osgi.OSGiBeanProperties;
import com.liferay.portal.kernel.workflow.permission.WorkflowPermissionUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.messageboards.service.permission.MBCategoryPermission;
import com.liferay.portlet.messageboards.service.permission.MBPermission;

@OSGiBeanProperties(property={"model.class.name=com.liferay.message.boards.kernel.model.MBMessage"})
public class MBMessagePermission
implements BaseModelPermissionChecker {
    public static void check(PermissionChecker permissionChecker, long messageId, String actionId) throws PortalException {
        if (!MBMessagePermission.contains(permissionChecker, messageId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, MBMessage.class.getName(), messageId, new String[]{actionId});
        }
    }

    public static void check(PermissionChecker permissionChecker, MBMessage message, String actionId) throws PortalException {
        if (!MBMessagePermission.contains(permissionChecker, message, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, MBMessage.class.getName(), message.getMessageId(), new String[]{actionId});
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long classPK, String actionId) throws PortalException {
        MBThread mbThread = MBThreadLocalServiceUtil.fetchThread((long)classPK);
        MBMessage message = null;
        message = mbThread == null ? MBMessageLocalServiceUtil.getMessage((long)classPK) : MBMessageLocalServiceUtil.getMessage((long)mbThread.getRootMessageId());
        return MBMessagePermission.contains(permissionChecker, message, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, MBMessage message, String actionId) throws PortalException {
        block14: {
            if (MBBanLocalServiceUtil.hasBan((long)message.getGroupId(), (long)permissionChecker.getUserId())) {
                return false;
            }
            String portletId = PortletProviderUtil.getPortletId((String)MBMessage.class.getName(), (PortletProvider.Action)PortletProvider.Action.EDIT);
            Boolean hasPermission = StagingPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)message.getGroupId(), (String)MBMessage.class.getName(), (long)message.getMessageId(), (String)portletId, (String)actionId);
            if (hasPermission != null) {
                return hasPermission;
            }
            if (message.isDraft() || message.isScheduled()) {
                if (actionId.equals("VIEW") && !MBMessagePermission.contains(permissionChecker, message, "UPDATE")) {
                    return false;
                }
            } else if (message.isPending() && (hasPermission = WorkflowPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)message.getGroupId(), (String)message.getWorkflowClassName(), (long)message.getMessageId(), (String)actionId)) != null) {
                return hasPermission;
            }
            if (actionId.equals("VIEW") && PropsValues.PERMISSIONS_VIEW_DYNAMIC_INHERITANCE) {
                long categoryId = message.getCategoryId();
                if (categoryId == 0L || categoryId == -1L) {
                    if (!MBPermission.contains(permissionChecker, message.getGroupId(), actionId)) {
                        return false;
                    }
                } else {
                    try {
                        MBCategory category = MBCategoryLocalServiceUtil.getCategory((long)categoryId);
                        if (!MBCategoryPermission.contains(permissionChecker, category, actionId)) {
                            return false;
                        }
                    }
                    catch (NoSuchCategoryException nsce) {
                        if (message.isInTrash()) break block14;
                        throw nsce;
                    }
                }
            }
        }
        if (permissionChecker.hasOwnerPermission(message.getCompanyId(), MBMessage.class.getName(), message.getRootMessageId(), message.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(message.getGroupId(), MBMessage.class.getName(), message.getMessageId(), actionId);
    }

    public void checkBaseModel(PermissionChecker permissionChecker, long groupId, long primaryKey, String actionId) throws PortalException {
        MBMessagePermission.check(permissionChecker, primaryKey, actionId);
    }
}

