/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.social.service.impl;

import com.liferay.portal.kernel.cache.MultiVMPoolUtil;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portlet.social.service.base.SocialActivitySettingLocalServiceBaseImpl;
import com.liferay.social.kernel.model.SocialActivityCounterDefinition;
import com.liferay.social.kernel.model.SocialActivityDefinition;
import com.liferay.social.kernel.model.SocialActivitySetting;
import com.liferay.social.kernel.util.SocialConfigurationUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class SocialActivitySettingLocalServiceImpl
extends SocialActivitySettingLocalServiceBaseImpl {
    private static final String _PREFIX_CLASS_PK = "_LFR_CLASS_PK_";
    private static final Log _log = LogFactoryUtil.getLog(SocialActivitySettingLocalServiceImpl.class);
    private static final PortalCache<String, SocialActivityDefinition> _activityDefinitions = MultiVMPoolUtil.getPortalCache((String)SocialActivitySettingLocalServiceImpl.class.getName());

    public void deleteActivitySetting(long groupId, String className, long classPK) {
        String name;
        long classNameId = this.classNameLocalService.getClassNameId(className);
        SocialActivitySetting activitySetting = this.socialActivitySettingPersistence.fetchByG_C_A_N(groupId, classNameId, 0, name = _PREFIX_CLASS_PK.concat(String.valueOf(classPK)));
        if (activitySetting != null) {
            this.socialActivitySettingPersistence.remove((BaseModel)activitySetting);
        }
    }

    public void deleteActivitySettings(long groupId) {
        this.socialActivitySettingPersistence.removeByGroupId(groupId);
    }

    public SocialActivityDefinition getActivityDefinition(long groupId, String className, int activityType) {
        String key = this.encodeKey(groupId, className, activityType);
        SocialActivityDefinition activityDefinition = (SocialActivityDefinition)_activityDefinitions.get((Serializable)((Object)key));
        if (activityDefinition != null) {
            return activityDefinition;
        }
        SocialActivityDefinition defaultActivityDefinition = SocialConfigurationUtil.getActivityDefinition((String)className, (int)activityType);
        if (defaultActivityDefinition == null) {
            return null;
        }
        activityDefinition = this.getActivityDefinition(groupId, className, activityType, defaultActivityDefinition);
        _activityDefinitions.put((Serializable)((Object)key), (Object)activityDefinition);
        return activityDefinition;
    }

    public List<SocialActivityDefinition> getActivityDefinitions(long groupId, String className) {
        ArrayList<SocialActivityDefinition> activityDefinitions = new ArrayList<SocialActivityDefinition>();
        List defaultActivityDefinitions = SocialConfigurationUtil.getActivityDefinitions((String)className);
        for (SocialActivityDefinition defaultActivityDefinition : defaultActivityDefinitions) {
            SocialActivityDefinition activityDefinition = this.getActivityDefinition(groupId, className, defaultActivityDefinition.getActivityType());
            activityDefinitions.add(activityDefinition);
        }
        return activityDefinitions;
    }

    public List<SocialActivitySetting> getActivitySettings(long groupId) {
        return this.socialActivitySettingPersistence.findByG_A(groupId, 0);
    }

    public boolean isEnabled(long groupId, long classNameId) {
        SocialActivitySetting activitySetting = this.socialActivitySettingPersistence.fetchByG_C_A_N(groupId, classNameId, 0, "enabled");
        if (activitySetting == null) {
            return false;
        }
        return GetterUtil.getBoolean((String)activitySetting.getValue());
    }

    public boolean isEnabled(long groupId, long classNameId, long classPK) {
        String name = _PREFIX_CLASS_PK.concat(String.valueOf(classPK));
        SocialActivitySetting activitySetting = this.socialActivitySettingPersistence.fetchByG_C_A_N(groupId, classNameId, 0, name);
        if (activitySetting == null) {
            return true;
        }
        try {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)activitySetting.getValue());
            return jsonObject.getBoolean("enabled");
        }
        catch (JSONException jsone) {
            _log.error((Object)("Unable to create JSON object from " + activitySetting.getValue()));
            return false;
        }
    }

    public void updateActivitySetting(long groupId, String className, boolean enabled) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        SocialActivitySetting activitySetting = this.socialActivitySettingPersistence.fetchByG_C_A_N(groupId, classNameId, 0, "enabled");
        if (activitySetting == null) {
            Group group = this.groupLocalService.getGroup(groupId);
            long activitySettingId = this.counterLocalService.increment();
            activitySetting = this.socialActivitySettingPersistence.create(activitySettingId);
            activitySetting.setGroupId(groupId);
            activitySetting.setCompanyId(group.getCompanyId());
            activitySetting.setClassNameId(classNameId);
            activitySetting.setName("enabled");
        }
        activitySetting.setValue(String.valueOf(enabled));
        this.socialActivitySettingPersistence.update((BaseModel)activitySetting);
    }

    public void updateActivitySetting(long groupId, String className, int activityType, SocialActivityCounterDefinition activityCounterDefinition) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        SocialActivityDefinition defaultActivityDefinition = SocialConfigurationUtil.getActivityDefinition((String)className, (int)activityType);
        SocialActivityCounterDefinition defaultActivityCounterDefinition = defaultActivityDefinition.getActivityCounterDefinition(activityCounterDefinition.getName());
        SocialActivitySetting activitySetting = this.socialActivitySettingPersistence.fetchByG_C_A_N(groupId, classNameId, activityType, activityCounterDefinition.getName());
        if (defaultActivityCounterDefinition != null && defaultActivityCounterDefinition.equals((Object)activityCounterDefinition)) {
            if (activitySetting != null) {
                this.socialActivitySettingPersistence.remove((BaseModel)activitySetting);
            }
            return;
        }
        if (activitySetting != null) {
            activitySetting.setValue(this.toJSON(activityCounterDefinition));
        } else {
            Group group = this.groupLocalService.getGroup(groupId);
            long activitySettingId = this.counterLocalService.increment();
            activitySetting = this.socialActivitySettingPersistence.create(activitySettingId);
            activitySetting.setGroupId(groupId);
            activitySetting.setCompanyId(group.getCompanyId());
            activitySetting.setClassNameId(classNameId);
            activitySetting.setActivityType(activityType);
            activitySetting.setName(activityCounterDefinition.getName());
            activitySetting.setValue(this.toJSON(activityCounterDefinition));
        }
        this.socialActivitySettingPersistence.update((BaseModel)activitySetting);
        String key = this.encodeKey(groupId, className, activityType);
        _activityDefinitions.remove((Serializable)((Object)key));
    }

    public void updateActivitySetting(long groupId, String className, long classPK, boolean enabled) throws PortalException {
        String name;
        long classNameId = this.classNameLocalService.getClassNameId(className);
        SocialActivitySetting activitySetting = this.socialActivitySettingPersistence.fetchByG_C_A_N(groupId, classNameId, 0, name = _PREFIX_CLASS_PK.concat(String.valueOf(classPK)));
        if (activitySetting == null) {
            Group group = this.groupLocalService.getGroup(groupId);
            long activitySettingId = this.counterLocalService.increment();
            activitySetting = this.socialActivitySettingPersistence.create(activitySettingId);
            activitySetting.setGroupId(groupId);
            activitySetting.setCompanyId(group.getCompanyId());
            activitySetting.setClassNameId(classNameId);
            activitySetting.setName(name);
        }
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        jsonObject.put("enabled", enabled);
        activitySetting.setValue(jsonObject.toString());
        this.socialActivitySettingPersistence.update((BaseModel)activitySetting);
    }

    public void updateActivitySettings(long groupId, String className, int activityType, List<SocialActivityCounterDefinition> activityCounterDefinitions) throws PortalException {
        for (SocialActivityCounterDefinition activityCounterDefinition : activityCounterDefinitions) {
            this.updateActivitySetting(groupId, className, activityType, activityCounterDefinition);
        }
    }

    protected String encodeKey(long groupId, String className, int activityType) {
        StringBundler sb = new StringBundler(5);
        sb.append(groupId);
        sb.append("#");
        sb.append(className);
        sb.append("#");
        sb.append(activityType);
        return sb.toString();
    }

    protected SocialActivityDefinition getActivityDefinition(long groupId, String className, int activityType, SocialActivityDefinition defaultActivityDefinition) {
        SocialActivityDefinition activityDefinition = defaultActivityDefinition.clone();
        List<SocialActivitySetting> activitySettings = this.getActivitySettings(groupId, className, defaultActivityDefinition.getActivityType());
        for (SocialActivitySetting activitySetting : activitySettings) {
            String name = activitySetting.getName();
            if (name.equals("enabled")) {
                activityDefinition.setCountersEnabled(GetterUtil.getBoolean((String)activitySetting.getValue(), (boolean)defaultActivityDefinition.isCountersEnabled()));
                continue;
            }
            if (name.equals("logEnabled")) {
                activityDefinition.setLogActivity(GetterUtil.getBoolean((String)activitySetting.getValue(), (boolean)defaultActivityDefinition.isLogActivity()));
                continue;
            }
            JSONObject jsonObject = null;
            try {
                jsonObject = JSONFactoryUtil.createJSONObject((String)activitySetting.getValue());
            }
            catch (Exception e) {
                jsonObject = JSONFactoryUtil.createJSONObject();
            }
            SocialActivityCounterDefinition activityCounterDefinition = activityDefinition.getActivityCounterDefinition(name);
            if (activityCounterDefinition == null) {
                activityCounterDefinition = new SocialActivityCounterDefinition();
                activityCounterDefinition.setName(name);
                activityDefinition.addCounter(activityCounterDefinition);
            }
            activityCounterDefinition.setEnabled(jsonObject.getBoolean("enabled"));
            activityCounterDefinition.setIncrement(jsonObject.getInt("value"));
            activityCounterDefinition.setLimitEnabled(jsonObject.getBoolean("limitEnabled"));
            activityCounterDefinition.setLimitPeriod(jsonObject.getInt("limitPeriod"));
            activityCounterDefinition.setLimitValue(jsonObject.getInt("limitValue"));
            activityCounterDefinition.setOwnerType(jsonObject.getInt("ownerType"));
        }
        return activityDefinition;
    }

    protected List<SocialActivitySetting> getActivitySettings(long groupId, String className, int activityType) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        List activitySettings = this.socialActivitySettingPersistence.findByG_C_A(groupId, classNameId, activityType);
        return activitySettings;
    }

    protected String toJSON(SocialActivityCounterDefinition activityCounterDefinition) {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        jsonObject.put("enabled", activityCounterDefinition.isEnabled());
        jsonObject.put("limitEnabled", activityCounterDefinition.isLimitEnabled());
        jsonObject.put("limitPeriod", activityCounterDefinition.getLimitPeriod());
        jsonObject.put("limitValue", activityCounterDefinition.getLimitValue());
        jsonObject.put("ownerType", activityCounterDefinition.getOwnerType());
        jsonObject.put("value", activityCounterDefinition.getIncrement());
        return jsonObject.toString();
    }
}

