/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.fabric.netty.fileserver.handlers;

import com.liferay.portal.fabric.netty.fileserver.FileHelperUtil;
import com.liferay.portal.fabric.netty.fileserver.FileResponse;
import com.liferay.portal.kernel.concurrent.AsyncBroker;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.util.concurrent.EventExecutor;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.concurrent.Callable;

public class FileUploadChannelHandler
extends ChannelInboundHandlerAdapter {
    protected final AsyncBroker<Path, FileResponse> asyncBroker;
    protected final EventExecutor eventExecutor;
    protected final FileChannel fileChannel;
    protected final FileResponse fileResponse;
    protected final Path tempFilePath;
    private static final Log _log = LogFactoryUtil.getLog(FileUploadChannelHandler.class);

    public FileUploadChannelHandler(AsyncBroker<Path, FileResponse> asyncBroker, FileResponse fileResponse, EventExecutor eventExecutor) throws IOException {
        if (asyncBroker == null) {
            throw new NullPointerException("Async broker is null");
        }
        if (fileResponse == null) {
            throw new NullPointerException("File response is null");
        }
        if (eventExecutor == null) {
            throw new NullPointerException("Event executor is null");
        }
        if (fileResponse.getSize() < 1L) {
            throw new IllegalArgumentException("File response has no content for uploading");
        }
        this.asyncBroker = asyncBroker;
        this.fileResponse = fileResponse;
        this.eventExecutor = eventExecutor;
        this.tempFilePath = Files.createTempFile(FileUploadChannelHandler.class.getName() + "-", null, new FileAttribute[0]);
        this.fileChannel = FileChannel.open(this.tempFilePath, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        fileResponse.setLocalFile(this.tempFilePath);
    }

    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) throws IOException {
        ByteBuf byteBuf = (ByteBuf)object;
        if (!this.receive(byteBuf)) {
            return;
        }
        this.fileChannel.close();
        if (this.eventExecutor.inEventLoop() || !this.fileResponse.isFolder()) {
            this.finish();
        } else {
            this.eventExecutor.submit((Callable)new Callable<Void>(){

                @Override
                public Void call() throws IOException {
                    try {
                        FileUploadChannelHandler.this.finish();
                    }
                    catch (IOException ioe) {
                        FileUploadChannelHandler.this.exceptionCaught(null, ioe);
                    }
                    return null;
                }
            });
        }
        ChannelPipeline channelPipeline = channelHandlerContext.pipeline();
        channelPipeline.remove((ChannelHandler)this);
        if (byteBuf.isReadable()) {
            channelHandlerContext.fireChannelRead(object);
        }
    }

    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) throws IOException {
        _log.error((Object)"File upload failure", throwable);
        if (channelHandlerContext != null) {
            ChannelPipeline channelPipeline = channelHandlerContext.pipeline();
            channelPipeline.remove((ChannelHandler)this);
        }
        if (!this.asyncBroker.takeWithException((Object)this.fileResponse.getPath(), throwable)) {
            _log.error((Object)("Unable to place exception because no future exists with ID " + this.fileResponse.getPath()), throwable);
        }
        this.fileChannel.close();
        Files.delete(this.tempFilePath);
    }

    protected void finish() throws IOException {
        if (this.fileResponse.isFolder()) {
            this.fileResponse.setLocalFile(FileHelperUtil.unzip(this.tempFilePath, FileHelperUtil.TEMP_DIR_PATH));
            Files.delete(this.tempFilePath);
        }
        Files.setLastModifiedTime(this.fileResponse.getLocalFile(), FileTime.fromMillis(this.fileResponse.getLastModifiedTime()));
        Path path = this.fileResponse.getPath();
        if (!this.asyncBroker.takeWithResult((Object)path, (Object)this.fileResponse)) {
            _log.error((Object)("Unable to place result " + this.fileResponse + " because no future exists with ID " + path));
        }
    }

    protected boolean receive(ByteBuf byteBuf) throws IOException {
        long readSize;
        do {
            int readableBytes;
            if ((readSize = this.fileResponse.getSize() - this.fileChannel.position()) <= (long)(readableBytes = byteBuf.readableBytes())) continue;
            readSize = readableBytes;
        } while ((long)byteBuf.readBytes((GatheringByteChannel)this.fileChannel, (int)readSize) != readSize);
        if (!byteBuf.isReadable()) {
            byteBuf.release();
        }
        return this.fileChannel.position() >= this.fileResponse.getSize();
    }
}

