/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.capabilities.util;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.repository.DocumentRepository;
import com.liferay.portal.kernel.repository.model.FileEntry;

public class RepositoryEntryChecker {
    private final DocumentRepository _documentRepository;

    public RepositoryEntryChecker(DocumentRepository documentRepository) {
        this._documentRepository = documentRepository;
    }

    public DLFileEntry checkDLFileEntry(DLFileEntry dlFileEntry) {
        long repositoryId = this._documentRepository.getRepositoryId();
        if (dlFileEntry.getRepositoryId() != repositoryId) {
            throw new SystemException("File entry " + dlFileEntry.getFileEntryId() + " does not belong to repository " + repositoryId);
        }
        return dlFileEntry;
    }

    public FileEntry checkFileEntry(FileEntry fileEntry) {
        long repositoryId = this._documentRepository.getRepositoryId();
        if (fileEntry.getRepositoryId() != repositoryId) {
            throw new SystemException("File entry " + fileEntry.getFileEntryId() + " does not belong to repository " + repositoryId);
        }
        return fileEntry;
    }
}

