/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence.impl;

import aQute.bnd.annotation.ProviderType;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.NoSuchRepositoryException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.CompanyProvider;
import com.liferay.portal.kernel.service.persistence.CompanyProviderWrapper;
import com.liferay.portal.kernel.service.persistence.RepositoryPersistence;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.model.impl.RepositoryImpl;
import com.liferay.portal.model.impl.RepositoryModelImpl;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ProviderType
public class RepositoryPersistenceImpl
extends BasePersistenceImpl<Repository>
implements RepositoryPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = RepositoryImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryModelImpl.FINDER_CACHE_ENABLED, RepositoryImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryModelImpl.FINDER_CACHE_ENABLED, RepositoryImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_UUID = new FinderPath(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryModelImpl.FINDER_CACHE_ENABLED, RepositoryImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid", new String[]{String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID = new FinderPath(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryModelImpl.FINDER_CACHE_ENABLED, RepositoryImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid", new String[]{String.class.getName()}, 16L);
    public static final FinderPath FINDER_PATH_COUNT_BY_UUID = new FinderPath(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid", new String[]{String.class.getName()});
    private static final String _FINDER_COLUMN_UUID_UUID_1 = "repository.uuid IS NULL";
    private static final String _FINDER_COLUMN_UUID_UUID_2 = "repository.uuid = ?";
    private static final String _FINDER_COLUMN_UUID_UUID_3 = "(repository.uuid IS NULL OR repository.uuid = '')";
    public static final FinderPath FINDER_PATH_FETCH_BY_UUID_G = new FinderPath(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryModelImpl.FINDER_CACHE_ENABLED, RepositoryImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByUUID_G", new String[]{String.class.getName(), Long.class.getName()}, 18L);
    public static final FinderPath FINDER_PATH_COUNT_BY_UUID_G = new FinderPath(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUUID_G", new String[]{String.class.getName(), Long.class.getName()});
    private static final String _FINDER_COLUMN_UUID_G_UUID_1 = "repository.uuid IS NULL AND ";
    private static final String _FINDER_COLUMN_UUID_G_UUID_2 = "repository.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_G_UUID_3 = "(repository.uuid IS NULL OR repository.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_G_GROUPID_2 = "repository.groupId = ?";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_UUID_C = new FinderPath(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryModelImpl.FINDER_CACHE_ENABLED, RepositoryImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID_C = new FinderPath(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryModelImpl.FINDER_CACHE_ENABLED, RepositoryImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName()}, 17L);
    public static final FinderPath FINDER_PATH_COUNT_BY_UUID_C = new FinderPath(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid_C", new String[]{String.class.getName(), Long.class.getName()});
    private static final String _FINDER_COLUMN_UUID_C_UUID_1 = "repository.uuid IS NULL AND ";
    private static final String _FINDER_COLUMN_UUID_C_UUID_2 = "repository.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_C_UUID_3 = "(repository.uuid IS NULL OR repository.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_C_COMPANYID_2 = "repository.companyId = ?";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_GROUPID = new FinderPath(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryModelImpl.FINDER_CACHE_ENABLED, RepositoryImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByGroupId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_GROUPID = new FinderPath(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryModelImpl.FINDER_CACHE_ENABLED, RepositoryImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByGroupId", new String[]{Long.class.getName()}, 2L);
    public static final FinderPath FINDER_PATH_COUNT_BY_GROUPID = new FinderPath(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByGroupId", new String[]{Long.class.getName()});
    private static final String _FINDER_COLUMN_GROUPID_GROUPID_2 = "repository.groupId = ?";
    public static final FinderPath FINDER_PATH_FETCH_BY_G_N_P = new FinderPath(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryModelImpl.FINDER_CACHE_ENABLED, RepositoryImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByG_N_P", new String[]{Long.class.getName(), String.class.getName(), String.class.getName()}, 14L);
    public static final FinderPath FINDER_PATH_COUNT_BY_G_N_P = new FinderPath(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByG_N_P", new String[]{Long.class.getName(), String.class.getName(), String.class.getName()});
    private static final String _FINDER_COLUMN_G_N_P_GROUPID_2 = "repository.groupId = ? AND ";
    private static final String _FINDER_COLUMN_G_N_P_NAME_1 = "repository.name IS NULL AND ";
    private static final String _FINDER_COLUMN_G_N_P_NAME_2 = "repository.name = ? AND ";
    private static final String _FINDER_COLUMN_G_N_P_NAME_3 = "(repository.name IS NULL OR repository.name = '') AND ";
    private static final String _FINDER_COLUMN_G_N_P_PORTLETID_1 = "repository.portletId IS NULL";
    private static final String _FINDER_COLUMN_G_N_P_PORTLETID_2 = "repository.portletId = ?";
    private static final String _FINDER_COLUMN_G_N_P_PORTLETID_3 = "(repository.portletId IS NULL OR repository.portletId = '')";
    @BeanReference(type=CompanyProviderWrapper.class)
    protected CompanyProvider companyProvider;
    protected EntityCache entityCache = EntityCacheUtil.getEntityCache();
    protected FinderCache finderCache = FinderCacheUtil.getFinderCache();
    private static final String _SQL_SELECT_REPOSITORY = "SELECT repository FROM Repository repository";
    private static final String _SQL_SELECT_REPOSITORY_WHERE_PKS_IN = "SELECT repository FROM Repository repository WHERE repositoryId IN (";
    private static final String _SQL_SELECT_REPOSITORY_WHERE = "SELECT repository FROM Repository repository WHERE ";
    private static final String _SQL_COUNT_REPOSITORY = "SELECT COUNT(repository) FROM Repository repository";
    private static final String _SQL_COUNT_REPOSITORY_WHERE = "SELECT COUNT(repository) FROM Repository repository WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "repository.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No Repository exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No Repository exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(RepositoryPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"uuid"});

    public List<Repository> findByUuid(String uuid) {
        return this.findByUuid(uuid, -1, -1, null);
    }

    public List<Repository> findByUuid(String uuid, int start, int end) {
        return this.findByUuid(uuid, start, end, null);
    }

    public List<Repository> findByUuid(String uuid, int start, int end, OrderByComparator<Repository> orderByComparator) {
        return this.findByUuid(uuid, start, end, orderByComparator, true);
    }

    public List<Repository> findByUuid(String uuid, int start, int end, OrderByComparator<Repository> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID;
            finderArgs = new Object[]{uuid};
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_UUID;
            finderArgs = new Object[]{uuid, start, end, orderByComparator};
        }
        List<Repository> list = null;
        if (retrieveFromCache && (list = (List<Repository>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (Repository repository : list) {
                if (Objects.equals(uuid, repository.getUuid())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_REPOSITORY_WHERE);
            boolean bindUuid = false;
            if (uuid == null) {
                query.append(_FINDER_COLUMN_UUID_UUID_1);
            } else if (uuid.equals("")) {
                query.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                query.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY repository.repositoryId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public Repository findByUuid_First(String uuid, OrderByComparator<Repository> orderByComparator) throws NoSuchRepositoryException {
        Repository repository = this.fetchByUuid_First(uuid, orderByComparator);
        if (repository != null) {
            return repository;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("uuid=");
        msg.append(uuid);
        msg.append("}");
        throw new NoSuchRepositoryException(msg.toString());
    }

    public Repository fetchByUuid_First(String uuid, OrderByComparator<Repository> orderByComparator) {
        List<Repository> list = this.findByUuid(uuid, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Repository findByUuid_Last(String uuid, OrderByComparator<Repository> orderByComparator) throws NoSuchRepositoryException {
        Repository repository = this.fetchByUuid_Last(uuid, orderByComparator);
        if (repository != null) {
            return repository;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("uuid=");
        msg.append(uuid);
        msg.append("}");
        throw new NoSuchRepositoryException(msg.toString());
    }

    public Repository fetchByUuid_Last(String uuid, OrderByComparator<Repository> orderByComparator) {
        int count = this.countByUuid(uuid);
        if (count == 0) {
            return null;
        }
        List<Repository> list = this.findByUuid(uuid, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Repository[] findByUuid_PrevAndNext(long repositoryId, String uuid, OrderByComparator<Repository> orderByComparator) throws NoSuchRepositoryException {
        Repository repository = this.findByPrimaryKey(repositoryId);
        Session session = null;
        try {
            session = this.openSession();
            Repository[] array = new RepositoryImpl[]{this.getByUuid_PrevAndNext(session, repository, uuid, orderByComparator, true), repository, this.getByUuid_PrevAndNext(session, repository, uuid, orderByComparator, false)};
            Repository[] repositoryArray = array;
            return repositoryArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Repository getByUuid_PrevAndNext(Session session, Repository repository, String uuid, OrderByComparator<Repository> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_REPOSITORY_WHERE);
        boolean bindUuid = false;
        if (uuid == null) {
            query.append(_FINDER_COLUMN_UUID_UUID_1);
        } else if (uuid.equals("")) {
            query.append(_FINDER_COLUMN_UUID_UUID_3);
        } else {
            bindUuid = true;
            query.append(_FINDER_COLUMN_UUID_UUID_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY repository.repositoryId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        if (bindUuid) {
            qPos.add(uuid);
        }
        if (orderByComparator != null) {
            Object[] values;
            for (Object value : values = orderByComparator.getOrderByConditionValues((Object)repository)) {
                qPos.add(value);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Repository)list.get(1);
        }
        return null;
    }

    public void removeByUuid(String uuid) {
        for (Repository repository : this.findByUuid(uuid, -1, -1, null)) {
            this.remove((BaseModel)repository);
        }
    }

    public int countByUuid(String uuid) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_UUID;
        Object[] finderArgs = new Object[]{uuid};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_REPOSITORY_WHERE);
            boolean bindUuid = false;
            if (uuid == null) {
                query.append(_FINDER_COLUMN_UUID_UUID_1);
            } else if (uuid.equals("")) {
                query.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                query.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Repository findByUUID_G(String uuid, long groupId) throws NoSuchRepositoryException {
        Repository repository = this.fetchByUUID_G(uuid, groupId);
        if (repository == null) {
            StringBundler msg = new StringBundler(6);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("uuid=");
            msg.append(uuid);
            msg.append(", groupId=");
            msg.append(groupId);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)msg.toString());
            }
            throw new NoSuchRepositoryException(msg.toString());
        }
        return repository;
    }

    public Repository fetchByUUID_G(String uuid, long groupId) {
        return this.fetchByUUID_G(uuid, groupId, true);
    }

    public Repository fetchByUUID_G(String uuid, long groupId, boolean retrieveFromCache) {
        Repository repository;
        Object[] finderArgs = new Object[]{uuid, groupId};
        Object result = null;
        if (retrieveFromCache) {
            result = this.finderCache.getResult(FINDER_PATH_FETCH_BY_UUID_G, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof Repository && (!Objects.equals(uuid, (repository = (Repository)result).getUuid()) || groupId != repository.getGroupId())) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_SELECT_REPOSITORY_WHERE);
            boolean bindUuid = false;
            if (uuid == null) {
                query.append("repository.uuid IS NULL AND ");
            } else if (uuid.equals("")) {
                query.append("(repository.uuid IS NULL OR repository.uuid = '') AND ");
            } else {
                bindUuid = true;
                query.append("repository.uuid = ? AND ");
            }
            query.append("repository.groupId = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                qPos.add(groupId);
                List list = q.list();
                if (list.isEmpty()) {
                    this.finderCache.putResult(FINDER_PATH_FETCH_BY_UUID_G, finderArgs, (Object)list);
                } else {
                    Repository repository2 = (Repository)list.get(0);
                    result = repository2;
                    this.cacheResult(repository2);
                    if (repository2.getUuid() == null || !repository2.getUuid().equals(uuid) || repository2.getGroupId() != groupId) {
                        this.finderCache.putResult(FINDER_PATH_FETCH_BY_UUID_G, finderArgs, (Object)repository2);
                    }
                }
            }
            catch (Exception e) {
                this.finderCache.removeResult(FINDER_PATH_FETCH_BY_UUID_G, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (Repository)result;
    }

    public Repository removeByUUID_G(String uuid, long groupId) throws NoSuchRepositoryException {
        Repository repository = this.findByUUID_G(uuid, groupId);
        return (Repository)this.remove((BaseModel)repository);
    }

    public int countByUUID_G(String uuid, long groupId) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_UUID_G;
        Object[] finderArgs = new Object[]{uuid, groupId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_REPOSITORY_WHERE);
            boolean bindUuid = false;
            if (uuid == null) {
                query.append("repository.uuid IS NULL AND ");
            } else if (uuid.equals("")) {
                query.append("(repository.uuid IS NULL OR repository.uuid = '') AND ");
            } else {
                bindUuid = true;
                query.append("repository.uuid = ? AND ");
            }
            query.append("repository.groupId = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                qPos.add(groupId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<Repository> findByUuid_C(String uuid, long companyId) {
        return this.findByUuid_C(uuid, companyId, -1, -1, null);
    }

    public List<Repository> findByUuid_C(String uuid, long companyId, int start, int end) {
        return this.findByUuid_C(uuid, companyId, start, end, null);
    }

    public List<Repository> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<Repository> orderByComparator) {
        return this.findByUuid_C(uuid, companyId, start, end, orderByComparator, true);
    }

    public List<Repository> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<Repository> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID_C;
            finderArgs = new Object[]{uuid, companyId};
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_UUID_C;
            finderArgs = new Object[]{uuid, companyId, start, end, orderByComparator};
        }
        List<Repository> list = null;
        if (retrieveFromCache && (list = (List<Repository>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (Repository repository : list) {
                if (Objects.equals(uuid, repository.getUuid()) && companyId == repository.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            query.append(_SQL_SELECT_REPOSITORY_WHERE);
            boolean bindUuid = false;
            if (uuid == null) {
                query.append("repository.uuid IS NULL AND ");
            } else if (uuid.equals("")) {
                query.append("(repository.uuid IS NULL OR repository.uuid = '') AND ");
            } else {
                bindUuid = true;
                query.append("repository.uuid = ? AND ");
            }
            query.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY repository.repositoryId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                qPos.add(companyId);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public Repository findByUuid_C_First(String uuid, long companyId, OrderByComparator<Repository> orderByComparator) throws NoSuchRepositoryException {
        Repository repository = this.fetchByUuid_C_First(uuid, companyId, orderByComparator);
        if (repository != null) {
            return repository;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("uuid=");
        msg.append(uuid);
        msg.append(", companyId=");
        msg.append(companyId);
        msg.append("}");
        throw new NoSuchRepositoryException(msg.toString());
    }

    public Repository fetchByUuid_C_First(String uuid, long companyId, OrderByComparator<Repository> orderByComparator) {
        List<Repository> list = this.findByUuid_C(uuid, companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Repository findByUuid_C_Last(String uuid, long companyId, OrderByComparator<Repository> orderByComparator) throws NoSuchRepositoryException {
        Repository repository = this.fetchByUuid_C_Last(uuid, companyId, orderByComparator);
        if (repository != null) {
            return repository;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("uuid=");
        msg.append(uuid);
        msg.append(", companyId=");
        msg.append(companyId);
        msg.append("}");
        throw new NoSuchRepositoryException(msg.toString());
    }

    public Repository fetchByUuid_C_Last(String uuid, long companyId, OrderByComparator<Repository> orderByComparator) {
        int count = this.countByUuid_C(uuid, companyId);
        if (count == 0) {
            return null;
        }
        List<Repository> list = this.findByUuid_C(uuid, companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Repository[] findByUuid_C_PrevAndNext(long repositoryId, String uuid, long companyId, OrderByComparator<Repository> orderByComparator) throws NoSuchRepositoryException {
        Repository repository = this.findByPrimaryKey(repositoryId);
        Session session = null;
        try {
            session = this.openSession();
            Repository[] array = new RepositoryImpl[]{this.getByUuid_C_PrevAndNext(session, repository, uuid, companyId, orderByComparator, true), repository, this.getByUuid_C_PrevAndNext(session, repository, uuid, companyId, orderByComparator, false)};
            Repository[] repositoryArray = array;
            return repositoryArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Repository getByUuid_C_PrevAndNext(Session session, Repository repository, String uuid, long companyId, OrderByComparator<Repository> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        query.append(_SQL_SELECT_REPOSITORY_WHERE);
        boolean bindUuid = false;
        if (uuid == null) {
            query.append("repository.uuid IS NULL AND ");
        } else if (uuid.equals("")) {
            query.append("(repository.uuid IS NULL OR repository.uuid = '') AND ");
        } else {
            bindUuid = true;
            query.append("repository.uuid = ? AND ");
        }
        query.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY repository.repositoryId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        if (bindUuid) {
            qPos.add(uuid);
        }
        qPos.add(companyId);
        if (orderByComparator != null) {
            Object[] values;
            for (Object value : values = orderByComparator.getOrderByConditionValues((Object)repository)) {
                qPos.add(value);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Repository)list.get(1);
        }
        return null;
    }

    public void removeByUuid_C(String uuid, long companyId) {
        for (Repository repository : this.findByUuid_C(uuid, companyId, -1, -1, null)) {
            this.remove((BaseModel)repository);
        }
    }

    public int countByUuid_C(String uuid, long companyId) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_UUID_C;
        Object[] finderArgs = new Object[]{uuid, companyId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_REPOSITORY_WHERE);
            boolean bindUuid = false;
            if (uuid == null) {
                query.append("repository.uuid IS NULL AND ");
            } else if (uuid.equals("")) {
                query.append("(repository.uuid IS NULL OR repository.uuid = '') AND ");
            } else {
                bindUuid = true;
                query.append("repository.uuid = ? AND ");
            }
            query.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                qPos.add(companyId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<Repository> findByGroupId(long groupId) {
        return this.findByGroupId(groupId, -1, -1, null);
    }

    public List<Repository> findByGroupId(long groupId, int start, int end) {
        return this.findByGroupId(groupId, start, end, null);
    }

    public List<Repository> findByGroupId(long groupId, int start, int end, OrderByComparator<Repository> orderByComparator) {
        return this.findByGroupId(groupId, start, end, orderByComparator, true);
    }

    public List<Repository> findByGroupId(long groupId, int start, int end, OrderByComparator<Repository> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_GROUPID;
            finderArgs = new Object[]{groupId};
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_GROUPID;
            finderArgs = new Object[]{groupId, start, end, orderByComparator};
        }
        List<Repository> list = null;
        if (retrieveFromCache && (list = (List<Repository>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (Repository repository : list) {
                if (groupId == repository.getGroupId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_REPOSITORY_WHERE);
            query.append("repository.groupId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY repository.repositoryId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(groupId);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public Repository findByGroupId_First(long groupId, OrderByComparator<Repository> orderByComparator) throws NoSuchRepositoryException {
        Repository repository = this.fetchByGroupId_First(groupId, orderByComparator);
        if (repository != null) {
            return repository;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("groupId=");
        msg.append(groupId);
        msg.append("}");
        throw new NoSuchRepositoryException(msg.toString());
    }

    public Repository fetchByGroupId_First(long groupId, OrderByComparator<Repository> orderByComparator) {
        List<Repository> list = this.findByGroupId(groupId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Repository findByGroupId_Last(long groupId, OrderByComparator<Repository> orderByComparator) throws NoSuchRepositoryException {
        Repository repository = this.fetchByGroupId_Last(groupId, orderByComparator);
        if (repository != null) {
            return repository;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("groupId=");
        msg.append(groupId);
        msg.append("}");
        throw new NoSuchRepositoryException(msg.toString());
    }

    public Repository fetchByGroupId_Last(long groupId, OrderByComparator<Repository> orderByComparator) {
        int count = this.countByGroupId(groupId);
        if (count == 0) {
            return null;
        }
        List<Repository> list = this.findByGroupId(groupId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Repository[] findByGroupId_PrevAndNext(long repositoryId, long groupId, OrderByComparator<Repository> orderByComparator) throws NoSuchRepositoryException {
        Repository repository = this.findByPrimaryKey(repositoryId);
        Session session = null;
        try {
            session = this.openSession();
            Repository[] array = new RepositoryImpl[]{this.getByGroupId_PrevAndNext(session, repository, groupId, orderByComparator, true), repository, this.getByGroupId_PrevAndNext(session, repository, groupId, orderByComparator, false)};
            Repository[] repositoryArray = array;
            return repositoryArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Repository getByGroupId_PrevAndNext(Session session, Repository repository, long groupId, OrderByComparator<Repository> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_REPOSITORY_WHERE);
        query.append("repository.groupId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY repository.repositoryId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(groupId);
        if (orderByComparator != null) {
            Object[] values;
            for (Object value : values = orderByComparator.getOrderByConditionValues((Object)repository)) {
                qPos.add(value);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Repository)list.get(1);
        }
        return null;
    }

    public void removeByGroupId(long groupId) {
        for (Repository repository : this.findByGroupId(groupId, -1, -1, null)) {
            this.remove((BaseModel)repository);
        }
    }

    public int countByGroupId(long groupId) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_GROUPID;
        Object[] finderArgs = new Object[]{groupId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_REPOSITORY_WHERE);
            query.append("repository.groupId = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(groupId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Repository findByG_N_P(long groupId, String name, String portletId) throws NoSuchRepositoryException {
        Repository repository = this.fetchByG_N_P(groupId, name, portletId);
        if (repository == null) {
            StringBundler msg = new StringBundler(8);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("groupId=");
            msg.append(groupId);
            msg.append(", name=");
            msg.append(name);
            msg.append(", portletId=");
            msg.append(portletId);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)msg.toString());
            }
            throw new NoSuchRepositoryException(msg.toString());
        }
        return repository;
    }

    public Repository fetchByG_N_P(long groupId, String name, String portletId) {
        return this.fetchByG_N_P(groupId, name, portletId, true);
    }

    public Repository fetchByG_N_P(long groupId, String name, String portletId, boolean retrieveFromCache) {
        Repository repository;
        Object[] finderArgs = new Object[]{groupId, name, portletId};
        Object result = null;
        if (retrieveFromCache) {
            result = this.finderCache.getResult(FINDER_PATH_FETCH_BY_G_N_P, finderArgs, (BasePersistenceImpl)this);
        }
        if (!(!(result instanceof Repository) || groupId == (repository = (Repository)result).getGroupId() && Objects.equals(name, repository.getName()) && Objects.equals(portletId, repository.getPortletId()))) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(5);
            query.append(_SQL_SELECT_REPOSITORY_WHERE);
            query.append(_FINDER_COLUMN_G_N_P_GROUPID_2);
            boolean bindName = false;
            if (name == null) {
                query.append(_FINDER_COLUMN_G_N_P_NAME_1);
            } else if (name.equals("")) {
                query.append(_FINDER_COLUMN_G_N_P_NAME_3);
            } else {
                bindName = true;
                query.append(_FINDER_COLUMN_G_N_P_NAME_2);
            }
            boolean bindPortletId = false;
            if (portletId == null) {
                query.append(_FINDER_COLUMN_G_N_P_PORTLETID_1);
            } else if (portletId.equals("")) {
                query.append(_FINDER_COLUMN_G_N_P_PORTLETID_3);
            } else {
                bindPortletId = true;
                query.append(_FINDER_COLUMN_G_N_P_PORTLETID_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(groupId);
                if (bindName) {
                    qPos.add(name);
                }
                if (bindPortletId) {
                    qPos.add(portletId);
                }
                if ((list = q.list()).isEmpty()) {
                    this.finderCache.putResult(FINDER_PATH_FETCH_BY_G_N_P, finderArgs, (Object)list);
                } else {
                    Repository repository2 = (Repository)list.get(0);
                    result = repository2;
                    this.cacheResult(repository2);
                    if (repository2.getGroupId() != groupId || repository2.getName() == null || !repository2.getName().equals(name) || repository2.getPortletId() == null || !repository2.getPortletId().equals(portletId)) {
                        this.finderCache.putResult(FINDER_PATH_FETCH_BY_G_N_P, finderArgs, (Object)repository2);
                    }
                }
            }
            catch (Exception e) {
                this.finderCache.removeResult(FINDER_PATH_FETCH_BY_G_N_P, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (Repository)result;
    }

    public Repository removeByG_N_P(long groupId, String name, String portletId) throws NoSuchRepositoryException {
        Repository repository = this.findByG_N_P(groupId, name, portletId);
        return (Repository)this.remove((BaseModel)repository);
    }

    public int countByG_N_P(long groupId, String name, String portletId) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_G_N_P;
        Object[] finderArgs = new Object[]{groupId, name, portletId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_COUNT_REPOSITORY_WHERE);
            query.append(_FINDER_COLUMN_G_N_P_GROUPID_2);
            boolean bindName = false;
            if (name == null) {
                query.append(_FINDER_COLUMN_G_N_P_NAME_1);
            } else if (name.equals("")) {
                query.append(_FINDER_COLUMN_G_N_P_NAME_3);
            } else {
                bindName = true;
                query.append(_FINDER_COLUMN_G_N_P_NAME_2);
            }
            boolean bindPortletId = false;
            if (portletId == null) {
                query.append(_FINDER_COLUMN_G_N_P_PORTLETID_1);
            } else if (portletId.equals("")) {
                query.append(_FINDER_COLUMN_G_N_P_PORTLETID_3);
            } else {
                bindPortletId = true;
                query.append(_FINDER_COLUMN_G_N_P_PORTLETID_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(groupId);
                if (bindName) {
                    qPos.add(name);
                }
                if (bindPortletId) {
                    qPos.add(portletId);
                }
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public RepositoryPersistenceImpl() {
        this.setModelClass(Repository.class);
    }

    public void cacheResult(Repository repository) {
        this.entityCache.putResult(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryImpl.class, (Serializable)Long.valueOf(repository.getPrimaryKey()), (Serializable)repository);
        this.finderCache.putResult(FINDER_PATH_FETCH_BY_UUID_G, new Object[]{repository.getUuid(), repository.getGroupId()}, (Object)repository);
        this.finderCache.putResult(FINDER_PATH_FETCH_BY_G_N_P, new Object[]{repository.getGroupId(), repository.getName(), repository.getPortletId()}, (Object)repository);
        repository.resetOriginalValues();
    }

    public void cacheResult(List<Repository> repositories) {
        for (Repository repository : repositories) {
            if (this.entityCache.getResult(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryImpl.class, (Serializable)Long.valueOf(repository.getPrimaryKey())) == null) {
                this.cacheResult(repository);
                continue;
            }
            repository.resetOriginalValues();
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(RepositoryImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(Repository repository) {
        this.entityCache.removeResult(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryImpl.class, (Serializable)Long.valueOf(repository.getPrimaryKey()));
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache((RepositoryModelImpl)repository);
    }

    public void clearCache(List<Repository> repositories) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Repository repository : repositories) {
            this.entityCache.removeResult(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryImpl.class, (Serializable)Long.valueOf(repository.getPrimaryKey()));
            this.clearUniqueFindersCache((RepositoryModelImpl)repository);
        }
    }

    protected void cacheUniqueFindersCache(RepositoryModelImpl repositoryModelImpl, boolean isNew) {
        if (isNew) {
            Object[] args = new Object[]{repositoryModelImpl.getUuid(), repositoryModelImpl.getGroupId()};
            this.finderCache.putResult(FINDER_PATH_COUNT_BY_UUID_G, args, (Object)1L);
            this.finderCache.putResult(FINDER_PATH_FETCH_BY_UUID_G, args, (Object)repositoryModelImpl);
            args = new Object[]{repositoryModelImpl.getGroupId(), repositoryModelImpl.getName(), repositoryModelImpl.getPortletId()};
            this.finderCache.putResult(FINDER_PATH_COUNT_BY_G_N_P, args, (Object)1L);
            this.finderCache.putResult(FINDER_PATH_FETCH_BY_G_N_P, args, (Object)repositoryModelImpl);
        } else {
            Object[] args;
            if ((repositoryModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_UUID_G.getColumnBitmask()) != 0L) {
                args = new Object[]{repositoryModelImpl.getUuid(), repositoryModelImpl.getGroupId()};
                this.finderCache.putResult(FINDER_PATH_COUNT_BY_UUID_G, args, (Object)1L);
                this.finderCache.putResult(FINDER_PATH_FETCH_BY_UUID_G, args, (Object)repositoryModelImpl);
            }
            if ((repositoryModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_G_N_P.getColumnBitmask()) != 0L) {
                args = new Object[]{repositoryModelImpl.getGroupId(), repositoryModelImpl.getName(), repositoryModelImpl.getPortletId()};
                this.finderCache.putResult(FINDER_PATH_COUNT_BY_G_N_P, args, (Object)1L);
                this.finderCache.putResult(FINDER_PATH_FETCH_BY_G_N_P, args, (Object)repositoryModelImpl);
            }
        }
    }

    protected void clearUniqueFindersCache(RepositoryModelImpl repositoryModelImpl) {
        Object[] args = new Object[]{repositoryModelImpl.getUuid(), repositoryModelImpl.getGroupId()};
        this.finderCache.removeResult(FINDER_PATH_COUNT_BY_UUID_G, args);
        this.finderCache.removeResult(FINDER_PATH_FETCH_BY_UUID_G, args);
        if ((repositoryModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_UUID_G.getColumnBitmask()) != 0L) {
            args = new Object[]{repositoryModelImpl.getOriginalUuid(), repositoryModelImpl.getOriginalGroupId()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_UUID_G, args);
            this.finderCache.removeResult(FINDER_PATH_FETCH_BY_UUID_G, args);
        }
        args = new Object[]{repositoryModelImpl.getGroupId(), repositoryModelImpl.getName(), repositoryModelImpl.getPortletId()};
        this.finderCache.removeResult(FINDER_PATH_COUNT_BY_G_N_P, args);
        this.finderCache.removeResult(FINDER_PATH_FETCH_BY_G_N_P, args);
        if ((repositoryModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_G_N_P.getColumnBitmask()) != 0L) {
            args = new Object[]{repositoryModelImpl.getOriginalGroupId(), repositoryModelImpl.getOriginalName(), repositoryModelImpl.getOriginalPortletId()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_G_N_P, args);
            this.finderCache.removeResult(FINDER_PATH_FETCH_BY_G_N_P, args);
        }
    }

    public Repository create(long repositoryId) {
        RepositoryImpl repository = new RepositoryImpl();
        repository.setNew(true);
        repository.setPrimaryKey(repositoryId);
        String uuid = PortalUUIDUtil.generate();
        repository.setUuid(uuid);
        repository.setCompanyId(this.companyProvider.getCompanyId());
        return repository;
    }

    public Repository remove(long repositoryId) throws NoSuchRepositoryException {
        return this.remove(Long.valueOf(repositoryId));
    }

    public Repository remove(Serializable primaryKey) throws NoSuchRepositoryException {
        Session session = null;
        try {
            session = this.openSession();
            Repository repository = (Repository)session.get(RepositoryImpl.class, primaryKey);
            if (repository == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchRepositoryException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            Repository repository2 = (Repository)this.remove((BaseModel)repository);
            return repository2;
        }
        catch (NoSuchRepositoryException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Repository removeImpl(Repository repository) {
        repository = this.toUnwrappedModel(repository);
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)repository)) {
                repository = (Repository)session.get(RepositoryImpl.class, repository.getPrimaryKeyObj());
            }
            if (repository != null) {
                session.delete((Object)repository);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        if (repository != null) {
            this.clearCache(repository);
        }
        return repository;
    }

    public Repository updateImpl(Repository repository) {
        repository = this.toUnwrappedModel(repository);
        boolean isNew = repository.isNew();
        RepositoryModelImpl repositoryModelImpl = (RepositoryModelImpl)repository;
        if (Validator.isNull((String)repository.getUuid())) {
            String uuid = PortalUUIDUtil.generate();
            repository.setUuid(uuid);
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date now = new Date();
        if (isNew && repository.getCreateDate() == null) {
            if (serviceContext == null) {
                repository.setCreateDate(now);
            } else {
                repository.setCreateDate(serviceContext.getCreateDate(now));
            }
        }
        if (!repositoryModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                repository.setModifiedDate(now);
            } else {
                repository.setModifiedDate(serviceContext.getModifiedDate(now));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (repository.isNew()) {
                session.save((Object)repository);
                repository.setNew(false);
            } else {
                repository = (Repository)session.merge((Object)repository);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (isNew || !RepositoryModelImpl.COLUMN_BITMASK_ENABLED) {
            this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else {
            Object[] args;
            if ((repositoryModelImpl.getColumnBitmask() & FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID.getColumnBitmask()) != 0L) {
                args = new Object[]{repositoryModelImpl.getOriginalUuid()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_UUID, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID, args);
                args = new Object[]{repositoryModelImpl.getUuid()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_UUID, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID, args);
            }
            if ((repositoryModelImpl.getColumnBitmask() & FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID_C.getColumnBitmask()) != 0L) {
                args = new Object[]{repositoryModelImpl.getOriginalUuid(), repositoryModelImpl.getOriginalCompanyId()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_UUID_C, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID_C, args);
                args = new Object[]{repositoryModelImpl.getUuid(), repositoryModelImpl.getCompanyId()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_UUID_C, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID_C, args);
            }
            if ((repositoryModelImpl.getColumnBitmask() & FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_GROUPID.getColumnBitmask()) != 0L) {
                args = new Object[]{repositoryModelImpl.getOriginalGroupId()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_GROUPID, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_GROUPID, args);
                args = new Object[]{repositoryModelImpl.getGroupId()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_GROUPID, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_GROUPID, args);
            }
        }
        this.entityCache.putResult(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryImpl.class, (Serializable)Long.valueOf(repository.getPrimaryKey()), (Serializable)repository, false);
        this.clearUniqueFindersCache(repositoryModelImpl);
        this.cacheUniqueFindersCache(repositoryModelImpl, isNew);
        repository.resetOriginalValues();
        return repository;
    }

    protected Repository toUnwrappedModel(Repository repository) {
        if (repository instanceof RepositoryImpl) {
            return repository;
        }
        RepositoryImpl repositoryImpl = new RepositoryImpl();
        repositoryImpl.setNew(repository.isNew());
        repositoryImpl.setPrimaryKey(repository.getPrimaryKey());
        repositoryImpl.setMvccVersion(repository.getMvccVersion());
        repositoryImpl.setUuid(repository.getUuid());
        repositoryImpl.setRepositoryId(repository.getRepositoryId());
        repositoryImpl.setGroupId(repository.getGroupId());
        repositoryImpl.setCompanyId(repository.getCompanyId());
        repositoryImpl.setUserId(repository.getUserId());
        repositoryImpl.setUserName(repository.getUserName());
        repositoryImpl.setCreateDate(repository.getCreateDate());
        repositoryImpl.setModifiedDate(repository.getModifiedDate());
        repositoryImpl.setClassNameId(repository.getClassNameId());
        repositoryImpl.setName(repository.getName());
        repositoryImpl.setDescription(repository.getDescription());
        repositoryImpl.setPortletId(repository.getPortletId());
        repositoryImpl.setTypeSettings(repository.getTypeSettings());
        repositoryImpl.setDlFolderId(repository.getDlFolderId());
        repositoryImpl.setLastPublishDate(repository.getLastPublishDate());
        return repositoryImpl;
    }

    public Repository findByPrimaryKey(Serializable primaryKey) throws NoSuchRepositoryException {
        Repository repository = this.fetchByPrimaryKey(primaryKey);
        if (repository == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchRepositoryException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return repository;
    }

    public Repository findByPrimaryKey(long repositoryId) throws NoSuchRepositoryException {
        return this.findByPrimaryKey(Long.valueOf(repositoryId));
    }

    public Repository fetchByPrimaryKey(Serializable primaryKey) {
        Serializable serializable = this.entityCache.getResult(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryImpl.class, primaryKey);
        if (serializable == nullModel) {
            return null;
        }
        Repository repository = (Repository)serializable;
        if (repository == null) {
            Session session = null;
            try {
                session = this.openSession();
                repository = (Repository)session.get(RepositoryImpl.class, primaryKey);
                if (repository != null) {
                    this.cacheResult(repository);
                } else {
                    this.entityCache.putResult(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryImpl.class, primaryKey, (Serializable)nullModel);
                }
            }
            catch (Exception e) {
                this.entityCache.removeResult(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryImpl.class, primaryKey);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return repository;
    }

    public Repository fetchByPrimaryKey(long repositoryId) {
        return this.fetchByPrimaryKey(Long.valueOf(repositoryId));
    }

    public Map<Serializable, Repository> fetchByPrimaryKeys(Set<Serializable> primaryKeys) {
        Session session;
        if (primaryKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Serializable, Repository> map = new HashMap<Serializable, Repository>();
        if (primaryKeys.size() == 1) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            Serializable primaryKey = iterator.next();
            Repository repository = this.fetchByPrimaryKey(primaryKey);
            if (repository != null) {
                map.put(primaryKey, repository);
            }
            return map;
        }
        HashSet<Serializable> uncachedPrimaryKeys = null;
        for (Serializable serializable : primaryKeys) {
            Serializable serializable2 = this.entityCache.getResult(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryImpl.class, serializable);
            if (serializable2 == nullModel) continue;
            if (serializable2 == null) {
                if (uncachedPrimaryKeys == null) {
                    uncachedPrimaryKeys = new HashSet<Serializable>();
                }
                uncachedPrimaryKeys.add(serializable);
                continue;
            }
            map.put(serializable, (Repository)serializable2);
        }
        if (uncachedPrimaryKeys == null) {
            return map;
        }
        StringBundler query = new StringBundler(uncachedPrimaryKeys.size() * 2 + 1);
        query.append(_SQL_SELECT_REPOSITORY_WHERE_PKS_IN);
        for (Serializable serializable : uncachedPrimaryKeys) {
            query.append(String.valueOf(serializable));
            query.append(",");
        }
        query.setIndex(query.index() - 1);
        query.append(")");
        String string = query.toString();
        Session session2 = null;
        try {
            session = this.openSession();
            Query q = session.createQuery(string);
            for (Repository repository : q.list()) {
                map.put(repository.getPrimaryKeyObj(), repository);
                this.cacheResult(repository);
                uncachedPrimaryKeys.remove(repository.getPrimaryKeyObj());
            }
            for (Serializable serializable : uncachedPrimaryKeys) {
                this.entityCache.putResult(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryImpl.class, serializable, (Serializable)nullModel);
            }
        }
        catch (Exception e) {
            try {
                throw this.processException(e);
            }
            catch (Throwable throwable) {
                this.closeSession(session2);
                throw throwable;
            }
        }
        this.closeSession(session);
        return map;
    }

    public List<Repository> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<Repository> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<Repository> findAll(int start, int end, OrderByComparator<Repository> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<Repository> findAll(int start, int end, OrderByComparator<Repository> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (retrieveFromCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                query.append(_SQL_SELECT_REPOSITORY);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_REPOSITORY;
                if (pagination) {
                    sql = sql.concat(" ORDER BY repository.repositoryId ASC");
                }
            }
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (Repository repository : this.findAll()) {
            this.remove((BaseModel)repository);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_REPOSITORY);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return RepositoryModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
    }

    public void destroy() {
        this.entityCache.removeCache(RepositoryImpl.class.getName());
        this.finderCache.removeCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

