/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.servlet.DynamicServletRequest;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.servlet.NamespaceServletRequest;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class DynamicServletRequestUtil {
    public static HttpServletRequest createDynamicServletRequest(HttpServletRequest httpServletRequest, Portlet portlet, Map<String, String[]> parameterMap, boolean mergeParameters) {
        DynamicServletRequest dynamicServletRequest = null;
        if (portlet.isPrivateRequestAttributes()) {
            String portletNamespace = PortalUtil.getPortletNamespace((String)portlet.getPortletName());
            dynamicServletRequest = new NamespaceServletRequest(httpServletRequest, portletNamespace, portletNamespace);
        } else {
            dynamicServletRequest = new DynamicServletRequest(httpServletRequest);
        }
        for (Map.Entry<String, String[]> entry : parameterMap.entrySet()) {
            String name = entry.getKey();
            Object[] values = entry.getValue();
            Object[] oldValues = dynamicServletRequest.getParameterValues(name);
            if (mergeParameters && oldValues != null) {
                values = (String[])ArrayUtil.append((Object[])values, (Object[])oldValues);
            }
            dynamicServletRequest.setParameterValues(name, (String[])values);
        }
        return dynamicServletRequest;
    }
}

