/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.aggregate;

import com.liferay.portal.kernel.cache.key.CacheKeyGenerator;
import com.liferay.portal.kernel.cache.key.CacheKeyGeneratorUtil;
import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.BufferCacheServletResponse;
import com.liferay.portal.kernel.servlet.PortalWebResourcesUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.URLUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.minifier.MinifierUtil;
import com.liferay.portal.servlet.filters.IgnoreModuleRequestFilter;
import com.liferay.portal.servlet.filters.aggregate.ServletPaths;
import com.liferay.portal.servlet.filters.dynamiccss.DynamicCSSUtil;
import com.liferay.portal.util.AggregateUtil;
import com.liferay.portal.util.JavaScriptBundleUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AggregateFilter
extends IgnoreModuleRequestFilter {
    private static final String _BASE_URL = "@base_url@";
    private static final String _CSS_COMMENT_BEGIN = "/*";
    private static final String _CSS_COMMENT_END = "*/";
    private static final String _CSS_EXTENSION = ".css";
    private static final String _CSS_IMPORT_BEGIN = "@import url(";
    private static final String _CSS_IMPORT_END = ");";
    private static final String _CSS_MEDIA_QUERY = "@media";
    private static final String _JAVASCRIPT_EXTENSION = ".js";
    private static final String _JSP_EXTENSION = ".jsp";
    private static final String _TEMP_DIR = "aggregate";
    private static final Log _log = LogFactoryUtil.getLog(AggregateFilter.class);
    private static final Pattern _pattern = Pattern.compile("^(\\.ie|\\.js\\.ie)([^}]*)}", 8);
    private ServletContext _servletContext;
    private File _tempDir;

    public static String aggregateCss(ServletPaths servletPaths, String content) throws IOException {
        StringBundler sb = new StringBundler();
        int pos = 0;
        while (true) {
            int commentX = content.indexOf(_CSS_COMMENT_BEGIN, pos);
            int commentY = content.indexOf(_CSS_COMMENT_END, commentX + _CSS_COMMENT_BEGIN.length());
            int importX = content.indexOf(_CSS_IMPORT_BEGIN, pos);
            int importY = content.indexOf(_CSS_IMPORT_END, importX + _CSS_IMPORT_BEGIN.length());
            if (importX == -1 || importY == -1) break;
            if (commentX != -1 && commentY != -1 && commentX < importX && commentY > importX) {
                sb.append(content.substring(pos, commentY += _CSS_COMMENT_END.length()));
                pos = commentY;
                continue;
            }
            sb.append(content.substring(pos, importX));
            String mediaQuery = "";
            int mediaQueryImportX = content.indexOf(41, importX + _CSS_IMPORT_BEGIN.length());
            int mediaQueryImportY = content.indexOf(59, importX + _CSS_IMPORT_BEGIN.length());
            String importFileName = null;
            if (importY != mediaQueryImportX) {
                mediaQuery = content.substring(mediaQueryImportX + 1, mediaQueryImportY);
                importFileName = content.substring(importX + _CSS_IMPORT_BEGIN.length(), mediaQueryImportX);
            } else {
                importFileName = content.substring(importX + _CSS_IMPORT_BEGIN.length(), importY);
            }
            String importContent = null;
            if (Validator.isUrl((String)importFileName)) {
                URL url = new URL(importFileName);
                URLConnection urlConnection = url.openConnection();
                importContent = StringUtil.read((InputStream)urlConnection.getInputStream());
            } else {
                ServletPaths importFileServletPaths = servletPaths.down(importFileName);
                importContent = importFileServletPaths.getContent();
                if (importContent == null) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)("File " + importFileServletPaths.getResourcePath() + " does not exist"));
                    }
                    importContent = "";
                }
                String importDirName = "";
                int slashPos = importFileName.lastIndexOf(47);
                if (slashPos != -1) {
                    importDirName = importFileName.substring(0, slashPos + 1);
                }
                ServletPaths importDirServletPaths = servletPaths.down(importDirName);
                importContent = AggregateFilter.aggregateCss(importDirServletPaths, importContent);
                String baseURL = _BASE_URL.concat(importDirServletPaths.getResourcePath());
                if (!baseURL.endsWith("/")) {
                    baseURL = baseURL + "/";
                }
                importContent = AggregateUtil.updateRelativeURLs(importContent, baseURL);
            }
            if (Validator.isNotNull((String)mediaQuery)) {
                sb.append(_CSS_MEDIA_QUERY);
                sb.append(' ');
                sb.append(mediaQuery);
                sb.append('{');
                sb.append(importContent);
                sb.append('}');
                pos = mediaQueryImportY + 1;
                continue;
            }
            sb.append(importContent);
            pos = importY + _CSS_IMPORT_END.length();
        }
        sb.append(content.substring(pos));
        return sb.toString();
    }

    public static String aggregateJavaScript(ServletPaths servletPaths, String[] fileNames) {
        StringBundler sb = new StringBundler(fileNames.length * 2);
        for (String fileName : fileNames) {
            ServletPaths fileServletPaths = servletPaths.down(fileName);
            String content = fileServletPaths.getContent();
            if (Validator.isNull((String)content)) continue;
            sb.append(content);
            sb.append("\n");
        }
        return AggregateFilter.getJavaScriptContent(StringUtil.merge((Object[])fileNames, (String)"+"), sb.toString());
    }

    public void init(FilterConfig filterConfig) {
        super.init(filterConfig);
        this._servletContext = filterConfig.getServletContext();
        File tempDir = (File)this._servletContext.getAttribute("javax.servlet.context.tempdir");
        this._tempDir = new File(tempDir, _TEMP_DIR);
        this._tempDir.mkdirs();
    }

    protected static String getJavaScriptContent(String resourceName, String content) {
        return MinifierUtil.minifyJavaScript(resourceName, content);
    }

    protected Object getBundleContent(HttpServletRequest request, HttpServletResponse response) throws IOException {
        long lastModified;
        String minifierType = ParamUtil.getString((HttpServletRequest)request, (String)"minifierType");
        String bundleId = ParamUtil.getString((HttpServletRequest)request, (String)"bundleId", (String)ParamUtil.getString((HttpServletRequest)request, (String)"minifierBundleId"));
        if (Validator.isNull((String)minifierType) || Validator.isNull((String)bundleId) || !ArrayUtil.contains((Object[])PropsValues.JAVASCRIPT_BUNDLE_IDS, (Object)bundleId)) {
            return null;
        }
        String bundleDirName = PropsUtil.get("javascript.bundle.dir", new Filter(bundleId));
        ServletContext jsServletContext = PortalWebResourcesUtil.getServletContext((String)"js");
        URL bundleDirURL = jsServletContext.getResource(bundleDirName);
        if (bundleDirURL == null) {
            return null;
        }
        String cacheFileName = bundleId;
        String[] fileNames = JavaScriptBundleUtil.getFileNames(bundleId);
        File cacheFile = new File(this._tempDir, cacheFileName);
        if (cacheFile.exists() && (lastModified = PortalWebResourcesUtil.getLastModified((String)"js")) <= cacheFile.lastModified()) {
            response.setContentType("text/javascript");
            return cacheFile;
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Aggregating JavaScript bundle " + bundleId));
        }
        String content = null;
        content = fileNames.length == 0 ? "" : AggregateFilter.aggregateJavaScript(new ServletPaths(jsServletContext, bundleDirName), fileNames);
        response.setContentType("text/javascript");
        FileUtil.write((File)cacheFile, (String)content);
        return content;
    }

    protected String getCacheFileName(HttpServletRequest request) {
        String queryString;
        CacheKeyGenerator cacheKeyGenerator = CacheKeyGeneratorUtil.getCacheKeyGenerator((String)AggregateFilter.class.getName());
        cacheKeyGenerator.append(HttpUtil.getProtocol((boolean)request.isSecure()));
        cacheKeyGenerator.append("_");
        cacheKeyGenerator.append(request.getRequestURI());
        String requestURL = String.valueOf(request.getRequestURL());
        if (requestURL != null && (queryString = HttpUtil.getQueryString((String)(requestURL = HttpUtil.removeParameter((String)requestURL, (String)"zx")))) != null) {
            cacheKeyGenerator.append(this.sterilizeQueryString(queryString));
        }
        return String.valueOf(cacheKeyGenerator.finish());
    }

    protected Object getContent(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        URL resourceURL;
        String requestURI;
        String minifierType = ParamUtil.getString((HttpServletRequest)request, (String)"minifierType");
        String minifierBundleId = ParamUtil.getString((HttpServletRequest)request, (String)"minifierBundleId");
        String minifierBundleDirName = ParamUtil.getString((HttpServletRequest)request, (String)"minifierBundleDir");
        if (Validator.isNull((String)minifierType) || Validator.isNotNull((String)minifierBundleId) || Validator.isNotNull((String)minifierBundleDirName)) {
            return null;
        }
        String resourcePath = requestURI = request.getRequestURI();
        String contextPath = request.getContextPath();
        if (!contextPath.equals("/")) {
            resourcePath = resourcePath.substring(contextPath.length());
        }
        if (resourcePath.endsWith(_CSS_EXTENSION) && PortalUtil.isRightToLeft((HttpServletRequest)request)) {
            int pos = resourcePath.lastIndexOf(".");
            resourcePath = resourcePath.substring(0, pos) + "_rtl" + resourcePath.substring(pos);
        }
        if ((resourceURL = this._servletContext.getResource(resourcePath)) == null && (resourceURL = PortalWebResourcesUtil.getResource((String)resourcePath)) == null) {
            return null;
        }
        String cacheCommonFileName = this.getCacheFileName(request);
        File cacheContentTypeFile = new File(this._tempDir, cacheCommonFileName + "_E_CONTENT_TYPE");
        File cacheDataFile = new File(this._tempDir, cacheCommonFileName + "_E_DATA");
        if (cacheDataFile.exists() && cacheDataFile.lastModified() >= URLUtil.getLastModifiedTime((URL)resourceURL)) {
            if (cacheContentTypeFile.exists()) {
                String contentType = FileUtil.read((File)cacheContentTypeFile);
                response.setContentType(contentType);
            }
            return cacheDataFile;
        }
        String content = null;
        if (resourcePath.endsWith(_CSS_EXTENSION)) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Minifying CSS " + resourcePath));
            }
            content = this.getCssContent(request, response, resourceURL, resourcePath);
            response.setContentType("text/css");
            FileUtil.write((File)cacheContentTypeFile, (String)"text/css");
        } else if (resourcePath.endsWith(_JAVASCRIPT_EXTENSION)) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Minifying JavaScript " + resourcePath));
            }
            content = this.getJavaScriptContent(resourceURL);
            response.setContentType("text/javascript");
            FileUtil.write((File)cacheContentTypeFile, (String)"text/javascript");
        } else if (resourcePath.endsWith(_JSP_EXTENSION)) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Minifying JSP " + resourcePath));
            }
            BufferCacheServletResponse bufferCacheServletResponse = new BufferCacheServletResponse(response);
            this.processFilter(AggregateFilter.class.getName(), request, (HttpServletResponse)bufferCacheServletResponse, filterChain);
            bufferCacheServletResponse.finishResponse(false);
            content = bufferCacheServletResponse.getString();
            if (minifierType.equals("css")) {
                content = this.getCssContent(request, response, resourcePath, content);
            } else if (minifierType.equals("js")) {
                content = AggregateFilter.getJavaScriptContent(resourcePath, content);
            }
            FileUtil.write((File)cacheContentTypeFile, (String)bufferCacheServletResponse.getContentType());
        } else {
            return null;
        }
        FileUtil.write((File)cacheDataFile, (String)content);
        return content;
    }

    protected String getCssContent(HttpServletRequest request, HttpServletResponse response, String resourcePath, String content) {
        try {
            ServletContext cssServletContext = null;
            String requestURI = request.getRequestURI();
            if (PortalWebResourcesUtil.hasContextPath((String)requestURI)) {
                cssServletContext = PortalWebResourcesUtil.getPathServletContext((String)requestURI);
            }
            if (cssServletContext == null) {
                cssServletContext = this._servletContext;
            }
            content = DynamicCSSUtil.replaceToken(cssServletContext, request, content);
        }
        catch (Exception e) {
            _log.error((Object)("Unable to replace tokens in CSS " + resourcePath), (Throwable)e);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)content);
            }
            response.setHeader("Cache-Control", "private, no-cache, no-store, must-revalidate");
        }
        String browserId = ParamUtil.getString((HttpServletRequest)request, (String)"browserId");
        if (!browserId.equals("ie")) {
            Matcher matcher = _pattern.matcher(content);
            content = matcher.replaceAll("");
        }
        return MinifierUtil.minifyCss(content);
    }

    protected String getCssContent(HttpServletRequest request, HttpServletResponse response, URL resourceURL, String resourcePath) throws IOException {
        ServletContext cssServletContext = null;
        String resourcePathRoot = null;
        String requestURI = request.getRequestURI();
        if (PortalWebResourcesUtil.hasContextPath((String)requestURI)) {
            cssServletContext = PortalWebResourcesUtil.getPathServletContext((String)requestURI);
            resourcePathRoot = "/";
        }
        if (cssServletContext == null) {
            cssServletContext = this._servletContext;
            resourcePathRoot = ServletPaths.getParentPath(resourcePath);
        }
        URLConnection urlConnection = resourceURL.openConnection();
        String content = StringUtil.read((InputStream)urlConnection.getInputStream());
        content = AggregateFilter.aggregateCss(new ServletPaths(cssServletContext, resourcePathRoot), content);
        return this.getCssContent(request, response, resourcePath, content);
    }

    protected String getJavaScriptContent(URL resourceURL) throws IOException {
        URLConnection urlConnection = resourceURL.openConnection();
        String content = StringUtil.read((InputStream)urlConnection.getInputStream());
        return AggregateFilter.getJavaScriptContent(resourceURL.toString(), content);
    }

    @Override
    protected boolean isModuleRequest(HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        if (PortalWebResourcesUtil.hasContextPath((String)requestURI)) {
            return false;
        }
        return super.isModuleRequest(request);
    }

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        Object minifiedContent = this.getContent(request, response, filterChain);
        if (minifiedContent == null) {
            minifiedContent = this.getBundleContent(request, response);
        }
        if (minifiedContent == null) {
            this.processFilter(AggregateFilter.class.getName(), request, response, filterChain);
        } else if (minifiedContent instanceof File) {
            ServletResponseUtil.write((HttpServletResponse)response, (File)((File)minifiedContent));
        } else if (minifiedContent instanceof String) {
            ServletResponseUtil.write((HttpServletResponse)response, (String)((String)minifiedContent));
        }
    }

    protected String sterilizeQueryString(String queryString) {
        return StringUtil.replace((String)queryString, (char[])new char[]{'/', '\\'}, (char[])new char[]{'_', '_'});
    }
}

