/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.strip;

import com.liferay.portal.kernel.cache.key.CacheKeyGenerator;
import com.liferay.portal.kernel.cache.key.CacheKeyGeneratorUtil;
import com.liferay.portal.kernel.concurrent.ConcurrentLFUCache;
import com.liferay.portal.kernel.io.OutputStreamWriter;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.servlet.BufferCacheServletResponse;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.KMPSearch;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.minifier.MinifierUtil;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.portal.util.PropsValues;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.CharBuffer;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class StripFilter
extends BasePortalFilter {
    public static final String SKIP_FILTER = StripFilter.class.getName() + "#SKIP_FILTER";
    private static final String _ENSURE_CONTENT_LENGTH = "ensureContentLength";
    private static final String _MARKER_INPUT_CLOSE = "/>";
    private static final int[] _MARKER_INPUT_CLOSE_NEXTS = KMPSearch.generateNexts((CharSequence)"/>");
    private static final char[] _MARKER_INPUT_OPEN = "input".toCharArray();
    private static final String _MARKER_LANGUAGE = "language=";
    private static final int[] _MARKER_LANGUAGE_NEXTS = KMPSearch.generateNexts((CharSequence)"language=");
    private static final String _MARKER_PRE_CLOSE = "/pre>";
    private static final int[] _MARKER_PRE_CLOSE_NEXTS = KMPSearch.generateNexts((CharSequence)"/pre>");
    private static final char[] _MARKER_PRE_OPEN = "pre".toCharArray();
    private static final String _MARKER_SCRIPT_CLOSE = "</script>";
    private static final int[] _MARKER_SCRIPT_CLOSE_NEXTS = KMPSearch.generateNexts((CharSequence)"</script>");
    private static final char[] _MARKER_SCRIPT_OPEN = "script".toCharArray();
    private static final String _MARKER_STYLE_CLOSE = "</style>";
    private static final int[] _MARKER_STYLE_CLOSE_NEXTS = KMPSearch.generateNexts((CharSequence)"</style>");
    private static final char[] _MARKER_STYLE_OPEN = "style type=\"text/css\">".toCharArray();
    private static final String _MARKER_TEXTAREA_CLOSE = "/textarea>";
    private static final int[] _MARKER_TEXTAREA_CLOSE_NEXTS = KMPSearch.generateNexts((CharSequence)"/textarea>");
    private static final char[] _MARKER_TEXTAREA_OPEN = "textarea ".toCharArray();
    private static final String _MARKER_TYPE_JAVASCRIPT = "type=\"text/javascript\"";
    private static final int[] _MARKER_TYPE_JAVASCRIPT_NEXTS = KMPSearch.generateNexts((CharSequence)"type=\"text/javascript\"");
    private static final String _STRIP = "strip";
    private static final Log _log = LogFactoryUtil.getLog(StripFilter.class);
    private static final Pattern _javaScriptPattern = Pattern.compile("[Jj][aA][vV][aA][sS][cC][rR][iI][pP][tT]");
    private final Set<String> _ignorePaths = new HashSet<String>();
    private final ConcurrentLFUCache<String, String> _minifierCache = PropsValues.MINIFIER_INLINE_CONTENT_CACHE_SIZE > 0 ? new ConcurrentLFUCache(PropsValues.MINIFIER_INLINE_CONTENT_CACHE_SIZE) : null;

    public void init(FilterConfig filterConfig) {
        super.init(filterConfig);
        for (String ignorePath : PropsValues.STRIP_IGNORE_PATHS) {
            this._ignorePaths.add(ignorePath);
        }
    }

    public boolean isFilterEnabled(HttpServletRequest request, HttpServletResponse response) {
        return this.isStrip(request) && !this.isInclude(request) && !this.isAlreadyFiltered(request);
    }

    protected String extractContent(CharBuffer charBuffer, int length) {
        CharBuffer duplicateCharBuffer = charBuffer.duplicate();
        int position = duplicateCharBuffer.position() + length;
        String content = duplicateCharBuffer.limit(position).toString();
        charBuffer.position(position);
        return content;
    }

    protected boolean hasLanguageAttribute(CharBuffer charBuffer, int startPos, int length) {
        if (!PropsValues.STRIP_JS_LANGUAGE_ATTRIBUTE_SUPPORT_ENABLED) {
            return false;
        }
        if (KMPSearch.search((CharSequence)charBuffer, (int)startPos, (int)length, (CharSequence)_MARKER_LANGUAGE, (int[])_MARKER_LANGUAGE_NEXTS) == -1) {
            return false;
        }
        Matcher matcher = _javaScriptPattern.matcher(charBuffer);
        return matcher.find();
    }

    protected boolean hasMarker(CharBuffer charBuffer, char[] marker) {
        int position = charBuffer.position();
        if (position + marker.length >= charBuffer.limit()) {
            return false;
        }
        for (int i = 0; i < marker.length; ++i) {
            char c = marker[i];
            char oldC = charBuffer.charAt(i);
            if (c == oldC || Character.toUpperCase(c) == oldC) continue;
            return false;
        }
        return true;
    }

    protected boolean isAlreadyFiltered(HttpServletRequest request) {
        return request.getAttribute(SKIP_FILTER) != null;
    }

    protected boolean isInclude(HttpServletRequest request) {
        String uri = (String)request.getAttribute("javax.servlet.include.request_uri");
        return uri != null;
    }

    protected boolean isStrip(HttpServletRequest request) {
        if (!ParamUtil.getBoolean((HttpServletRequest)request, (String)_STRIP, (boolean)true)) {
            return false;
        }
        String path = request.getPathInfo();
        if (this._ignorePaths.contains(path)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Ignore path " + path));
            }
            return false;
        }
        String lifecycle = ParamUtil.getString((HttpServletRequest)request, (String)"p_p_lifecycle");
        return (!lifecycle.equals("1") || !LiferayWindowState.isExclusive((HttpServletRequest)request)) && !lifecycle.equals("2");
    }

    protected boolean isStripContentType(String contentType) {
        for (String stripContentType : PropsValues.STRIP_MIME_TYPES) {
            if (!(stripContentType.endsWith("*") ? contentType.startsWith(stripContentType = stripContentType.substring(0, stripContentType.length() - 1)) : contentType.equals(stripContentType))) continue;
            return true;
        }
        return false;
    }

    protected void outputCloseTag(CharBuffer charBuffer, Writer writer, String closeTag) throws Exception {
        writer.write(closeTag);
        charBuffer.position(charBuffer.position() + closeTag.length());
        this.skipWhiteSpace(charBuffer, writer, true);
    }

    protected void outputOpenTag(CharBuffer charBuffer, Writer writer, char[] openTag) throws Exception {
        writer.write(openTag);
        charBuffer.position(charBuffer.position() + openTag.length);
    }

    protected void processCSS(HttpServletRequest request, HttpServletResponse response, CharBuffer charBuffer, Writer writer) throws Exception {
        CacheKeyGenerator cacheKeyGenerator;
        String key;
        String content;
        this.outputOpenTag(charBuffer, writer, _MARKER_STYLE_OPEN);
        int length = KMPSearch.search((CharSequence)charBuffer, (CharSequence)_MARKER_STYLE_CLOSE, (int[])_MARKER_STYLE_CLOSE_NEXTS);
        if (length == -1) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Missing </style>");
            }
            return;
        }
        if (length == 0) {
            this.outputCloseTag(charBuffer, writer, _MARKER_STYLE_CLOSE);
            return;
        }
        String minifiedContent = content = this.extractContent(charBuffer, length);
        if (PropsValues.MINIFIER_INLINE_CONTENT_CACHE_SIZE > 0 && (minifiedContent = (String)this._minifierCache.get((Object)(key = String.valueOf((cacheKeyGenerator = CacheKeyGeneratorUtil.getCacheKeyGenerator((String)StripFilter.class.getName())).getCacheKey(content))))) == null) {
            minifiedContent = MinifierUtil.minifyCss(content);
            boolean skipCache = false;
            for (String skipCss : PropsValues.MINIFIER_INLINE_CONTENT_CACHE_SKIP_CSS) {
                if (!minifiedContent.contains(skipCss)) continue;
                skipCache = true;
                break;
            }
            if (!skipCache) {
                this._minifierCache.put((Object)key, (Object)minifiedContent);
            }
        }
        if (Validator.isNotNull((String)minifiedContent)) {
            writer.write(minifiedContent);
        }
        this.outputCloseTag(charBuffer, writer, _MARKER_STYLE_CLOSE);
    }

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        if (_log.isDebugEnabled()) {
            String completeURL = HttpUtil.getCompleteURL((HttpServletRequest)request);
            _log.debug((Object)("Stripping " + completeURL));
        }
        request.setAttribute(SKIP_FILTER, (Object)Boolean.TRUE);
        BufferCacheServletResponse bufferCacheServletResponse = new BufferCacheServletResponse(response);
        this.processFilter(StripFilter.class.getName(), request, (HttpServletResponse)bufferCacheServletResponse, filterChain);
        String contentType = GetterUtil.getString((String)bufferCacheServletResponse.getContentType());
        contentType = StringUtil.toLowerCase((String)contentType);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Stripping content of type " + contentType));
        }
        response.setContentType(contentType);
        if (this.isStripContentType(contentType) && bufferCacheServletResponse.getStatus() == 200) {
            CharBuffer oldCharBuffer = bufferCacheServletResponse.getCharBuffer();
            boolean ensureContentLength = ParamUtil.getBoolean((HttpServletRequest)request, (String)_ENSURE_CONTENT_LENGTH);
            if (ensureContentLength) {
                UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
                this.strip(request, response, oldCharBuffer, (Writer)new OutputStreamWriter((OutputStream)unsyncByteArrayOutputStream));
                response.setContentLength(unsyncByteArrayOutputStream.size());
                unsyncByteArrayOutputStream.writeTo((OutputStream)response.getOutputStream());
            } else if (!response.isCommitted()) {
                this.strip(request, response, oldCharBuffer, response.getWriter());
            }
        } else {
            ServletResponseUtil.write((HttpServletResponse)response, (BufferCacheServletResponse)bufferCacheServletResponse);
        }
    }

    protected void processInput(CharBuffer oldCharBuffer, Writer writer) throws Exception {
        int length = KMPSearch.search((CharSequence)oldCharBuffer, (int)(_MARKER_INPUT_OPEN.length + 1), (CharSequence)_MARKER_INPUT_CLOSE, (int[])_MARKER_INPUT_CLOSE_NEXTS);
        if (length == -1) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Missing />");
            }
            this.outputOpenTag(oldCharBuffer, writer, _MARKER_INPUT_OPEN);
            return;
        }
        String content = this.extractContent(oldCharBuffer, length += _MARKER_INPUT_CLOSE.length());
        writer.write(content);
        this.skipWhiteSpace(oldCharBuffer, writer, true);
    }

    protected void processJavaScript(String resourceName, CharBuffer charBuffer, Writer writer, char[] openTag) throws Exception {
        CacheKeyGenerator cacheKeyGenerator;
        String key;
        String content;
        int endPos = openTag.length + 1;
        char c = charBuffer.charAt(openTag.length);
        if (c == ' ') {
            int startPos;
            for (int i = startPos = openTag.length + 1; i < charBuffer.length(); ++i) {
                c = charBuffer.charAt(i);
                if (c == '>') {
                    endPos = i + 1;
                    int length = i - startPos;
                    if (length >= _MARKER_TYPE_JAVASCRIPT.length() && KMPSearch.search((CharSequence)charBuffer, (int)startPos, (int)length, (CharSequence)_MARKER_TYPE_JAVASCRIPT, (int[])_MARKER_TYPE_JAVASCRIPT_NEXTS) != -1 || this.hasLanguageAttribute(charBuffer, startPos, length)) break;
                    return;
                }
                if (c != '<') continue;
                return;
            }
            if (endPos == charBuffer.length()) {
                return;
            }
        } else if (c != '>') {
            return;
        }
        writer.append(charBuffer, 0, endPos);
        charBuffer.position(charBuffer.position() + endPos);
        int length = KMPSearch.search((CharSequence)charBuffer, (CharSequence)_MARKER_SCRIPT_CLOSE, (int[])_MARKER_SCRIPT_CLOSE_NEXTS);
        if (length == -1) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Missing </script>");
            }
            return;
        }
        if (length == 0) {
            this.outputCloseTag(charBuffer, writer, _MARKER_SCRIPT_CLOSE);
            return;
        }
        String minifiedContent = content = this.extractContent(charBuffer, length);
        if (PropsValues.MINIFIER_INLINE_CONTENT_CACHE_SIZE > 0 && (minifiedContent = (String)this._minifierCache.get((Object)(key = String.valueOf((cacheKeyGenerator = CacheKeyGeneratorUtil.getCacheKeyGenerator((String)StripFilter.class.getName())).getCacheKey(content))))) == null) {
            minifiedContent = MinifierUtil.minifyJavaScript(resourceName, content);
            boolean skipCache = false;
            for (String skipJavaScript : PropsValues.MINIFIER_INLINE_CONTENT_CACHE_SKIP_JAVASCRIPT) {
                if (!minifiedContent.contains(skipJavaScript)) continue;
                skipCache = true;
                break;
            }
            if (!skipCache) {
                this._minifierCache.put((Object)key, (Object)minifiedContent);
            }
        }
        if (Validator.isNotNull((String)minifiedContent)) {
            writer.write(minifiedContent);
        }
        this.outputCloseTag(charBuffer, writer, _MARKER_SCRIPT_CLOSE);
    }

    protected void processPre(CharBuffer oldCharBuffer, Writer writer) throws Exception {
        int length = KMPSearch.search((CharSequence)oldCharBuffer, (int)(_MARKER_PRE_OPEN.length + 1), (CharSequence)_MARKER_PRE_CLOSE, (int[])_MARKER_PRE_CLOSE_NEXTS);
        if (length == -1) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Missing </pre>");
            }
            this.outputOpenTag(oldCharBuffer, writer, _MARKER_PRE_OPEN);
            return;
        }
        String content = this.extractContent(oldCharBuffer, length += _MARKER_PRE_CLOSE.length());
        writer.write(content);
        this.skipWhiteSpace(oldCharBuffer, writer, true);
    }

    protected void processTextArea(CharBuffer oldCharBuffer, Writer writer) throws Exception {
        int length = KMPSearch.search((CharSequence)oldCharBuffer, (int)(_MARKER_TEXTAREA_OPEN.length + 1), (CharSequence)_MARKER_TEXTAREA_CLOSE, (int[])_MARKER_TEXTAREA_CLOSE_NEXTS);
        if (length == -1) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Missing </textArea>");
            }
            this.outputOpenTag(oldCharBuffer, writer, _MARKER_TEXTAREA_OPEN);
            return;
        }
        String content = this.extractContent(oldCharBuffer, length += _MARKER_TEXTAREA_CLOSE.length());
        writer.write(content);
        this.skipWhiteSpace(oldCharBuffer, writer, true);
    }

    protected boolean skipWhiteSpace(CharBuffer charBuffer, Writer writer, boolean appendSeparator) throws Exception {
        boolean skipped = false;
        for (int i = charBuffer.position(); i < charBuffer.limit(); ++i) {
            char c = charBuffer.get();
            if (c != ' ' && c != '\t' && c != '\r' && c != '\n') {
                charBuffer.position(i);
                break;
            }
            skipped = true;
        }
        if (skipped && appendSeparator) {
            writer.write(32);
        }
        return skipped;
    }

    protected void strip(HttpServletRequest request, HttpServletResponse response, CharBuffer charBuffer, Writer writer) throws Exception {
        this.skipWhiteSpace(charBuffer, writer, false);
        while (charBuffer.hasRemaining()) {
            char c = charBuffer.get();
            writer.write(c);
            if (c == '<') {
                if (this.hasMarker(charBuffer, _MARKER_INPUT_OPEN)) {
                    this.processInput(charBuffer, writer);
                    continue;
                }
                if (this.hasMarker(charBuffer, _MARKER_PRE_OPEN)) {
                    this.processPre(charBuffer, writer);
                    continue;
                }
                if (this.hasMarker(charBuffer, _MARKER_TEXTAREA_OPEN)) {
                    this.processTextArea(charBuffer, writer);
                    continue;
                }
                if (this.hasMarker(charBuffer, _MARKER_SCRIPT_OPEN)) {
                    StringBuffer requestURL = request.getRequestURL();
                    this.processJavaScript(requestURL.toString(), charBuffer, writer, _MARKER_SCRIPT_OPEN);
                    continue;
                }
                if (this.hasMarker(charBuffer, _MARKER_STYLE_OPEN)) {
                    this.processCSS(request, response, charBuffer, writer);
                    continue;
                }
            } else if (c == '>') {
                this.skipWhiteSpace(charBuffer, writer, true);
            }
            this.skipWhiteSpace(charBuffer, writer, true);
        }
        writer.flush();
    }
}

