/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.concurrent.ThrowableAwareRunnable;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ContactLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourceLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.verify.model.VerifiableResourcedModel;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.verify.VerifyProcess;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class VerifyResourcePermissions
extends VerifyProcess {
    private static final Log _log = LogFactoryUtil.getLog(VerifyResourcePermissions.class);

    public void verify(VerifiableResourcedModel ... verifiableResourcedModels) throws Exception {
        long[] companyIds;
        for (long companyId : companyIds = PortalInstances.getCompanyIdsBySQL()) {
            Role role = RoleLocalServiceUtil.getRole((long)companyId, (String)"Owner");
            ArrayList<VerifyResourcedModelRunnable> verifyResourcedModelRunnables = new ArrayList<VerifyResourcedModelRunnable>(verifiableResourcedModels.length);
            for (VerifiableResourcedModel verifiableResourcedModel : verifiableResourcedModels) {
                VerifyResourcedModelRunnable verifyResourcedModelRunnable = new VerifyResourcedModelRunnable(role, verifiableResourcedModel);
                verifyResourcedModelRunnables.add(verifyResourcedModelRunnable);
            }
            this.doVerify(verifyResourcedModelRunnables);
            this.verifyLayout(role);
        }
    }

    @Override
    protected void doVerify() throws Exception {
        Map verifiableResourcedModelsMap = PortalBeanLocatorUtil.locate(VerifiableResourcedModel.class);
        Collection verifiableResourcedModels = verifiableResourcedModelsMap.values();
        this.verify(verifiableResourcedModels.toArray(new VerifiableResourcedModel[verifiableResourcedModels.size()]));
    }

    protected void verifyLayout(Role role) throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            List layouts = LayoutLocalServiceUtil.getNoPermissionLayouts((long)role.getRoleId());
            int total = layouts.size();
            for (int i = 0; i < total; ++i) {
                Layout layout = (Layout)layouts.get(i);
                this.verifyResourcedModel(role.getCompanyId(), Layout.class.getName(), layout.getPlid(), role, 0L, i, total);
            }
        }
    }

    protected void verifyResourcedModel(long companyId, String modelName, long primKey, Role role, long ownerId, int cur, int total) throws Exception {
        Contact contact;
        User user;
        ResourcePermission resourcePermission;
        if (_log.isInfoEnabled() && cur % 100 == 0) {
            _log.info((Object)("Processed " + cur + " of " + total + " resource permissions for company = " + companyId + " and model " + modelName));
        }
        if ((resourcePermission = ResourcePermissionLocalServiceUtil.fetchResourcePermission((long)companyId, (String)modelName, (int)4, (String)String.valueOf(primKey), (long)role.getRoleId())) == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("No resource found for {" + companyId + ", " + modelName + ", " + 4 + ", " + primKey + ", " + role.getRoleId() + "}"));
            }
            ResourceLocalServiceUtil.addResources((long)companyId, (long)0L, (long)ownerId, (String)modelName, (String)String.valueOf(primKey), (boolean)false, (boolean)false, (boolean)false);
        }
        if (resourcePermission == null && (resourcePermission = ResourcePermissionLocalServiceUtil.fetchResourcePermission((long)companyId, (String)modelName, (int)4, (String)String.valueOf(primKey), (long)role.getRoleId())) == null) {
            return;
        }
        if (modelName.equals(User.class.getName()) && (user = UserLocalServiceUtil.fetchUserById((long)ownerId)) != null && (contact = ContactLocalServiceUtil.fetchContact((long)user.getContactId())) != null) {
            ownerId = contact.getUserId();
        }
        if (ownerId != resourcePermission.getOwnerId()) {
            resourcePermission.setOwnerId(ownerId);
            ResourcePermissionLocalServiceUtil.updateResourcePermission((ResourcePermission)resourcePermission);
        }
    }

    protected void verifyResourcedModel(Role role, VerifiableResourcedModel verifiableResourcedModel) throws Exception {
        int total = 0;
        try (LoggingTimer loggingTimer = new LoggingTimer(verifiableResourcedModel.getTableName());
             Connection con = DataAccess.getUpgradeOptimizedConnection();
             PreparedStatement ps1 = con.prepareStatement("select count(*) from " + verifiableResourcedModel.getTableName() + " where companyId = " + role.getCompanyId());
             ResultSet rs1 = ps1.executeQuery();){
            if (rs1.next()) {
                total = rs1.getInt(1);
            }
            StringBundler sb = new StringBundler(8);
            sb.append("select ");
            sb.append(verifiableResourcedModel.getPrimaryKeyColumnName());
            sb.append(", ");
            sb.append(verifiableResourcedModel.getUserIdColumnName());
            sb.append(" from ");
            sb.append(verifiableResourcedModel.getTableName());
            sb.append(" where companyId = ");
            sb.append(role.getCompanyId());
            try (PreparedStatement ps2 = con.prepareStatement(sb.toString());
                 ResultSet rs2 = ps2.executeQuery();){
                int i = 0;
                while (rs2.next()) {
                    long primKey = rs2.getLong(verifiableResourcedModel.getPrimaryKeyColumnName());
                    long userId = rs2.getLong(verifiableResourcedModel.getUserIdColumnName());
                    this.verifyResourcedModel(role.getCompanyId(), verifiableResourcedModel.getModelName(), primKey, role, userId, i, total);
                    ++i;
                }
            }
        }
    }

    private class VerifyResourcedModelRunnable
    extends ThrowableAwareRunnable {
        private final Role _role;
        private final VerifiableResourcedModel _verifiableResourcedModel;

        public VerifyResourcedModelRunnable(Role role, VerifiableResourcedModel verifiableResourcedModel) {
            this._role = role;
            this._verifiableResourcedModel = verifiableResourcedModel;
        }

        protected void doRun() throws Exception {
            VerifyResourcePermissions.this.verifyResourcedModel(this._role, this._verifiableResourcedModel);
        }
    }
}

