/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.persistence.impl;

import aQute.bnd.annotation.ProviderType;
import com.liferay.asset.kernel.exception.NoSuchTagStatsException;
import com.liferay.asset.kernel.model.AssetTagStats;
import com.liferay.asset.kernel.service.persistence.AssetTagStatsPersistence;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.service.persistence.CompanyProvider;
import com.liferay.portal.kernel.service.persistence.CompanyProviderWrapper;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portlet.asset.model.impl.AssetTagStatsImpl;
import com.liferay.portlet.asset.model.impl.AssetTagStatsModelImpl;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

@ProviderType
public class AssetTagStatsPersistenceImpl
extends BasePersistenceImpl<AssetTagStats>
implements AssetTagStatsPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = AssetTagStatsImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(AssetTagStatsModelImpl.ENTITY_CACHE_ENABLED, AssetTagStatsModelImpl.FINDER_CACHE_ENABLED, AssetTagStatsImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(AssetTagStatsModelImpl.ENTITY_CACHE_ENABLED, AssetTagStatsModelImpl.FINDER_CACHE_ENABLED, AssetTagStatsImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(AssetTagStatsModelImpl.ENTITY_CACHE_ENABLED, AssetTagStatsModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_TAGID = new FinderPath(AssetTagStatsModelImpl.ENTITY_CACHE_ENABLED, AssetTagStatsModelImpl.FINDER_CACHE_ENABLED, AssetTagStatsImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByTagId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_TAGID = new FinderPath(AssetTagStatsModelImpl.ENTITY_CACHE_ENABLED, AssetTagStatsModelImpl.FINDER_CACHE_ENABLED, AssetTagStatsImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByTagId", new String[]{Long.class.getName()}, 6L);
    public static final FinderPath FINDER_PATH_COUNT_BY_TAGID = new FinderPath(AssetTagStatsModelImpl.ENTITY_CACHE_ENABLED, AssetTagStatsModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByTagId", new String[]{Long.class.getName()});
    private static final String _FINDER_COLUMN_TAGID_TAGID_2 = "assetTagStats.tagId = ?";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_CLASSNAMEID = new FinderPath(AssetTagStatsModelImpl.ENTITY_CACHE_ENABLED, AssetTagStatsModelImpl.FINDER_CACHE_ENABLED, AssetTagStatsImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByClassNameId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_CLASSNAMEID = new FinderPath(AssetTagStatsModelImpl.ENTITY_CACHE_ENABLED, AssetTagStatsModelImpl.FINDER_CACHE_ENABLED, AssetTagStatsImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByClassNameId", new String[]{Long.class.getName()}, 5L);
    public static final FinderPath FINDER_PATH_COUNT_BY_CLASSNAMEID = new FinderPath(AssetTagStatsModelImpl.ENTITY_CACHE_ENABLED, AssetTagStatsModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByClassNameId", new String[]{Long.class.getName()});
    private static final String _FINDER_COLUMN_CLASSNAMEID_CLASSNAMEID_2 = "assetTagStats.classNameId = ?";
    public static final FinderPath FINDER_PATH_FETCH_BY_T_C = new FinderPath(AssetTagStatsModelImpl.ENTITY_CACHE_ENABLED, AssetTagStatsModelImpl.FINDER_CACHE_ENABLED, AssetTagStatsImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByT_C", new String[]{Long.class.getName(), Long.class.getName()}, 3L);
    public static final FinderPath FINDER_PATH_COUNT_BY_T_C = new FinderPath(AssetTagStatsModelImpl.ENTITY_CACHE_ENABLED, AssetTagStatsModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByT_C", new String[]{Long.class.getName(), Long.class.getName()});
    private static final String _FINDER_COLUMN_T_C_TAGID_2 = "assetTagStats.tagId = ? AND ";
    private static final String _FINDER_COLUMN_T_C_CLASSNAMEID_2 = "assetTagStats.classNameId = ?";
    @BeanReference(type=CompanyProviderWrapper.class)
    protected CompanyProvider companyProvider;
    protected EntityCache entityCache = EntityCacheUtil.getEntityCache();
    protected FinderCache finderCache = FinderCacheUtil.getFinderCache();
    private static final String _SQL_SELECT_ASSETTAGSTATS = "SELECT assetTagStats FROM AssetTagStats assetTagStats";
    private static final String _SQL_SELECT_ASSETTAGSTATS_WHERE_PKS_IN = "SELECT assetTagStats FROM AssetTagStats assetTagStats WHERE tagStatsId IN (";
    private static final String _SQL_SELECT_ASSETTAGSTATS_WHERE = "SELECT assetTagStats FROM AssetTagStats assetTagStats WHERE ";
    private static final String _SQL_COUNT_ASSETTAGSTATS = "SELECT COUNT(assetTagStats) FROM AssetTagStats assetTagStats";
    private static final String _SQL_COUNT_ASSETTAGSTATS_WHERE = "SELECT COUNT(assetTagStats) FROM AssetTagStats assetTagStats WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "assetTagStats.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No AssetTagStats exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No AssetTagStats exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(AssetTagStatsPersistenceImpl.class);

    public List<AssetTagStats> findByTagId(long tagId) {
        return this.findByTagId(tagId, -1, -1, null);
    }

    public List<AssetTagStats> findByTagId(long tagId, int start, int end) {
        return this.findByTagId(tagId, start, end, null);
    }

    public List<AssetTagStats> findByTagId(long tagId, int start, int end, OrderByComparator<AssetTagStats> orderByComparator) {
        return this.findByTagId(tagId, start, end, orderByComparator, true);
    }

    public List<AssetTagStats> findByTagId(long tagId, int start, int end, OrderByComparator<AssetTagStats> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_TAGID;
            finderArgs = new Object[]{tagId};
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_TAGID;
            finderArgs = new Object[]{tagId, start, end, orderByComparator};
        }
        List<AssetTagStats> list = null;
        if (retrieveFromCache && (list = (List<AssetTagStats>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (AssetTagStats assetTagStats : list) {
                if (tagId == assetTagStats.getTagId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_ASSETTAGSTATS_WHERE);
            query.append(_FINDER_COLUMN_TAGID_TAGID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY assetTagStats.assetCount DESC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(tagId);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public AssetTagStats findByTagId_First(long tagId, OrderByComparator<AssetTagStats> orderByComparator) throws NoSuchTagStatsException {
        AssetTagStats assetTagStats = this.fetchByTagId_First(tagId, orderByComparator);
        if (assetTagStats != null) {
            return assetTagStats;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("tagId=");
        msg.append(tagId);
        msg.append("}");
        throw new NoSuchTagStatsException(msg.toString());
    }

    public AssetTagStats fetchByTagId_First(long tagId, OrderByComparator<AssetTagStats> orderByComparator) {
        List<AssetTagStats> list = this.findByTagId(tagId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public AssetTagStats findByTagId_Last(long tagId, OrderByComparator<AssetTagStats> orderByComparator) throws NoSuchTagStatsException {
        AssetTagStats assetTagStats = this.fetchByTagId_Last(tagId, orderByComparator);
        if (assetTagStats != null) {
            return assetTagStats;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("tagId=");
        msg.append(tagId);
        msg.append("}");
        throw new NoSuchTagStatsException(msg.toString());
    }

    public AssetTagStats fetchByTagId_Last(long tagId, OrderByComparator<AssetTagStats> orderByComparator) {
        int count = this.countByTagId(tagId);
        if (count == 0) {
            return null;
        }
        List<AssetTagStats> list = this.findByTagId(tagId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public AssetTagStats[] findByTagId_PrevAndNext(long tagStatsId, long tagId, OrderByComparator<AssetTagStats> orderByComparator) throws NoSuchTagStatsException {
        AssetTagStats assetTagStats = this.findByPrimaryKey(tagStatsId);
        Session session = null;
        try {
            session = this.openSession();
            AssetTagStats[] array = new AssetTagStatsImpl[]{this.getByTagId_PrevAndNext(session, assetTagStats, tagId, orderByComparator, true), assetTagStats, this.getByTagId_PrevAndNext(session, assetTagStats, tagId, orderByComparator, false)};
            AssetTagStats[] assetTagStatsArray = array;
            return assetTagStatsArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected AssetTagStats getByTagId_PrevAndNext(Session session, AssetTagStats assetTagStats, long tagId, OrderByComparator<AssetTagStats> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_ASSETTAGSTATS_WHERE);
        query.append(_FINDER_COLUMN_TAGID_TAGID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY assetTagStats.assetCount DESC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(tagId);
        if (orderByComparator != null) {
            Object[] values;
            for (Object value : values = orderByComparator.getOrderByConditionValues((Object)assetTagStats)) {
                qPos.add(value);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (AssetTagStats)list.get(1);
        }
        return null;
    }

    public void removeByTagId(long tagId) {
        for (AssetTagStats assetTagStats : this.findByTagId(tagId, -1, -1, null)) {
            this.remove((BaseModel)assetTagStats);
        }
    }

    public int countByTagId(long tagId) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_TAGID;
        Object[] finderArgs = new Object[]{tagId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_ASSETTAGSTATS_WHERE);
            query.append(_FINDER_COLUMN_TAGID_TAGID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(tagId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<AssetTagStats> findByClassNameId(long classNameId) {
        return this.findByClassNameId(classNameId, -1, -1, null);
    }

    public List<AssetTagStats> findByClassNameId(long classNameId, int start, int end) {
        return this.findByClassNameId(classNameId, start, end, null);
    }

    public List<AssetTagStats> findByClassNameId(long classNameId, int start, int end, OrderByComparator<AssetTagStats> orderByComparator) {
        return this.findByClassNameId(classNameId, start, end, orderByComparator, true);
    }

    public List<AssetTagStats> findByClassNameId(long classNameId, int start, int end, OrderByComparator<AssetTagStats> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_CLASSNAMEID;
            finderArgs = new Object[]{classNameId};
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_CLASSNAMEID;
            finderArgs = new Object[]{classNameId, start, end, orderByComparator};
        }
        List<AssetTagStats> list = null;
        if (retrieveFromCache && (list = (List<AssetTagStats>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (AssetTagStats assetTagStats : list) {
                if (classNameId == assetTagStats.getClassNameId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_ASSETTAGSTATS_WHERE);
            query.append("assetTagStats.classNameId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY assetTagStats.assetCount DESC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(classNameId);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public AssetTagStats findByClassNameId_First(long classNameId, OrderByComparator<AssetTagStats> orderByComparator) throws NoSuchTagStatsException {
        AssetTagStats assetTagStats = this.fetchByClassNameId_First(classNameId, orderByComparator);
        if (assetTagStats != null) {
            return assetTagStats;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("classNameId=");
        msg.append(classNameId);
        msg.append("}");
        throw new NoSuchTagStatsException(msg.toString());
    }

    public AssetTagStats fetchByClassNameId_First(long classNameId, OrderByComparator<AssetTagStats> orderByComparator) {
        List<AssetTagStats> list = this.findByClassNameId(classNameId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public AssetTagStats findByClassNameId_Last(long classNameId, OrderByComparator<AssetTagStats> orderByComparator) throws NoSuchTagStatsException {
        AssetTagStats assetTagStats = this.fetchByClassNameId_Last(classNameId, orderByComparator);
        if (assetTagStats != null) {
            return assetTagStats;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("classNameId=");
        msg.append(classNameId);
        msg.append("}");
        throw new NoSuchTagStatsException(msg.toString());
    }

    public AssetTagStats fetchByClassNameId_Last(long classNameId, OrderByComparator<AssetTagStats> orderByComparator) {
        int count = this.countByClassNameId(classNameId);
        if (count == 0) {
            return null;
        }
        List<AssetTagStats> list = this.findByClassNameId(classNameId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public AssetTagStats[] findByClassNameId_PrevAndNext(long tagStatsId, long classNameId, OrderByComparator<AssetTagStats> orderByComparator) throws NoSuchTagStatsException {
        AssetTagStats assetTagStats = this.findByPrimaryKey(tagStatsId);
        Session session = null;
        try {
            session = this.openSession();
            AssetTagStats[] array = new AssetTagStatsImpl[]{this.getByClassNameId_PrevAndNext(session, assetTagStats, classNameId, orderByComparator, true), assetTagStats, this.getByClassNameId_PrevAndNext(session, assetTagStats, classNameId, orderByComparator, false)};
            AssetTagStats[] assetTagStatsArray = array;
            return assetTagStatsArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected AssetTagStats getByClassNameId_PrevAndNext(Session session, AssetTagStats assetTagStats, long classNameId, OrderByComparator<AssetTagStats> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_ASSETTAGSTATS_WHERE);
        query.append("assetTagStats.classNameId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY assetTagStats.assetCount DESC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(classNameId);
        if (orderByComparator != null) {
            Object[] values;
            for (Object value : values = orderByComparator.getOrderByConditionValues((Object)assetTagStats)) {
                qPos.add(value);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (AssetTagStats)list.get(1);
        }
        return null;
    }

    public void removeByClassNameId(long classNameId) {
        for (AssetTagStats assetTagStats : this.findByClassNameId(classNameId, -1, -1, null)) {
            this.remove((BaseModel)assetTagStats);
        }
    }

    public int countByClassNameId(long classNameId) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_CLASSNAMEID;
        Object[] finderArgs = new Object[]{classNameId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_ASSETTAGSTATS_WHERE);
            query.append("assetTagStats.classNameId = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(classNameId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public AssetTagStats findByT_C(long tagId, long classNameId) throws NoSuchTagStatsException {
        AssetTagStats assetTagStats = this.fetchByT_C(tagId, classNameId);
        if (assetTagStats == null) {
            StringBundler msg = new StringBundler(6);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("tagId=");
            msg.append(tagId);
            msg.append(", classNameId=");
            msg.append(classNameId);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)msg.toString());
            }
            throw new NoSuchTagStatsException(msg.toString());
        }
        return assetTagStats;
    }

    public AssetTagStats fetchByT_C(long tagId, long classNameId) {
        return this.fetchByT_C(tagId, classNameId, true);
    }

    public AssetTagStats fetchByT_C(long tagId, long classNameId, boolean retrieveFromCache) {
        AssetTagStats assetTagStats;
        Object[] finderArgs = new Object[]{tagId, classNameId};
        Object result = null;
        if (retrieveFromCache) {
            result = this.finderCache.getResult(FINDER_PATH_FETCH_BY_T_C, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof AssetTagStats && (tagId != (assetTagStats = (AssetTagStats)result).getTagId() || classNameId != assetTagStats.getClassNameId())) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_SELECT_ASSETTAGSTATS_WHERE);
            query.append(_FINDER_COLUMN_T_C_TAGID_2);
            query.append("assetTagStats.classNameId = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(tagId);
                qPos.add(classNameId);
                List list = q.list();
                if (list.isEmpty()) {
                    this.finderCache.putResult(FINDER_PATH_FETCH_BY_T_C, finderArgs, (Object)list);
                } else {
                    AssetTagStats assetTagStats2 = (AssetTagStats)list.get(0);
                    result = assetTagStats2;
                    this.cacheResult(assetTagStats2);
                    if (assetTagStats2.getTagId() != tagId || assetTagStats2.getClassNameId() != classNameId) {
                        this.finderCache.putResult(FINDER_PATH_FETCH_BY_T_C, finderArgs, (Object)assetTagStats2);
                    }
                }
            }
            catch (Exception e) {
                this.finderCache.removeResult(FINDER_PATH_FETCH_BY_T_C, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (AssetTagStats)result;
    }

    public AssetTagStats removeByT_C(long tagId, long classNameId) throws NoSuchTagStatsException {
        AssetTagStats assetTagStats = this.findByT_C(tagId, classNameId);
        return (AssetTagStats)this.remove((BaseModel)assetTagStats);
    }

    public int countByT_C(long tagId, long classNameId) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_T_C;
        Object[] finderArgs = new Object[]{tagId, classNameId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_ASSETTAGSTATS_WHERE);
            query.append(_FINDER_COLUMN_T_C_TAGID_2);
            query.append("assetTagStats.classNameId = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(tagId);
                qPos.add(classNameId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public AssetTagStatsPersistenceImpl() {
        this.setModelClass(AssetTagStats.class);
    }

    public void cacheResult(AssetTagStats assetTagStats) {
        this.entityCache.putResult(AssetTagStatsModelImpl.ENTITY_CACHE_ENABLED, AssetTagStatsImpl.class, (Serializable)Long.valueOf(assetTagStats.getPrimaryKey()), (Serializable)assetTagStats);
        this.finderCache.putResult(FINDER_PATH_FETCH_BY_T_C, new Object[]{assetTagStats.getTagId(), assetTagStats.getClassNameId()}, (Object)assetTagStats);
        assetTagStats.resetOriginalValues();
    }

    public void cacheResult(List<AssetTagStats> assetTagStatses) {
        for (AssetTagStats assetTagStats : assetTagStatses) {
            if (this.entityCache.getResult(AssetTagStatsModelImpl.ENTITY_CACHE_ENABLED, AssetTagStatsImpl.class, (Serializable)Long.valueOf(assetTagStats.getPrimaryKey())) == null) {
                this.cacheResult(assetTagStats);
                continue;
            }
            assetTagStats.resetOriginalValues();
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(AssetTagStatsImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(AssetTagStats assetTagStats) {
        this.entityCache.removeResult(AssetTagStatsModelImpl.ENTITY_CACHE_ENABLED, AssetTagStatsImpl.class, (Serializable)Long.valueOf(assetTagStats.getPrimaryKey()));
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache((AssetTagStatsModelImpl)assetTagStats);
    }

    public void clearCache(List<AssetTagStats> assetTagStatses) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (AssetTagStats assetTagStats : assetTagStatses) {
            this.entityCache.removeResult(AssetTagStatsModelImpl.ENTITY_CACHE_ENABLED, AssetTagStatsImpl.class, (Serializable)Long.valueOf(assetTagStats.getPrimaryKey()));
            this.clearUniqueFindersCache((AssetTagStatsModelImpl)assetTagStats);
        }
    }

    protected void cacheUniqueFindersCache(AssetTagStatsModelImpl assetTagStatsModelImpl, boolean isNew) {
        if (isNew) {
            Object[] args = new Object[]{assetTagStatsModelImpl.getTagId(), assetTagStatsModelImpl.getClassNameId()};
            this.finderCache.putResult(FINDER_PATH_COUNT_BY_T_C, args, (Object)1L);
            this.finderCache.putResult(FINDER_PATH_FETCH_BY_T_C, args, (Object)assetTagStatsModelImpl);
        } else if ((assetTagStatsModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_T_C.getColumnBitmask()) != 0L) {
            Object[] args = new Object[]{assetTagStatsModelImpl.getTagId(), assetTagStatsModelImpl.getClassNameId()};
            this.finderCache.putResult(FINDER_PATH_COUNT_BY_T_C, args, (Object)1L);
            this.finderCache.putResult(FINDER_PATH_FETCH_BY_T_C, args, (Object)assetTagStatsModelImpl);
        }
    }

    protected void clearUniqueFindersCache(AssetTagStatsModelImpl assetTagStatsModelImpl) {
        Object[] args = new Object[]{assetTagStatsModelImpl.getTagId(), assetTagStatsModelImpl.getClassNameId()};
        this.finderCache.removeResult(FINDER_PATH_COUNT_BY_T_C, args);
        this.finderCache.removeResult(FINDER_PATH_FETCH_BY_T_C, args);
        if ((assetTagStatsModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_T_C.getColumnBitmask()) != 0L) {
            args = new Object[]{assetTagStatsModelImpl.getOriginalTagId(), assetTagStatsModelImpl.getOriginalClassNameId()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_T_C, args);
            this.finderCache.removeResult(FINDER_PATH_FETCH_BY_T_C, args);
        }
    }

    public AssetTagStats create(long tagStatsId) {
        AssetTagStatsImpl assetTagStats = new AssetTagStatsImpl();
        assetTagStats.setNew(true);
        assetTagStats.setPrimaryKey(tagStatsId);
        assetTagStats.setCompanyId(this.companyProvider.getCompanyId());
        return assetTagStats;
    }

    public AssetTagStats remove(long tagStatsId) throws NoSuchTagStatsException {
        return this.remove(Long.valueOf(tagStatsId));
    }

    public AssetTagStats remove(Serializable primaryKey) throws NoSuchTagStatsException {
        Session session = null;
        try {
            session = this.openSession();
            AssetTagStats assetTagStats = (AssetTagStats)session.get(AssetTagStatsImpl.class, primaryKey);
            if (assetTagStats == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchTagStatsException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            AssetTagStats assetTagStats2 = (AssetTagStats)this.remove((BaseModel)assetTagStats);
            return assetTagStats2;
        }
        catch (NoSuchTagStatsException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected AssetTagStats removeImpl(AssetTagStats assetTagStats) {
        assetTagStats = this.toUnwrappedModel(assetTagStats);
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)assetTagStats)) {
                assetTagStats = (AssetTagStats)session.get(AssetTagStatsImpl.class, assetTagStats.getPrimaryKeyObj());
            }
            if (assetTagStats != null) {
                session.delete((Object)assetTagStats);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        if (assetTagStats != null) {
            this.clearCache(assetTagStats);
        }
        return assetTagStats;
    }

    public AssetTagStats updateImpl(AssetTagStats assetTagStats) {
        assetTagStats = this.toUnwrappedModel(assetTagStats);
        boolean isNew = assetTagStats.isNew();
        AssetTagStatsModelImpl assetTagStatsModelImpl = (AssetTagStatsModelImpl)assetTagStats;
        Session session = null;
        try {
            session = this.openSession();
            if (assetTagStats.isNew()) {
                session.save((Object)assetTagStats);
                assetTagStats.setNew(false);
            } else {
                assetTagStats = (AssetTagStats)session.merge((Object)assetTagStats);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (isNew || !AssetTagStatsModelImpl.COLUMN_BITMASK_ENABLED) {
            this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else {
            Object[] args;
            if ((assetTagStatsModelImpl.getColumnBitmask() & FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_TAGID.getColumnBitmask()) != 0L) {
                args = new Object[]{assetTagStatsModelImpl.getOriginalTagId()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_TAGID, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_TAGID, args);
                args = new Object[]{assetTagStatsModelImpl.getTagId()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_TAGID, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_TAGID, args);
            }
            if ((assetTagStatsModelImpl.getColumnBitmask() & FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_CLASSNAMEID.getColumnBitmask()) != 0L) {
                args = new Object[]{assetTagStatsModelImpl.getOriginalClassNameId()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_CLASSNAMEID, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_CLASSNAMEID, args);
                args = new Object[]{assetTagStatsModelImpl.getClassNameId()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_CLASSNAMEID, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_CLASSNAMEID, args);
            }
        }
        this.entityCache.putResult(AssetTagStatsModelImpl.ENTITY_CACHE_ENABLED, AssetTagStatsImpl.class, (Serializable)Long.valueOf(assetTagStats.getPrimaryKey()), (Serializable)assetTagStats, false);
        this.clearUniqueFindersCache(assetTagStatsModelImpl);
        this.cacheUniqueFindersCache(assetTagStatsModelImpl, isNew);
        assetTagStats.resetOriginalValues();
        return assetTagStats;
    }

    protected AssetTagStats toUnwrappedModel(AssetTagStats assetTagStats) {
        if (assetTagStats instanceof AssetTagStatsImpl) {
            return assetTagStats;
        }
        AssetTagStatsImpl assetTagStatsImpl = new AssetTagStatsImpl();
        assetTagStatsImpl.setNew(assetTagStats.isNew());
        assetTagStatsImpl.setPrimaryKey(assetTagStats.getPrimaryKey());
        assetTagStatsImpl.setTagStatsId(assetTagStats.getTagStatsId());
        assetTagStatsImpl.setCompanyId(assetTagStats.getCompanyId());
        assetTagStatsImpl.setTagId(assetTagStats.getTagId());
        assetTagStatsImpl.setClassNameId(assetTagStats.getClassNameId());
        assetTagStatsImpl.setAssetCount(assetTagStats.getAssetCount());
        return assetTagStatsImpl;
    }

    public AssetTagStats findByPrimaryKey(Serializable primaryKey) throws NoSuchTagStatsException {
        AssetTagStats assetTagStats = this.fetchByPrimaryKey(primaryKey);
        if (assetTagStats == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchTagStatsException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return assetTagStats;
    }

    public AssetTagStats findByPrimaryKey(long tagStatsId) throws NoSuchTagStatsException {
        return this.findByPrimaryKey(Long.valueOf(tagStatsId));
    }

    public AssetTagStats fetchByPrimaryKey(Serializable primaryKey) {
        Serializable serializable = this.entityCache.getResult(AssetTagStatsModelImpl.ENTITY_CACHE_ENABLED, AssetTagStatsImpl.class, primaryKey);
        if (serializable == nullModel) {
            return null;
        }
        AssetTagStats assetTagStats = (AssetTagStats)serializable;
        if (assetTagStats == null) {
            Session session = null;
            try {
                session = this.openSession();
                assetTagStats = (AssetTagStats)session.get(AssetTagStatsImpl.class, primaryKey);
                if (assetTagStats != null) {
                    this.cacheResult(assetTagStats);
                } else {
                    this.entityCache.putResult(AssetTagStatsModelImpl.ENTITY_CACHE_ENABLED, AssetTagStatsImpl.class, primaryKey, (Serializable)nullModel);
                }
            }
            catch (Exception e) {
                this.entityCache.removeResult(AssetTagStatsModelImpl.ENTITY_CACHE_ENABLED, AssetTagStatsImpl.class, primaryKey);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return assetTagStats;
    }

    public AssetTagStats fetchByPrimaryKey(long tagStatsId) {
        return this.fetchByPrimaryKey(Long.valueOf(tagStatsId));
    }

    public Map<Serializable, AssetTagStats> fetchByPrimaryKeys(Set<Serializable> primaryKeys) {
        Session session;
        if (primaryKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Serializable, AssetTagStats> map = new HashMap<Serializable, AssetTagStats>();
        if (primaryKeys.size() == 1) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            Serializable primaryKey = iterator.next();
            AssetTagStats assetTagStats = this.fetchByPrimaryKey(primaryKey);
            if (assetTagStats != null) {
                map.put(primaryKey, assetTagStats);
            }
            return map;
        }
        HashSet<Serializable> uncachedPrimaryKeys = null;
        for (Serializable serializable : primaryKeys) {
            Serializable serializable2 = this.entityCache.getResult(AssetTagStatsModelImpl.ENTITY_CACHE_ENABLED, AssetTagStatsImpl.class, serializable);
            if (serializable2 == nullModel) continue;
            if (serializable2 == null) {
                if (uncachedPrimaryKeys == null) {
                    uncachedPrimaryKeys = new HashSet<Serializable>();
                }
                uncachedPrimaryKeys.add(serializable);
                continue;
            }
            map.put(serializable, (AssetTagStats)serializable2);
        }
        if (uncachedPrimaryKeys == null) {
            return map;
        }
        StringBundler query = new StringBundler(uncachedPrimaryKeys.size() * 2 + 1);
        query.append(_SQL_SELECT_ASSETTAGSTATS_WHERE_PKS_IN);
        for (Serializable serializable : uncachedPrimaryKeys) {
            query.append(String.valueOf(serializable));
            query.append(",");
        }
        query.setIndex(query.index() - 1);
        query.append(")");
        String string = query.toString();
        Session session2 = null;
        try {
            session = this.openSession();
            Query q = session.createQuery(string);
            for (AssetTagStats assetTagStats : q.list()) {
                map.put(assetTagStats.getPrimaryKeyObj(), assetTagStats);
                this.cacheResult(assetTagStats);
                uncachedPrimaryKeys.remove(assetTagStats.getPrimaryKeyObj());
            }
            for (Serializable serializable : uncachedPrimaryKeys) {
                this.entityCache.putResult(AssetTagStatsModelImpl.ENTITY_CACHE_ENABLED, AssetTagStatsImpl.class, serializable, (Serializable)nullModel);
            }
        }
        catch (Exception e) {
            try {
                throw this.processException(e);
            }
            catch (Throwable throwable) {
                this.closeSession(session2);
                throw throwable;
            }
        }
        this.closeSession(session);
        return map;
    }

    public List<AssetTagStats> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<AssetTagStats> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<AssetTagStats> findAll(int start, int end, OrderByComparator<AssetTagStats> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<AssetTagStats> findAll(int start, int end, OrderByComparator<AssetTagStats> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (retrieveFromCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                query.append(_SQL_SELECT_ASSETTAGSTATS);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_ASSETTAGSTATS;
                if (pagination) {
                    sql = sql.concat(" ORDER BY assetTagStats.assetCount DESC");
                }
            }
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (AssetTagStats assetTagStats : this.findAll()) {
            this.remove((BaseModel)assetTagStats);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_ASSETTAGSTATS);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return AssetTagStatsModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
    }

    public void destroy() {
        this.entityCache.removeCache(AssetTagStatsImpl.class.getName());
        this.finderCache.removeCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

