/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.dao.orm;

import com.liferay.portal.kernel.concurrent.ThreadPoolExecutor;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.OrderFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.executor.PortalExecutorManagerUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public class DefaultActionableDynamicQuery
implements ActionableDynamicQuery {
    public static final TransactionConfig REQUIRES_NEW_TRANSACTION_CONFIG;
    private ActionableDynamicQuery.AddCriteriaMethod _addCriteriaMethod;
    private ActionableDynamicQuery.AddOrderCriteriaMethod _addOrderCriteriaMethod;
    private BaseLocalService _baseLocalService;
    private ClassLoader _classLoader;
    private long _companyId;
    private Method _dynamicQueryCountMethod;
    private Method _dynamicQueryMethod;
    private long _groupId;
    private String _groupIdPropertyName = "groupId";
    private int _interval = 10000;
    private Class<?> _modelClass;
    private boolean _parallel;
    private ActionableDynamicQuery.PerformActionMethod _performActionMethod;
    private ActionableDynamicQuery.PerformCountMethod _performCountMethod;
    private String _primaryKeyPropertyName;
    private final ThreadPoolExecutor _threadPoolExecutor = PortalExecutorManagerUtil.getPortalExecutor(DefaultActionableDynamicQuery.class.getName());
    private TransactionConfig _transactionConfig;

    @Override
    public ActionableDynamicQuery.AddCriteriaMethod getAddCriteriaMethod() {
        return this._addCriteriaMethod;
    }

    @Override
    public ActionableDynamicQuery.AddOrderCriteriaMethod getAddOrderCriteriaMethod() {
        return this._addOrderCriteriaMethod;
    }

    @Override
    public ActionableDynamicQuery.PerformActionMethod<?> getPerformActionMethod() {
        return this._performActionMethod;
    }

    @Override
    public ActionableDynamicQuery.PerformCountMethod getPerformCountMethod() {
        return this._performCountMethod;
    }

    @Override
    public boolean isParallel() {
        return this._parallel;
    }

    @Override
    public void performActions() throws PortalException {
        try {
            long previousPrimaryKey = -1L;
            while (true) {
                long lastPrimaryKey;
                if ((lastPrimaryKey = this.doPerformActions(previousPrimaryKey)) < 0L) {
                    return;
                }
                this.intervalCompleted(previousPrimaryKey, lastPrimaryKey);
                previousPrimaryKey = lastPrimaryKey;
            }
        }
        finally {
            this.actionsCompleted();
        }
    }

    @Override
    public long performCount() throws PortalException {
        if (this._performCountMethod != null) {
            return this._performCountMethod.performCount();
        }
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(this._modelClass, this._classLoader);
        this.addDefaultCriteria(dynamicQuery);
        this.addCriteria(dynamicQuery);
        return (Long)this.executeDynamicQuery(this._dynamicQueryCountMethod, dynamicQuery, this.getCountProjection());
    }

    @Override
    public void setAddCriteriaMethod(ActionableDynamicQuery.AddCriteriaMethod addCriteriaMethod) {
        this._addCriteriaMethod = addCriteriaMethod;
    }

    @Override
    public void setAddOrderCriteriaMethod(ActionableDynamicQuery.AddOrderCriteriaMethod addOrderCriteriaMethod) {
        this._addOrderCriteriaMethod = addOrderCriteriaMethod;
    }

    @Override
    public void setBaseLocalService(BaseLocalService baseLocalService) {
        this._baseLocalService = baseLocalService;
        Class<?> clazz = this._baseLocalService.getClass();
        try {
            this._dynamicQueryMethod = clazz.getMethod("dynamicQuery", DynamicQuery.class);
            this._dynamicQueryCountMethod = clazz.getMethod("dynamicQueryCount", DynamicQuery.class, Projection.class);
        }
        catch (NoSuchMethodException nsme) {
            throw new SystemException(nsme);
        }
    }

    @Override
    @Deprecated
    public void setClass(Class<?> modelClass) {
        this._modelClass = modelClass;
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this._classLoader = classLoader;
    }

    @Override
    public void setCompanyId(long companyId) {
        this._companyId = companyId;
    }

    @Override
    public void setGroupId(long groupId) {
        this._groupId = groupId;
    }

    @Override
    public void setGroupIdPropertyName(String groupIdPropertyName) {
        this._groupIdPropertyName = groupIdPropertyName;
    }

    @Override
    public void setInterval(int interval) {
        this._interval = interval;
    }

    @Override
    public void setModelClass(Class<?> modelClass) {
        this._modelClass = modelClass;
    }

    @Override
    public void setParallel(boolean parallel) {
        this._parallel = parallel;
    }

    @Override
    public void setPerformActionMethod(ActionableDynamicQuery.PerformActionMethod<?> performActionMethod) {
        this._performActionMethod = performActionMethod;
    }

    @Override
    public void setPerformCountMethod(ActionableDynamicQuery.PerformCountMethod performCountMethod) {
        this._performCountMethod = performCountMethod;
    }

    @Override
    public void setPrimaryKeyPropertyName(String primaryKeyPropertyName) {
        this._primaryKeyPropertyName = primaryKeyPropertyName;
    }

    @Override
    public void setTransactionConfig(TransactionConfig transactionConfig) {
        this._transactionConfig = transactionConfig;
    }

    protected void actionsCompleted() throws PortalException {
    }

    protected void addCriteria(DynamicQuery dynamicQuery) {
        if (this._addCriteriaMethod != null) {
            this._addCriteriaMethod.addCriteria(dynamicQuery);
        }
    }

    protected void addDefaultCriteria(DynamicQuery dynamicQuery) {
        Property property;
        if (this._companyId > 0L) {
            property = PropertyFactoryUtil.forName("companyId");
            dynamicQuery.add(property.eq(this._companyId));
        }
        if (this._groupId > 0L) {
            property = PropertyFactoryUtil.forName(this._groupIdPropertyName);
            dynamicQuery.add(property.eq(this._groupId));
        }
    }

    protected void addOrderCriteria(DynamicQuery dynamicQuery) {
        if (this._addOrderCriteriaMethod != null) {
            this._addOrderCriteriaMethod.addOrderCriteria(dynamicQuery);
        } else {
            dynamicQuery.addOrder(OrderFactoryUtil.asc(this._primaryKeyPropertyName));
        }
    }

    protected long doPerformActions(long previousPrimaryKey) throws PortalException {
        final DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(this._modelClass, this._classLoader);
        Property property = PropertyFactoryUtil.forName(this._primaryKeyPropertyName);
        dynamicQuery.add(property.gt(previousPrimaryKey));
        dynamicQuery.setLimit(0, this._interval);
        this.addDefaultCriteria(dynamicQuery);
        this.addCriteria(dynamicQuery);
        this.addOrderCriteria(dynamicQuery);
        Callable<Long> callable = new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                List objects = (List)DefaultActionableDynamicQuery.this.executeDynamicQuery(DefaultActionableDynamicQuery.this._dynamicQueryMethod, dynamicQuery);
                if (objects.isEmpty()) {
                    return -1L;
                }
                if (DefaultActionableDynamicQuery.this._parallel) {
                    ArrayList futures = new ArrayList(objects.size());
                    for (final Object object : objects) {
                        futures.add(DefaultActionableDynamicQuery.this._threadPoolExecutor.submit(new Callable<Void>(){

                            @Override
                            public Void call() throws PortalException {
                                DefaultActionableDynamicQuery.this.performAction(object);
                                return null;
                            }
                        }));
                    }
                    Iterator iterator = futures.iterator();
                    while (iterator.hasNext()) {
                        Future future = (Future)iterator.next();
                        future.get();
                    }
                } else {
                    for (Object object : objects) {
                        DefaultActionableDynamicQuery.this.performAction(object);
                    }
                }
                if (objects.size() < DefaultActionableDynamicQuery.this._interval) {
                    return -1L;
                }
                BaseModel baseModel = (BaseModel)objects.get(objects.size() - 1);
                return (Long)baseModel.getPrimaryKeyObj();
            }
        };
        TransactionConfig transactionConfig = this.getTransactionConfig();
        try {
            if (transactionConfig == null) {
                return (Long)callable.call();
            }
            return TransactionInvokerUtil.invoke(transactionConfig, callable);
        }
        catch (Throwable t) {
            if (t instanceof PortalException) {
                throw (PortalException)t;
            }
            if (t instanceof SystemException) {
                throw (SystemException)t;
            }
            throw new SystemException(t);
        }
    }

    protected Object executeDynamicQuery(Method dynamicQueryMethod, Object ... arguments) throws PortalException {
        try {
            return dynamicQueryMethod.invoke((Object)this._baseLocalService, arguments);
        }
        catch (InvocationTargetException ite) {
            Throwable throwable = ite.getCause();
            if (throwable instanceof PortalException) {
                throw (PortalException)throwable;
            }
            if (throwable instanceof SystemException) {
                throw (SystemException)throwable;
            }
            throw new SystemException(ite);
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
    }

    protected long getCompanyId() {
        return this._companyId;
    }

    protected Projection getCountProjection() {
        return ProjectionFactoryUtil.rowCount();
    }

    protected int getInterval() {
        return this._interval;
    }

    protected Class<?> getModelClass() {
        return this._modelClass;
    }

    protected TransactionConfig getTransactionConfig() {
        return this._transactionConfig;
    }

    protected void intervalCompleted(long startPrimaryKey, long endPrimaryKey) throws PortalException {
    }

    protected void performAction(Object object) throws PortalException {
        if (this._performActionMethod != null) {
            this._performActionMethod.performAction(object);
        }
    }

    static {
        TransactionConfig.Builder builder = new TransactionConfig.Builder();
        builder.setPropagation(Propagation.REQUIRES_NEW);
        builder.setRollbackForClasses(PortalException.class, SystemException.class);
        REQUIRES_NEW_TRANSACTION_CONFIG = builder.build();
    }
}

