/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ByteArrayFileInputStream
extends InputStream {
    protected byte[] data;
    protected boolean deleteOnClose;
    protected File file;
    protected FileInputStream fileInputStream;
    protected long fileSize;
    protected int index;
    protected int markIndex;
    protected int threshold;

    public ByteArrayFileInputStream(File file, int threshold) {
        this(file, threshold, false);
    }

    public ByteArrayFileInputStream(File file, int threshold, boolean deleteOnClose) {
        if (!file.exists() || !file.isFile()) {
            throw new IllegalArgumentException("File " + file.getAbsolutePath() + " does not exist");
        }
        this.file = file;
        this.fileSize = file.length();
        this.threshold = threshold;
        this.deleteOnClose = deleteOnClose;
    }

    @Override
    public int available() throws IOException {
        if (this.data != null) {
            return this.data.length - this.index;
        }
        if (this.fileInputStream != null) {
            return this.fileInputStream.available();
        }
        return 0;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.fileInputStream != null) {
                this.fileInputStream.close();
            }
        }
        finally {
            this.data = null;
            this.fileInputStream = null;
            if (this.deleteOnClose && this.file != null) {
                this.file.delete();
            }
            this.file = null;
        }
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public void mark(int readLimit) {
        this.markIndex = this.index;
    }

    @Override
    public boolean markSupported() {
        return this.fileSize < (long)this.threshold;
    }

    @Override
    public int read() throws IOException {
        if (this.fileSize < (long)this.threshold) {
            this.initData();
            if (this.index < this.data.length) {
                return this.data[this.index++] & 0xFF;
            }
            return -1;
        }
        this.initFileInputStream();
        return this.fileInputStream.read();
    }

    @Override
    public int read(byte[] bytes) throws IOException {
        return this.read(bytes, 0, bytes.length);
    }

    @Override
    public int read(byte[] bytes, int offset, int length) throws IOException {
        if (length <= 0) {
            return 0;
        }
        if (this.fileSize < (long)this.threshold) {
            this.initData();
            if (this.index >= this.data.length) {
                return -1;
            }
            int read = length;
            if (this.index + read > this.data.length) {
                read = this.data.length - this.index;
            }
            System.arraycopy(this.data, this.index, bytes, offset, read);
            this.index += read;
            return read;
        }
        this.initFileInputStream();
        return this.fileInputStream.read(bytes, offset, length);
    }

    @Override
    public void reset() throws IOException {
        if (this.data != null) {
            this.index = this.markIndex;
        } else if (this.fileInputStream != null) {
            this.fileInputStream.close();
            this.fileInputStream = null;
        }
    }

    @Override
    public long skip(long skip) throws IOException {
        if (skip < 0L) {
            return 0L;
        }
        if (this.fileSize < (long)this.threshold) {
            this.initData();
            if (skip + (long)this.index > (long)this.data.length) {
                skip = this.data.length - this.index;
            }
            this.index = (int)((long)this.index + skip);
            return skip;
        }
        this.initFileInputStream();
        return this.fileInputStream.skip(skip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initData() throws IOException {
        if (this.data != null) {
            return;
        }
        int arraySize = (int)this.fileSize;
        this.data = new byte[arraySize];
        int length = 0;
        try (FileInputStream fileInputStream = new FileInputStream(this.file);){
            for (int offset = 0; offset < arraySize; offset += length) {
                length = fileInputStream.read(this.data, offset, arraySize - offset);
            }
        }
    }

    protected void initFileInputStream() throws IOException {
        if (this.fileInputStream == null) {
            this.fileInputStream = new FileInputStream(this.file);
        }
    }
}

