/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.poller.comet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.poller.comet.CometException;
import com.liferay.portal.kernel.poller.comet.CometHandler;
import com.liferay.portal.kernel.poller.comet.CometSession;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class CometHandlerPool {
    private static final Log _log = LogFactoryUtil.getLog(CometHandlerPool.class);
    private final ReadWriteLock _cometHandlerPoolReadWriteLock = new ReentrantReadWriteLock();
    private final Map<String, CometHandler> _cometHandlers = new HashMap<String, CometHandler>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeCometHandler(String sessionId) throws CometException {
        if (_log.isDebugEnabled()) {
            _log.debug("Close comet handler " + sessionId);
        }
        Lock writeLock = this._cometHandlerPoolReadWriteLock.writeLock();
        try {
            writeLock.lock();
            CometHandler cometHandler = this._cometHandlers.remove(sessionId);
            if (cometHandler != null) {
                cometHandler.destroy();
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeCometHandlers() throws CometException {
        Lock writeLock = this._cometHandlerPoolReadWriteLock.writeLock();
        try {
            writeLock.lock();
            Set<Map.Entry<String, CometHandler>> cometHandlers = this._cometHandlers.entrySet();
            Iterator<Map.Entry<String, CometHandler>> itr = cometHandlers.iterator();
            while (itr.hasNext()) {
                Map.Entry<String, CometHandler> entry = itr.next();
                CometHandler cometHandler = entry.getValue();
                if (cometHandler != null) {
                    cometHandler.destroy();
                }
                itr.remove();
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CometHandler getCometHandler(String sessionId) {
        Lock readLock = this._cometHandlerPoolReadWriteLock.readLock();
        try {
            readLock.lock();
            CometHandler cometHandler = this._cometHandlers.get(sessionId);
            return cometHandler;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startCometHandler(CometSession cometSession, CometHandler cometHandler) throws CometException {
        String sessionId = cometSession.getSessionId();
        if (_log.isDebugEnabled()) {
            _log.debug("Start comet handler " + sessionId);
        }
        Lock writeLock = this._cometHandlerPoolReadWriteLock.writeLock();
        try {
            writeLock.lock();
            if (this._cometHandlers.containsKey(sessionId)) {
                this.closeCometHandler(sessionId);
            }
            this._cometHandlers.put(sessionId, cometHandler);
            if (_log.isWarnEnabled()) {
                _log.warn("Initialize comet handler " + sessionId);
            }
            cometHandler.init(cometSession);
        }
        finally {
            writeLock.unlock();
        }
    }
}

