/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search.suggest;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.suggest.BaseSpellCheckIndexWriter;
import com.liferay.portal.kernel.search.suggest.DictionaryEntry;
import com.liferay.portal.kernel.search.suggest.DictionaryReader;
import com.liferay.portal.kernel.search.suggest.NGramHolder;
import com.liferay.portal.kernel.search.suggest.NGramHolderBuilderUtil;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class BaseGenericSpellCheckIndexWriter
extends BaseSpellCheckIndexWriter {
    private static final int _DEFAULT_BATCH_SIZE = 1000;
    private static final Log _log = LogFactoryUtil.getLog(BaseGenericSpellCheckIndexWriter.class);
    private int _batchSize = 1000;
    private Document _documentPrototype = new DocumentImpl();

    public void setBatchSize(int batchSize) {
        this._batchSize = batchSize;
    }

    public void setDocumentPrototype(Document documentPrototype) {
        this._documentPrototype = documentPrototype;
    }

    protected abstract void addDocument(String var1, SearchContext var2, Document var3) throws SearchException;

    protected abstract void addDocuments(String var1, SearchContext var2, Collection<Document> var3) throws SearchException;

    protected void addNGramFields(Document document, Map<String, String> nGrams) {
        for (Map.Entry<String, String> nGramEntry : nGrams.entrySet()) {
            document.addKeyword(nGramEntry.getKey(), nGramEntry.getValue());
        }
    }

    protected Document createDocument() {
        return (Document)this._documentPrototype.clone();
    }

    protected Document createDocument(long companyId, long groupId, String languageId, String keywords, float weight, String keywordFieldName, String typeFieldValue, int maxNGramLength) throws SearchException {
        Document document = this.createDocument();
        document.addKeyword("companyId", companyId);
        document.addKeyword("groupId", groupId);
        document.addKeyword("languageId", languageId);
        document.addKeyword("priority", String.valueOf(weight));
        document.addKeyword("spellCheckWord", true);
        document.addKeyword(keywordFieldName, keywords);
        document.addKeyword("type", typeFieldValue);
        document.addKeyword("uid", this.getUID(companyId, languageId, keywords, new String[0]));
        NGramHolder nGramHolder = NGramHolderBuilderUtil.buildNGramHolder(keywords, maxNGramLength);
        this.addNGramFields(document, nGramHolder.getNGramEnds());
        Map<String, List<String>> nGrams = nGramHolder.getNGrams();
        for (Map.Entry<String, List<String>> entry : nGrams.entrySet()) {
            String fieldName = entry.getKey();
            for (String nGram : entry.getValue()) {
                document.addKeyword(fieldName, nGram);
            }
        }
        this.addNGramFields(document, nGramHolder.getNGramStarts());
        return document;
    }

    @Override
    protected void indexKeyword(SearchContext searchContext, long groupId, String languageId, String keyword, float weight, String keywordFieldName, String typeFieldValue, int maxNGramLength) throws Exception {
        Document document = this.createDocument(searchContext.getCompanyId(), groupId, languageId, keyword, weight, keywordFieldName, typeFieldValue, maxNGramLength);
        this.addDocument(typeFieldValue, searchContext, document);
    }

    @Override
    protected void indexKeywords(SearchContext searchContext, long groupId, String languageId, InputStream inputStream, String keywordFieldName, String typeFieldValue, int maxNGramLength) throws Exception {
        HashSet<Document> documents = new HashSet<Document>();
        try {
            DictionaryReader dictionaryReader = new DictionaryReader(inputStream, "UTF-8");
            Iterator<DictionaryEntry> iterator = dictionaryReader.getDictionaryEntriesIterator();
            int counter = 0;
            while (iterator.hasNext()) {
                DictionaryEntry dictionaryEntry = iterator.next();
                Document document = this.createDocument(searchContext.getCompanyId(), groupId, languageId, dictionaryEntry.getWord(), dictionaryEntry.getWeight(), keywordFieldName, typeFieldValue, maxNGramLength);
                documents.add(document);
                if (++counter != this._batchSize && iterator.hasNext()) continue;
                this.addDocuments(typeFieldValue, searchContext, documents);
                documents.clear();
                counter = 0;
            }
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn("Unable to index dictionaries", e);
            }
            throw new SearchException(e.getMessage(), e);
        }
    }
}

