/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.service;

import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.AutoResetThreadLocal;
import java.util.LinkedList;

public class ServiceContextThreadLocal {
    private static final ThreadLocal<LinkedList<ServiceContext>> _serviceContextThreadLocal = new AutoResetThreadLocal<LinkedList<ServiceContext>>(ServiceContextThreadLocal.class + "._serviceContextThreadLocal", new LinkedList()){

        @Override
        protected LinkedList<ServiceContext> copy(LinkedList<ServiceContext> serviceContexts) {
            LinkedList<ServiceContext> cloneServiceContexts = new LinkedList<ServiceContext>();
            for (ServiceContext serviceContext : serviceContexts) {
                ServiceContext cloneServiceContext = (ServiceContext)serviceContext.clone();
                cloneServiceContexts.add(cloneServiceContext);
            }
            return cloneServiceContexts;
        }
    };

    public static ServiceContext getServiceContext() {
        LinkedList<ServiceContext> serviceContextStack = _serviceContextThreadLocal.get();
        return serviceContextStack.peek();
    }

    public static ServiceContext popServiceContext() {
        LinkedList<ServiceContext> serviceContextStack = _serviceContextThreadLocal.get();
        if (serviceContextStack.isEmpty()) {
            return null;
        }
        return serviceContextStack.pop();
    }

    public static void pushServiceContext(ServiceContext serviceContext) {
        LinkedList<ServiceContext> serviceContextStack = _serviceContextThreadLocal.get();
        serviceContextStack.push(serviceContext);
    }
}

