/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import java.util.Collections;
import java.util.Set;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class HttpOnlyCookieServletResponse
extends HttpServletResponseWrapper {
    private static final Set<String> _cookieHttpOnlyCookieNamesExcludes;

    public static HttpServletResponse getHttpOnlyCookieServletResponse(HttpServletResponse response) {
        HttpServletResponse wrappedResponse = response;
        while (wrappedResponse instanceof HttpServletResponseWrapper) {
            if (wrappedResponse instanceof HttpOnlyCookieServletResponse) {
                return response;
            }
            HttpServletResponseWrapper httpServletResponseWrapper = (HttpServletResponseWrapper)wrappedResponse;
            wrappedResponse = (HttpServletResponse)httpServletResponseWrapper.getResponse();
        }
        return new HttpOnlyCookieServletResponse(response);
    }

    public HttpOnlyCookieServletResponse(HttpServletResponse response) {
        super(response);
    }

    public void addCookie(Cookie cookie) {
        if (!_cookieHttpOnlyCookieNamesExcludes.contains(cookie.getName())) {
            cookie.setHttpOnly(true);
        }
        super.addCookie(cookie);
    }

    static {
        Set<String> cookieHttpOnlyCookieNamesExcludes = SetUtil.fromArray(StringUtil.split(SystemProperties.get("cookie.http.only.names.excludes")));
        _cookieHttpOnlyCookieNamesExcludes = cookieHttpOnlyCookieNamesExcludes.isEmpty() ? Collections.emptySet() : cookieHttpOnlyCookieNamesExcludes;
    }
}

